/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.client;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCollection;
import com.kingdee.eas.ncm.cal.CalCostCheckItemFactory;
import com.kingdee.eas.ncm.cal.CalCostCheckItemInfo;
import com.kingdee.eas.ncm.cal.ICalCostCheckItem;
import com.kingdee.eas.ncm.cal.client.AbstractCostCalReccUI;
import com.kingdee.eas.ncm.cal.client.CostCalUI;
import com.kingdee.eas.ncm.cal.utils.CostCalUtils;
import com.kingdee.eas.ncm.common.task.client.CostTaskClientUtils;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class CostCalReccUI
extends AbstractCostCalReccUI {
    private static final Logger logger = CoreUIObject.getLogger(CostCalReccUI.class);
    private static final ImageIcon iconCheck = new ImageIcon(CostCalUI.class.getResource("/com/kingdee/eas/ncm/common/resource/pic/ncm_after_check.png"));

    public CostCalReccUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        this.lbPicture.setIcon((Icon)iconCheck);
    }

    @Override
    protected String getCostTaskNumber() {
        return "FactCostCalRecc";
    }

    @Override
    protected void btnRecc_actionPerformed(ActionEvent e) throws Exception {
        Set companyIds = this.getSelectedCompanyIds();
        if (companyIds.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.task.CostCalReccResource", (String)"CHOOSE_COMPANY_EMPTY"));
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("checkStatus", (Object)"0"));
        filter.getFilterItems().add(new FilterItemInfo("calType", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("stage", (Object)7));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("name");
        selector.add("type");
        view.setSelector(selector);
        HashSet<String> ids = new HashSet<String>();
        ICalCostCheckItem iCalCostCheckItem = CalCostCheckItemFactory.getRemoteInstance();
        CalCostCheckItemCollection checkItems = iCalCostCheckItem.getCalCostCheckItemCollection(view);
        for (int i = 0; i < checkItems.size(); ++i) {
            CalCostCheckItemInfo checkItem = checkItems.get(i);
            ids.add(checkItem.getId().toString());
        }
        HashMap<String, HashSet<String>> source = new HashMap<String, HashSet<String>>();
        source.put("checkItem_ids", ids);
        Set checkItem_ids = (Set)source.get("checkItem_ids");
        if (checkItem_ids == null || checkItem_ids.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.task.CostCalReccResource", (String)"CHOOSE_ITEM_EMPTY"));
            return;
        }
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)companyIds, CompareType.INCLUDE));
        view.setFilter(filter);
        selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        view.setSelector(selector);
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        HashMap<String, PeriodInfo> periods = new HashMap<String, PeriodInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            CompanyOrgUnitInfo company = coll.get(i);
            if (!NCMUtils.isStart(null, (String)company.getId().toString())) {
                MsgBox.showInfo((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ncm.cal.task.CostCalReccResource", (String)"COST_NOT_ON"), company.getName()));
                return;
            }
            PeriodInfo period = NCMUtils.GetCurrentPeriod(null, (String)company.getId().toString());
            periods.put(company.getId().toString(), period);
        }
        ArrayList<Map> params = new ArrayList<Map>(coll.size());
        for (int i = 0; i < coll.size(); ++i) {
            CompanyOrgUnitInfo company = coll.get(i);
            PeriodInfo period = (PeriodInfo)periods.get(company.getId().toString());
            source.put("company", (HashSet<String>)company);
            source.put("period", (HashSet<String>)period);
            source.put("user", (HashSet<String>)SysContext.getSysContext().getCurrentUserInfo());
            Map param = CostCalUtils.buildReccParam(source);
            params.add(param);
        }
        CostTaskClientUtils.execute(params, (CoreUIObject)this, (boolean)true);
    }
}

