/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.CalCostFacadeFactory;
import com.kingdee.eas.ncm.cal.CalcLogCollection;
import com.kingdee.eas.ncm.cal.CalcLogEntryCollection;
import com.kingdee.eas.ncm.cal.CalcLogInfo;
import com.kingdee.eas.ncm.cal.client.AbstractCostCalcLogReportUI;
import com.kingdee.eas.ncm.cal.client.CostCalcLogDetailReportUI;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.Assert;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CostCalcLogReportUI
extends AbstractCostCalcLogReportUI {
    private static final Logger logger = CoreUIObject.getLogger(CostCalcLogReportUI.class);
    private Map _parentParam = null;
    private String _companyId = null;
    private String _periodId = null;
    private String _companyName = null;
    private String _periodNumber = null;
    private CalcLogCollection _logData = null;

    public static void showCalcReportUI(CoreUIObject ui, Map param) throws Exception {
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("companyName"));
        Assert.that((boolean)param.containsKey("periodNumber"));
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"param", (Object)param);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CostCalcLogReportUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this._parentParam = (Map)this.getUIContext().get("param");
        if (this._parentParam == null) {
            this._parentParam = (Map)this.getUIContext().get("key.cost.task.entry.param");
        }
        this._companyId = (String)this._parentParam.get("companyId");
        this._periodId = (String)this._parentParam.get("periodId");
        this._companyName = (String)this._parentParam.get("companyName");
        this._periodNumber = (String)this._parentParam.get("periodNumber");
        if (this._companyName == null) {
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this._companyId));
            this._companyName = company.getName();
        }
        if (this._periodNumber == null) {
            PeriodInfo period = PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectUuidPK(this._periodId));
            this._periodNumber = String.valueOf(period.getNumber());
        }
        this._logData = this._parentParam.containsKey("logData") ? (CalcLogCollection)((Object)this._parentParam.get("logData")) : CalCostFacadeFactory.getRemoteInstance().getCalcLogData(this._companyId, this._periodId);
        this.kDTable.checkParsed();
        this.kDTable.getGroupManager().setGroup(true);
        this.kDTable.getColumn("calcRank").setGroup(true);
        this.kDTable.getColumn("calcRank").setMergeable(true);
        this.kDTable.getStyleAttributes().setWrapText(true);
        this.loadFields();
    }

    public void onShow() throws Exception {
        super.onShow();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int rowCount = CostCalcLogReportUI.this.kDTable.getBody().size();
                for (int i = 0; i < rowCount; ++i) {
                    KDTableHelper.autoFitRowHeight((KDTable)CostCalcLogReportUI.this.kDTable, (int)i, (int)2, (boolean)false);
                }
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.fillReportData();
    }

    private void fillReportData() {
        this.txtCompany.setText(this._companyName);
        this.txtPeriod.setText(this._periodNumber);
        if (this._logData == null) {
            return;
        }
        boolean isHandle = false;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd,HH:mm:ss");
        for (int i = 0; i < this._logData.size(); ++i) {
            CalcLogInfo item = this._logData.get(i);
            if (!isHandle) {
                this.txtLogTime.setText(sdf.format(item.getCreateTime()));
                this.txtLogUser.setText(item.getCreator().getName());
                isHandle = true;
            }
            IRow row = this.kDTable.addRow();
            row.getCell("calcRank").setValue((Object)item.getCalcRank());
            row.getCell("costObjectDispName").setValue((Object)item.getCostObjectDispName());
            row.getCell("calcItem").setValue((Object)item);
            row.getCell("status").setValue((Object)item.getStatus());
            row.getCell("attachment").setValue((Object)item.getAttachment());
            row.getCell("logDetail").setValue((Object)item.getEntries());
            if (item.getEntries().size() <= 0) continue;
            row.getStyleAttributes().setBackground(new Color(246, 246, 191));
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kDTable);
        this.kDTable.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kDTable);
        this.kDTable.getPrintManager().printPreview();
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
    }

    @Override
    protected void cbOnlyShowError_actionPerformed(ActionEvent e) throws Exception {
        super.cbOnlyShowError_actionPerformed(e);
        if (!this.cbOnlyShowError.isSelected()) {
            for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
                this.kDTable.getRow(i).getStyleAttributes().setHided(false);
            }
            return;
        }
        for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
            Object value = this.kDTable.getCell(i, "calcItem").getValue();
            boolean hide = true;
            if (value instanceof CalcLogInfo) {
                CalcLogInfo item = (CalcLogInfo)value;
                if (item.getCostObjectDispName() == null) {
                    hide = true;
                } else if (item.isHasDetailLog()) {
                    hide = false;
                }
            }
            this.kDTable.getRow(i).getStyleAttributes().setHided(hide);
        }
    }

    @Override
    protected void kDTable_tableClicked(KDTMouseEvent e) throws Exception {
        CalcLogEntryCollection item;
        super.kDTable_tableClicked(e);
        if (e.getClickCount() == 2 && e.getColIndex() == this.kDTable.getColumnIndex("attachment") && (item = (CalcLogEntryCollection)((Object)this.kDTable.getCell(e.getRowIndex(), this.kDTable.getColumnIndex("logDetail")).getValue())).size() > 0) {
            HashMap<String, CalcLogEntryCollection> param = new HashMap<String, CalcLogEntryCollection>();
            param.put("logDetail", item);
            CostCalcLogDetailReportUI.showCalcDetailReportUI((CoreUIObject)this, param);
        }
        if (this.kDTable.getRowCount() <= 0) {
            return;
        }
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (colIndex < 0 || rowIndex < 0) {
            return;
        }
        Object content = this.kDTable.getCell(rowIndex, colIndex).getValue();
        Object calRank = this.kDTable.getCell(rowIndex, 0).getValue();
        Object maxCalRank = this.kDTable.getCell(this.kDTable.getRowCount() - 1, 0).getValue();
        if (content != null && "\u51fa\u5e93\u6838\u7b97\u62a5\u544a".equals(content.toString())) {
            try {
                UIContext uiContext = new UIContext((Object)this);
                RptParams filter = new RptParams();
                CompanyOrgUnitInfo companyInfo = SysContext.getSysContext().getCurrentFIUnit();
                uiContext.put((Object)"rptparams", (Object)filter);
                filter.setObject("companyInfo", (Object)companyInfo);
                filter.setObject("companyNumber", (Object)companyInfo.getNumber());
                PeriodInfo period = NCMUtils.GetCurrentPeriod((Context)this.getUserContext(), (String)companyInfo.getId().toString());
                filter.setObject("year", (Object)String.valueOf(period.getPeriodYear()));
                filter.setObject("period", (Object)String.valueOf(period.getPeriodNumber()));
                filter.setObject("periodID", (Object)period.getId().toString());
                if (calRank != null) {
                    filter.setObject("calRank", (Object)calRank.toString().substring(1, calRank.toString().length() - 1));
                }
                if (maxCalRank != null) {
                    filter.setObject("maxCalRank", (Object)maxCalRank.toString().substring(1, maxCalRank.toString().length() - 1));
                }
                uiContext.put((Object)"report", (Object)"tkCBOw3+TL2rNOcUTDQCxNBgBtA=");
                IUIWindow wnd = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.base.report.client.ReportViewerUI", (Map)uiContext);
                wnd.show();
            }
            catch (UIException e1) {
                SysUtil.abort((Throwable)e1);
            }
        }
    }
}

