/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.client;

import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.cal.CostObjectRankEntryCollection;
import com.kingdee.eas.ncm.cal.CostObjectRankEntryInfo;
import com.kingdee.eas.ncm.cal.CostObjectRankFactory;
import com.kingdee.eas.ncm.cal.CostObjectRankInfo;
import com.kingdee.eas.ncm.cal.ICostObjectRank;
import com.kingdee.eas.ncm.cal.LowLevelCodeTypeEnum;
import com.kingdee.eas.ncm.cal.client.AbstractCostObjectRankEditUI;
import com.kingdee.eas.ncm.common.utils.client.LowLevelCodeTrees;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class CostObjectRankEditUI
extends AbstractCostObjectRankEditUI {
    private static final Logger logger = CoreUIObject.getLogger(CostObjectRankEditUI.class);
    private final String[] num_cols = new String[]{"rank"};
    private final String[] lock_cols = new String[]{"costObject.name", "costObject.group", "costObject.calculateMode"};

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCompute.setIcon(EASResource.getIcon((String)"imgTbtn_getparms"));
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        if ("ADDNEW".equals(this.oprtState)) {
            this.btnCompute.setEnabled(true);
        } else if ("EDIT".equals(this.oprtState)) {
            this.btnCompute.setEnabled(true);
        } else if ("VIEW".equals(this.oprtState)) {
            this.btnCompute.setEnabled(false);
        } else if ("AUDIT".equalsIgnoreCase(this.oprtState)) {
            this.btnCompute.setEnabled(false);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.initEntriesTable();
    }

    private void initEntriesTable() {
        KDTDefaultCellEditor obj = null;
        KDTextField txtd = new KDTextField();
        txtd.setMaxLength(80);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)txtd);
        this.kdtEntrys.getColumn("remark").setEditor((ICellEditor)cellEditor);
        KDFormattedTextField txtField = null;
        for (int i = 0; i < this.num_cols.length; ++i) {
            this.kdtEntrys.getColumn(this.num_cols[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            obj = (KDTDefaultCellEditor)this.kdtEntrys.getColumn(this.num_cols[i]).getEditor();
            txtField = (KDFormattedTextField)obj.getComponent();
            txtField.setDataType(0);
            txtField.setMaximumValue((Comparable)new Integer("99"));
            txtField.setMinimumValue((Comparable)new Integer("0"));
            txtField.setDataVerifierType(12);
        }
        for (int j = 0; j < this.lock_cols.length; ++j) {
            this.kdtEntrys.getColumn(this.lock_cols[j]).getStyleAttributes().setLocked(true);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.combBillStatus.setEditable(false);
        this.combBillStatus.setEnabled(false);
        Component[] comps = new Component[]{this.menuBiz, this.MenuItemWFG, this.menuItemMultiapprove, this.menuItemNextPerson, this.menuItemAuditResult, this.menuItemSendMessage, this.btnAttachment, this.btnPrint, this.btnPrintPreview, this.separatorFW1, this.btnCancelCancel, this.btnCancel, this.btnMultiapprove, this.btnNextPerson};
        NCMClientUtils.setVisible((boolean)false, (Component[])comps);
        this.prmtCompany.setEnabled(true);
        this.prmtCalculatePeriod.setEnabled(true);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CostObjectRankFactory.getRemoteInstance();
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntrys;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return new CostObjectRankEntryInfo();
    }

    @Override
    protected IObjectValue createNewData() {
        CostObjectRankInfo objectValue = new CostObjectRankInfo();
        super.applyBillDefaultValue((IObjectValue)objectValue);
        objectValue.setLlcType(LowLevelCodeTypeEnum.Normal);
        return objectValue;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected String[] getValidateColumns() {
        return new String[]{"costObject", "rank"};
    }

    @Override
    public void computeAction_actionPerformed(ActionEvent e) throws Exception {
        BDCMClientUtils.verifyF7Input((KDPromptBox)this.prmtCompany, (String)this.kDLabelContainer10.getBoundLabelText());
        BDCMClientUtils.verifyF7Input((KDPromptBox)this.prmtCalculatePeriod, (String)this.kDLabelContainer11.getBoundLabelText());
        String companyOrgID = ((CompanyOrgUnitInfo)this.prmtCompany.getData()).getId().toString();
        String periodID = ((PeriodInfo)this.prmtCalculatePeriod.getData()).getId().toString();
        this.kdtEntrys.removeRows();
        this.editData.getEntrys().clear();
        ICostObjectRank icor = CostObjectRankFactory.getRemoteInstance();
        CostObjectRankEntryCollection entries = (CostObjectRankEntryCollection)icor.rank(companyOrgID, periodID, (LowLevelCodeTypeEnum)((Object)this.combLLCType.getSelectedItem()));
        if (entries.size() <= 0) {
            return;
        }
        this.dataBinder.bindDataToTable(this.kdtEntrys, (IObjectCollection)entries);
    }

    public void auditAction_actionPerformed(ActionEvent e) throws Exception {
        super.auditAction_actionPerformed(e);
        this.btnCompute.setEnabled(false);
    }

    @Override
    protected void kdtEntrys_editStopped(KDTEditEvent e) throws Exception {
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        if (newValue != null && oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.kdtEntrys.getColumnKey(colIndex);
        if ("costObject".equalsIgnoreCase(fieldName)) {
            Object cellValue = this.kdtEntrys.getCell(rowIndex, "costObject").getValue();
            if (cellValue == null) {
                this.kdtEntrys.getCell(rowIndex, "costObject.name").setValue(null);
                this.kdtEntrys.getCell(rowIndex, "rank").setValue(null);
                this.kdtEntrys.getCell(rowIndex, "costObject.group").setValue(null);
                this.kdtEntrys.getCell(rowIndex, "costObject.calculateMode").setValue(null);
                return;
            }
            String id = ((CostObjectInfo)cellValue).getId().toString();
            ICostObject ico = CostObjectFactory.getRemoteInstance();
            StringBuffer oql = new StringBuffer();
            oql.append("SELECT id, name, group.name, calculateMode WHERE id ='").append(id).append("'");
            CostObjectInfo co = ico.getCostObjectInfo(oql.toString());
            this.kdtEntrys.getCell(rowIndex, "costObject.name").setValue((Object)co.getName());
            this.kdtEntrys.getCell(rowIndex, "costObject.group").setValue((Object)co.getGroup().getName());
            this.kdtEntrys.getCell(rowIndex, "costObject.calculateMode").setValue((Object)co.getCalculateMode());
        }
    }

    @Override
    public void generateTreesAction_actionPerformed(ActionEvent e) throws Exception {
        BDCMClientUtils.verifyF7Input((KDPromptBox)this.prmtCompany, (String)this.kDLabelContainer10.getBoundLabelText());
        BDCMClientUtils.verifyF7Input((KDPromptBox)this.prmtCalculatePeriod, (String)this.kDLabelContainer11.getBoundLabelText());
        String companyOrgID = ((CompanyOrgUnitInfo)this.prmtCompany.getData()).getId().toString();
        String periodID = ((PeriodInfo)this.prmtCalculatePeriod.getData()).getId().toString();
        ICostObjectRank iRank = CostObjectRankFactory.getRemoteInstance();
        Object[] obj = iRank.calcLLCForTrees(companyOrgID, periodID, LowLevelCodeTypeEnum.Normal);
        LowLevelCodeTrees.generateTrees((Object[])obj);
    }
}

