/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.ncm.cal.MaterialAllocVoucherFilterParam;
import com.kingdee.eas.ncm.cal.client.AbstractMaterialAllocVoucherFilterUI;
import com.kingdee.eas.ncm.common.NCMIFilterParam;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import org.apache.log4j.Logger;

public class MaterialAllocVoucherFilterUI
extends AbstractMaterialAllocVoucherFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialAllocVoucherFilterUI.class);
    private String Company = "company";
    private String Period = "period";
    private String CostCenterFrom = "costCenterFrom";
    private String CostCenterTo = "costCenterTo";
    private String CostObjectFrom = "costObjectFrom";
    private String CostObjectTo = "costObjectTo";

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtCompanyOrg.setValue((Object)this.getCompanyOrgInfoWithDefault());
        this.prmtPeriod.setValue((Object)NCMUtils.GetCurrentPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString()));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected NCMIFilterParam createNewFilterParam() {
        return new MaterialAllocVoucherFilterParam();
    }

    protected void storeBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof MaterialAllocVoucherFilterParam)) {
            return;
        }
        MaterialAllocVoucherFilterParam fp = (MaterialAllocVoucherFilterParam)filterParam;
        super.putIdByKey(customerParams, (Object)fp.getPeriodInfo(), this.Period);
        super.putIdByKey(customerParams, (Object)fp.getCostCenterFrom(), this.CostCenterFrom);
        super.putIdByKey(customerParams, (Object)fp.getCostCenterTo(), this.CostCenterTo);
        super.putIdByKey(customerParams, (Object)fp.getCostObjectFrom(), this.CostObjectFrom);
        super.putIdByKey(customerParams, (Object)fp.getCostObjectTo(), this.CostObjectTo);
    }

    protected void storeFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof MaterialAllocVoucherFilterParam)) {
            return;
        }
        MaterialAllocVoucherFilterParam fp = (MaterialAllocVoucherFilterParam)filterParam;
        Object temp = null;
        PeriodInfo period = null;
        temp = this.prmtPeriod.getValue();
        if (temp != null && temp instanceof PeriodInfo) {
            period = (PeriodInfo)temp;
        }
        fp.setPeriodInfo(period);
        CostCenterOrgUnitInfo costCenterFrom = null;
        CostCenterOrgUnitInfo costCenterTo = null;
        temp = this.prmtCostCenterFrom.getData();
        if (temp != null && temp instanceof CostCenterOrgUnitInfo) {
            costCenterFrom = (CostCenterOrgUnitInfo)temp;
        }
        if ((temp = this.prmtCostCenterTo.getData()) != null && temp instanceof CostCenterOrgUnitInfo) {
            costCenterTo = (CostCenterOrgUnitInfo)temp;
        }
        fp.setCostCenterFrom(costCenterFrom);
        fp.setCostCenterTo(costCenterTo);
        CostObjectInfo costObjectFrom = null;
        CostObjectInfo costObjectTo = null;
        temp = this.prmtCostObjectFrom.getData();
        if (temp != null && temp instanceof CostObjectInfo) {
            costObjectFrom = (CostObjectInfo)temp;
        }
        if ((temp = this.prmtCostObjectTo.getData()) != null && temp instanceof CostObjectInfo) {
            costObjectTo = (CostObjectInfo)temp;
        }
        fp.setCostObjectFrom(costObjectFrom);
        fp.setCostObjectTo(costObjectTo);
    }

    protected void loadBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof MaterialAllocVoucherFilterParam)) {
            return;
        }
        MaterialAllocVoucherFilterParam fp = (MaterialAllocVoucherFilterParam)filterParam;
        PeriodInfo period = null;
        String periodData = customerParams.getCustomerParam(this.Period);
        if (periodData != null && periodData.length() > 0) {
            period = null;
            try {
                period = PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectUuidPK(periodData));
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        fp.setPeriodInfo(period);
        CostCenterOrgUnitInfo ccFrom = null;
        CostCenterOrgUnitInfo ccTo = null;
        String costCenterFromData = customerParams.getCustomerParam(this.CostCenterFrom);
        String costCenterToData = customerParams.getCustomerParam(this.CostCenterTo);
        if (costCenterFromData != null && costCenterFromData.length() > 0) {
            ccFrom = new CostCenterOrgUnitInfo();
            ccFrom.setId(BOSUuid.read((String)costCenterFromData));
        }
        if (costCenterToData != null && costCenterToData.length() > 0) {
            ccTo = new CostCenterOrgUnitInfo();
            ccTo.setId(BOSUuid.read((String)costCenterToData));
        }
        fp.setCostCenterFrom(ccFrom);
        fp.setCostCenterTo(ccTo);
        CostObjectInfo cbFrom = null;
        CostObjectInfo cbTo = null;
        String costObjectFromData = customerParams.getCustomerParam(this.CostObjectFrom);
        String costObjectToData = customerParams.getCustomerParam(this.CostObjectTo);
        if (costObjectFromData != null && costObjectFromData.length() > 0) {
            cbFrom = new CostObjectInfo();
            cbFrom.setId(BOSUuid.read((String)costObjectFromData));
        }
        if (costObjectToData != null && costObjectToData.length() > 0) {
            cbTo = new CostObjectInfo();
            cbTo.setId(BOSUuid.read((String)costObjectToData));
        }
        fp.setCostObjectFrom(cbFrom);
        fp.setCostObjectTo(cbTo);
    }

    protected void loadFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof MaterialAllocVoucherFilterParam)) {
            return;
        }
        MaterialAllocVoucherFilterParam fp = (MaterialAllocVoucherFilterParam)filterParam;
        PeriodInfo period = null;
        if (fp.getPeriodInfo() != null) {
            period = null;
            try {
                period = PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectUuidPK(fp.getPeriodInfo().getId().toString()));
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        this.prmtPeriod.setData(period);
        this.prmtCostCenterFrom.setData((Object)fp.getCostCenterFrom());
        this.prmtCostCenterTo.setData((Object)fp.getCostCenterTo());
        this.prmtCostObjectFrom.setData((Object)fp.getCostObjectFrom());
        this.prmtCostObjectTo.setData((Object)fp.getCostObjectTo());
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = super.getFilterInfo();
        FilterInfo periodFilter = new FilterInfo();
        PeriodInfo period = (PeriodInfo)this.prmtPeriod.getValue();
        if (period != null) {
            periodFilter.getFilterItems().add(new FilterItemInfo("year", (Object)String.valueOf(period.getPeriodYear()), CompareType.EQUALS));
            periodFilter.getFilterItems().add(new FilterItemInfo("period", (Object)String.valueOf(period.getPeriodNumber()), CompareType.EQUALS));
        }
        try {
            filterInfo.mergeFilter(periodFilter, "AND");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return filterInfo;
    }

    public void clear() {
        super.clear();
        try {
            this.clearFilterData();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public KDBizPromptBox getCompanyF7() {
        return this.prmtCompanyOrg;
    }

    protected void registerF7() throws Exception {
        super.registerF7();
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenterFrom);
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenterTo);
        this.f7ContextManager.registerCostObjectF7(this.prmtCostObjectFrom, false);
        this.f7ContextManager.registerCostObjectF7(this.prmtCostObjectTo, false);
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.prmtCostObjectFrom, Boolean.TRUE, Boolean.FALSE, Boolean.TRUE, this.getCompanyOrgInfoWithDefault().getId().toString());
        this.prmtCostObjectFrom.setSelector((KDPromptSelector)arg0);
        CostObjectF7UISelector arg1 = new CostObjectF7UISelector((Object)this, this.prmtCostObjectTo, Boolean.TRUE, Boolean.FALSE, Boolean.TRUE, this.getCompanyOrgInfoWithDefault().getId().toString());
        this.prmtCostObjectTo.setSelector((KDPromptSelector)arg1);
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                this.prmtCostCenterFrom.setData(null);
                this.prmtCostCenterTo.setData(null);
                this.prmtCostObjectFrom.setData(null);
                this.prmtCostObjectTo.setData(null);
                this.prmtPeriod.setValue((Object)NCMUtils.GetCurrentPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString()));
                FilterInfo filterPrmt = new FilterInfo();
                filterPrmt.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)this.getCompanyOrgInfoWithDefault().getAccountPeriodType().getId().toString()));
                EntityViewInfo ev = new EntityViewInfo();
                ev.setFilter(filterPrmt);
                this.prmtPeriod.setEntityViewInfo(ev);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    private void clearFilterData() throws EASBizException, BOSException {
        this.prmtCostCenterFrom.setData(null);
        this.prmtCostCenterTo.setData(null);
        this.prmtCostObjectFrom.setData(null);
        this.prmtCostObjectTo.setData(null);
        this.prmtPeriod.setData((Object)NCMUtils.GetCurrentPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString()));
    }

    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    public boolean verify() {
        super.verify();
        if (this.prmtPeriod.getData() == null) {
            MsgBox.showInfo((String)"\u6838\u7b97\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\uff01");
            this.getCompanyF7().requestFocus();
            SysUtil.abort();
        }
        return true;
    }
}

