/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostItemCollection;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.AUXOverheadCollection;
import com.kingdee.eas.basedata.ncm.AUXOverheadFactory;
import com.kingdee.eas.basedata.ncm.AUXOverheadInfo;
import com.kingdee.eas.basedata.ncm.ExpenseCollection;
import com.kingdee.eas.basedata.ncm.ExpenseFactory;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.ncm.client.MaterialF7TreeListSelector;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.ncm.cal.report.client.AUXOverheadSumReportFilterUI;
import com.kingdee.eas.ncm.cal.report.client.AbstractAuxFeeAllocResultReportFilterUI;
import com.kingdee.eas.ncm.cal.report.client.SingleSpinnerFilterElement;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.SpinnerUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.util.Assert;
import java.awt.Component;
import java.util.HashSet;
import javax.swing.JSpinner;
import org.apache.log4j.Logger;

public class AuxFeeAllocResultReportFilterUI
extends AbstractAuxFeeAllocResultReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(AuxFeeAllocResultReportFilterUI.class);
    private PeriodInfo currentPeriod;
    private PeriodInfo startPeriod;
    private PeriodInfo maxPeriod = null;
    private CustomerParams cp = null;

    public AuxFeeAllocResultReportFilterUI() throws Exception {
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtCompanyOrg.setValue((Object)companyOrg);
        this.currentPeriod = sysctrol.getCacheCurrentPeriod(1001, companyOrg.getId().toString());
        if (this.currentPeriod == null) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        this.startPeriod = sysctrol.getStartPeriod(1001, companyOrg.getId().toString());
        this.maxPeriod = NCMUtils.getMaxPeriod((CompanyOrgUnitInfo)companyOrg, (PeriodInfo)this.currentPeriod);
    }

    @Override
    public void onLoad() throws Exception {
        this.formatPeriod();
        this.prmtCostObjectFrom.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CostObjectQuery");
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.prmtCostObjectFrom, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, this.getCompanyOrgInfoWithDefault().getId().toString());
        this.prmtCostObjectFrom.setSelector((KDPromptSelector)arg0);
        BDCMClientUtils.filterDataBaseDF7((String)"8CB367E7", (KDBizPromptBox)this.prmtAUXOverheadFrom);
        BDCMClientUtils.filterDataBaseDF7((String)"4A255827", (KDBizPromptBox)this.prmtExpenseFrom);
        this.filterProject(this.prmtProjectNumber);
        this.filterTrack(this.prmtTrackNumber);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)String.valueOf(1)));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        this.prmtMaterial.setEntityViewInfo(view);
        super.onLoad();
    }

    protected void formatPeriod() {
    }

    @Override
    protected FilterElement getFilterElement() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new AUXOverheadSumReportFilterUI.SingleBizPromptFilterElement("companyOrg", this.prmtCompanyOrg));
        Assert.that((this.getPeriodSpinner() != null && this.getPeriodSpinner().length == 4 ? 1 : 0) != 0);
        SingleSpinnerFilterElement element = new SingleSpinnerFilterElement(this.getPeriodSpinner()[0].getName(), (Component)this.getPeriodSpinner()[0]);
        element.setDefaultValue(this.currentPeriod.getPeriodYear());
        elements.add((FilterElement)element);
        element = new SingleSpinnerFilterElement(this.getPeriodSpinner()[1].getName(), (Component)this.getPeriodSpinner()[1]);
        element.setDefaultValue(this.currentPeriod.getPeriodYear());
        elements.add((FilterElement)element);
        element = new SingleSpinnerFilterElement(this.getPeriodSpinner()[2].getName(), (Component)this.getPeriodSpinner()[2]);
        element.setDefaultValue(this.currentPeriod.getPeriodNumber());
        elements.add((FilterElement)element);
        element = new SingleSpinnerFilterElement(this.getPeriodSpinner()[3].getName(), (Component)this.getPeriodSpinner()[3]);
        element.setDefaultValue(this.currentPeriod.getPeriodNumber());
        elements.add((FilterElement)element);
        elements.add((FilterElement)new F7SingleFilterElement("costCenterFrom", (Component)this.prmtCostCenterFrom));
        elements.add((FilterElement)new F7SingleFilterElement("expenseFrom", (Component)this.prmtExpenseFrom));
        elements.add((FilterElement)new F7SingleFilterElement("auxOverheadFrom", (Component)this.prmtAUXOverheadFrom));
        elements.add((FilterElement)new F7SingleFilterElement("costObjectFrom", (Component)this.prmtCostObjectFrom));
        elements.add((FilterElement)new F7SingleFilterElement("costItemFrom", (Component)this.prmtCostItemFrom));
        elements.add((FilterElement)new F7SingleFilterElement("orderNumberFrom", (Component)this.prmtOrderNumberFrom));
        elements.add((FilterElement)new SingleFilterElement("batchNumber", (Component)this.txtBatchNumber));
        elements.add((FilterElement)new F7SingleFilterElement("projectNumber", (Component)this.prmtProjectNumber));
        elements.add((FilterElement)new F7SingleFilterElement("trackNumber", (Component)this.prmtTrackNumber));
        elements.add((FilterElement)new F7SingleFilterElement("materialNumber", (Component)this.prmtMaterial));
        return elements;
    }

    protected void filterProject(KDBizPromptBox prmt) throws Exception {
        FilterInfo filter = ProjectFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), "id", "CU.id");
        EntityViewInfo view = null;
        view = prmt.getEntityViewInfo() != null ? prmt.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        prmt.setEntityViewInfo(view);
    }

    protected void filterTrack(KDBizPromptBox prmt) throws Exception {
        FilterInfo filter = TrackNumberFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), "id", "CU.id");
        EntityViewInfo view = null;
        view = prmt.getEntityViewInfo() != null ? prmt.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        prmt.setEntityViewInfo(view);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void initComp() throws Exception {
        BDCMClientUtils.setBizOrgF7ByType((KDBizPromptBox)this.prmtCompanyOrg, (OrgType)OrgType.Company);
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    @Override
    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CustomerParams params = this.cp;
        if (params != null) {
            this.loadPeriod(params);
            this.loadExpense(params);
            this.loadOverhead(params);
            this.loadCostCenterNum(params);
            this.loadCostObject(params);
            this.loadOrderNum(params);
            this.loadCostItemNum(params);
            this.loadProjectNum(params);
            this.loadTrackNum(params);
            this.loadMaterialNum(params);
            this.loadBatchNumber(params);
        }
    }

    private void loadPeriod(CustomerParams params) {
        PeriodInfo initPeriodFrom = this.currentPeriod;
        PeriodInfo initPeriodTo = this.currentPeriod;
        String initYearFrom = params.getCustomerParam("spYearFrom");
        String initMonthFrom = params.getCustomerParam("spPeriodFrom");
        String initYearTo = params.getCustomerParam("spYearTo");
        String initMonthTo = params.getCustomerParam("spPeriodTo");
        try {
            if (!StringUtils.isEmpty((String)initYearFrom) && !StringUtils.isEmpty((String)initMonthFrom)) {
                initPeriodFrom = new PeriodInfo();
                initPeriodFrom.setPeriodYear(Integer.parseInt(initYearFrom));
                initPeriodFrom.setPeriodNumber(Integer.parseInt(initMonthFrom));
            }
            if (!StringUtils.isEmpty((String)initYearTo) && !StringUtils.isEmpty((String)initMonthTo)) {
                initPeriodTo = new PeriodInfo();
                initPeriodTo.setPeriodYear(Integer.parseInt(initYearTo));
                initPeriodTo.setPeriodNumber(Integer.parseInt(initMonthTo));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)initPeriodFrom, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)initPeriodTo);
    }

    @Override
    public void setDefaultValue() {
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtCompanyOrg.setValue((Object)companyOrg);
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)this.currentPeriod);
    }

    @Override
    public KDBizPromptBox getCompanyF7() {
        return this.prmtCompanyOrg;
    }

    @Override
    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    @Override
    protected void registerF7() throws Exception {
        super.registerF7();
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenterFrom);
        this.f7ContextManager.registerCompanyFilterOnlyF7(this.prmtExpenseFrom, "com.kingdee.eas.basedata.ncm.app.ExpenseF7Query", "CompanyInfo.id");
        this.f7ContextManager.registerCompanyFilterOnlyF7(this.prmtAUXOverheadFrom, "com.kingdee.eas.basedata.ncm.app.AUXOverheadF7Query", "CompanyInfo.id");
        this.f7ContextManager.registerCostObjectF7(this.prmtCostObjectFrom, true);
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> statuses = new HashSet<Integer>();
        statuses.add(5);
        statuses.add(8);
        statuses.add(7);
        statuses.add(11);
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", statuses, CompareType.INCLUDE));
        this.f7ContextManager.registerManufactureOrderF7(this.prmtOrderNumberFrom, filter);
        this.prmtOrderNumberFrom.setDisplayFormat("$number$");
        this.f7ContextManager.registerMaterialTreeF7(this.prmtMaterial, null);
        MaterialF7TreeListSelector selector = new MaterialF7TreeListSelector((Object)this, this.prmtMaterial);
        this.prmtMaterial.setSelector((KDPromptSelector)selector);
    }

    @Override
    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                this.prmtExpenseFrom.setValue(null);
                this.prmtAUXOverheadFrom.setValue(null);
                this.prmtCostCenterFrom.setValue(null);
                this.prmtCostObjectFrom.setValue(null);
                this.prmtOrderNumberFrom.setValue(null);
                this.txtBatchNumber.setText(null);
                this.prmtProjectNumber.setValue(null);
                this.prmtTrackNumber.setValue(null);
                this.prmtMaterial.setValue(null);
                this.prmtCostItemFrom.setValue(null);
                this.initPeriod(this.getCompanyOrgInfoWithDefault());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private void initPeriod(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        this.maxPeriod = NCMUtils.getMaxPeriod((CompanyOrgUnitInfo)company, (PeriodInfo)this.currentPeriod);
        this.startPeriod = NCMUtils.GetStartPeriod(null, (String)company.getId().toString());
        this.currentPeriod = NCMUtils.GetCurrentPeriod(null, (String)company.getId().toString());
        if (this.currentPeriod == null) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        if (this.startPeriod == null) {
            return;
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)this.currentPeriod);
    }

    @Override
    protected String getReportViewPermissionItem() {
        return "AUXOverHeadAllocReportView";
    }

    @Override
    protected String getReportPrintPermissionItem() {
        return "AUXOverHeadAllocReportPrint";
    }

    @Override
    protected KDSpinner[] getPeriodSpinner() {
        return new KDSpinner[]{this.spYearFrom, this.spYearTo, this.spPeriodFrom, this.spPeriodTo};
    }

    @Override
    protected KDBizPromptBox[] getCostCenterF7() {
        return new KDBizPromptBox[]{this.prmtCostCenterFrom};
    }

    @Override
    protected KDBizPromptBox[] getCostObjectF7() {
        return new KDBizPromptBox[]{this.prmtCostObjectFrom};
    }

    @Override
    protected KDBizPromptBox[] getCostItemF7() {
        return new KDBizPromptBox[]{this.prmtCostItemFrom};
    }

    @Override
    protected KDBizPromptBox[] getOrderNumberF7() {
        return new KDBizPromptBox[]{this.prmtOrderNumberFrom};
    }

    @Override
    protected KDTextField[] getBatchNumberCtrls() {
        return new KDTextField[]{this.txtBatchNumber};
    }

    private void loadExpense(CustomerParams params) {
        String value = "";
        if (params.getCustomerParam("prmtExpenseFrom") != null) {
            value = params.getCustomerParam("prmtExpenseFrom");
        }
        if (StringUtils.isEmpty((String)value)) {
            this.prmtExpenseFrom.setData(null);
            return;
        }
        String[] numbers = value.split(";");
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < numbers.length; ++i) {
            set.add(numbers[i].trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        try {
            ExpenseCollection coll = ExpenseFactory.getRemoteInstance().getExpenseCollection(view);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                ExpenseInfo[] infos = new ExpenseInfo[size];
                for (int i = 0; i < size; ++i) {
                    infos[i] = coll.get(i);
                }
                this.prmtExpenseFrom.setData((Object)infos);
            }
        }
        catch (BOSException e) {
            this.prmtExpenseFrom.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadOverhead(CustomerParams params) {
        String value = "";
        if (params.getCustomerParam("prmtAUXOverheadFrom") != null) {
            value = params.getCustomerParam("prmtAUXOverheadFrom");
        }
        if (StringUtils.isEmpty((String)value)) {
            this.prmtAUXOverheadFrom.setData(null);
            return;
        }
        String[] numbers = value.split(";");
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < numbers.length; ++i) {
            set.add(numbers[i].trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        try {
            AUXOverheadCollection coll = AUXOverheadFactory.getRemoteInstance().getAUXOverheadCollection(view);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                AUXOverheadInfo[] infos = new AUXOverheadInfo[size];
                for (int i = 0; i < size; ++i) {
                    infos[i] = coll.get(i);
                }
                this.prmtAUXOverheadFrom.setData((Object)infos);
            }
        }
        catch (BOSException e) {
            this.prmtAUXOverheadFrom.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadCostCenterNum(CustomerParams params) {
        String value = "";
        if (params.getCustomerParam("prmtCostCenterFrom") != null) {
            value = params.getCustomerParam("prmtCostCenterFrom");
        }
        if (StringUtils.isEmpty((String)value)) {
            this.prmtCostCenterFrom.setData(null);
            return;
        }
        String[] numbers = value.split(";");
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < numbers.length; ++i) {
            set.add(numbers[i].trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        try {
            CostCenterOrgUnitCollection coll = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(view);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                CostCenterOrgUnitInfo[] infos = new CostCenterOrgUnitInfo[size];
                for (int i = 0; i < size; ++i) {
                    infos[i] = coll.get(i);
                }
                this.prmtCostCenterFrom.setData((Object)infos);
            }
        }
        catch (BOSException e) {
            this.prmtCostCenterFrom.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadCostObject(CustomerParams params) {
        String value = "";
        if (params.getCustomerParam("prmtCostObjectFrom") != null) {
            value = params.getCustomerParam("prmtCostObjectFrom");
        }
        if (StringUtils.isEmpty((String)value)) {
            this.prmtCostObjectFrom.setData(null);
            return;
        }
        String[] numbers = value.split(";");
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < numbers.length; ++i) {
            set.add(numbers[i].trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String companyId = this.getCompanyOrgInfoWithDefault().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        try {
            CostObjectCollection coll = CostObjectFactory.getRemoteInstance().getCostObjectCollection(view);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                CostObjectInfo[] infos = new CostObjectInfo[size];
                for (int i = 0; i < size; ++i) {
                    infos[i] = coll.get(i);
                }
                this.prmtCostObjectFrom.setData((Object)infos);
            }
        }
        catch (BOSException e) {
            this.prmtCostObjectFrom.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadOrderNum(CustomerParams params) {
        String value = "";
        if (params.getCustomerParam("prmtOrderNumberFrom") != null) {
            value = params.getCustomerParam("prmtOrderNumberFrom");
        }
        if (StringUtils.isEmpty((String)value)) {
            this.prmtOrderNumberFrom.setData(null);
            return;
        }
        String[] numbers = value.split(";");
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < numbers.length; ++i) {
            set.add(numbers[i].trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        try {
            ManufactureOrderCollection coll = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderCollection(view);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                ManufactureOrderInfo[] infos = new ManufactureOrderInfo[size];
                for (int i = 0; i < size; ++i) {
                    infos[i] = coll.get(i);
                }
                this.prmtOrderNumberFrom.setData((Object)infos);
            }
        }
        catch (BOSException e) {
            this.prmtOrderNumberFrom.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadProjectNum(CustomerParams params) {
        String value = "";
        if (params.getCustomerParam("prmtProjectNumber") != null) {
            value = params.getCustomerParam("prmtProjectNumber");
        }
        if (StringUtils.isEmpty((String)value)) {
            this.prmtProjectNumber.setData(null);
            return;
        }
        String[] numbers = value.split(";");
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < numbers.length; ++i) {
            set.add(numbers[i].trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        view.setSelector(sic);
        try {
            ProjectCollection coll = ProjectFactory.getRemoteInstance().getProjectCollection(view);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                ProjectInfo[] infos = new ProjectInfo[size];
                for (int i = 0; i < size; ++i) {
                    infos[i] = coll.get(i);
                }
                this.prmtProjectNumber.setData((Object)infos);
            }
        }
        catch (BOSException e) {
            this.prmtProjectNumber.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadTrackNum(CustomerParams params) {
        String value = "";
        if (params.getCustomerParam("prmtTrackNumber") != null) {
            value = params.getCustomerParam("prmtTrackNumber");
        }
        if (StringUtils.isEmpty((String)value)) {
            this.prmtTrackNumber.setData(null);
            return;
        }
        String[] numbers = value.split(";");
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < numbers.length; ++i) {
            set.add(numbers[i].trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        view.setSelector(sic);
        try {
            TrackNumberCollection coll = TrackNumberFactory.getRemoteInstance().getTrackNumberCollection(view);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                TrackNumberInfo[] infos = new TrackNumberInfo[size];
                for (int i = 0; i < size; ++i) {
                    infos[i] = coll.get(i);
                }
                this.prmtTrackNumber.setData((Object)infos);
            }
        }
        catch (BOSException e) {
            this.prmtTrackNumber.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadMaterialNum(CustomerParams params) {
        String value = "";
        if (params.getCustomerParam("prmtMaterial") != null) {
            value = params.getCustomerParam("prmtMaterial");
        }
        if (StringUtils.isEmpty((String)value)) {
            this.prmtMaterial.setData(null);
            return;
        }
        String[] numbers = value.split(";");
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < numbers.length; ++i) {
            set.add(numbers[i].trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        view.setSelector(sic);
        try {
            MaterialCollection coll = MaterialFactory.getRemoteInstance().getMaterialCollection(view);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                MaterialInfo[] infos = new MaterialInfo[size];
                for (int i = 0; i < size; ++i) {
                    infos[i] = coll.get(i);
                }
                this.prmtMaterial.setData((Object)infos);
            }
        }
        catch (BOSException e) {
            this.prmtMaterial.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadCostItemNum(CustomerParams params) {
        String value = "";
        if (params.getCustomerParam("prmtCostItemFrom") != null) {
            value = params.getCustomerParam("prmtCostItemFrom");
        }
        if (StringUtils.isEmpty((String)value)) {
            this.prmtCostItemFrom.setData(null);
            return;
        }
        String[] numbers = value.split(";");
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < numbers.length; ++i) {
            set.add(numbers[i].trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
        view.setFilter(filter);
        try {
            FilterInfo costItemFilterInfo = this.getCostItemFilter();
            costItemFilterInfo.mergeFilter(filter, "and");
            view.setFilter(costItemFilterInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        try {
            CostItemCollection coll = CostItemFactory.getRemoteInstance().getCostItemCollection(view);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                CostItemInfo[] infos = new CostItemInfo[size];
                for (int i = 0; i < size; ++i) {
                    infos[i] = coll.get(i);
                }
                this.prmtCostItemFrom.setData((Object)infos);
            }
        }
        catch (BOSException e) {
            this.prmtCostItemFrom.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    @Override
    protected void loadBatchNumber(CustomerParams params) {
        String batchNumberFrom = "";
        String batchNumberTo = "";
        if (params.getCustomerParam(this.getSpecialCustomerParamKey(this.getBatchNumberCtrls()[0].getName())) != null) {
            batchNumberFrom = params.getCustomerParam(this.getSpecialCustomerParamKey(this.getBatchNumberCtrls()[0].getName()));
            this.getBatchNumberCtrls()[0].setText(batchNumberFrom);
        }
    }

    class F7BatchFilterElement
    extends SingleFilterElement {
        public F7BatchFilterElement(String id, Component component) {
            super(id, component);
        }

        protected void setNumber(Object obj, String value) {
            ((KDBizPromptBox)obj).setText(value);
        }
    }

    class F7SingleFilterElement
    extends SingleFilterElement {
        public F7SingleFilterElement(String id, Component component) {
            super(id, component);
        }

        protected void setNumber(Object obj, String value) {
            ((KDBizPromptBox)obj).setData((Object)value);
        }
    }
}

