/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostObjectEntryCollection;
import com.kingdee.eas.basedata.assistant.CostObjectEntryFactory;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.ncm.client.MaterialF7TreeListSelector;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.client.AbstractByClassCostCalReportFilterUI;
import com.kingdee.eas.ncm.cal.report.client.ByClassCostCalReportFilter2UI;
import com.kingdee.eas.ncm.cal.report.client.CheckBoxFilterElement;
import com.kingdee.eas.ncm.cal.report.client.NCMReportFilterUI;
import com.kingdee.eas.ncm.cal.report.client.SingleSpinnerFilterElement;
import com.kingdee.eas.ncm.cal.report.client.SpinnerFilterElement;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.SpinnerUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class ByClassCostCalReportFilterUI
extends AbstractByClassCostCalReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ByClassCostCalReportFilterUI.class);
    ByClassCostCalReportFilter2UI filter2UI = null;
    private PeriodInfo currentPeriod;
    private PeriodInfo startPeriod;
    private PeriodInfo maxPeriod = null;
    private CustomerParams cp = null;

    public ByClassCostCalReportFilterUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        NCMClientUtils.checkIsStart();
    }

    @Override
    public void onLoad() throws Exception {
        this.formatUI();
        super.onLoad();
        if (this.filter2UI != null) {
            ((CompositeFilterElement)this.getFilterManager().getElement()).add((FilterElement)new KDTableFilterElement("table", this.filter2UI.tableMain));
        }
        this.kDTabbedPane1.setComponentAt(0, (Component)this.kDTab1);
        this.kDTabbedPane1.add((Component)this.kDTab2, (Object)this.resHelper.getString("kDTab2.constraints"));
    }

    private void formatUI() throws Exception {
        CompanyOrgUnitInfo companyOrg = this.getCompanyOrgInfoWithDefault();
        this.initPeriod(companyOrg);
        this.spCostObjectNum.setModel((SpinnerModel)new SpinnerNumberModel(1, 1, 200, 1));
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.prmtCostObjectFrom, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, this.getCompanyOrgInfoWithDefault().getId().toString());
        this.prmtCostObjectFrom.setSelector((KDPromptSelector)arg0);
        CostObjectF7UISelector arg1 = new CostObjectF7UISelector((Object)this, this.prmtCostObjectTo, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, this.getCompanyOrgInfoWithDefault().getId().toString());
        this.prmtCostObjectTo.setSelector((KDPromptSelector)arg1);
    }

    @Override
    protected FilterElement getFilterElement() {
        CompositeFilterElement elements = (CompositeFilterElement)super.getFilterElement();
        elements = new CompositeFilterElement(0);
        NCMReportFilterUI.SingleComPromptFilterElement filterElement = new NCMReportFilterUI.SingleComPromptFilterElement(this, "prmtCompanyOrg", this.prmtCompanyOrg);
        filterElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"183_CCFeeTotalReportFilterUI")));
        elements.add((FilterElement)filterElement);
        SingleFilterElement element = new SingleSpinnerFilterElement("spYearFrom", (Component)this.spYearFrom);
        elements.add((FilterElement)element);
        element = new SingleSpinnerFilterElement("spYearTo", (Component)this.spYearTo);
        elements.add((FilterElement)element);
        element = new SingleSpinnerFilterElement("spPeriodFrom", (Component)this.spPeriodFrom);
        elements.add((FilterElement)element);
        element = new SingleSpinnerFilterElement("spPeriodTo", (Component)this.spPeriodTo);
        elements.add((FilterElement)element);
        elements.add((FilterElement)new SingleFilterElement("prmtCostCenterFrom", (Component)this.prmtCostCenterFrom));
        elements.add((FilterElement)new SingleFilterElement("prmtCostCenterTo", (Component)this.prmtCostCenterTo));
        elements.add((FilterElement)new SingleFilterElement("prmtCostObjectFrom", (Component)this.prmtCostObjectFrom));
        elements.add((FilterElement)new SingleFilterElement("prmtCostObjectTo", (Component)this.prmtCostObjectTo));
        elements.add((FilterElement)new SingleFilterElement("prmtProductFrom", (Component)this.prmtProductFrom));
        elements.add((FilterElement)new SingleFilterElement("prmtProductTo", (Component)this.prmtProductTo));
        elements.add((FilterElement)new SingleFilterElement("prmtCostItemFrom", (Component)this.prmtCostItemFrom));
        elements.add((FilterElement)new SingleFilterElement("prmtCostItemTo", (Component)this.prmtCostItemTo));
        this.spCostObjectNum.setModel((SpinnerModel)new SpinnerNumberModel(20, 1, 1000, 1));
        element = new SpinnerFilterElement("spCostObjectNum", (Component)this.spCostObjectNum);
        element.setDefaultValue((Object)20);
        elements.add((FilterElement)element);
        this.getFilterManager().setElement((FilterElement)elements);
        if (this.kDTab2.getComponentCount() == 0) {
            try {
                this.filter2UI = new ByClassCostCalReportFilter2UI();
                this.filter2UI.onLoad();
                this.filter2UI.initLayout();
                this.filter2UI.repaint();
                this.filter2UI.setBounds(new Rectangle(-50, -40, 400, 500));
                this.kDTab2.add((Component)((Object)this.filter2UI));
                ((CompositeFilterElement)this.getFilterManager().getElement()).add((FilterElement)new KDTableFilterElement("table", this.filter2UI.tableMain));
                ((CompositeFilterElement)this.getFilterManager().getElement()).add((FilterElement)new CheckBoxFilterElement("disPlayOnlyTotalRow", this.filter2UI.disPlayOnlyTotalRow));
                ((CompositeFilterElement)this.getFilterManager().getElement()).add((FilterElement)new CheckBoxFilterElement("isTotalRowTop", this.filter2UI.isTotalRowTop));
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return elements;
    }

    private void initPeriod(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        this.maxPeriod = NCMUtils.getMaxPeriod((CompanyOrgUnitInfo)company, (PeriodInfo)this.currentPeriod);
        this.startPeriod = NCMUtils.GetStartPeriod(null, (String)company.getId().toString());
        this.currentPeriod = NCMUtils.GetCurrentPeriod(null, (String)company.getId().toString());
        if (this.currentPeriod == null) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        if (this.startPeriod == null) {
            return;
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)this.currentPeriod);
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    @Override
    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.prmtCompanyOrg.setValue((Object)this.getCompanyOrgInfoWithDefault());
        CustomerParams params = this.cp;
        if (params != null) {
            this.loadPeriod(params);
        }
    }

    private void loadPeriod(CustomerParams params) {
        PeriodInfo initPeriodFrom = this.currentPeriod;
        PeriodInfo initPeriodTo = this.currentPeriod;
        String initYearFrom = params.getCustomerParam("spYearFrom");
        String initMonthFrom = params.getCustomerParam("spPeriodFrom");
        String initYearTo = params.getCustomerParam("spYearTo");
        String initMonthTo = params.getCustomerParam("spPeriodTo");
        try {
            if (!StringUtils.isEmpty((String)initYearFrom) && !StringUtils.isEmpty((String)initMonthFrom)) {
                initPeriodFrom = new PeriodInfo();
                initPeriodFrom.setPeriodYear(Integer.parseInt(initYearFrom));
                initPeriodFrom.setPeriodNumber(Integer.parseInt(initMonthFrom));
            }
            if (!StringUtils.isEmpty((String)initYearTo) && !StringUtils.isEmpty((String)initMonthTo)) {
                initPeriodTo = new PeriodInfo();
                initPeriodTo.setPeriodYear(Integer.parseInt(initYearTo));
                initPeriodTo.setPeriodNumber(Integer.parseInt(initMonthTo));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)initPeriodFrom, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)initPeriodTo);
    }

    @Override
    public void setDefaultValue() {
        super.setDefaultValue();
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)this.currentPeriod);
    }

    @Override
    protected KDSpinner[] getPeriodSpinner() {
        return new KDSpinner[]{this.spYearFrom, this.spYearTo, this.spPeriodFrom, this.spPeriodTo};
    }

    @Override
    protected KDSpinner getDisplayCountSpinner() {
        return this.spCostObjectNum;
    }

    @Override
    protected KDBizPromptBox[] getCostCenterF7() {
        return new KDBizPromptBox[]{this.prmtCostCenterFrom, this.prmtCostCenterTo};
    }

    @Override
    protected KDBizPromptBox[] getCostObjectF7() {
        return new KDBizPromptBox[]{this.prmtCostObjectFrom, this.prmtCostObjectTo};
    }

    @Override
    protected KDBizPromptBox[] getMaterialF7() {
        return new KDBizPromptBox[]{this.prmtProductFrom, this.prmtProductTo};
    }

    @Override
    protected KDBizPromptBox[] getCostItemF7() {
        return new KDBizPromptBox[]{this.prmtCostItemFrom, this.prmtCostItemTo};
    }

    @Override
    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrg;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public KDBizPromptBox getCompanyF7() {
        return this.prmtCompanyOrg;
    }

    @Override
    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    @Override
    protected void registerF7() throws Exception {
        super.registerF7();
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenterFrom);
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenterTo);
        FilterInfo filterByClass = new FilterInfo();
        filterByClass.getFilterItems().add(new FilterItemInfo("calculateMode", (Object)String.valueOf(3)));
        this.f7ContextManager.registerF7ByFilterInfo(this.prmtCostObjectFrom, "com.kingdee.eas.basedata.assistant.app.F7GroupCostObjectForNcmQuery", "company.id", filterByClass);
        this.f7ContextManager.registerF7ByFilterInfo(this.prmtCostObjectTo, "com.kingdee.eas.basedata.assistant.app.F7GroupCostObjectForNcmQuery", "company.id", filterByClass);
        FilterInfo filterProd = new FilterInfo();
        filterProd.getFilterItems().add(new FilterItemInfo("FIInfo.calculateType", (Object)2));
        this.f7ContextManager.registerMaterialTreeF7(this.prmtProductFrom, filterProd);
        MaterialF7TreeListSelector selector = new MaterialF7TreeListSelector((Object)this, this.prmtProductFrom);
        this.prmtProductFrom.setSelector((KDPromptSelector)selector);
        this.f7ContextManager.registerMaterialTreeF7(this.prmtProductTo, filterProd);
        selector = new MaterialF7TreeListSelector((Object)this, this.prmtProductTo);
        this.prmtProductTo.setSelector((KDPromptSelector)selector);
    }

    @Override
    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                IObjectPK[] coPKs;
                this.prmtCostCenterFrom.setData(null);
                this.prmtCostCenterTo.setData(null);
                this.prmtCostObjectFrom.setData(null);
                this.prmtCostObjectTo.setData(null);
                this.prmtProductFrom.setData(null);
                this.prmtProductTo.setData(null);
                this.initPeriod(this.getCompanyOrgInfoWithDefault());
                EntityViewInfo coEvi = this.prmtCostObjectFrom.getEntityViewInfo();
                if (coEvi != null && (coPKs = CostObjectFactory.getRemoteInstance().getPKList(coEvi.getFilter(), null)) != null && coPKs.length > 0) {
                    HashSet<String> coPKset = new HashSet<String>(coPKs.length);
                    for (int i = 0; i < coPKs.length; ++i) {
                        coPKset.add(coPKs[i].toString());
                    }
                    EntityViewInfo coeEvi = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("parent.id", coPKset, CompareType.INCLUDE));
                    coeEvi.setFilter(filter);
                    coeEvi.getSelector().add("RelatedID");
                    CostObjectEntryCollection materials = CostObjectEntryFactory.getRemoteInstance().getCostObjectEntryCollection(coeEvi);
                    int n = materials.size();
                    HashSet<String> matSet = new HashSet<String>(n);
                    for (int j = 0; j < n; ++j) {
                        matSet.add(materials.get(j).getRelatedID().toString());
                    }
                    if (matSet.size() > 0) {
                        FilterInfo filterProd = new FilterInfo();
                        filterProd.getFilterItems().add(new FilterItemInfo("FIInfo.calculateType", (Object)2));
                        filterProd.getFilterItems().add(new FilterItemInfo("id", matSet, CompareType.INCLUDE));
                        this.f7ContextManager.registerMaterialTreeF7(this.prmtProductFrom, filterProd);
                        MaterialF7TreeListSelector selector = new MaterialF7TreeListSelector((Object)this, this.prmtProductFrom);
                        this.prmtProductFrom.setSelector((KDPromptSelector)selector);
                        this.f7ContextManager.registerMaterialTreeF7(this.prmtProductTo, filterProd);
                        selector = new MaterialF7TreeListSelector((Object)this, this.prmtProductTo);
                        this.prmtProductTo.setSelector((KDPromptSelector)selector);
                        this.f7ContextManager.changeF7Context(this.getUIContext(), this.orgContextManager().getMainOrgContext(), this.prmtProductFrom);
                        this.f7ContextManager.changeF7Context(this.getUIContext(), this.orgContextManager().getMainOrgContext(), this.prmtProductTo);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    @Override
    protected String getReportViewPermissionItem() {
        return "ByClassCostStatReportView";
    }

    @Override
    protected String getReportPrintPermissionItem() {
        return "ByClassCostStatReportPrint";
    }

    static class KDTableFilterElement
    extends SingleFilterElement {
        private KDTable table;

        public KDTableFilterElement(String id, KDTable component) {
            super(id, (Component)component);
            this.table = component;
        }

        protected String getName(Object obj) {
            if (obj instanceof KDTable) {
                return ((KDTable)obj).getName();
            }
            return null;
        }

        public void addCustomerParam(CustomerParams cp, String key, Object obj) {
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                for (int j = 0; j < this.table.getColumnCount(); ++j) {
                    IColumn col = this.table.getColumn(j);
                    cp.addCustomerParam("_" + col.getKey() + ":" + i, this.table.getRow(i).getCell(col.getKey()).getValue().toString());
                }
            }
        }

        public void setElementValue(CustomerParams cp) {
            Set keySet;
            if (cp != null && (keySet = (Set)cp.getKeys()) != null && keySet.size() > 0) {
                String key2 = null;
                for (String key2 : keySet) {
                    if (key2 == null || !key2.startsWith("_")) continue;
                    int index = Integer.parseInt(key2.substring(key2.lastIndexOf(":") + 1));
                    String fieldKey = key2.substring(1, key2.lastIndexOf(":"));
                    if (fieldKey.equals("isTotal")) {
                        this.table.getRow(index).getCell(fieldKey).setValue((Object)Boolean.valueOf(cp.getCustomerParam(key2)));
                    }
                    if (fieldKey.equals("fieldName")) {
                        this.table.getRow(index).getCell(fieldKey).setValue((Object)cp.getCustomerParam(key2));
                    }
                    if (!fieldKey.equals("id")) continue;
                    this.table.getRow(index).getCell(fieldKey).setValue((Object)cp.getCustomerParam(key2));
                }
            }
        }

        public void addRptParams(RptParams cp) {
            ArrayList list = this.getParamterFromKDTable();
            cp.setObject(this.getId(), (Object)list);
        }

        private ArrayList getParamterFromKDTable() {
            ArrayList list = new ArrayList();
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int j = 0; j < this.table.getColumnCount(); ++j) {
                    IColumn col = this.table.getColumn(j);
                    map.put(col.getKey(), this.table.getRow(i).getCell(col.getKey()).getValue());
                }
                list.add(map);
            }
            return list;
        }
    }
}

