/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.ncm.ExpenseCollection;
import com.kingdee.eas.basedata.ncm.ExpenseFactory;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.client.AbstractCCFeeTotalReportFilterUI;
import com.kingdee.eas.ncm.cal.report.client.CheckBoxFilterElement;
import com.kingdee.eas.ncm.cal.report.client.SpinnerFilterElement;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.SpinnerUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.ParseException;
import javax.swing.JSpinner;
import org.apache.log4j.Logger;

public class CCFeeTotalReportFilterUI
extends AbstractCCFeeTotalReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CCFeeTotalReportFilterUI.class);
    private PeriodInfo currentPeriod;
    private PeriodInfo startPeriod;
    private PeriodInfo maxPeriod = null;
    private CustomerParams cp = null;

    public CCFeeTotalReportFilterUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        NCMClientUtils.checkIsStart();
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        this.currentPeriod = sysctrol.getCacheCurrentPeriod(1001, companyOrg.getId().toString());
        if (this.currentPeriod == null) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        this.startPeriod = sysctrol.getStartPeriod(1001, companyOrg.getId().toString());
        this.maxPeriod = NCMUtils.getMaxPeriod((CompanyOrgUnitInfo)companyOrg, (PeriodInfo)this.currentPeriod);
        this.prmtCompanyOrg.setValue((Object)companyOrg);
        BDCMClientUtils.setBizOrgF7ByType((KDBizPromptBox)this.prmtCompanyOrg, (OrgType)OrgType.Company);
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterFrom, (String)companyOrg.getId().toString());
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterTo, (String)companyOrg.getId().toString());
        FilterInfo expenseFilterInfo = this.getExpenseFilter();
        this.setFilterInfoF7(this.prmtExpenseFrom, expenseFilterInfo);
        this.setFilterInfoF7(this.prmtExpenseTo, expenseFilterInfo);
    }

    @Override
    protected FilterElement getFilterElement() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleBizPromptFilterElement filterElement = new SingleBizPromptFilterElement("companyorg", this.prmtCompanyOrg);
        filterElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"183_CCFeeTotalReportFilterUI")));
        elements.add((FilterElement)filterElement);
        SpinnerFilterElement element = new SpinnerFilterElement("yearfrom", (Component)this.spYearFrom);
        element.setDefaultValue(this.currentPeriod.getPeriodYear());
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("yearto", (Component)this.spYearTo);
        element.setDefaultValue(this.currentPeriod.getPeriodYear());
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("periodfrom", (Component)this.spPeriodFrom);
        element.setDefaultValue(this.currentPeriod.getPeriodNumber());
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("periodto", (Component)this.spPeriodTo);
        element.setDefaultValue(this.currentPeriod.getPeriodNumber());
        elements.add((FilterElement)element);
        elements.add((FilterElement)new SingleFilterElement("costcenterfrom", (Component)this.prmtCostCenterFrom));
        elements.add((FilterElement)new SingleFilterElement("costcenterto", (Component)this.prmtCostCenterTo));
        elements.add((FilterElement)new CheckBoxFilterElement("labor", this.cbLabor));
        elements.add((FilterElement)new CheckBoxFilterElement("manufacture", this.cbManufacture));
        elements.add((FilterElement)new CheckBoxFilterElement("consign", this.cbConsign));
        elements.add((FilterElement)new CheckBoxFilterElement("equipment", this.cbEquipment));
        elements.add((FilterElement)new CheckBoxFilterElement("other", this.cbOther));
        elements.add((FilterElement)new CheckBoxFilterElement("material", this.cbMaterial));
        elements.add((FilterElement)new SingleBizPromptFilterElement("expensefrom", this.prmtExpenseFrom));
        elements.add((FilterElement)new SingleBizPromptFilterElement("expenseto", this.prmtExpenseTo));
        return elements;
    }

    private void setFilterInfoF7(KDBizPromptBox f7, FilterInfo filter) {
        EntityViewInfo view = f7.getEntityViewInfo() != null ? f7.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    @Override
    protected FilterInfo getCostItemFilter() throws Exception {
        return CostItemFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
    }

    protected FilterInfo getExpenseFilter() throws Exception {
        return ExpenseFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
    }

    @Override
    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    @Override
    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    protected String getAdminCUFieldName() {
        return "adminCU.id";
    }

    private void filterItemF7(KDBizPromptBox f7, String compnayID) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)compnayID));
        this.setFilterInfoF7(f7, filter);
    }

    @Override
    public void clear() {
        this.getFilterManager().clearAll();
        this.setDefaultValue();
    }

    @Override
    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrg;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public KDBizPromptBox getCompanyF7() {
        return this.prmtCompanyOrg;
    }

    @Override
    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    @Override
    protected void registerF7() throws Exception {
        super.registerF7();
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenterFrom);
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenterTo);
        this.f7ContextManager.registerCompanyFilterOnlyF7(this.prmtExpenseFrom, "com.kingdee.eas.basedata.ncm.app.ExpenseF7Query", "CompanyInfo.id");
        this.f7ContextManager.registerCompanyFilterOnlyF7(this.prmtExpenseTo, "com.kingdee.eas.basedata.ncm.app.ExpenseF7Query", "CompanyInfo.id");
    }

    @Override
    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                this.prmtCostCenterFrom.setValue(null);
                this.prmtCostCenterTo.setValue(null);
                this.prmtExpenseFrom.setValue(null);
                this.prmtExpenseTo.setValue(null);
                this.cbLabor.setSelected(true);
                this.cbManufacture.setSelected(true);
                this.cbConsign.setSelected(true);
                this.cbEquipment.setSelected(true);
                this.cbOther.setSelected(true);
                this.cbMaterial.setSelected(true);
                this.initPeriod(this.getCompanyOrgInfoWithDefault());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private void initPeriod(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        this.maxPeriod = NCMUtils.getMaxPeriod((CompanyOrgUnitInfo)company, (PeriodInfo)this.currentPeriod);
        this.startPeriod = NCMUtils.GetStartPeriod(null, (String)company.getId().toString());
        this.currentPeriod = NCMUtils.GetCurrentPeriod(null, (String)company.getId().toString());
        if (this.currentPeriod == null) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        if (this.startPeriod == null) {
            return;
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)this.currentPeriod);
    }

    @Override
    protected String getReportViewPermissionItem() {
        return "CCFeeTotalReportView";
    }

    @Override
    protected String getReportPrintPermissionItem() {
        return "CCFeeTotalReportPrint";
    }

    @Override
    public boolean verify() {
        Integer yearFrom = (Integer)this.spYearFrom.getValue();
        Integer yearTo = (Integer)this.spYearTo.getValue();
        if (yearTo.compareTo(yearFrom) < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"184_CCFeeTotalReportFilterUI"));
            return false;
        }
        if (yearTo.compareTo(yearFrom) == 0) {
            Integer periodFrom = (Integer)this.spPeriodFrom.getValue();
            Integer periodTo = (Integer)this.spPeriodTo.getValue();
            if (periodTo.compareTo(periodFrom) < 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"184_CCFeeTotalReportFilterUI"));
                return false;
            }
        }
        return super.verify();
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    @Override
    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CustomerParams params = this.cp;
        if (params != null) {
            this.loadPeriod(params);
            this.loadExpense(params);
            this.loadCostCenterNum(params);
        }
    }

    private void loadPeriod(CustomerParams params) {
        PeriodInfo initPeriodFrom = this.currentPeriod;
        PeriodInfo initPeriodTo = this.currentPeriod;
        String initYearFrom = params.getCustomerParam("spYearFrom");
        String initMonthFrom = params.getCustomerParam("spPeriodFrom");
        String initYearTo = params.getCustomerParam("spYearTo");
        String initMonthTo = params.getCustomerParam("spPeriodTo");
        try {
            if (!StringUtils.isEmpty((String)initYearFrom) && !StringUtils.isEmpty((String)initMonthFrom)) {
                initPeriodFrom = new PeriodInfo();
                initPeriodFrom.setPeriodYear(Integer.parseInt(initYearFrom));
                initPeriodFrom.setPeriodNumber(Integer.parseInt(initMonthFrom));
            }
            if (!StringUtils.isEmpty((String)initYearTo) && !StringUtils.isEmpty((String)initMonthTo)) {
                initPeriodTo = new PeriodInfo();
                initPeriodTo.setPeriodYear(Integer.parseInt(initYearTo));
                initPeriodTo.setPeriodNumber(Integer.parseInt(initMonthTo));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)initPeriodFrom, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)initPeriodTo);
    }

    @Override
    protected void setDefaultValue() {
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtCompanyOrg.setValue((Object)companyOrg);
        this.prmtCostCenterFrom.setValue(null);
        this.prmtCostCenterTo.setValue(null);
        this.prmtExpenseFrom.setValue(null);
        this.prmtExpenseTo.setValue(null);
        this.cbLabor.setSelected(true);
        this.cbManufacture.setSelected(true);
        this.cbConsign.setSelected(true);
        this.cbEquipment.setSelected(true);
        this.cbOther.setSelected(true);
        this.cbMaterial.setSelected(true);
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)this.currentPeriod);
    }

    private void loadCostCenterNum(CustomerParams params) {
        String costCenterFrom = "";
        String costCenterTo = "";
        if (params.getCustomerParam("prmtCostCenterFrom") != null) {
            costCenterFrom = params.getCustomerParam("prmtCostCenterFrom");
        }
        if (params.getCustomerParam("prmtCostCenterTo") != null) {
            costCenterTo = params.getCustomerParam("prmtCostCenterTo");
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterFrom));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterTo));
            view.setFilter(filter);
            view.getFilter().setMaskString("#0 or #1");
            CostCenterOrgUnitCollection costCenterColl = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(view);
            if (costCenterColl != null && costCenterColl.size() > 0) {
                if (costCenterColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (costCenterColl.get(i).getNumber().equals(costCenterFrom)) {
                            this.prmtCostCenterFrom.setData((Object)costCenterColl.get(0));
                            continue;
                        }
                        this.prmtCostCenterTo.setData((Object)costCenterColl.get(1));
                    }
                } else if (costCenterColl.size() == 1) {
                    if (costCenterColl.get(0).getNumber().equals(costCenterFrom)) {
                        this.prmtCostCenterFrom.setData((Object)costCenterColl.get(0));
                    }
                    if (costCenterColl.get(0).getNumber().equals(costCenterTo)) {
                        this.prmtCostCenterTo.setData((Object)costCenterColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtCostCenterFrom.setData(null);
            this.prmtCostCenterTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadExpense(CustomerParams params) {
        String expenseFrom = "";
        String expenseTo = "";
        if (params.getCustomerParam("prmtExpenseFrom") != null) {
            expenseFrom = params.getCustomerParam("prmtExpenseFrom");
        }
        if (params.getCustomerParam("prmtExpenseTo") != null) {
            expenseTo = params.getCustomerParam("prmtExpenseTo");
        }
        try {
            ExpenseCollection expenseColl = ExpenseFactory.getRemoteInstance().getExpenseCollection("select * where number ='" + expenseFrom + "' or number = '" + expenseTo + "'");
            if (expenseColl != null && expenseColl.size() > 0) {
                if (expenseColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (expenseColl.get(i).getNumber().equals(expenseFrom)) {
                            this.prmtExpenseFrom.setData((Object)expenseColl.get(i));
                            continue;
                        }
                        this.prmtExpenseTo.setData((Object)expenseColl.get(i));
                    }
                } else if (expenseColl.size() == 1) {
                    if (expenseColl.get(0).getNumber().equals(expenseFrom)) {
                        this.prmtExpenseFrom.setData((Object)expenseColl.get(0));
                    }
                    if (expenseColl.get(0).getNumber().equals(expenseTo)) {
                        this.prmtExpenseTo.setData((Object)expenseColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtExpenseFrom.setData(null);
            this.prmtExpenseTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    static class SingleBizPromptFilterElement
    extends SingleFilterElement {
        KDBizPromptBox prmt;

        public SingleBizPromptFilterElement(String id, KDBizPromptBox component) {
            super(id, (Component)component);
            this.prmt = component;
        }

        public void addRptParams(RptParams cp) {
            Object object = this.prmt.getValue();
            if (object == null) {
                try {
                    this.prmt.commitEdit();
                }
                catch (ParseException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                object = this.prmt.getValue();
            }
            if (object instanceof Object[]) {
                object = ((Object[])object)[0];
            }
            cp.setObject(this.getId(), object);
        }
    }
}

