/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.ncm.cal.report.client.AbstractCostCalPreDetailVoucherReportFilterUI;
import com.kingdee.eas.ncm.cal.report.client.CheckBoxFilterElement;
import com.kingdee.eas.ncm.cal.report.client.NCMReportFilterUI;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import java.text.ParseException;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class CostCalPreDetailVoucherReportFilterUI
extends AbstractCostCalPreDetailVoucherReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CostCalPreDetailVoucherReportFilterUI.class);
    CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
    String comOrgId = this.companyOrg.getId().toString();
    private CustomerParams cp = null;
    private boolean flag = false;

    public CostCalPreDetailVoucherReportFilterUI() throws Exception {
        this.costobject.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.costobject, Boolean.TRUE);
        this.costobject.setSelector((KDPromptSelector)arg0);
        this.period.setEnabled(true);
        this.costobject.setCommitFormat("$number$");
    }

    @Override
    protected void registerF7() throws Exception {
        super.registerF7();
        this.f7ContextManager.registerCostCenterF7(this.costcenter);
        this.f7ContextManager.registerCostObjectF7(this.costobject, true);
        this.costcenter.setEnabledMultiSelection(true);
    }

    @Override
    public void setDefaultValue() {
        super.setDefaultValue();
        try {
            this.period.setValue((Object)NCMUtils.GetCurrentPeriod(null, (String)this.comOrgId));
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        this.cbIncludeStatUnit.setSelected(false);
    }

    @Override
    protected FilterElement getFilterElement() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        NCMReportFilterUI.SingleComPromptFilterElement filterElement = new NCMReportFilterUI.SingleComPromptFilterElement(this, "companyorg", this.companyorg);
        filterElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"183_CCFeeTotalReportFilterUI")));
        elements.add((FilterElement)filterElement);
        elements.add((FilterElement)new NCMReportFilterUI.SingleComPromptFilterElement(this, "period", this.period));
        elements.add((FilterElement)new NCMReportFilterUI.MutilComPromptFilterElement(this, "costcenter", this.costcenter));
        elements.add((FilterElement)new NCMReportFilterUI.SingleComPromptFilterElement(this, "costobject", this.costobject));
        elements.add((FilterElement)new CheckBoxFilterElement(this.cbIncludeStatUnit.getName(), this.cbIncludeStatUnit));
        return elements;
    }

    @Override
    public KDBizPromptBox getMainBizOrgF7() {
        return this.companyorg;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public boolean verify() {
        if (this.companyorg.getText() != null) {
            try {
                this.companyorg.commitEdit();
            }
            catch (ParseException e) {
                this.handUIException(e);
            }
        }
        if (this.costcenter.getText() != null) {
            try {
                this.costcenter.commitEdit();
            }
            catch (ParseException e) {
                this.handUIException(e);
            }
        }
        if (this.costobject.getText() != null) {
            try {
                this.costobject.commitEdit();
            }
            catch (ParseException e) {
                this.handUIException(e);
            }
        }
        return super.verify();
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
        this.flag = true;
        try {
            this.loadPeriod();
            if (cp != null) {
                this.loadCompany(cp);
                this.loadCostCenter(cp);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    @Override
    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.flag = true;
        try {
            this.loadPeriod();
            if (this.cp != null) {
                this.loadCompany(this.cp);
                this.loadCostCenter(this.cp);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    @Override
    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                this.costcenter.setValue(null);
                this.costobject.setValue(null);
                FilterInfo filterPrmt = new FilterInfo();
                filterPrmt.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)this.getCompanyOrgInfoWithDefault().getAccountPeriodType().getId().toString()));
                EntityViewInfo ev = new EntityViewInfo();
                ev.setFilter(filterPrmt);
                this.period.setEntityViewInfo(ev);
                if (!this.flag) {
                    this.initPeriod(this.getCompanyOrgInfoWithDefault());
                }
                this.flag = false;
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    @Override
    protected String getReportViewPermissionItem() {
        return "calcost_view";
    }

    @Override
    protected String getReportPrintPermissionItem() {
        return "calcost_print";
    }

    @Override
    public KDBizPromptBox getCompanyF7() {
        return this.companyorg;
    }

    @Override
    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    private void initPeriod(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        this.period.setValue((Object)NCMUtils.GetCurrentPeriod(null, (String)company.getId().toString()));
    }

    @Override
    protected KDBizPromptBox[] getCostCenterF7() {
        return new KDBizPromptBox[]{this.costcenter, this.costcenter};
    }

    @Override
    protected KDBizPromptBox[] getCostObjectF7() {
        return new KDBizPromptBox[]{this.costobject, this.costobject};
    }

    private void loadPeriod() throws EASBizException, BOSException {
        if (this.cp == null) {
            return;
        }
        String peirod = this.cp.getCustomerParam("period");
        if (peirod == null) {
            return;
        }
        FilterInfo filterPrmt = new FilterInfo();
        filterPrmt.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)this.getCompanyOrgInfoWithDefault().getAccountPeriodType().getId().toString()));
        filterPrmt.getFilterItems().add(new FilterItemInfo("number", (Object)peirod, CompareType.EQUALS));
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filterPrmt);
        PeriodCollection periodColl = PeriodFactory.getRemoteInstance().getPeriodCollection(ev);
        PeriodInfo periodInfo = periodColl.get(0);
        this.period.setData((Object)periodInfo);
        this.flag = false;
    }

    @Override
    protected void loadCompany(CustomerParams params) {
        this.flag = true;
        super.loadCompany(params);
    }

    @Override
    protected void loadCostCenter(CustomerParams params) {
        String costCenterFrom = "";
        String costCenterTo = "";
        if (params.getCustomerParam(this.getSpecialCustomerParamKey(this.getCostCenterF7()[0].getName())) != null) {
            costCenterFrom = params.getCustomerParam(this.getSpecialCustomerParamKey(this.getCostCenterF7()[0].getName()));
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            String[] ccs = costCenterFrom.split("; ");
            HashSet<String> ccIDsSet = new HashSet<String>();
            for (int i = 0; i < ccs.length; ++i) {
                ccIDsSet.add(ccs[i]);
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", ccIDsSet, CompareType.INCLUDE));
            view.setFilter(filter);
            CostCenterOrgUnitCollection costCenterColl = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(view);
            if (costCenterColl != null && costCenterColl.size() > 0) {
                Object[] costCenters = new Object[costCenterColl.size()];
                for (int index = 0; index < costCenterColl.size(); ++index) {
                    costCenters[index] = costCenterColl.get(index);
                }
                this.getCostCenterF7()[0].setData((Object)costCenters);
            }
        }
        catch (BOSException e) {
            this.getCostCenterF7()[0].setData(null);
            this.getCostCenterF7()[1].setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }
}

