/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.client;

import com.kingdee.eas.base.report.CellEvent;
import com.kingdee.eas.base.report.ReportApplication;
import com.kingdee.eas.base.report.ReportException;
import com.kingdee.eas.base.report.ReportListener;
import com.kingdee.eas.base.report.client.ReportViewerUI;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.report.util.RptParams;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class CostCalTotalDetailReportPlugIn
extends ReportListener {
    private static Logger logger = Logger.getLogger(CostCalTotalDetailReportPlugIn.class);

    public void fireTableDbClick(CellEvent event) throws Exception {
        HashMap rowData = this.reportApplication.getCurrentRow();
        BigDecimal totalRow = (BigDecimal)rowData.get("FTOTALROW");
        if (totalRow == null || totalRow.compareTo(SysConstant.BIGZERO) != 0) {
            throw new ReportException(ReportException.REPORT_NO_LINEQUERY);
        }
        RptParams filter = this.reportApplication.getFilter();
        String detailReportID = null;
        String costItemType = (String)rowData.get("FCOSTITEMTYPE");
        if ("1".equals(costItemType)) {
            detailReportID = "snUE4SCldk2TJXPBs5EFHtBgBtA=";
        } else if ("2".equals(costItemType) || "30".equals(costItemType) || "50".equals(costItemType) || "60".equals(costItemType) || "40".equals(costItemType)) {
            detailReportID = "v9nPKwEbEADgAAAAwKgT2M5PzmM=";
        } else {
            throw new ReportException(ReportException.REPORT_NO_LINEQUERY);
        }
        this.showDetailReport(detailReportID, filter, rowData);
    }

    protected void showDetailReport(String detailReportID, RptParams filter, HashMap rowData) throws Exception {
        try {
            Method method = ReportApplication.class.getDeclaredMethod("getReportViewer", null);
            boolean isAccessible = method.isAccessible();
            method.setAccessible(true);
            Object viewer = method.invoke((Object)this.reportApplication, null);
            method.setAccessible(isAccessible);
            method = ReportViewerUI.class.getDeclaredMethod("showDetailReport", String.class, RptParams.class, HashMap.class);
            isAccessible = method.isAccessible();
            method.setAccessible(true);
            method.invoke(viewer, detailReportID, filter, rowData);
            method.setAccessible(isAccessible);
        }
        catch (SecurityException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }
}

