/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.ncm.client.MaterialF7TreeListSelector;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.ncm.cal.report.client.AbstractMaterialCostStatReportFilterUI;
import com.kingdee.eas.ncm.cal.report.client.SpinnerFilterElement;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.SpinnerUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import java.awt.Component;
import java.util.HashSet;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class MaterialCostStatReportFilterUI
extends AbstractMaterialCostStatReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialCostStatReportFilterUI.class);
    private PeriodInfo currentPeriod;
    private PeriodInfo startPeriod;
    private PeriodInfo maxPeriod = null;
    private CustomerParams cp = null;

    public MaterialCostStatReportFilterUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        NCMClientUtils.checkIsStart();
    }

    @Override
    public void onLoad() throws Exception {
        this.formatUI();
        super.onLoad();
    }

    private void formatUI() throws Exception {
        CompanyOrgUnitInfo companyOrg = this.getCompanyOrgInfoWithDefault();
        this.initPeriod(companyOrg);
        this.prmtCostObjectFrom.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.prmtCostObjectFrom, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, companyOrg.getId().toString());
        this.prmtCostObjectFrom.setSelector((KDPromptSelector)arg0);
        this.prmtCostObjectTo.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg1 = new CostObjectF7UISelector((Object)this, this.prmtCostObjectTo, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, companyOrg.getId().toString());
        this.prmtCostObjectTo.setSelector((KDPromptSelector)arg1);
        this.filterProject(this.prmtProjectFrom);
        this.filterProject(this.prmtProjectTo);
        this.filterTrack(this.prmtTrackFrom);
        this.filterTrack(this.prmtTrackTo);
        FilterInfo costItemFilterInfo = this.getCostItemFilter();
        this.setFilterInfoF7(this.prmtCostItemFrom, costItemFilterInfo);
        this.setFilterInfoF7(this.prmtCostItemTo, costItemFilterInfo);
        MaterialCostStatReportFilterUI.setF7CostItem(this.prmtCostItemFrom, Integer.valueOf("1"));
        MaterialCostStatReportFilterUI.setF7CostItem(this.prmtCostItemTo, Integer.valueOf("1"));
    }

    @Override
    protected FilterElement getFilterElement() {
        CompositeFilterElement elements = (CompositeFilterElement)super.getFilterElement();
        SpinnerFilterElement element = null;
        this.setSpinnerRange(1, 1, 1000, 1, this.spCountPerPage);
        element = new SpinnerFilterElement("costobjectPerPage", (Component)this.spCountPerPage);
        elements.add((FilterElement)element);
        elements.add((FilterElement)new SingleFilterElement("prmtProductFrom", (Component)this.prmtProductFrom));
        elements.add((FilterElement)new SingleFilterElement("prmtProductTo", (Component)this.prmtProductTo));
        element = new SingleFilterElement("showQty", (Component)this.cbShowQty);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("showAssistQty", (Component)this.cbShowAssistQty);
        elements.add((FilterElement)element);
        return elements;
    }

    private void initPeriod(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        this.maxPeriod = NCMUtils.getMaxPeriod((CompanyOrgUnitInfo)company, (PeriodInfo)this.currentPeriod);
        this.startPeriod = NCMUtils.GetStartPeriod(null, (String)company.getId().toString());
        this.currentPeriod = NCMUtils.GetCurrentPeriod(null, (String)company.getId().toString());
        if (this.currentPeriod == null) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        if (this.startPeriod == null) {
            return;
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)this.currentPeriod);
    }

    protected void filterProject(KDBizPromptBox prmt) throws Exception {
        FilterInfo filter = ProjectFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), "id", "CU.id");
        EntityViewInfo view = null;
        view = prmt.getEntityViewInfo() != null ? prmt.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        prmt.setEntityViewInfo(view);
    }

    protected void filterTrack(KDBizPromptBox prmt) throws Exception {
        FilterInfo filter = TrackNumberFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), "id", "CU.id");
        EntityViewInfo view = null;
        view = prmt.getEntityViewInfo() != null ? prmt.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        prmt.setEntityViewInfo(view);
    }

    @Override
    protected void setDefaultValue() {
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtCompanyOrg.setValue((Object)companyOrg);
        this.prmtCostCenterFrom.setValue(null);
        this.prmtCostCenterTo.setValue(null);
        this.prmtCostObjectFrom.setValue(null);
        this.prmtCostObjectTo.setValue(null);
        this.prmtCostItemTo.setValue(null);
        this.prmtCostItemTo.setValue(null);
        this.prmtMaterialFrom.setValue(null);
        this.prmtMaterialTo.setValue(null);
        this.cbShowQty.setSelected(false);
        this.cbShowAssistQty.setSelected(false);
        this.spCountPerPage.setValue((Object)1);
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)this.currentPeriod);
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    @Override
    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CustomerParams params = this.cp;
        if (params != null) {
            this.loadOrder(params);
        }
    }

    private void loadOrder(CustomerParams params) {
        String orderNumberFromStr = "";
        String orderNumberToStr = "";
        if (params.getCustomerParam("prmtOrderNumberFrom") != null) {
            orderNumberFromStr = params.getCustomerParam("prmtOrderNumberFrom");
        }
        if (params.getCustomerParam("prmtOrderNumberTo") != null) {
            orderNumberToStr = params.getCustomerParam("prmtOrderNumberTo");
        }
        try {
            String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)orderNumberFromStr));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)orderNumberToStr));
            filter.setMaskString("#0 or #1");
            view.setFilter(filter);
            ManufactureOrderCollection orderNumberColl = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderCollection(view);
            if (orderNumberColl != null && orderNumberColl.size() > 0) {
                if (orderNumberColl.size() >= 2) {
                    for (int i = 0; i < orderNumberColl.size(); ++i) {
                        if (orderNumberColl.get(i).getNumber().equals(orderNumberFromStr)) {
                            this.prmtOrderNumberFrom.setData((Object)orderNumberColl.get(i));
                            continue;
                        }
                        this.prmtOrderNumberTo.setData((Object)orderNumberColl.get(i));
                    }
                } else if (orderNumberColl.size() < 2) {
                    if (orderNumberColl.get(0).getNumber().equals(orderNumberFromStr)) {
                        this.prmtOrderNumberFrom.setData((Object)orderNumberColl.get(0));
                    }
                    if (orderNumberColl.get(0).getNumber().equals(orderNumberToStr)) {
                        this.prmtOrderNumberTo.setData((Object)orderNumberColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtOrderNumberFrom.setData(null);
            this.prmtOrderNumberTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadPeriod(CustomerParams params) {
        PeriodInfo initPeriodFrom = this.currentPeriod;
        PeriodInfo initPeriodTo = this.currentPeriod;
        String initYearFrom = params.getCustomerParam("spYearFrom");
        String initMonthFrom = params.getCustomerParam("spPeriodFrom");
        String initYearTo = params.getCustomerParam("spYearTo");
        String initMonthTo = params.getCustomerParam("spPeriodTo");
        try {
            if (!StringUtils.isEmpty((String)initYearFrom) && !StringUtils.isEmpty((String)initMonthFrom)) {
                initPeriodFrom = new PeriodInfo();
                initPeriodFrom.setPeriodYear(Integer.parseInt(initYearFrom));
                initPeriodFrom.setPeriodNumber(Integer.parseInt(initMonthFrom));
            }
            if (!StringUtils.isEmpty((String)initYearTo) && !StringUtils.isEmpty((String)initMonthTo)) {
                initPeriodTo = new PeriodInfo();
                initPeriodTo.setPeriodYear(Integer.parseInt(initYearTo));
                initPeriodTo.setPeriodNumber(Integer.parseInt(initMonthTo));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)initPeriodFrom, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)initPeriodTo);
    }

    private void loadShowItem(CustomerParams params) {
        boolean showQty = true;
        boolean showAssistQty = true;
        String temp = null;
        if (params.getCustomerParam("cbShowQty") != null && (temp = params.getCustomerParam("cbShowQty")) != null && temp.equalsIgnoreCase("false")) {
            showQty = false;
        }
        if (params.getCustomerParam("cbShowAssistQty") != null && (temp = params.getCustomerParam("cbShowAssistQty")) != null && temp.equalsIgnoreCase("false")) {
            showAssistQty = false;
        }
        this.cbShowQty.setSelected(showQty);
        this.cbShowAssistQty.setSelected(showAssistQty);
    }

    private void setSpinnerRange(int nDefault, int nMin, int nMax, int nStep, KDSpinner sp) {
        Integer value = nDefault;
        Integer min = nMin;
        Integer max = nMax;
        Integer step = nStep;
        SpinnerNumberModel model = new SpinnerNumberModel(value, min, max, step);
        sp.setModel((SpinnerModel)model);
    }

    private void setFilterInfoF7(KDBizPromptBox f7, FilterInfo filter) {
        EntityViewInfo view = f7.getEntityViewInfo() != null ? f7.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    @Override
    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    @Override
    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    protected String getAdminCUFieldName() {
        return "adminCU.id";
    }

    @Override
    protected FilterInfo getCostItemFilter() throws Exception {
        return CostItemFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
    }

    public static void setF7CostItem(KDBizPromptBox bizBox, Integer itemType) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.appendFilterItem("ItemType", (Object)itemType);
        filterInfo.setMaskString("#0");
        viewInfo.setFilter(filterInfo);
        bizBox.setHasCUDefaultFilter(false);
        bizBox.setEntityViewInfo(viewInfo);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrg;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public KDBizPromptBox getCompanyF7() {
        return this.prmtCompanyOrg;
    }

    @Override
    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    @Override
    protected void registerF7() throws Exception {
        super.registerF7();
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenterFrom);
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenterTo);
        this.f7ContextManager.registerCostObjectF7(this.prmtCostObjectFrom, false);
        this.f7ContextManager.registerCostObjectF7(this.prmtCostObjectTo, false);
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> statuses = new HashSet<Integer>();
        statuses.add(5);
        statuses.add(8);
        statuses.add(7);
        statuses.add(11);
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", statuses, CompareType.INCLUDE));
        this.f7ContextManager.registerManufactureOrderF7(this.prmtOrderNumberFrom, filter);
        this.f7ContextManager.registerManufactureOrderF7(this.prmtOrderNumberTo, filter);
        this.f7ContextManager.registerMaterialTreeF7(this.prmtProductFrom, null);
        MaterialF7TreeListSelector selector_Prod = new MaterialF7TreeListSelector((Object)this, this.prmtProductFrom);
        this.prmtProductFrom.setSelector((KDPromptSelector)selector_Prod);
        this.f7ContextManager.registerMaterialTreeF7(this.prmtProductTo, null);
        selector_Prod = new MaterialF7TreeListSelector((Object)this, this.prmtProductTo);
        this.prmtProductTo.setSelector((KDPromptSelector)selector_Prod);
        this.f7ContextManager.registerMaterialTreeF7(this.prmtMaterialFrom, null);
        MaterialF7TreeListSelector selector = new MaterialF7TreeListSelector((Object)this, this.prmtMaterialFrom);
        this.prmtMaterialFrom.setSelector((KDPromptSelector)selector);
        this.f7ContextManager.registerMaterialTreeF7(this.prmtMaterialTo, null);
        selector = new MaterialF7TreeListSelector((Object)this, this.prmtMaterialTo);
        this.prmtMaterialTo.setSelector((KDPromptSelector)selector);
    }

    @Override
    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                this.prmtCostCenterFrom.setData(null);
                this.prmtCostCenterTo.setData(null);
                this.prmtCostObjectFrom.setData(null);
                this.prmtCostObjectTo.setData(null);
                this.prmtOrderNumberFrom.setData(null);
                this.prmtOrderNumberTo.setData(null);
                this.prmtMaterialFrom.setData(null);
                this.prmtMaterialTo.setData(null);
                this.prmtOrderNumberFrom.setDisplayFormat("$number$");
                this.prmtOrderNumberTo.setDisplayFormat("$number$");
                this.initPeriod(this.getCompanyOrgInfoWithDefault());
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    @Override
    protected String getReportViewPermissionItem() {
        return "MaterialCostStatReportView";
    }

    @Override
    protected String getReportPrintPermissionItem() {
        return "MaterialCostStatReportPrint";
    }

    @Override
    protected KDSpinner[] getPeriodSpinner() {
        return new KDSpinner[]{this.spYearFrom, this.spYearTo, this.spPeriodFrom, this.spPeriodTo};
    }

    @Override
    protected KDSpinner getDisplayCountSpinner() {
        return this.spCountPerPage;
    }

    @Override
    protected KDBizPromptBox[] getCostCenterF7() {
        return new KDBizPromptBox[]{this.prmtCostCenterFrom, this.prmtCostCenterTo};
    }

    @Override
    protected KDBizPromptBox[] getCostObjectF7() {
        return new KDBizPromptBox[]{this.prmtCostObjectFrom, this.prmtCostObjectTo};
    }

    @Override
    protected KDBizPromptBox[] getMaterialF7() {
        return new KDBizPromptBox[]{this.prmtMaterialFrom, this.prmtMaterialTo};
    }

    @Override
    protected KDBizPromptBox[] getCostItemF7() {
        return new KDBizPromptBox[]{this.prmtCostItemFrom, this.prmtCostItemTo};
    }

    @Override
    protected KDBizPromptBox[] getOrderNumberF7() {
        return new KDBizPromptBox[]{this.prmtOrderNumberFrom, this.prmtOrderNumberTo};
    }

    @Override
    protected KDTextField[] getBatchNumberCtrls() {
        return new KDTextField[]{this.txtBatchFrom, this.txtBathTo};
    }

    @Override
    protected KDBizPromptBox[] getProjectNumberF7() {
        return new KDBizPromptBox[]{this.prmtProjectFrom, this.prmtProjectTo};
    }

    @Override
    protected KDBizPromptBox[] getTrackNumberF7() {
        return new KDBizPromptBox[]{this.prmtTrackFrom, this.prmtTrackTo};
    }
}

