/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostItemCollection;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.client.context.OrgContextManager;
import com.kingdee.eas.framework.client.context.f7.IF7ContextChange;
import com.kingdee.eas.framework.client.context.f7.IF7Register;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.ncm.cal.report.client.AbstractNCMReportFilterUI;
import com.kingdee.eas.ncm.cal.report.client.SingleSpinnerFilterElement;
import com.kingdee.eas.ncm.cal.report.client.SpinnerFilterElement;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.NCMCommonFacadeFactory;
import com.kingdee.eas.ncm.common.client.NCMF7ContextManager;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.OrgUnitClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public abstract class NCMReportFilterUI
extends AbstractNCMReportFilterUI
implements IMultiOrgSupport {
    private static final Logger logger = CoreUIObject.getLogger(NCMReportFilterUI.class);
    protected OrgContextManager orgContextManager = null;
    protected NCMF7ContextManager f7ContextManager;
    private String permissionItem = null;
    private IMetaDataPK metaDataPKForPemmission = null;
    private IMetaDataPK metaDataPKForPemmissionByUI = null;
    private static Map permissionItemMap = new HashMap();
    private String CompanyPick = "CompanyPick";
    private boolean mainOrgChangeCanceling = false;
    private boolean filterManagerHasSetting = false;

    public NCMReportFilterUI() throws Exception {
        BDCMClientUtils.checkLoginCompanyOrgIsVirtual();
        this.setIsSupportMultiOrgs(false);
    }

    public void onLoad() throws Exception {
        this.isStart();
        super.onLoad();
        this.initOrgContextManager();
        this.setFilterManager();
    }

    protected void setFilterManager() {
        if (!this.filterManagerHasSetting) {
            FilterElement element = this.getFilterElement();
            if (element != null) {
                this.getFilterManager().setElement(element);
            }
            this.filterManagerHasSetting = true;
        }
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.setFilterManager();
    }

    public void clear() {
        this.getFilterManager().clearAll();
        this.setDefaultValue();
        if (this.getMainBizOrgF7() != null) {
            this.getMainBizOrgF7().setValue((Object)this.getCompanyOrgInfoWithDefault());
        }
    }

    protected void setDefaultValue() {
        if (this.getCompanyF7() != null) {
            this.getCompanyF7().setData((Object)this.getCompanyOrgInfoWithDefault());
        }
        if (this.getCostCenterF7() != null && this.getCostCenterF7().length == 2) {
            this.getCostCenterF7()[0].setData(null);
            this.getCostCenterF7()[1].setData(null);
        }
        if (this.getCostObjectF7() != null && this.getCostObjectF7().length == 2) {
            this.getCostObjectF7()[0].setData(null);
            this.getCostObjectF7()[1].setData(null);
        }
        if (this.getMaterialF7() != null && this.getMaterialF7().length == 2) {
            this.getMaterialF7()[0].setData(null);
            this.getMaterialF7()[1].setData(null);
        }
        if (this.getCostItemF7() != null && this.getCostItemF7().length == 2) {
            this.getCostItemF7()[0].setData(null);
            this.getCostItemF7()[1].setData(null);
        }
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CustomerParams params = this.getCustomerParams();
        if (params != null) {
            if (this.getCompanyF7() != null) {
                this.loadCompany(params);
            }
            if (this.getCostCenterF7() != null && this.getCostCenterF7().length == 2) {
                this.loadCostCenter(params);
            }
            if (this.getCostObjectF7() != null && this.getCostObjectF7().length == 2) {
                this.loadCostObject(params);
            }
            if (this.getMaterialF7() != null && this.getMaterialF7().length == 2) {
                this.loadMaterial(params);
            }
            if (this.getCostItemF7() != null && this.getCostItemF7().length == 2) {
                this.loadCostItem(params);
            }
            if (this.getOrderNumberF7() != null && this.getOrderNumberF7().length == 2) {
                this.loadOrderNumber(params);
            }
            if (this.getBatchNumberCtrls() != null && this.getBatchNumberCtrls().length == 2) {
                this.loadBatchNumber(params);
            }
            if (this.getProjectNumberF7() != null && this.getProjectNumberF7().length == 2) {
                this.loadProjectNumber(params);
            }
            if (this.getTrackNumberF7() != null && this.getTrackNumberF7().length == 2) {
                this.loadTrackNumber(params);
            }
        }
        this.LoadCustomerParams2Panel(params);
    }

    protected void LoadCustomerParams2Panel(CustomerParams params) {
    }

    protected void initOrgContextManager() throws EASBizException, BOSException {
        this.orgContextManager = new OrgContextManager((IMultiOrgSupport)this, ContextTypeEnum.INQUERYING, null);
        this.orgContextManager.init(this.getUIContext());
        if (this.getCompanyF7() != null) {
            this.getCompanyF7().setSelector(null);
            if (this.isEnableMultiOrgSupport()) {
                this.getCompanyF7().setEnabled(true);
                this.getCompanyF7().setRequired(true);
                if (this.getCompanyF7().getQueryInfo() == null || this.getCompanyF7().getQueryInfo().trim().length() == 0) {
                    this.getCompanyF7().setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
                }
                OrgUnitClientUtils.setMainBizOrgF7((KDBizPromptBox)this.getCompanyF7(), (OrgType)OrgType.Company, (String[])new String[]{this.getReportViewPermissionItem()});
                if (this.getCompanyF7().getData() == null) {
                    this.getCompanyF7().setData((Object)this.getCompanyOrgInfoWithDefault());
                }
                this.getF7Register();
                try {
                    this.registerF7();
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
        }
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        if (this.mainOrgChangeCanceling) {
            return;
        }
        if (chgVo.isDiffrent()) {
            try {
                CompanyOrgUnitInfo companyOrg;
                if (chgVo.getNewOrg() != null && chgVo.getNewOrg() instanceof CompanyOrgUnitInfo && !NCMUtils.isStart(null, (String)(companyOrg = (CompanyOrgUnitInfo)chgVo.getNewOrg()).getId().toString())) {
                    throw new CMBillException(CMBillException.COST_NOTON);
                }
            }
            catch (Exception e) {
                MsgBox.showInfo((String)e.getMessage());
                if (this.getCompanyF7() != null) {
                    try {
                        this.mainOrgChangeCanceling = true;
                        this.getCompanyF7().setData(chgVo.getOldOrg());
                    }
                    finally {
                        this.mainOrgChangeCanceling = false;
                    }
                    this.getCompanyF7().requestFocus();
                }
                SysUtil.abort();
            }
        }
    }

    public IF7ContextChange getF7ContextManager() {
        return (NCMF7ContextManager)this.getF7Register();
    }

    public IF7Register getF7Register() {
        if (this.f7ContextManager == null) {
            this.f7ContextManager = new NCMF7ContextManager((Component)((Object)this), OrgType.Company, ContextTypeEnum.INQUERYING, 0);
        }
        return this.f7ContextManager;
    }

    protected void registerF7() throws Exception {
    }

    public KDBizPromptBox getMainOrg() {
        return this.getCompanyF7();
    }

    public KDBizPromptBox getCompanyF7() {
        return null;
    }

    public String getMainOrgKeyForCustomerParams(OrgType orgType) {
        return "company.id";
    }

    public OrgType getMainOrgType() {
        return OrgType.Company;
    }

    public String getPermissionItem() {
        if (this.permissionItem == null && this.metaDataPKForPemmissionByUI != null) {
            try {
                String permissionItemKey = "" + MetaDataTypeList.UIOBJECT + this.metaDataPKForPemmissionByUI;
                if (!permissionItemMap.containsKey(permissionItemKey)) {
                    MetaDataPK actionPK = new MetaDataPK("ActionOnLoad");
                    this.permissionItem = NCMCommonFacadeFactory.getRemoteInstance().getUIPermissiionItem(this.metaDataPKForPemmissionByUI, (IMetaDataPK)actionPK);
                    permissionItemMap.put(permissionItemKey, this.permissionItem);
                } else {
                    this.permissionItem = (String)permissionItemMap.get(permissionItemKey);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return this.permissionItem;
    }

    public void setMetaDataPKForPemmission(IMetaDataPK metaDataPKForPemmission) {
        this.metaDataPKForPemmission = metaDataPKForPemmission;
    }

    public void setMetaDataPKForPemmissionByUI(IMetaDataPK metaDataPKForPemmissionByUI) {
        this.metaDataPKForPemmissionByUI = metaDataPKForPemmissionByUI;
    }

    public boolean isSupportMultiOrgs() {
        return false;
    }

    public boolean isSupportVirturalOrgs() {
        return false;
    }

    public boolean isEnableMultiOrgSupport() {
        return false;
    }

    public OrgContextManager orgContextManager() {
        return this.orgContextManager;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getCompanyF7();
    }

    public boolean verify() {
        if (this.isEnableMultiOrgSupport()) {
            if (this.getCompanyF7().getData() == null) {
                MsgBox.showInfo((String)SCMGroupClientUtils.getMainOrgNullMsg((OrgType)OrgType.Company));
                this.getCompanyF7().requestFocus();
                SysUtil.abort();
            }
            try {
                if (!NCMUtils.isStart(null, (String)((CompanyOrgUnitInfo)this.getCompanyF7().getData()).getId().toString())) {
                    throw new CMBillException(CMBillException.COST_NOTON);
                }
            }
            catch (Exception e) {
                MsgBox.showInfo((String)e.getMessage());
                this.getCompanyF7().requestFocus();
                SysUtil.abort();
            }
        }
        return super.verify();
    }

    protected CompanyOrgUnitInfo getCompanyOrgInfoWithDefault() {
        Object temp = null;
        Object object = temp = this.getCompanyF7() == null ? null : this.getCompanyF7().getData();
        if (temp != null && temp instanceof CompanyOrgUnitInfo) {
            if (!((CompanyOrgUnitInfo)temp).isLoaded() && ((CompanyOrgUnitInfo)temp).getId().toString().trim().length() > 0) {
                try {
                    temp = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(((CompanyOrgUnitInfo)temp).getId().toString()));
                }
                catch (EASBizException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
            return (CompanyOrgUnitInfo)temp;
        }
        return SysContext.getSysContext().getCurrentFIUnit();
    }

    protected void isStart() throws Exception {
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        if (!sysctrol.isStart(1001, SysContext.getSysContext().getCurrentFIUnit().getId().toString())) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected abstract String getReportViewPermissionItem();

    protected abstract String getReportPrintPermissionItem();

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(this.getCompanyOrgInfoWithDefault().getId());
    }

    protected FilterElement getFilterElement() {
        CompanyOrgUnitInfo companyOrg = this.getCompanyOrgInfoWithDefault();
        PeriodInfo currentPeriod = null;
        try {
            currentPeriod = NCMUtils.GetCurrentPeriod(null, (String)companyOrg.getId().toString());
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleComPromptFilterElement filterElement = new SingleComPromptFilterElement(this.getSpecialCustomerParamKey(this.getCompanyF7().getName()), this.getCompanyF7());
        filterElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"183_CCFeeTotalReportFilterUI")));
        elements.add((FilterElement)filterElement);
        SingleFilterElement element = new SingleSpinnerFilterElement(this.getSpecialCustomerParamKey(this.getPeriodSpinner()[0].getName()), (Component)this.getPeriodSpinner()[0]);
        element.setDefaultValue((Object)currentPeriod.getPeriodYear());
        elements.add((FilterElement)element);
        element = new SingleSpinnerFilterElement(this.getSpecialCustomerParamKey(this.getPeriodSpinner()[1].getName()), (Component)this.getPeriodSpinner()[1]);
        element.setDefaultValue((Object)currentPeriod.getPeriodYear());
        elements.add((FilterElement)element);
        element = new SingleSpinnerFilterElement(this.getSpecialCustomerParamKey(this.getPeriodSpinner()[2].getName()), (Component)this.getPeriodSpinner()[2]);
        element.setDefaultValue((Object)currentPeriod.getPeriodNumber());
        elements.add((FilterElement)element);
        element = new SingleSpinnerFilterElement(this.getSpecialCustomerParamKey(this.getPeriodSpinner()[3].getName()), (Component)this.getPeriodSpinner()[3]);
        element.setDefaultValue((Object)currentPeriod.getPeriodNumber());
        elements.add((FilterElement)element);
        if (this.getCostCenterF7() != null && this.getCostCenterF7().length == 2) {
            elements.add((FilterElement)new SingleFilterElement(this.getSpecialCustomerParamKey(this.getCostCenterF7()[0].getName()), (Component)this.getCostCenterF7()[0]));
            elements.add((FilterElement)new SingleFilterElement(this.getSpecialCustomerParamKey(this.getCostCenterF7()[1].getName()), (Component)this.getCostCenterF7()[1]));
        }
        if (this.getCostObjectF7() != null && this.getCostObjectF7().length == 2) {
            elements.add((FilterElement)new SingleFilterElement(this.getSpecialCustomerParamKey(this.getCostObjectF7()[0].getName()), (Component)this.getCostObjectF7()[0]));
            elements.add((FilterElement)new SingleFilterElement(this.getSpecialCustomerParamKey(this.getCostObjectF7()[1].getName()), (Component)this.getCostObjectF7()[1]));
        }
        if (this.getMaterialF7() != null && this.getMaterialF7().length == 2) {
            elements.add((FilterElement)new SingleFilterElement(this.getSpecialCustomerParamKey(this.getMaterialF7()[0].getName()), (Component)this.getMaterialF7()[0]));
            elements.add((FilterElement)new SingleFilterElement(this.getSpecialCustomerParamKey(this.getMaterialF7()[1].getName()), (Component)this.getMaterialF7()[1]));
        }
        if (this.getCostItemF7() != null && this.getCostItemF7().length == 2) {
            elements.add((FilterElement)new SingleFilterElement(this.getSpecialCustomerParamKey(this.getCostItemF7()[0].getName()), (Component)this.getCostItemF7()[0]));
            elements.add((FilterElement)new SingleFilterElement(this.getSpecialCustomerParamKey(this.getCostItemF7()[1].getName()), (Component)this.getCostItemF7()[1]));
        }
        if (this.getOrderNumberF7() != null && this.getOrderNumberF7().length == 2) {
            elements.add((FilterElement)new SingleFilterElement(this.getSpecialCustomerParamKey(this.getOrderNumberF7()[0].getName()), (Component)this.getOrderNumberF7()[0]));
            elements.add((FilterElement)new SingleFilterElement(this.getSpecialCustomerParamKey(this.getOrderNumberF7()[1].getName()), (Component)this.getOrderNumberF7()[1]));
        }
        if (this.getBatchNumberCtrls() != null && this.getBatchNumberCtrls().length == 2) {
            elements.add((FilterElement)new SingleFilterElement(this.getSpecialCustomerParamKey(this.getBatchNumberCtrls()[0].getName()), (Component)this.getBatchNumberCtrls()[0]));
            elements.add((FilterElement)new SingleFilterElement(this.getSpecialCustomerParamKey(this.getBatchNumberCtrls()[1].getName()), (Component)this.getBatchNumberCtrls()[1]));
        }
        if (this.getProjectNumberF7() != null && this.getProjectNumberF7().length == 2) {
            elements.add((FilterElement)new SingleFilterElement(this.getSpecialCustomerParamKey(this.getProjectNumberF7()[0].getName()), (Component)this.getProjectNumberF7()[0]));
            elements.add((FilterElement)new SingleFilterElement(this.getSpecialCustomerParamKey(this.getProjectNumberF7()[1].getName()), (Component)this.getProjectNumberF7()[1]));
        }
        if (this.getTrackNumberF7() != null && this.getTrackNumberF7().length == 2) {
            elements.add((FilterElement)new SingleFilterElement(this.getSpecialCustomerParamKey(this.getTrackNumberF7()[0].getName()), (Component)this.getTrackNumberF7()[0]));
            elements.add((FilterElement)new SingleFilterElement(this.getSpecialCustomerParamKey(this.getTrackNumberF7()[1].getName()), (Component)this.getTrackNumberF7()[1]));
        }
        if (this.getDisplayCountSpinner() != null) {
            element = new SpinnerFilterElement(this.getSpecialCustomerParamKey(this.getDisplayCountSpinner().getName()), (Component)this.getDisplayCountSpinner());
            elements.add((FilterElement)element);
        }
        if (this.getOtherComponent() != null) {
            for (int i = 0; i < this.getOtherComponent().length; ++i) {
                element = new SingleFilterElement(this.getSpecialCustomerParamKey(this.getOtherComponent()[i].getName()), (Component)this.getOtherComponent()[i]);
                elements.add((FilterElement)element);
            }
        }
        return elements;
    }

    protected String getSpecialCustomerParamKey(String defaultF7Name) {
        return defaultF7Name;
    }

    private void loadCostObject(CustomerParams params) {
        String costObjectFrom = "";
        String costObjectTo = "";
        if (params.getCustomerParam(this.getCostObjectF7()[0].getName()) != null) {
            costObjectFrom = params.getCustomerParam(this.getSpecialCustomerParamKey(this.getCostObjectF7()[0].getName()));
        }
        if (params.getCustomerParam(this.getCostObjectF7()[1].getName()) != null) {
            costObjectTo = params.getCustomerParam(this.getSpecialCustomerParamKey(this.getCostObjectF7()[1].getName()));
        }
        try {
            String companyId = this.getCompanyOrgInfoWithDefault().getId().toString();
            String oql = " select * where company.id = '" + companyId + "'  and ( number = '" + costObjectFrom + "' or number = '" + costObjectTo + "')";
            CostObjectCollection costObjectColl = CostObjectFactory.getRemoteInstance().getCostObjectCollection(oql);
            if (costObjectColl != null && costObjectColl.size() > 0) {
                if (costObjectColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (costObjectColl.get(i).getNumber().equals(costObjectFrom)) {
                            this.getCostObjectF7()[0].setData((Object)costObjectColl.get(i));
                            continue;
                        }
                        this.getCostObjectF7()[1].setData((Object)costObjectColl.get(i));
                    }
                } else if (costObjectColl.size() == 1) {
                    if (costObjectColl.get(0).getNumber().equals(costObjectFrom)) {
                        this.getCostObjectF7()[0].setData((Object)costObjectColl.get(0));
                    }
                    if (costObjectColl.get(0).getNumber().equals(costObjectTo)) {
                        this.getCostObjectF7()[1].setData((Object)costObjectColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.getCostObjectF7()[0].setData(null);
            this.getCostObjectF7()[1].setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    protected void loadCompany(CustomerParams params) {
        block9: {
            String companyNumber = "";
            if (params.getCustomerParam(this.getSpecialCustomerParamKey(this.getCompanyF7().getName())) != null) {
                companyNumber = params.getCustomerParam(this.getSpecialCustomerParamKey(this.getCompanyF7().getName()));
            }
            if ("".equals(companyNumber)) {
                return;
            }
            try {
                String osql = "where number = '" + companyNumber + "'";
                CompanyOrgUnitInfo companyOrg = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo(osql);
                if (companyOrg == null) break block9;
                try {
                    if (!SCMGroupClientUtils.isAuthoriedForOrg((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)OrgType.Company, (IObjectPK)new ObjectStringPK(companyOrg.getId().toString()), (String)this.getReportViewPermissionItem())) {
                        MsgBox.showInfo((String)"\u6ca1\u6709\u8be5\u65b9\u6848\u6240\u9009\u8d22\u52a1\u7ec4\u7ec7\u7684\u6743\u9650");
                        SysUtil.abort();
                    }
                }
                catch (EASBizException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                this.getCompanyF7().setData((Object)companyOrg);
            }
            catch (BOSException e) {
                this.getCompanyF7().setData(null);
                logger.error((Object)"", (Throwable)e);
            }
            catch (EASBizException e) {
                this.getCompanyF7().setData(null);
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    protected void loadCompany(String companyNumber) {
        block8: {
            if ("".equals(companyNumber)) {
                return;
            }
            try {
                String osql = "where number = '" + companyNumber + "'";
                CompanyOrgUnitInfo companyOrg = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo(osql);
                if (companyOrg == null) break block8;
                try {
                    if (!SCMGroupClientUtils.isAuthoriedForOrg((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)OrgType.Company, (IObjectPK)new ObjectStringPK(companyOrg.getId().toString()), (String)this.getReportViewPermissionItem())) {
                        MsgBox.showInfo((String)"\u6ca1\u6709\u8be5\u65b9\u6848\u6240\u9009\u8d22\u52a1\u7ec4\u7ec7\u7684\u6743\u9650");
                        SysUtil.abort();
                    }
                }
                catch (EASBizException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                this.getCompanyF7().setData((Object)companyOrg);
            }
            catch (BOSException e) {
                this.getCompanyF7().setData(null);
                logger.error((Object)"", (Throwable)e);
            }
            catch (EASBizException e) {
                this.getCompanyF7().setData(null);
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    protected void loadCostCenter(CustomerParams params) {
        String costCenterFrom = "";
        String costCenterTo = "";
        if (params.getCustomerParam(this.getSpecialCustomerParamKey(this.getCostCenterF7()[0].getName())) != null) {
            costCenterFrom = params.getCustomerParam(this.getSpecialCustomerParamKey(this.getCostCenterF7()[0].getName()));
        }
        if (params.getCustomerParam(this.getSpecialCustomerParamKey(this.getCostCenterF7()[1].getName())) != null) {
            costCenterTo = params.getCustomerParam(this.getSpecialCustomerParamKey(this.getCostCenterF7()[1].getName()));
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterFrom));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterTo));
            view.setFilter(filter);
            view.getFilter().setMaskString("#0 or #1");
            CostCenterOrgUnitCollection costCenterColl = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(view);
            if (costCenterColl != null && costCenterColl.size() > 0) {
                if (costCenterColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (costCenterColl.get(i).getNumber().equals(costCenterFrom)) {
                            this.getCostCenterF7()[0].setData((Object)costCenterColl.get(i));
                            continue;
                        }
                        this.getCostCenterF7()[1].setData((Object)costCenterColl.get(i));
                    }
                } else if (costCenterColl.size() == 1) {
                    if (costCenterColl.get(0).getNumber().equals(costCenterFrom)) {
                        this.getCostCenterF7()[0].setData((Object)costCenterColl.get(0));
                    }
                    if (costCenterColl.get(0).getNumber().equals(costCenterTo)) {
                        this.getCostCenterF7()[1].setData((Object)costCenterColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.getCostCenterF7()[0].setData(null);
            this.getCostCenterF7()[1].setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    protected void loadMaterial(CustomerParams params) {
        String materialFrom = "";
        String materialTo = "";
        if (params.getCustomerParam(this.getSpecialCustomerParamKey(this.getMaterialF7()[0].getName())) != null) {
            materialFrom = params.getCustomerParam(this.getSpecialCustomerParamKey(this.getMaterialF7()[0].getName()));
        }
        if (params.getCustomerParam(this.getSpecialCustomerParamKey(this.getMaterialF7()[1].getName())) != null) {
            materialTo = params.getCustomerParam(this.getSpecialCustomerParamKey(this.getMaterialF7()[1].getName()));
        }
        try {
            String sql = "select mateial.id,mateial.name,mateial.number where (mateial.number ='" + materialFrom + "' or mateial.number = '" + materialTo + "') AND company='" + this.getCompanyOrgInfoWithDefault().getId().toString() + "'";
            MaterialCompanyInfoCollection expenseColl = MaterialCompanyInfoFactory.getRemoteInstance().getMaterialCompanyInfoCollection(sql);
            if (expenseColl != null && expenseColl.size() > 0) {
                if (expenseColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (expenseColl.get(i).getMateial().getNumber().equals(materialFrom)) {
                            this.getMaterialF7()[0].setData((Object)expenseColl.get(i).getMateial());
                            continue;
                        }
                        this.getMaterialF7()[1].setData((Object)expenseColl.get(i).getMateial());
                    }
                } else if (expenseColl.size() == 1) {
                    if (expenseColl.get(0).getMateial().getNumber().equals(materialFrom)) {
                        this.getMaterialF7()[0].setData((Object)expenseColl.get(0).getMateial());
                    }
                    if (expenseColl.get(0).getMateial().getNumber().equals(materialTo)) {
                        this.getMaterialF7()[1].setData((Object)expenseColl.get(0).getMateial());
                    }
                }
            }
        }
        catch (BOSException e) {
            this.getMaterialF7()[0].setData(null);
            this.getMaterialF7()[1].setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    protected void loadCostItem(CustomerParams params) {
        String costItemFrom = "";
        String costItemTo = "";
        if (params.getCustomerParam(this.getSpecialCustomerParamKey(this.getCostItemF7()[0].getName())) != null) {
            costItemFrom = params.getCustomerParam(this.getSpecialCustomerParamKey(this.getCostItemF7()[0].getName()));
        }
        if (params.getCustomerParam(this.getSpecialCustomerParamKey(this.getCostItemF7()[1].getName())) != null) {
            costItemTo = params.getCustomerParam(this.getSpecialCustomerParamKey(this.getCostItemF7()[1].getName()));
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costItemFrom));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costItemTo));
            filter.setMaskString("#0 or #1");
            try {
                FilterInfo costItemFilterInfo = this.getCostItemFilter();
                costItemFilterInfo.mergeFilter(filter, "and");
                view.setFilter(costItemFilterInfo);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            CostItemCollection costItemColl = CostItemFactory.getRemoteInstance().getCostItemCollection(view);
            if (costItemColl != null && costItemColl.size() > 0) {
                if (costItemColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (costItemColl.get(i).getNumber().equals(costItemFrom)) {
                            this.getCostItemF7()[0].setData((Object)costItemColl.get(i));
                            continue;
                        }
                        this.getCostItemF7()[1].setData((Object)costItemColl.get(i));
                    }
                } else if (costItemColl.size() == 1) {
                    if (costItemColl.get(0).getNumber().equals(costItemFrom)) {
                        this.getCostItemF7()[0].setData((Object)costItemColl.get(0));
                    }
                    if (costItemColl.get(0).getNumber().equals(costItemTo)) {
                        this.getCostItemF7()[1].setData((Object)costItemColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.getCostItemF7()[0].setData(null);
            this.getCostItemF7()[1].setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    protected FilterInfo getCostItemFilter() throws Exception {
        return CostItemFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
    }

    protected void loadOrderNumber(CustomerParams params) {
        String orderNumberFrom = "";
        String orderNumberTo = "";
        if (params.getCustomerParam(this.getSpecialCustomerParamKey(this.getOrderNumberF7()[0].getName())) != null) {
            orderNumberFrom = params.getCustomerParam(this.getSpecialCustomerParamKey(this.getOrderNumberF7()[0].getName()));
        }
        if (params.getCustomerParam(this.getSpecialCustomerParamKey(this.getOrderNumberF7()[1].getName())) != null) {
            orderNumberTo = params.getCustomerParam(this.getSpecialCustomerParamKey(this.getOrderNumberF7()[1].getName()));
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)orderNumberFrom));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)orderNumberTo));
            view.setFilter(filter);
            view.getFilter().setMaskString("#0 or #1");
            ManufactureOrderCollection orderColl = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderCollection(view);
            if (orderColl != null && orderColl.size() > 0) {
                if (orderColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (orderColl.get(i).getNumber().equals(orderNumberFrom)) {
                            this.getOrderNumberF7()[0].setData((Object)orderColl.get(i));
                            continue;
                        }
                        this.getOrderNumberF7()[1].setData((Object)orderColl.get(i));
                    }
                } else if (orderColl.size() == 1) {
                    if (orderColl.get(0).getNumber().equals(orderNumberFrom)) {
                        this.getOrderNumberF7()[0].setData((Object)orderColl.get(0));
                    }
                    if (orderColl.get(0).getNumber().equals(orderNumberTo)) {
                        this.getOrderNumberF7()[1].setData((Object)orderColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.getOrderNumberF7()[0].setData(null);
            this.getOrderNumberF7()[1].setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    protected void loadProjectNumber(CustomerParams params) {
        String projectNumberFrom = "";
        String projectNumberTo = "";
        if (params.getCustomerParam(this.getSpecialCustomerParamKey(this.getProjectNumberF7()[0].getName())) != null) {
            projectNumberFrom = params.getCustomerParam(this.getSpecialCustomerParamKey(this.getProjectNumberF7()[0].getName()));
        }
        if (params.getCustomerParam(this.getSpecialCustomerParamKey(this.getProjectNumberF7()[1].getName())) != null) {
            projectNumberTo = params.getCustomerParam(this.getSpecialCustomerParamKey(this.getProjectNumberF7()[1].getName()));
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)projectNumberFrom));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)projectNumberTo));
            filter.setMaskString("#0 or #1");
            try {
                view.setFilter(filter);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            ProjectCollection projColl = ProjectFactory.getRemoteInstance().getProjectCollection(view);
            if (projColl != null && projColl.size() > 0) {
                if (projColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (projColl.get(i).getNumber().equals(projectNumberFrom)) {
                            this.getProjectNumberF7()[0].setData((Object)projColl.get(i));
                            continue;
                        }
                        this.getProjectNumberF7()[1].setData((Object)projColl.get(i));
                    }
                } else if (projColl.size() == 1) {
                    if (projColl.get(0).getNumber().equals(projectNumberFrom)) {
                        this.getProjectNumberF7()[0].setData((Object)projColl.get(0));
                    }
                    if (projColl.get(0).getNumber().equals(projectNumberTo)) {
                        this.getProjectNumberF7()[1].setData((Object)projColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.getProjectNumberF7()[0].setData(null);
            this.getProjectNumberF7()[1].setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    protected void loadTrackNumber(CustomerParams params) {
        String trackNumberFrom = "";
        String trackNumberTo = "";
        if (params.getCustomerParam(this.getSpecialCustomerParamKey(this.getTrackNumberF7()[0].getName())) != null) {
            trackNumberFrom = params.getCustomerParam(this.getSpecialCustomerParamKey(this.getTrackNumberF7()[0].getName()));
        }
        if (params.getCustomerParam(this.getSpecialCustomerParamKey(this.getTrackNumberF7()[1].getName())) != null) {
            trackNumberTo = params.getCustomerParam(this.getSpecialCustomerParamKey(this.getTrackNumberF7()[1].getName()));
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)trackNumberFrom));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)trackNumberTo));
            filter.setMaskString("#0 or #1");
            try {
                view.setFilter(filter);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            TrackNumberCollection projColl = TrackNumberFactory.getRemoteInstance().getTrackNumberCollection(view);
            if (projColl != null && projColl.size() > 0) {
                if (projColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (projColl.get(i).getNumber().equals(trackNumberFrom)) {
                            this.getTrackNumberF7()[0].setData((Object)projColl.get(i));
                            continue;
                        }
                        this.getTrackNumberF7()[1].setData((Object)projColl.get(i));
                    }
                } else if (projColl.size() == 1) {
                    if (projColl.get(0).getNumber().equals(trackNumberFrom)) {
                        this.getTrackNumberF7()[0].setData((Object)projColl.get(0));
                    }
                    if (projColl.get(0).getNumber().equals(trackNumberTo)) {
                        this.getTrackNumberF7()[1].setData((Object)projColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.getTrackNumberF7()[0].setData(null);
            this.getTrackNumberF7()[1].setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    protected void loadBatchNumber(CustomerParams params) {
        String batchNumberFrom = "";
        String batchNumberTo = "";
        if (params.getCustomerParam(this.getSpecialCustomerParamKey(this.getBatchNumberCtrls()[0].getName())) != null) {
            batchNumberFrom = params.getCustomerParam(this.getSpecialCustomerParamKey(this.getBatchNumberCtrls()[0].getName()));
            this.getBatchNumberCtrls()[0].setText(batchNumberFrom);
        }
        if (params.getCustomerParam(this.getSpecialCustomerParamKey(this.getBatchNumberCtrls()[1].getName())) != null) {
            batchNumberTo = params.getCustomerParam(this.getSpecialCustomerParamKey(this.getBatchNumberCtrls()[1].getName()));
            this.getBatchNumberCtrls()[1].setText(batchNumberTo);
        }
    }

    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getAdminCUFieldName() {
        return "adminCU.id";
    }

    protected KDSpinner[] getPeriodSpinner() {
        return null;
    }

    protected KDSpinner getDisplayCountSpinner() {
        return null;
    }

    protected JComponent[] getOtherComponent() {
        return null;
    }

    protected KDBizPromptBox[] getCostCenterF7() {
        return null;
    }

    protected KDBizPromptBox[] getCostObjectF7() {
        return null;
    }

    protected KDBizPromptBox[] getMaterialF7() {
        return null;
    }

    protected KDBizPromptBox[] getCostItemF7() {
        return null;
    }

    protected KDBizPromptBox[] getOrderNumberF7() {
        return null;
    }

    protected KDTextField[] getBatchNumberCtrls() {
        return null;
    }

    protected KDBizPromptBox[] getProjectNumberF7() {
        return null;
    }

    protected KDBizPromptBox[] getTrackNumberF7() {
        return null;
    }

    protected class MutilComPromptFilterElement
    extends SingleFilterElement {
        KDBizPromptBox prmt;

        public MutilComPromptFilterElement(String id, KDBizPromptBox component) {
            super(id, (Component)component);
            this.prmt = component;
        }

        public void addRptParams(RptParams cp) {
            Object object = this.prmt.getValue();
            HashSet<Object> objects = new HashSet<Object>();
            if (object == null) {
                object = this.prmt.getText();
                NCMReportFilterUI.this.loadCompany(object.toString());
                object = this.prmt.getValue();
            }
            if (object instanceof Object[]) {
                for (int i = 0; i < ((Object[])object).length; ++i) {
                    objects.add(((Object[])object)[i]);
                }
            }
            if (objects == null) {
                object = this.prmt.getText().trim();
            }
            cp.setObject(this.getId(), objects);
        }
    }

    protected class SingleComPromptFilterElement
    extends SingleFilterElement {
        KDBizPromptBox prmt;

        public SingleComPromptFilterElement(String id, KDBizPromptBox component) {
            super(id, (Component)component);
            this.prmt = component;
        }

        public void addRptParams(RptParams cp) {
            Object object = this.prmt.getValue();
            if (object == null) {
                object = this.prmt.getText();
                NCMReportFilterUI.this.loadCompany(object.toString());
                object = this.prmt.getValue();
            }
            if (object instanceof Object[]) {
                object = ((Object[])object)[0];
            }
            if (object == null) {
                object = this.prmt.getText().trim();
            }
            cp.setObject(this.getId(), object);
        }
    }
}

