/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostItemCollection;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.ncm.ExpenseCollection;
import com.kingdee.eas.basedata.ncm.ExpenseFactory;
import com.kingdee.eas.basedata.ncm.client.MaterialF7TreeListSelector;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.ncm.cal.report.client.AbstractOtherCostAllocDetailReportFilterUI;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.SpinnerUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.enums.IntEnum;
import java.awt.Component;
import java.text.ParseException;
import java.util.HashSet;
import javax.swing.JSpinner;
import org.apache.log4j.Logger;

public class OtherCostAllocDetailReportFilterUI
extends AbstractOtherCostAllocDetailReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(OtherCostAllocDetailReportFilterUI.class);
    protected boolean isNormal = false;
    private PeriodInfo currentPeriod;
    private PeriodInfo startPeriod;
    private PeriodInfo maxPeriod = null;
    private CustomerParams cp = null;

    public OtherCostAllocDetailReportFilterUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        NCMClientUtils.checkIsStart();
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        this.currentPeriod = sysctrol.getCacheCurrentPeriod(1001, companyOrg.getId().toString());
        if (this.currentPeriod == null) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        this.startPeriod = sysctrol.getStartPeriod(1001, companyOrg.getId().toString());
        this.maxPeriod = NCMUtils.getMaxPeriod((CompanyOrgUnitInfo)companyOrg, (PeriodInfo)this.currentPeriod);
        this.prmtCompanyOrg.setValue((Object)companyOrg);
        BDCMClientUtils.setBizOrgF7ByType((KDBizPromptBox)this.prmtCompanyOrg, (OrgType)OrgType.Company);
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterFrom, (String)companyOrg.getId().toString());
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterTo, (String)companyOrg.getId().toString());
        this.prmtCostObjectFrom.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.prmtCostObjectFrom, Boolean.TRUE);
        this.prmtCostObjectFrom.setSelector((KDPromptSelector)arg0);
        this.prmtCostObjectTo.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg1 = new CostObjectF7UISelector((Object)this, this.prmtCostObjectTo, Boolean.TRUE);
        this.prmtCostObjectTo.setSelector((KDPromptSelector)arg1);
        BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)this.prmtCostObjectFrom, (String)companyOrg.getId().toString());
        BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)this.prmtCostObjectTo, (String)companyOrg.getId().toString());
        BDCMClientUtils.filterOrderF7((KDBizPromptBox)this.prmtOrderNumberFrom, (String)companyOrg.getId().toString());
        BDCMClientUtils.filterOrderF7((KDBizPromptBox)this.prmtOrderNumberTo, (String)companyOrg.getId().toString());
        FilterInfo costItemFilterInfo = this.getCostItemFilter();
        FilterInfo expenseFilterInfo = this.getExpenseFilter();
        this.setFilterInfoF7(this.prmtCostItemFrom, costItemFilterInfo);
        this.setFilterInfoF7(this.prmtCostItemTo, costItemFilterInfo);
        this.setFilterInfoF7(this.prmtExpenseFrom, expenseFilterInfo);
        this.setFilterInfoF7(this.prmtExpenseTo, expenseFilterInfo);
        this.filterProject(this.prmtProjectNumberFrom);
        this.filterProject(this.prmtProjectNumberTo);
        this.filterTrack(this.prmtTrackNumberFrom);
        this.filterTrack(this.prmtTrackNumberTo);
        BDCMClientUtils.filterF7((KDBizPromptBox)this.prmtMaterialFrom, (String)"company.id", (Object)companyOrg.getId().toString());
        BDCMClientUtils.filterF7((KDBizPromptBox)this.prmtMaterialFrom, (String)"status", (IntEnum)UsedStatusEnum.APPROVED);
        BDCMClientUtils.filterF7((KDBizPromptBox)this.prmtMaterialTo, (String)"company.id", (Object)companyOrg.getId().toString());
        BDCMClientUtils.filterF7((KDBizPromptBox)this.prmtMaterialTo, (String)"status", (IntEnum)UsedStatusEnum.APPROVED);
        FilterInfo filterPrmt2 = this.prmtMaterialFrom.getEntityViewInfo().getFilter();
        filterPrmt2.getFilterItems().add(new FilterItemInfo("FIInfo.status", (Object)String.valueOf(1), CompareType.EQUALS));
        this.prmtMaterialFrom = NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)this.prmtMaterialFrom, (FilterInfo)filterPrmt2);
        this.prmtMaterialTo = NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)this.prmtMaterialTo, (FilterInfo)filterPrmt2);
    }

    @Override
    protected FilterElement getFilterElement() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleBizPromptFilterElement filterElement = new SingleBizPromptFilterElement("companyorg", this.prmtCompanyOrg);
        filterElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"183_CCFeeTotalReportFilterUI")));
        elements.add((FilterElement)filterElement);
        SpinnerFilterElement element = new SpinnerFilterElement("yearFrom", (Component)this.spYearFrom);
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("yearTo", (Component)this.spYearTo);
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("periodFrom", (Component)this.spPeriodFrom);
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("periodTo", (Component)this.spPeriodTo);
        elements.add((FilterElement)element);
        elements.add((FilterElement)new SingleFilterElement("costcenterFrom", (Component)this.prmtCostCenterFrom));
        elements.add((FilterElement)new SingleFilterElement("costcenterTo", (Component)this.prmtCostCenterTo));
        elements.add((FilterElement)new SingleFilterElement("expenseFrom", (Component)this.prmtExpenseFrom));
        elements.add((FilterElement)new SingleFilterElement("expenseTo", (Component)this.prmtExpenseTo));
        elements.add((FilterElement)new SingleFilterElement("costobjectFrom", (Component)this.prmtCostObjectFrom));
        elements.add((FilterElement)new SingleFilterElement("costobjectTo", (Component)this.prmtCostObjectTo));
        elements.add((FilterElement)new SingleFilterElement("costitemFrom", (Component)this.prmtCostItemFrom));
        elements.add((FilterElement)new SingleFilterElement("costitemTo", (Component)this.prmtCostItemTo));
        elements.add((FilterElement)new SingleFilterElement("orderNumberFrom", (Component)this.prmtOrderNumberFrom));
        elements.add((FilterElement)new SingleFilterElement("orderNumberTo", (Component)this.prmtOrderNumberTo));
        elements.add((FilterElement)new SingleFilterElement("batchNumberFrom", (Component)this.txtBatchNumberFrom));
        elements.add((FilterElement)new SingleFilterElement("batchNumberTo", (Component)this.txtBatchNumberTo));
        elements.add((FilterElement)new SingleFilterElement("projectNumberFrom", (Component)this.prmtProjectNumberFrom));
        elements.add((FilterElement)new SingleFilterElement("projectNumberTo", (Component)this.prmtProjectNumberTo));
        elements.add((FilterElement)new SingleFilterElement("trackNumberFrom", (Component)this.prmtTrackNumberFrom));
        elements.add((FilterElement)new SingleFilterElement("trackNumberTo", (Component)this.prmtTrackNumberTo));
        elements.add((FilterElement)new SingleFilterElement("materialFrom", (Component)this.prmtMaterialFrom));
        elements.add((FilterElement)new SingleFilterElement("materialTo", (Component)this.prmtMaterialTo));
        this.getFilterManager().setElement((FilterElement)elements);
        return elements;
    }

    protected void filterProject(KDBizPromptBox prmt) throws Exception {
        FilterInfo filter = ProjectFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), "id", "CU.id");
        EntityViewInfo view = null;
        view = prmt.getEntityViewInfo() != null ? prmt.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        prmt.setEntityViewInfo(view);
    }

    protected void filterTrack(KDBizPromptBox prmt) throws Exception {
        FilterInfo filter = TrackNumberFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), "id", "CU.id");
        EntityViewInfo view = null;
        view = prmt.getEntityViewInfo() != null ? prmt.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        prmt.setEntityViewInfo(view);
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
    }

    private void setFilterInfoF7(KDBizPromptBox f7, FilterInfo filter) {
        EntityViewInfo view = f7.getEntityViewInfo() != null ? f7.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    @Override
    protected FilterInfo getCostItemFilter() throws Exception {
        return CostItemFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
    }

    protected FilterInfo getExpenseFilter() throws Exception {
        FilterInfo filter = ExpenseFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
        FilterInfo noMatFilter = new FilterInfo();
        noMatFilter.getFilterItems().add(new FilterItemInfo("expenseType", (Object)String.valueOf(1), CompareType.NOTEQUALS));
        filter.mergeFilter(noMatFilter, "and");
        return filter;
    }

    @Override
    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    @Override
    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    protected String getAdminCUFieldName() {
        return "adminCU.id";
    }

    @Override
    public void clear() {
        this.getFilterManager().clearAll();
        this.setDefaultValue();
    }

    @Override
    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrg;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public KDBizPromptBox getCompanyF7() {
        return this.prmtCompanyOrg;
    }

    @Override
    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    @Override
    protected void registerF7() throws Exception {
        super.registerF7();
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenterFrom);
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenterTo);
        this.f7ContextManager.registerCompanyFilterOnlyF7(this.prmtExpenseFrom, "com.kingdee.eas.basedata.ncm.app.ExpenseF7Query", "CompanyInfo.id");
        this.f7ContextManager.registerCompanyFilterOnlyF7(this.prmtExpenseTo, "com.kingdee.eas.basedata.ncm.app.ExpenseF7Query", "CompanyInfo.id");
        this.f7ContextManager.registerCostObjectF7(this.prmtCostObjectFrom, true);
        this.f7ContextManager.registerCostObjectF7(this.prmtCostObjectTo, true);
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> statuses = new HashSet<Integer>();
        statuses.add(5);
        statuses.add(8);
        statuses.add(7);
        statuses.add(11);
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", statuses, CompareType.INCLUDE));
        this.f7ContextManager.registerManufactureOrderF7(this.prmtOrderNumberFrom, filter);
        this.f7ContextManager.registerManufactureOrderF7(this.prmtOrderNumberTo, filter);
        this.prmtOrderNumberFrom.setDisplayFormat("$number$");
        this.prmtOrderNumberTo.setDisplayFormat("$number$");
        this.f7ContextManager.registerMaterialTreeF7(this.prmtMaterialFrom, null);
        MaterialF7TreeListSelector selector = new MaterialF7TreeListSelector((Object)this, this.prmtMaterialFrom);
        this.prmtMaterialFrom.setSelector((KDPromptSelector)selector);
        this.f7ContextManager.registerMaterialTreeF7(this.prmtMaterialTo, null);
        selector = new MaterialF7TreeListSelector((Object)this, this.prmtMaterialTo);
        this.prmtMaterialTo.setSelector((KDPromptSelector)selector);
    }

    @Override
    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                this.prmtCostCenterFrom.setValue(null);
                this.prmtCostCenterTo.setValue(null);
                this.prmtCostObjectFrom.setValue(null);
                this.prmtCostObjectTo.setValue(null);
                this.prmtExpenseFrom.setValue(null);
                this.prmtExpenseTo.setValue(null);
                this.prmtCostItemFrom.setValue(null);
                this.prmtCostItemTo.setValue(null);
                this.prmtOrderNumberFrom.setValue(null);
                this.prmtOrderNumberTo.setValue(null);
                this.txtBatchNumberFrom.setText(null);
                this.txtBatchNumberTo.setText(null);
                this.prmtProjectNumberFrom.setValue(null);
                this.prmtProjectNumberTo.setValue(null);
                this.prmtTrackNumberFrom.setValue(null);
                this.prmtTrackNumberTo.setValue(null);
                this.prmtMaterialFrom.setValue(null);
                this.prmtMaterialTo.setValue(null);
                this.initPeriod(this.getCompanyOrgInfoWithDefault());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private void initPeriod(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        this.maxPeriod = NCMUtils.getMaxPeriod((CompanyOrgUnitInfo)company, (PeriodInfo)this.currentPeriod);
        this.startPeriod = NCMUtils.GetStartPeriod(null, (String)company.getId().toString());
        this.currentPeriod = NCMUtils.GetCurrentPeriod(null, (String)company.getId().toString());
        if (this.currentPeriod == null) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        if (this.startPeriod == null) {
            return;
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)this.currentPeriod);
    }

    @Override
    protected String getReportViewPermissionItem() {
        return "OtherCostAllocTotalReportView";
    }

    @Override
    protected String getReportPrintPermissionItem() {
        return "OtherCostAllocTotalReportPrint";
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    @Override
    protected KDBizPromptBox[] getOrderNumberF7() {
        return new KDBizPromptBox[]{this.prmtOrderNumberFrom, this.prmtOrderNumberTo};
    }

    @Override
    protected KDBizPromptBox[] getProjectNumberF7() {
        return new KDBizPromptBox[]{this.prmtProjectNumberFrom, this.prmtProjectNumberTo};
    }

    @Override
    protected KDBizPromptBox[] getTrackNumberF7() {
        return new KDBizPromptBox[]{this.prmtTrackNumberFrom, this.prmtTrackNumberTo};
    }

    @Override
    protected KDBizPromptBox[] getMaterialF7() {
        return new KDBizPromptBox[]{this.prmtMaterialFrom, this.prmtMaterialTo};
    }

    @Override
    protected KDTextField[] getBatchNumberCtrls() {
        return new KDTextField[]{this.txtBatchNumberFrom, this.txtBatchNumberTo};
    }

    @Override
    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CustomerParams params = this.cp;
        if (params != null) {
            this.loadPeriod(params);
            this.loadExpense(params);
            this.loadCostCenterNum(params);
            this.loadCostObject(params);
            this.loadCostItemNum(params);
        }
    }

    private void loadPeriod(CustomerParams params) {
        PeriodInfo initPeriodFrom = this.currentPeriod;
        PeriodInfo initPeriodTo = this.currentPeriod;
        String initYearFrom = params.getCustomerParam("spYearFrom");
        String initMonthFrom = params.getCustomerParam("spPeriodFrom");
        String initYearTo = params.getCustomerParam("spYearTo");
        String initMonthTo = params.getCustomerParam("spPeriodTo");
        try {
            if (!StringUtils.isEmpty((String)initYearFrom) && !StringUtils.isEmpty((String)initMonthFrom)) {
                initPeriodFrom = new PeriodInfo();
                initPeriodFrom.setPeriodYear(Integer.parseInt(initYearFrom));
                initPeriodFrom.setPeriodNumber(Integer.parseInt(initMonthFrom));
            }
            if (!StringUtils.isEmpty((String)initYearTo) && !StringUtils.isEmpty((String)initMonthTo)) {
                initPeriodTo = new PeriodInfo();
                initPeriodTo.setPeriodYear(Integer.parseInt(initYearTo));
                initPeriodTo.setPeriodNumber(Integer.parseInt(initMonthTo));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)initPeriodFrom, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)initPeriodTo);
    }

    @Override
    protected void setDefaultValue() {
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtCompanyOrg.setValue((Object)companyOrg);
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)this.currentPeriod);
        this.prmtCostCenterFrom.setValue(null);
        this.prmtCostCenterTo.setValue(null);
        this.prmtCostObjectFrom.setValue(null);
        this.prmtCostObjectTo.setValue(null);
        this.prmtExpenseFrom.setValue(null);
        this.prmtExpenseTo.setValue(null);
        this.prmtCostItemTo.setValue(null);
        this.prmtCostItemTo.setValue(null);
    }

    private void loadCostItemNum(CustomerParams params) {
        String costItemFrom = "";
        String costItemTo = "";
        if (params.getCustomerParam("prmtCostItemFrom") != null) {
            costItemFrom = params.getCustomerParam("prmtCostItemFrom");
        }
        if (params.getCustomerParam("prmtCostItemTo") != null) {
            costItemTo = params.getCustomerParam("prmtCostItemTo");
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costItemFrom));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costItemTo));
            filter.setMaskString("#0 or #1");
            try {
                FilterInfo costItemFilterInfo = this.getCostItemFilter();
                costItemFilterInfo.mergeFilter(filter, "and");
                view.setFilter(costItemFilterInfo);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            CostItemCollection costItemColl = CostItemFactory.getRemoteInstance().getCostItemCollection(view);
            if (costItemColl != null && costItemColl.size() > 0) {
                if (costItemColl.size() == 2) {
                    this.prmtCostItemFrom.setData((Object)(costItemColl.get(0).getNumber().equals(costItemFrom) ? costItemColl.get(0) : costItemColl.get(1)));
                    this.prmtCostItemTo.setData((Object)(costItemColl.get(0).getNumber().equals(costItemFrom) ? costItemColl.get(1) : costItemColl.get(0)));
                } else if (costItemColl.size() == 1) {
                    if (costItemColl.get(0).getNumber().equals(costItemFrom)) {
                        this.prmtCostItemFrom.setData((Object)costItemColl.get(0));
                    }
                    if (costItemColl.get(0).getNumber().equals(costItemTo)) {
                        this.prmtCostItemTo.setData((Object)costItemColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtCostItemFrom.setData(null);
            this.prmtCostItemTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadCostObject(CustomerParams params) {
        String costObjectFrom = "";
        String costObjectTo = "";
        if (params.getCustomerParam("prmtCostObjectFrom") != null) {
            costObjectFrom = params.getCustomerParam("prmtCostObjectFrom");
        }
        if (params.getCustomerParam("prmtCostObjectTo") != null) {
            costObjectTo = params.getCustomerParam("prmtCostObjectTo");
        }
        try {
            String companyId = this.getCompanyOrgInfoWithDefault().getId().toString();
            String oql = " select * where company.id = '" + companyId + "'  and ( number = '" + costObjectFrom + "' or number = '" + costObjectTo + "')";
            CostObjectCollection costObjectColl = CostObjectFactory.getRemoteInstance().getCostObjectCollection(oql);
            if (costObjectColl != null && costObjectColl.size() > 0) {
                if (costObjectColl.size() == 2) {
                    this.prmtCostObjectFrom.setData((Object)(costObjectColl.get(0).getNumber().equals(costObjectFrom) ? costObjectColl.get(0) : costObjectColl.get(1)));
                    this.prmtCostObjectTo.setData((Object)(costObjectColl.get(0).getNumber().equals(costObjectFrom) ? costObjectColl.get(1) : costObjectColl.get(0)));
                } else if (costObjectColl.size() == 1) {
                    if (costObjectColl.get(0).getNumber().equals(costObjectFrom)) {
                        this.prmtCostObjectFrom.setData((Object)costObjectColl.get(0));
                    }
                    if (costObjectColl.get(0).getNumber().equals(costObjectTo)) {
                        this.prmtCostObjectTo.setData((Object)costObjectColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtCostObjectFrom.setData(null);
            this.prmtCostObjectTo.setData(null);
            logger.error((Object)e);
        }
    }

    private void loadCostCenterNum(CustomerParams params) {
        String costCenterFrom = "";
        String costCenterTo = "";
        if (params.getCustomerParam("prmtCostCenterFrom") != null) {
            costCenterFrom = params.getCustomerParam("prmtCostCenterFrom");
        }
        if (params.getCustomerParam("prmtCostCenterTo") != null) {
            costCenterTo = params.getCustomerParam("prmtCostCenterTo");
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterFrom));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterTo));
            view.setFilter(filter);
            view.getFilter().setMaskString("#0 or #1");
            CostCenterOrgUnitCollection costCenterColl = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(view);
            if (costCenterColl != null && costCenterColl.size() > 0) {
                if (costCenterColl.size() == 2) {
                    this.prmtCostCenterFrom.setData((Object)(costCenterColl.get(0).getNumber().equals(costCenterFrom) ? costCenterColl.get(0) : costCenterColl.get(1)));
                    this.prmtCostCenterTo.setData((Object)(costCenterColl.get(0).getNumber().equals(costCenterFrom) ? costCenterColl.get(1) : costCenterColl.get(0)));
                } else if (costCenterColl.size() == 1) {
                    if (costCenterColl.get(0).getNumber().equals(costCenterFrom)) {
                        this.prmtCostCenterFrom.setData((Object)costCenterColl.get(0));
                    }
                    if (costCenterColl.get(0).getNumber().equals(costCenterTo)) {
                        this.prmtCostCenterTo.setData((Object)costCenterColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtCostCenterFrom.setData(null);
            this.prmtCostCenterTo.setData(null);
            logger.error((Object)e);
        }
    }

    private void loadExpense(CustomerParams params) {
        String expenseFrom = "";
        String expenseTo = "";
        if (params.getCustomerParam("prmtExpenseFrom") != null) {
            expenseFrom = params.getCustomerParam("prmtExpenseFrom");
        }
        if (params.getCustomerParam("prmtExpenseTo") != null) {
            expenseTo = params.getCustomerParam("prmtExpenseTo");
        }
        try {
            ExpenseCollection expenseColl = ExpenseFactory.getRemoteInstance().getExpenseCollection("select * where number ='" + expenseFrom + "' or number = '" + expenseTo + "'");
            if (expenseColl != null && expenseColl.size() > 0) {
                if (expenseColl.size() == 2) {
                    this.prmtExpenseFrom.setData((Object)(expenseColl.get(0).getNumber().equals(expenseFrom) ? expenseColl.get(0) : expenseColl.get(1)));
                    this.prmtExpenseTo.setData((Object)(expenseColl.get(0).getNumber().equals(expenseFrom) ? expenseColl.get(1) : expenseColl.get(0)));
                } else if (expenseColl.size() == 1) {
                    if (expenseColl.get(0).getNumber().equals(expenseFrom)) {
                        this.prmtExpenseFrom.setData((Object)expenseColl.get(0));
                    }
                    if (expenseColl.get(0).getNumber().equals(expenseTo)) {
                        this.prmtExpenseTo.setData((Object)expenseColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtExpenseFrom.setData(null);
            logger.error((Object)e);
        }
    }

    static class SingleBizPromptFilterElement
    extends SingleFilterElement {
        KDBizPromptBox prmt;

        public SingleBizPromptFilterElement(String id, KDBizPromptBox component) {
            super(id, (Component)component);
            this.prmt = component;
        }

        public void addRptParams(RptParams cp) {
            Object object = this.prmt.getValue();
            if (object == null) {
                try {
                    this.prmt.commitEdit();
                }
                catch (ParseException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                object = this.prmt.getValue();
            }
            if (object instanceof Object[]) {
                object = ((Object[])object)[0];
            }
            cp.setObject(this.getId(), object);
        }
    }

    static class SpinnerFilterElement
    extends SingleFilterElement {
        private KDSpinner spinner;

        public SpinnerFilterElement(String id, Component component) {
            super(id, component);
            this.spinner = (KDSpinner)component;
        }

        protected void setNumber(Object obj, String value) {
            this.spinner.setValue((Object)Integer.valueOf(value));
        }

        protected String getName(Object obj) {
            return ((Component)obj).getName();
        }

        protected void setData(Component obj, Object value) {
            this.spinner.setValue(value);
        }
    }
}

