/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostItemCollection;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectSuiteCollection;
import com.kingdee.eas.basedata.assistant.CostObjectSuiteFactory;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.ncm.ExpenseCollection;
import com.kingdee.eas.basedata.ncm.ExpenseFactory;
import com.kingdee.eas.basedata.ncm.ExpenseTypeEnum;
import com.kingdee.eas.basedata.ncm.client.MaterialF7TreeListSelector;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.ncm.cal.report.client.AbstractOtherFeeAllocDetailReportFilterUI;
import com.kingdee.eas.ncm.cal.report.client.CheckBoxFilterElement;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.SpinnerUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.awt.event.ItemListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JSpinner;
import org.apache.log4j.Logger;

public class OtherFeeAllocDetailReportFilterUI
extends AbstractOtherFeeAllocDetailReportFilterUI {
    private static final long serialVersionUID = -7802888175088998604L;
    private static final Logger logger = CoreUIObject.getLogger(OtherFeeAllocDetailReportFilterUI.class);
    private CompanyOrgUnitInfo companyOrg = null;
    private FilterInfo expenseBaseFilter = null;
    List expenseTypes = null;
    private ItemListener cbbExpenseTypeFromListener = null;
    private ItemListener cbbExpenseTypeToListener = null;
    private SingleFilterElement spYearFromFilterElement = null;
    private SingleFilterElement spYearToFilterElement = null;
    private SingleFilterElement spPeriodFromFilterElement = null;
    private SingleFilterElement spPeriodToFilterElement = null;
    private PeriodInfo currentPeriod;
    private PeriodInfo startPeriod;
    private PeriodInfo maxPeriod = null;
    private CustomerParams cp = null;

    public OtherFeeAllocDetailReportFilterUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        NCMClientUtils.checkIsStart();
        this.companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        this.currentPeriod = sysctrol.getCacheCurrentPeriod(1001, this.companyOrg.getId().toString());
        if (this.currentPeriod == null) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        this.startPeriod = sysctrol.getStartPeriod(1001, this.companyOrg.getId().toString());
        this.maxPeriod = NCMUtils.getMaxPeriod((CompanyOrgUnitInfo)this.companyOrg, (PeriodInfo)this.currentPeriod);
        this.prmtcompanyorg.setValue((Object)this.companyOrg);
        BDCMClientUtils.setBizOrgF7ByType((KDBizPromptBox)this.prmtcompanyorg, (OrgType)OrgType.Company);
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtcostcenterfrom, (String)this.companyOrg.getId().toString());
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtcostcenterto, (String)this.companyOrg.getId().toString());
        BDCMClientUtils.filterF7((KDBizPromptBox)this.prmtcostobjectgroupfrom, (String)"company.id", (Object)this.companyOrg.getId().toString());
        BDCMClientUtils.filterF7((KDBizPromptBox)this.prmtcostobjectgroupto, (String)"company.id", (Object)this.companyOrg.getId().toString());
        this.prmtcostobjectfrom.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.prmtcostobjectfrom, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
        this.prmtcostobjectfrom.setSelector((KDPromptSelector)arg0);
        this.prmtcostobjectto.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg1 = new CostObjectF7UISelector((Object)this, this.prmtcostobjectto, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
        this.prmtcostobjectto.setSelector((KDPromptSelector)arg1);
        BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)this.prmtcostobjectfrom, (String)this.companyOrg.getId().toString());
        BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)this.prmtcostobjectto, (String)this.companyOrg.getId().toString());
        FilterInfo expenseFilterInfo = this.getExpenseFilter();
        this.setFilterInfoF7(this.prmtexpensefrom, expenseFilterInfo);
        this.setFilterInfoF7(this.prmtexpenseto, expenseFilterInfo);
        BDCMClientUtils.filterF7((KDBizPromptBox)this.prmtcostitemfrom, (String)"company.id", (Object)this.companyOrg.getId().toString());
        BDCMClientUtils.filterF7((KDBizPromptBox)this.prmtcostitemto, (String)"company.id", (Object)this.companyOrg.getId().toString());
        FilterInfo costItemFilterInfo = this.getCostItemFilter();
        this.setFilterInfoF7(this.prmtcostitemfrom, costItemFilterInfo);
        this.setFilterInfoF7(this.prmtcostitemto, costItemFilterInfo);
        BDCMClientUtils.filterOrderF7((KDBizPromptBox)this.prmtOrderFrom, (String)this.companyOrg.getId().toString());
        BDCMClientUtils.filterOrderF7((KDBizPromptBox)this.prmtOrderTo, (String)this.companyOrg.getId().toString());
        this.filterProject(this.prmtProjectNumberFrom);
        this.filterProject(this.prmtProjectNumberTo);
        this.filterTrack(this.prmtTrackNumberFrom);
        this.filterTrack(this.prmtTrackNumberTo);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyOrg.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)String.valueOf(1)));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        this.prmtMaterialFrom.setEntityViewInfo(view);
        this.prmtMaterialTo.setEntityViewInfo(view);
        FilterInfo filterPrmt = this.prmtMaterialFrom.getEntityViewInfo().getFilter();
        filterPrmt.getFilterItems().add(new FilterItemInfo("FIInfo.status", (Object)String.valueOf(1), CompareType.EQUALS));
        this.prmtMaterialFrom = NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)this.prmtMaterialFrom, (FilterInfo)filterPrmt);
        this.prmtMaterialTo = NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)this.prmtMaterialTo, (FilterInfo)filterPrmt);
    }

    @Override
    protected FilterElement getFilterElement() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleBizPromptFilterElement filterElement = new SingleBizPromptFilterElement("companyorg", this.prmtcompanyorg);
        filterElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"183_CCFeeTotalReportFilterUI")));
        elements.add((FilterElement)filterElement);
        this.spYearFromFilterElement = new SpinnerFilterElement("yearfrom", (Component)this.spyearfrom);
        this.spYearFromFilterElement.setDefaultValue((Object)this.currentPeriod.getPeriodYear());
        elements.add((FilterElement)this.spYearFromFilterElement);
        this.spYearToFilterElement = new SpinnerFilterElement("yearto", (Component)this.spyearto);
        this.spYearToFilterElement.setDefaultValue((Object)this.currentPeriod.getPeriodYear());
        elements.add((FilterElement)this.spYearToFilterElement);
        this.spPeriodFromFilterElement = new SpinnerFilterElement("periodfrom", (Component)this.spperiodfrom);
        this.spPeriodFromFilterElement.setDefaultValue((Object)this.currentPeriod.getPeriodNumber());
        elements.add((FilterElement)this.spPeriodFromFilterElement);
        this.spPeriodToFilterElement = new SpinnerFilterElement("periodto", (Component)this.spperiodto);
        this.spPeriodToFilterElement.setDefaultValue((Object)this.currentPeriod.getPeriodNumber());
        elements.add((FilterElement)this.spPeriodToFilterElement);
        elements.add((FilterElement)new SingleFilterElement("costcenterfrom", (Component)this.prmtcostcenterfrom));
        elements.add((FilterElement)new SingleFilterElement("costcenterto", (Component)this.prmtcostcenterto));
        elements.add((FilterElement)new SingleFilterElement("costobjectgroupfrom", (Component)this.prmtcostobjectgroupfrom));
        elements.add((FilterElement)new SingleFilterElement("costobjectgroupto", (Component)this.prmtcostobjectgroupto));
        elements.add((FilterElement)new SingleFilterElement("costobjectfrom", (Component)this.prmtcostobjectfrom));
        elements.add((FilterElement)new SingleFilterElement("costobjectto", (Component)this.prmtcostobjectto));
        elements.add((FilterElement)new CheckBoxFilterElement("labor", this.cbLabor));
        elements.add((FilterElement)new CheckBoxFilterElement("manufacture", this.cbManufacture));
        elements.add((FilterElement)new CheckBoxFilterElement("consign", this.cbConsign));
        elements.add((FilterElement)new CheckBoxFilterElement("equipment", this.cbEquipment));
        elements.add((FilterElement)new CheckBoxFilterElement("other", this.cbOther));
        elements.add((FilterElement)new SingleFilterElement("expensefrom", (Component)this.prmtexpensefrom));
        elements.add((FilterElement)new SingleFilterElement("expenseto", (Component)this.prmtexpenseto));
        elements.add((FilterElement)new SingleFilterElement("costitemfrom", (Component)this.prmtcostitemfrom));
        elements.add((FilterElement)new SingleFilterElement("costitemto", (Component)this.prmtcostitemto));
        elements.add((FilterElement)new SingleFilterElement("orderFrom", (Component)this.prmtOrderFrom));
        elements.add((FilterElement)new SingleFilterElement("orderTo", (Component)this.prmtOrderTo));
        elements.add((FilterElement)new SingleFilterElement("batchNumberFrom", (Component)this.txtBatchNumberFrom));
        elements.add((FilterElement)new SingleFilterElement("batchNumberTo", (Component)this.txtBatchNumberTo));
        elements.add((FilterElement)new SingleFilterElement("projectNumberFrom", (Component)this.prmtProjectNumberFrom));
        elements.add((FilterElement)new SingleFilterElement("projectNumberTo", (Component)this.prmtProjectNumberTo));
        elements.add((FilterElement)new SingleFilterElement("trackNumberFrom", (Component)this.prmtTrackNumberFrom));
        elements.add((FilterElement)new SingleFilterElement("trackNumberTo", (Component)this.prmtTrackNumberTo));
        elements.add((FilterElement)new SingleFilterElement("materialFrom", (Component)this.prmtMaterialFrom));
        elements.add((FilterElement)new SingleFilterElement("materialTo", (Component)this.prmtMaterialTo));
        return elements;
    }

    protected FilterInfo getExpenseFilter() throws Exception {
        return ExpenseFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
    }

    protected void filterF7ForCU(KDBizPromptBox f7) throws BOSException, EASBizException {
        CtrlUnitInfo cU = SysContext.getSysContext().getCurrentCtrlUnit();
        String cUID = null;
        if (cU != null) {
            cUID = cU.getId().toString();
        }
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cUID, CompareType.EQUALS));
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    protected void filterProject(KDBizPromptBox prmt) throws Exception {
        FilterInfo filter = ProjectFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), "id", "CU.id");
        EntityViewInfo view = null;
        view = prmt.getEntityViewInfo() != null ? prmt.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        prmt.setEntityViewInfo(view);
    }

    protected void filterTrack(KDBizPromptBox prmt) throws Exception {
        FilterInfo filter = TrackNumberFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), "id", "CU.id");
        EntityViewInfo view = null;
        view = prmt.getEntityViewInfo() != null ? prmt.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        prmt.setEntityViewInfo(view);
    }

    private List getExpenseTypes() {
        if (this.expenseTypes == null) {
            this.expenseTypes = new ArrayList();
            this.expenseTypes.add(null);
            for (ExpenseTypeEnum expenseType : EnumUtils.getEnumList((String)"com.kingdee.eas.basedata.ncm.ExpenseTypeEnum")) {
                if (ExpenseTypeEnum.MATERIAL.equals((Object)expenseType)) continue;
                this.expenseTypes.add(expenseType);
            }
        }
        return this.expenseTypes;
    }

    private FilterInfo getExpenseBaseFilterInfo() throws EASBizException, BOSException {
        if (this.expenseBaseFilter == null) {
            this.expenseBaseFilter = ExpenseFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
            FilterInfo matFilter = new FilterInfo();
            matFilter.getFilterItems().add(new FilterItemInfo("expenseType", (Object)String.valueOf(1), CompareType.NOTEQUALS));
            this.expenseBaseFilter.mergeFilter(matFilter, "and");
        }
        return (FilterInfo)this.expenseBaseFilter.clone();
    }

    @Override
    protected FilterInfo getCostItemFilter() throws Exception {
        return CostItemFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
    }

    private void setFilterInfoF7(KDBizPromptBox f7, FilterInfo filter) {
        EntityViewInfo view = f7.getEntityViewInfo() != null ? f7.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    @Override
    public boolean verify() {
        Integer yearFrom = (Integer)this.spyearfrom.getValue();
        Integer yearTo = (Integer)this.spyearto.getValue();
        if (yearTo.compareTo(yearFrom) < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"184_CCFeeTotalReportFilterUI"));
            return false;
        }
        if (yearTo.compareTo(yearFrom) == 0) {
            Integer periodFrom = (Integer)this.spperiodfrom.getValue();
            Integer periodTo = (Integer)this.spperiodto.getValue();
            if (periodTo.compareTo(periodFrom) < 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"184_CCFeeTotalReportFilterUI"));
                return false;
            }
        }
        return super.verify();
    }

    @Override
    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtcompanyorg;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public void setCustomerParams(CustomerParams params) {
        super.setCustomerParams(params);
        this.cp = params;
    }

    @Override
    public KDBizPromptBox getCompanyF7() {
        return this.prmtcompanyorg;
    }

    @Override
    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    @Override
    protected void registerF7() throws Exception {
        super.registerF7();
        this.f7ContextManager.registerCostCenterF7(this.prmtcostcenterfrom);
        this.f7ContextManager.registerCostCenterF7(this.prmtcostcenterto);
        this.f7ContextManager.registerCompanyFilterOnlyF7(this.prmtexpensefrom, "com.kingdee.eas.basedata.ncm.app.ExpenseF7Query", "CompanyInfo.id");
        this.f7ContextManager.registerCompanyFilterOnlyF7(this.prmtexpenseto, "com.kingdee.eas.basedata.ncm.app.ExpenseF7Query", "CompanyInfo.id");
        this.f7ContextManager.registerCostObjectF7(this.prmtcostobjectfrom, true);
        this.f7ContextManager.registerCostObjectF7(this.prmtcostobjectto, true);
        this.f7ContextManager.registerCostObjectSuiteF7(this.prmtcostobjectgroupfrom);
        this.f7ContextManager.registerCostObjectSuiteF7(this.prmtcostobjectgroupto);
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> statuses = new HashSet<Integer>();
        statuses.add(5);
        statuses.add(8);
        statuses.add(7);
        statuses.add(11);
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", statuses, CompareType.INCLUDE));
        this.f7ContextManager.registerManufactureOrderF7(this.prmtOrderFrom, filter);
        this.f7ContextManager.registerManufactureOrderF7(this.prmtOrderTo, filter);
        this.prmtOrderFrom.setDisplayFormat("$number$");
        this.prmtOrderTo.setDisplayFormat("$number$");
        this.f7ContextManager.registerMaterialTreeF7(this.prmtMaterialFrom, null);
        MaterialF7TreeListSelector selector = new MaterialF7TreeListSelector((Object)this, this.prmtMaterialFrom);
        this.prmtMaterialFrom.setSelector((KDPromptSelector)selector);
        this.f7ContextManager.registerMaterialTreeF7(this.prmtMaterialTo, null);
        selector = new MaterialF7TreeListSelector((Object)this, this.prmtMaterialTo);
        this.prmtMaterialTo.setSelector((KDPromptSelector)selector);
    }

    @Override
    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                this.prmtcostcenterfrom.setValue(null);
                this.prmtcostcenterto.setValue(null);
                this.prmtcostobjectfrom.setValue(null);
                this.prmtcostobjectto.setValue(null);
                this.prmtcostobjectgroupfrom.setValue(null);
                this.prmtcostobjectgroupto.setValue(null);
                this.prmtexpensefrom.setValue(null);
                this.prmtexpenseto.setValue(null);
                this.prmtcostitemfrom.setValue(null);
                this.prmtcostitemto.setValue(null);
                this.cbLabor.setSelected(true);
                this.cbManufacture.setSelected(true);
                this.cbConsign.setSelected(true);
                this.cbEquipment.setSelected(true);
                this.cbOther.setSelected(true);
                this.prmtOrderFrom.setValue(null);
                this.prmtOrderTo.setValue(null);
                this.txtBatchNumberFrom.setText(null);
                this.txtBatchNumberTo.setText(null);
                this.prmtProjectNumberFrom.setValue(null);
                this.prmtProjectNumberTo.setValue(null);
                this.prmtTrackNumberFrom.setValue(null);
                this.prmtTrackNumberTo.setValue(null);
                this.prmtMaterialFrom.setValue(null);
                this.prmtMaterialTo.setValue(null);
                this.initPeriod(this.getCompanyOrgInfoWithDefault());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private void initPeriod(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        this.maxPeriod = NCMUtils.getMaxPeriod((CompanyOrgUnitInfo)company, (PeriodInfo)this.currentPeriod);
        this.startPeriod = NCMUtils.GetStartPeriod(null, (String)company.getId().toString());
        this.currentPeriod = NCMUtils.GetCurrentPeriod(null, (String)company.getId().toString());
        if (this.currentPeriod == null) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        if (this.startPeriod == null) {
            return;
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spyearfrom, (JSpinner)this.spperiodfrom, (PeriodInfo)this.currentPeriod, (JSpinner)this.spyearto, (JSpinner)this.spperiodto, (PeriodInfo)this.currentPeriod);
    }

    @Override
    protected String getReportViewPermissionItem() {
        return "OtherFeeDetailReportView";
    }

    @Override
    protected String getReportPrintPermissionItem() {
        return "OtherFeeDetailReportPrint";
    }

    @Override
    protected KDBizPromptBox[] getProjectNumberF7() {
        return new KDBizPromptBox[]{this.prmtProjectNumberFrom, this.prmtProjectNumberTo};
    }

    @Override
    protected KDBizPromptBox[] getTrackNumberF7() {
        return new KDBizPromptBox[]{this.prmtTrackNumberFrom, this.prmtTrackNumberTo};
    }

    @Override
    protected KDBizPromptBox[] getMaterialF7() {
        return new KDBizPromptBox[]{this.prmtMaterialFrom, this.prmtMaterialTo};
    }

    @Override
    protected KDTextField[] getBatchNumberCtrls() {
        return new KDTextField[]{this.txtBatchNumberFrom, this.txtBatchNumberTo};
    }

    @Override
    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CustomerParams params = this.cp;
        if (params != null) {
            this.loadPeriod(params);
            this.loadExpense(params);
            this.loadCostCenterNum(params);
            this.loadCostObject(params);
            this.loadCostItemNum(params);
            this.loadCostObjectGroup(params);
            this.loadOrder(params);
        }
    }

    private void loadPeriod(CustomerParams params) {
        PeriodInfo initPeriodFrom = this.currentPeriod;
        PeriodInfo initPeriodTo = this.currentPeriod;
        String initYearFrom = params.getCustomerParam("spyearfrom");
        String initMonthFrom = params.getCustomerParam("spperiodfrom");
        String initYearTo = params.getCustomerParam("spyearto");
        String initMonthTo = params.getCustomerParam("spperiodto");
        try {
            if (!StringUtils.isEmpty((String)initYearFrom) && !StringUtils.isEmpty((String)initMonthFrom)) {
                initPeriodFrom = new PeriodInfo();
                initPeriodFrom.setPeriodYear(Integer.parseInt(initYearFrom));
                initPeriodFrom.setPeriodNumber(Integer.parseInt(initMonthFrom));
            }
            if (!StringUtils.isEmpty((String)initYearTo) && !StringUtils.isEmpty((String)initMonthTo)) {
                initPeriodTo = new PeriodInfo();
                initPeriodTo.setPeriodYear(Integer.parseInt(initYearTo));
                initPeriodTo.setPeriodNumber(Integer.parseInt(initMonthTo));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spyearfrom, (JSpinner)this.spperiodfrom, (PeriodInfo)initPeriodFrom, (JSpinner)this.spyearto, (JSpinner)this.spperiodto, (PeriodInfo)initPeriodTo);
    }

    @Override
    protected void setDefaultValue() {
        this.prmtcompanyorg.setValue((Object)this.companyOrg);
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spyearfrom, (JSpinner)this.spperiodfrom, (PeriodInfo)this.currentPeriod, (JSpinner)this.spyearto, (JSpinner)this.spperiodto, (PeriodInfo)this.currentPeriod);
        this.prmtcostcenterfrom.setValue(null);
        this.prmtcostcenterto.setValue(null);
        this.prmtcostobjectfrom.setValue(null);
        this.prmtcostobjectto.setValue(null);
        this.prmtcostobjectgroupfrom.setValue(null);
        this.prmtcostobjectgroupto.setValue(null);
        this.prmtexpensefrom.setValue(null);
        this.prmtexpenseto.setValue(null);
        this.prmtcostitemfrom.setValue(null);
        this.prmtcostitemto.setValue(null);
        this.cbLabor.setSelected(true);
        this.cbManufacture.setSelected(true);
        this.cbConsign.setSelected(true);
        this.cbEquipment.setSelected(true);
        this.cbOther.setSelected(true);
    }

    private void loadCostItemNum(CustomerParams params) {
        String costItemFrom = "";
        String costItemTo = "";
        if (params.getCustomerParam("prmtcostitemfrom") != null) {
            costItemFrom = params.getCustomerParam("prmtcostitemfrom");
        }
        if (params.getCustomerParam("prmtcostitemto") != null) {
            costItemTo = params.getCustomerParam("prmtcostitemto");
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costItemFrom));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costItemTo));
            filter.setMaskString("#0 or #1");
            try {
                FilterInfo costItemFilterInfo = this.getCostItemFilter();
                costItemFilterInfo.mergeFilter(filter, "and");
                view.setFilter(costItemFilterInfo);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            CostItemCollection costItemColl = CostItemFactory.getRemoteInstance().getCostItemCollection(view);
            if (costItemColl != null && costItemColl.size() > 0) {
                if (costItemColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (costItemColl.get(i).getNumber().equals(costItemFrom)) {
                            this.prmtcostitemfrom.setData((Object)costItemColl.get(i));
                            continue;
                        }
                        this.prmtcostitemto.setData((Object)costItemColl.get(i));
                    }
                } else if (costItemColl.size() == 1) {
                    if (costItemColl.get(0).getNumber().equals(costItemFrom)) {
                        this.prmtcostitemfrom.setData((Object)costItemColl.get(0));
                    }
                    if (costItemColl.get(0).getNumber().equals(costItemTo)) {
                        this.prmtcostitemto.setData((Object)costItemColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtcostitemfrom.setData(null);
            this.prmtcostitemto.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadCostObject(CustomerParams params) {
        String costObjectFrom = "";
        String costObjectTo = "";
        if (params.getCustomerParam("prmtcostobjectfrom") != null) {
            costObjectFrom = params.getCustomerParam("prmtcostobjectfrom");
        }
        if (params.getCustomerParam("prmtcostobjectto") != null) {
            costObjectTo = params.getCustomerParam("prmtcostobjectto");
        }
        try {
            String companyId = this.getCompanyOrgInfoWithDefault().getId().toString();
            String oql = " select * where company.id = '" + companyId + "'  and ( number = '" + costObjectFrom + "' or number = '" + costObjectTo + "')";
            CostObjectCollection costObjectColl = CostObjectFactory.getRemoteInstance().getCostObjectCollection(oql);
            if (costObjectColl != null && costObjectColl.size() > 0) {
                if (costObjectColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (costObjectColl.get(i).getNumber().equals(costObjectFrom)) {
                            this.prmtcostobjectfrom.setData((Object)costObjectColl.get(i));
                            continue;
                        }
                        this.prmtcostobjectto.setData((Object)costObjectColl.get(i));
                    }
                } else if (costObjectColl.size() == 1) {
                    if (costObjectColl.get(0).getNumber().equals(costObjectFrom)) {
                        this.prmtcostobjectfrom.setData((Object)costObjectColl.get(0));
                    }
                    if (costObjectColl.get(0).getNumber().equals(costObjectTo)) {
                        this.prmtcostobjectto.setData((Object)costObjectColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtcostobjectfrom.setData(null);
            this.prmtcostobjectto.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadOrder(CustomerParams params) {
        String orderFrom = "";
        String orderTo = "";
        if (params.getCustomerParam("prmtOrderFrom") != null) {
            orderFrom = params.getCustomerParam("prmtOrderFrom");
        }
        if (params.getCustomerParam("prmtOrderTo") != null) {
            orderTo = params.getCustomerParam("prmtOrderTo");
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)orderFrom));
            view.setFilter(filter);
            ManufactureOrderCollection orderColl = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderCollection(view);
            if (orderColl != null && orderColl.size() > 0) {
                this.prmtOrderFrom.setData((Object)orderColl.get(0));
            }
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)orderTo));
            view.setFilter(filter);
            orderColl = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderCollection(view);
            if (orderColl != null && orderColl.size() > 0) {
                this.prmtOrderTo.setData((Object)orderColl.get(0));
            }
        }
        catch (BOSException e) {
            this.prmtOrderFrom.setData(null);
            this.prmtOrderTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadBatch(CustomerParams params) {
        String batchFrom = "";
        String batchTo = "";
        if (params.getCustomerParam("txtBatchNumberFrom") != null) {
            batchFrom = params.getCustomerParam("txtBatchNumberFrom");
        }
        if (params.getCustomerParam("txtBatchNumberTo") != null) {
            batchTo = params.getCustomerParam("txtBatchNumberTo");
        }
        this.txtBatchNumberFrom.setText(batchFrom);
        this.txtBatchNumberTo.setText(batchTo);
    }

    private void loadProject(CustomerParams params) {
        String projectFromStr = "";
        String projectToStr = "";
        if (params.getCustomerParam("prmtProjectNumberFrom") != null) {
            projectFromStr = params.getCustomerParam("prmtProjectNumberFrom");
        }
        if (params.getCustomerParam("prmtProjectNumberTo") != null) {
            projectToStr = params.getCustomerParam("prmtProjectNumberTo");
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)projectFromStr));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)projectToStr));
            view.setFilter(filter);
            view.getFilter().setMaskString("#0 or #1");
            ProjectCollection projectColl = ProjectFactory.getRemoteInstance().getProjectCollection(view);
            if (projectColl != null && projectColl.size() > 0) {
                if (projectColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (projectColl.get(i).getNumber().equals(projectFromStr)) {
                            this.prmtProjectNumberFrom.setData((Object)projectColl.get(i));
                            continue;
                        }
                        this.prmtProjectNumberTo.setData((Object)projectColl.get(i));
                    }
                } else if (projectColl.size() == 1) {
                    if (projectColl.get(0).getNumber().equals(projectFromStr)) {
                        this.prmtProjectNumberFrom.setData((Object)projectColl.get(0));
                    }
                    if (projectColl.get(0).getNumber().equals(projectToStr)) {
                        this.prmtProjectNumberTo.setData((Object)projectColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtProjectNumberFrom.setData(null);
            this.prmtProjectNumberTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadTrack(CustomerParams params) {
        String trackFromStr = "";
        String trackToStr = "";
        if (params.getCustomerParam("prmtTrackNumberFrom") != null) {
            trackFromStr = params.getCustomerParam("prmtTrackNumberFrom");
        }
        if (params.getCustomerParam("prmtTrackNumberTo") != null) {
            trackToStr = params.getCustomerParam("prmtTrackNumberTo");
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)trackFromStr));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)trackToStr));
            view.setFilter(filter);
            view.getFilter().setMaskString("#0 or #1");
            TrackNumberCollection trackColl = TrackNumberFactory.getRemoteInstance().getTrackNumberCollection(view);
            if (trackColl != null && trackColl.size() > 0) {
                if (trackColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (trackColl.get(i).getNumber().equals(trackFromStr)) {
                            this.prmtTrackNumberFrom.setData((Object)trackColl.get(i));
                            continue;
                        }
                        this.prmtTrackNumberTo.setData((Object)trackColl.get(i));
                    }
                } else if (trackColl.size() == 1) {
                    if (trackColl.get(0).getNumber().equals(trackFromStr)) {
                        this.prmtTrackNumberFrom.setData((Object)trackColl.get(0));
                    }
                    if (trackColl.get(0).getNumber().equals(trackToStr)) {
                        this.prmtTrackNumberTo.setData((Object)trackColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtTrackNumberFrom.setData(null);
            this.prmtTrackNumberTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadCostCenterNum(CustomerParams params) {
        String costCenterFrom = "";
        String costCenterTo = "";
        if (params.getCustomerParam("prmtcostcenterfrom") != null) {
            costCenterFrom = params.getCustomerParam("prmtcostcenterfrom");
        }
        if (params.getCustomerParam("prmtcostcenterto") != null) {
            costCenterTo = params.getCustomerParam("prmtcostcenterto");
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterFrom));
            view.setFilter(filter);
            CostCenterOrgUnitCollection costCenterColl = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(view);
            if (costCenterColl != null && costCenterColl.size() > 0) {
                this.prmtcostcenterfrom.setData((Object)costCenterColl.get(0));
            }
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterTo));
            view.setFilter(filter);
            costCenterColl = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(view);
            if (costCenterColl != null && costCenterColl.size() > 0) {
                this.prmtcostcenterto.setData((Object)costCenterColl.get(0));
            }
        }
        catch (BOSException e) {
            this.prmtcostcenterfrom.setData(null);
            this.prmtcostcenterto.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadExpenseType(CustomerParams params) {
        boolean labor = params.getBoolean("cbLabor");
        if (labor) {
            this.cbLabor.setSelected(true);
        } else {
            this.cbLabor.setSelected(false);
        }
        boolean manufacture = params.getBoolean("cbManufacture");
        if (manufacture) {
            this.cbManufacture.setSelected(true);
        } else {
            this.cbManufacture.setSelected(false);
        }
        boolean consign = params.getBoolean("cbConsign");
        if (consign) {
            this.cbConsign.setSelected(true);
        } else {
            this.cbConsign.setSelected(false);
        }
        boolean equipment = params.getBoolean("cbEquipment");
        if (equipment) {
            this.cbEquipment.setSelected(true);
        } else {
            this.cbEquipment.setSelected(false);
        }
        boolean other = params.getBoolean("cbOther");
        if (other) {
            this.cbOther.setSelected(true);
        } else {
            this.cbOther.setSelected(false);
        }
    }

    private void loadExpense(CustomerParams params) {
        String expenseFrom = "";
        String expenseTo = "";
        if (params.getCustomerParam("prmtexpensefrom") != null) {
            expenseFrom = params.getCustomerParam("prmtexpensefrom");
        }
        if (params.getCustomerParam("prmtexpenseto") != null) {
            expenseTo = params.getCustomerParam("prmtexpenseto");
        }
        try {
            ExpenseCollection expenseColl = ExpenseFactory.getRemoteInstance().getExpenseCollection("select * where number = '" + expenseFrom + "' or number = '" + expenseTo + "'");
            if (expenseColl != null && expenseColl.size() > 0) {
                if (expenseColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (expenseColl.get(i).getNumber().equals(expenseFrom)) {
                            this.prmtexpensefrom.setData((Object)expenseColl.get(i));
                            continue;
                        }
                        this.prmtexpenseto.setData((Object)expenseColl.get(i));
                    }
                } else if (expenseColl.size() == 1) {
                    if (expenseColl.get(0).getNumber().equals(expenseFrom)) {
                        this.prmtexpensefrom.setData((Object)expenseColl.get(0));
                    }
                    if (expenseColl.get(0).getNumber().equals(expenseTo)) {
                        this.prmtexpenseto.setData((Object)expenseColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtexpensefrom.setData(null);
            this.prmtexpenseto.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadCostObjectGroup(CustomerParams params) {
        String costobjectgroupfrom = "";
        String costobjectgroupto = "";
        if (params.getCustomerParam("prmtcostobjectgroupfrom") != null) {
            costobjectgroupfrom = params.getCustomerParam("prmtcostobjectgroupfrom");
        }
        if (params.getCustomerParam("prmtcostobjectgroupto") != null) {
            costobjectgroupto = params.getCustomerParam("prmtcostobjectgroupto");
        }
        try {
            CostObjectSuiteCollection costobjectSuiteColl = CostObjectSuiteFactory.getRemoteInstance().getCostObjectSuiteCollection("select * where number = '" + costobjectgroupfrom + "' or number = '" + costobjectgroupto + "'");
            if (costobjectSuiteColl != null && costobjectSuiteColl.size() > 0) {
                if (costobjectSuiteColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (costobjectSuiteColl.get(i).getNumber().equals(costobjectgroupfrom)) {
                            this.prmtcostobjectgroupfrom.setData((Object)costobjectSuiteColl.get(i));
                            continue;
                        }
                        this.prmtcostobjectgroupto.setData((Object)costobjectSuiteColl.get(i));
                    }
                } else if (costobjectSuiteColl.size() == 1) {
                    if (costobjectSuiteColl.get(0).getNumber().equals(costobjectgroupfrom)) {
                        this.prmtcostobjectgroupfrom.setData((Object)costobjectSuiteColl.get(0));
                    }
                    if (costobjectSuiteColl.get(0).getNumber().equals(costobjectgroupto)) {
                        this.prmtcostobjectgroupto.setData((Object)costobjectSuiteColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtcostobjectgroupfrom.setData(null);
            this.prmtcostobjectgroupto.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    @Override
    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    @Override
    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    protected String getAdminCUFieldName() {
        return "adminCU.id";
    }

    static class SpinnerFilterElement
    extends SingleFilterElement {
        private KDSpinner spinner;

        public SpinnerFilterElement(String id, Component component) {
            super(id, component);
            this.spinner = (KDSpinner)component;
        }

        protected void setNumber(Object obj, String value) {
            this.spinner.setValue((Object)Integer.valueOf(value));
        }

        protected String getName(Object obj) {
            return ((Component)obj).getName();
        }

        protected void setData(Component obj, Object value) {
            this.spinner.setValue(value);
        }
    }

    class SingleBizPromptFilterElement
    extends SingleFilterElement {
        KDBizPromptBox prmt;

        public SingleBizPromptFilterElement(String id, KDBizPromptBox component) {
            super(id, (Component)component);
            this.prmt = component;
        }

        public void addRptParams(RptParams cp) {
            Object object = this.prmt.getValue();
            if (object == null) {
                try {
                    this.prmt.commitEdit();
                }
                catch (ParseException e) {
                    OtherFeeAllocDetailReportFilterUI.this.handUIException(e);
                }
                object = this.prmt.getValue();
            }
            if (object instanceof Object[]) {
                object = ((Object[])object)[0];
            }
            cp.setObject(this.getId(), object);
        }
    }
}

