/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.report.CMPeriodFacadeFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReportPeriodEntity
implements Serializable {
    private List queryList = new ArrayList();
    private ReportPeriodEntity usedPeriod = null;
    private ReportPeriodEntity queryPeriod = null;
    private int[] cur;

    private ReportPeriodEntity() {
    }

    public static ReportPeriodEntity requestReportPeriodEntity(CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        return new ReportPeriodEntity(CMPeriodFacadeFactory.getRemoteInstance().getPeriodRange(company));
    }

    public static ReportPeriodEntity requestReportPeriodEntity(CompanyOrgUnitInfo company, Context ctx) throws BOSException, EASBizException {
        return new ReportPeriodEntity(CMPeriodFacadeFactory.getLocalInstance(ctx).getPeriodRange(company));
    }

    public ReportPeriodEntity(Map allMap) {
        this.cur = (int[])allMap.get("currentPeriod");
        this.usedPeriod = this.buildReportPeriodEntity((Map)allMap.get("usedPeriod"));
        this.queryPeriod = this.buildReportPeriodEntity((Map)allMap.get("queryPeriod"));
        this.usedPeriod.usedPeriod = this.usedPeriod;
        this.usedPeriod.queryPeriod = this.queryPeriod;
        this.usedPeriod.cur = this.cur;
        this.queryPeriod.usedPeriod = this.usedPeriod;
        this.queryPeriod.queryPeriod = this.queryPeriod;
        this.queryPeriod.cur = this.cur;
        this.queryList.addAll(this.queryPeriod.queryList);
    }

    private ReportPeriodEntity buildReportPeriodEntity(Map map) {
        ReportPeriodEntity pe = new ReportPeriodEntity();
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            Object key = entry.getKey();
            int[] value = (int[])entry.getValue();
            pe.queryList.add(new Entity((Integer)key, value));
        }
        return pe;
    }

    public ReportPeriodEntity getUsedPeriod() {
        return this.usedPeriod;
    }

    public ReportPeriodEntity getQueryPeriod() {
        return this.queryPeriod;
    }

    public int getCurrentYear() {
        return this.cur[0];
    }

    public int getCurrentPeriod() {
        return this.cur[1];
    }

    public Iterator iterator() {
        return this.queryList.iterator();
    }

    public int getMaxYear() {
        int maxYear = -1;
        for (int i = 0; i < this.queryList.size(); ++i) {
            int year = ((Entity)this.queryList.get((int)i)).year;
            if (maxYear >= year) continue;
            maxYear = year;
        }
        return maxYear;
    }

    public int getMinYear() {
        int minYear = -1;
        for (int i = 0; i < this.queryList.size(); ++i) {
            int year = ((Entity)this.queryList.get((int)i)).year;
            if (minYear <= year && i != 0) continue;
            minYear = year;
        }
        return minYear;
    }

    public int getMaxPeriod(int year) {
        for (int i = 0; i < this.queryList.size(); ++i) {
            Entity e = (Entity)this.queryList.get(i);
            if (year != e.year) continue;
            return e.maxPeriod;
        }
        return -1;
    }

    public int getMinPeriod(int year) {
        int i = 0;
        if (i < this.queryList.size()) {
            Entity e = (Entity)this.queryList.get(i);
            if (year == e.year) {
                return e.minPeriod;
            }
            return 1;
        }
        return -1;
    }

    public int getMinPeriod2(int year) {
        for (int i = 0; i < this.queryList.size(); ++i) {
            Entity e = (Entity)this.queryList.get(i);
            if (year != e.year) continue;
            return e.minPeriod;
        }
        return -1;
    }

    public List getPeriodRangeList(int fromYear, int fromPeriod, int toYear, int toPeriod) {
        ArrayList<int[]> result = new ArrayList<int[]>();
        int minValue = fromYear * 100 + fromPeriod;
        int maxValue = toYear * 100 + toPeriod;
        for (int i = 0; i < this.queryList.size(); ++i) {
            Entity en = (Entity)this.queryList.get(i);
            if (en.year < fromYear || en.year > toYear) continue;
            for (int j = en.minPeriod; j <= en.maxPeriod; ++j) {
                int value = en.year * 100 + j;
                if (value < minValue || value > maxValue) continue;
                result.add(new int[]{en.year, j});
            }
        }
        Collections.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                int[] p1 = (int[])o1;
                int[] p2 = (int[])o2;
                return p1[0] * 100 + p1[1] - (p2[0] * 100 + p2[1]);
            }
        });
        return result;
    }

    static class Entity
    implements Serializable {
        int year;
        int minPeriod;
        int maxPeriod;

        Entity(Integer year, int[] periodRange) {
            this.year = year;
            this.minPeriod = periodRange[0];
            this.maxPeriod = periodRange[1];
        }
    }
}

