/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.ncm.cal.report.client.AbstractSaleOrderCostDetailReportFilterUI;
import com.kingdee.eas.ncm.cal.report.client.CheckBoxFilterElement;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.sd.sale.SaleOrderCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class SaleOrderCostDetailReportFilterUI
extends AbstractSaleOrderCostDetailReportFilterUI {
    private static final long serialVersionUID = 8484725042801030793L;
    private static final Logger logger = CoreUIObject.getLogger(SaleOrderCostDetailReportFilterUI.class);
    protected boolean isNormal = false;
    private Set storageOrgUnitIds = null;
    private Set saleOrgUnitIds = null;
    private CustomerParams cp = null;
    private FilterInfo saleOrderBaseFilter = null;

    public SaleOrderCostDetailReportFilterUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        NCMClientUtils.checkIsStart();
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        FilterInfo saleOrderBaseFilter = this.getSaleOrderBaseFilter();
        this.prmtSaleOrderFrom.setQueryInfo("com.kingdee.eas.scm.sd.sale.app.F7SaleOrderForQuery");
        this.prmtSaleOrderFrom.setEditFormat("$number$");
        this.prmtSaleOrderFrom.setDisplayFormat("$number$");
        this.prmtSaleOrderFrom.setRequired(true);
        this.setFilterInfoF7(this.prmtSaleOrderFrom, saleOrderBaseFilter);
        saleOrderBaseFilter = this.getSaleOrderBaseFilter();
        this.prmtSaleOrderTo.setQueryInfo("com.kingdee.eas.scm.sd.sale.app.F7SaleOrderForQuery");
        this.prmtSaleOrderTo.setEditFormat("$number$");
        this.prmtSaleOrderTo.setDisplayFormat("$number$");
        this.prmtSaleOrderTo.setRequired(true);
        this.setFilterInfoF7(this.prmtSaleOrderTo, saleOrderBaseFilter);
        this.filterF7ForCU(this.prmtProjectNumberFrom);
        this.filterF7ForCU(this.prmtProjectNumberTo);
        this.filterF7ForCU(this.prmtTrackNumberFrom);
        this.filterF7ForCU(this.prmtTrackNumberTo);
        BDCMClientUtils.filterOrderF7((KDBizPromptBox)this.prmtOrderFrom, (String)company.getId().toString());
        BDCMClientUtils.filterOrderF7((KDBizPromptBox)this.prmtOrderTo, (String)company.getId().toString());
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleBizPromptFilterElement filterElement = new SingleBizPromptFilterElement("companyorg", this.prmtCompanyOrg);
        elements.add((FilterElement)filterElement);
        elements.add((FilterElement)new SingleFilterElement("saleOrderFrom", (Component)this.prmtSaleOrderFrom));
        elements.add((FilterElement)new SingleFilterElement("saleOrderTo", (Component)this.prmtSaleOrderTo));
        elements.add((FilterElement)new SingleFilterElement("projectNumberFrom", (Component)this.prmtProjectNumberFrom));
        elements.add((FilterElement)new SingleFilterElement("projectNumberTo", (Component)this.prmtProjectNumberTo));
        elements.add((FilterElement)new SingleFilterElement("trackNumberFrom", (Component)this.prmtTrackNumberFrom));
        elements.add((FilterElement)new SingleFilterElement("trackNumberTo", (Component)this.prmtTrackNumberTo));
        elements.add((FilterElement)new SingleFilterElement("orderFrom", (Component)this.prmtOrderFrom));
        elements.add((FilterElement)new SingleFilterElement("orderTo", (Component)this.prmtOrderTo));
        elements.add((FilterElement)new CheckBoxFilterElement("isShowMatDetail", this.isShowMatDetail));
        elements.add((FilterElement)new CheckBoxFilterElement("isShowExpenseDetail", this.isShowExpenseDetail));
        elements.add((FilterElement)new CheckBoxFilterElement("isShowExcludeSemi", this.isShowExcludeSemi));
        elements.add((FilterElement)new CheckBoxFilterElement("isShowOnlyOrderSum", this.isShowOnlyOrderSum));
        this.getFilterManager().setElement((FilterElement)elements);
        this.prmtSaleOrderFrom.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (SaleOrderCostDetailReportFilterUI.this.prmtSaleOrderFrom.getValue() != null && SaleOrderCostDetailReportFilterUI.this.prmtSaleOrderFrom.getValue() instanceof SaleOrderInfo && SaleOrderCostDetailReportFilterUI.this.prmtSaleOrderTo.getValue() == null) {
                    SaleOrderCostDetailReportFilterUI.this.prmtSaleOrderTo.setValue(SaleOrderCostDetailReportFilterUI.this.prmtSaleOrderFrom.getValue());
                }
            }
        });
        this.prmtSaleOrderTo.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (SaleOrderCostDetailReportFilterUI.this.prmtSaleOrderTo.getValue() != null && SaleOrderCostDetailReportFilterUI.this.prmtSaleOrderTo.getValue() instanceof SaleOrderInfo && SaleOrderCostDetailReportFilterUI.this.prmtSaleOrderFrom.getValue() == null) {
                    SaleOrderCostDetailReportFilterUI.this.prmtSaleOrderFrom.setValue(SaleOrderCostDetailReportFilterUI.this.prmtSaleOrderTo.getValue());
                }
            }
        });
    }

    protected void filterF7ForCU(KDBizPromptBox f7) throws BOSException, EASBizException {
        CtrlUnitInfo cU = SysContext.getSysContext().getCurrentCtrlUnit();
        String cUID = null;
        if (cU != null) {
            cUID = cU.getId().toString();
        }
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cUID, CompareType.EQUALS));
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    @Override
    protected FilterElement getFilterElement() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleBizPromptFilterElement filterElement = new SingleBizPromptFilterElement("companyorg", this.prmtCompanyOrg);
        elements.add((FilterElement)filterElement);
        elements.add((FilterElement)new SingleFilterElement("saleOrderFrom", (Component)this.prmtSaleOrderFrom));
        elements.add((FilterElement)new SingleFilterElement("saleOrderTo", (Component)this.prmtSaleOrderTo));
        elements.add((FilterElement)new CheckBoxFilterElement("isShowMatDetail", this.isShowMatDetail));
        elements.add((FilterElement)new CheckBoxFilterElement("isShowExpenseDetail", this.isShowExpenseDetail));
        elements.add((FilterElement)new CheckBoxFilterElement("isShowExcludeSemi", this.isShowExcludeSemi));
        elements.add((FilterElement)new CheckBoxFilterElement("isShowOnlyOrderSum", this.isShowOnlyOrderSum));
        elements.add((FilterElement)new SingleFilterElement("projectNumberFrom", (Component)this.prmtProjectNumberFrom));
        elements.add((FilterElement)new SingleFilterElement("projectNumberTo", (Component)this.prmtProjectNumberTo));
        elements.add((FilterElement)new SingleFilterElement("trackNumberFrom", (Component)this.prmtTrackNumberFrom));
        elements.add((FilterElement)new SingleFilterElement("trackNumberTo", (Component)this.prmtTrackNumberTo));
        elements.add((FilterElement)new SingleFilterElement("orderFrom", (Component)this.prmtOrderFrom));
        elements.add((FilterElement)new SingleFilterElement("orderTo", (Component)this.prmtOrderTo));
        return elements;
    }

    private Set getSaleOrgUnitIds() throws EASBizException, BOSException {
        Object o = this.prmtCompanyOrg.getValue();
        if (o != null && o instanceof CompanyOrgUnitInfo) {
            if (this.saleOrgUnitIds == null) {
                this.saleOrgUnitIds = BDCMUtils.getSaleOrgUnitIdsOfCompany(null, (String)((CompanyOrgUnitInfo)o).getId().toString());
            }
            return this.saleOrgUnitIds;
        }
        HashSet<String> saleOrgUnitIds = new HashSet<String>();
        saleOrgUnitIds.add("--");
        return saleOrgUnitIds;
    }

    @Override
    protected void setDefaultValue() {
        this.prmtCompanyOrg.setValue((Object)SysContext.getSysContext().getCurrentFIUnit());
        this.prmtSaleOrderFrom.setValue(null);
        this.prmtSaleOrderTo.setValue(null);
        this.prmtProjectNumberFrom.setValue(null);
        this.prmtProjectNumberTo.setValue(null);
        this.prmtTrackNumberFrom.setValue(null);
        this.prmtTrackNumberTo.setValue(null);
        this.prmtOrderFrom.setValue(null);
        this.prmtOrderTo.setValue(null);
        this.isShowMatDetail.setSelected(false);
        this.isShowExpenseDetail.setSelected(false);
        this.isShowExcludeSemi.setSelected(false);
        this.isShowOnlyOrderSum.setSelected(false);
    }

    private void setFilterInfoF7(KDBizPromptBox f7, FilterInfo filter) {
        EntityViewInfo view = f7.getEntityViewInfo() != null ? f7.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    protected FilterInfo getSaleOrderBaseFilter() throws Exception {
        if (this.saleOrderBaseFilter == null) {
            this.saleOrderBaseFilter = new FilterInfo();
            Set saleOrgUnitIds = this.getSaleOrgUnitIds();
            this.saleOrderBaseFilter.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", (Object)saleOrgUnitIds, CompareType.INCLUDE));
            HashSet<Integer> set = new HashSet<Integer>();
            set.add(0);
            set.add(2);
            set.add(1);
            this.saleOrderBaseFilter.getFilterItems().add(new FilterItemInfo("baseStatus", set, CompareType.NOTINCLUDE));
        }
        return (FilterInfo)this.saleOrderBaseFilter.clone();
    }

    @Override
    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
    }

    @Override
    public void clear() {
        this.getFilterManager().clearAll();
        this.setDefaultValue();
    }

    @Override
    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrg;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public KDBizPromptBox getCompanyF7() {
        return this.prmtCompanyOrg;
    }

    @Override
    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    @Override
    protected void registerF7() throws Exception {
        super.registerF7();
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> statuses = new HashSet<Integer>();
        statuses.add(0);
        statuses.add(2);
        statuses.add(1);
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", statuses, CompareType.NOTINCLUDE));
        this.f7ContextManager.registerSaleOrderF7(this.prmtSaleOrderFrom, filter);
        this.f7ContextManager.registerSaleOrderF7(this.prmtSaleOrderTo, filter);
        this.prmtSaleOrderFrom.setDisplayFormat("$number$");
        this.prmtSaleOrderTo.setDisplayFormat("$number$");
    }

    @Override
    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        this.storageOrgUnitIds = null;
        this.saleOrgUnitIds = null;
        this.saleOrderBaseFilter = null;
        if (chgVo.isDiffrent()) {
            try {
                this.prmtSaleOrderFrom.setValue(null);
                this.prmtSaleOrderTo.setValue(null);
                this.prmtProjectNumberFrom.setValue(null);
                this.prmtProjectNumberTo.setValue(null);
                this.prmtTrackNumberFrom.setValue(null);
                this.prmtTrackNumberTo.setValue(null);
                this.prmtOrderFrom.setValue(null);
                this.prmtOrderTo.setValue(null);
                this.isShowMatDetail.setSelected(false);
                this.isShowExpenseDetail.setSelected(false);
                this.isShowExcludeSemi.setSelected(false);
                this.isShowOnlyOrderSum.setSelected(false);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    @Override
    protected String getReportViewPermissionItem() {
        return "SaleOrderCostDetailReport_View";
    }

    @Override
    protected String getReportPrintPermissionItem() {
        return "SaleOrderCostDetailReport_Print";
    }

    @Override
    public boolean verify() {
        if (this.prmtSaleOrderFrom.getValue() == null || this.prmtSaleOrderTo.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.SaleOrderCostDetailReportResource", (String)"saleOrderNumber_CanNotEmpty"));
            return false;
        }
        return super.verify();
    }

    @Override
    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CustomerParams params = this.cp;
        if (params != null) {
            this.loadOrder(params);
            this.loadProOrder(params);
            String showMatDetail = "";
            showMatDetail = params.getCustomerParam("isShowMatDetail");
            this.isShowMatDetail.setSelected(Boolean.valueOf(showMatDetail).booleanValue());
            String showExcludeSemi = "";
            showExcludeSemi = params.getCustomerParam("isShowExcludeSemi");
            this.isShowExcludeSemi.setSelected(Boolean.valueOf(showExcludeSemi).booleanValue());
            String showOnlyOrderSum = "";
            showOnlyOrderSum = params.getCustomerParam("isShowOnlyOrderSum");
            this.isShowOnlyOrderSum.setSelected(Boolean.valueOf(showOnlyOrderSum).booleanValue());
            String showExpenseDetail = "";
            showExpenseDetail = params.getCustomerParam("isShowExpenseDetail");
            this.isShowExpenseDetail.setSelected(Boolean.valueOf(showExpenseDetail).booleanValue());
        }
    }

    @Override
    protected KDBizPromptBox[] getProjectNumberF7() {
        return new KDBizPromptBox[]{this.prmtProjectNumberFrom, this.prmtProjectNumberTo};
    }

    @Override
    protected KDBizPromptBox[] getTrackNumberF7() {
        return new KDBizPromptBox[]{this.prmtTrackNumberFrom, this.prmtTrackNumberTo};
    }

    private void loadOrder(CustomerParams params) {
        String orderFrom = "";
        String orderTo = "";
        if (params.getCustomerParam("prmtSaleOrderFrom") != null) {
            orderFrom = params.getCustomerParam("prmtSaleOrderFrom");
        }
        if (params.getCustomerParam("prmtSaleOrderTo") != null) {
            orderTo = params.getCustomerParam("prmtSaleOrderTo");
        }
        this.prmtSaleOrderFrom.setData(null);
        this.prmtSaleOrderTo.setData(null);
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)orderFrom));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)orderTo));
            filter.setMaskString("(#0 or #1)");
            try {
                FilterInfo orderBaseFilter = this.getSaleOrderBaseFilter();
                filter.mergeFilter(orderBaseFilter, "and");
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("name");
            view.setSelector(selector);
            SaleOrderCollection coll = SaleOrderFactory.getRemoteInstance().getSaleOrderCollection(view);
            if (coll != null && coll.size() > 0) {
                if (coll.size() == 1) {
                    if (coll.get(0).getNumber().equals(orderFrom)) {
                        this.prmtSaleOrderFrom.setData((Object)coll.get(0));
                    }
                    if (coll.get(0).getNumber().equals(orderTo)) {
                        this.prmtSaleOrderTo.setData((Object)coll.get(0));
                    }
                } else {
                    for (int i = 0; i < coll.size(); ++i) {
                        if (coll.get(i).getNumber().equals(orderFrom)) {
                            this.prmtSaleOrderFrom.setData((Object)coll.get(i));
                            continue;
                        }
                        if (!coll.get(i).getNumber().equals(orderTo)) continue;
                        this.prmtSaleOrderTo.setData((Object)coll.get(i));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadProOrder(CustomerParams params) {
        String orderFrom = "";
        String orderTo = "";
        if (params.getCustomerParam("prmtOrderFrom") != null) {
            orderFrom = params.getCustomerParam("prmtOrderFrom");
        }
        if (params.getCustomerParam("prmtOrderTo") != null) {
            orderTo = params.getCustomerParam("prmtOrderTo");
        }
        this.prmtOrderFrom.setData(null);
        this.prmtOrderTo.setData(null);
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)orderFrom));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)orderTo));
            view.setFilter(filter);
            view.getFilter().setMaskString("#0 or #1");
            ManufactureOrderCollection coll = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderCollection(view);
            if (coll != null && coll.size() > 0) {
                if (coll.size() == 1) {
                    if (coll.get(0).getNumber().equals(orderFrom)) {
                        this.prmtOrderFrom.setData((Object)coll.get(0));
                    }
                    if (coll.get(0).getNumber().equals(orderTo)) {
                        this.prmtOrderTo.setData((Object)coll.get(0));
                    }
                } else {
                    if (orderFrom.equals(orderTo)) {
                        this.prmtOrderFrom.setData((Object)coll.get(0));
                        this.prmtOrderTo.setData((Object)coll.get(0));
                        return;
                    }
                    for (int i = 0; i < coll.size(); ++i) {
                        if (coll.get(i).getNumber().equals(orderFrom)) {
                            this.prmtOrderFrom.setData((Object)coll.get(i));
                            continue;
                        }
                        if (!coll.get(i).getNumber().equals(orderTo)) continue;
                        this.prmtOrderTo.setData((Object)coll.get(i));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    class SingleBizPromptFilterElement
    extends SingleFilterElement {
        KDBizPromptBox prmt;

        public SingleBizPromptFilterElement(String id, KDBizPromptBox component) {
            super(id, (Component)component);
            this.prmt = component;
        }

        public void addRptParams(RptParams cp) {
            Object object = this.prmt.getValue();
            if (object == null) {
                object = this.prmt.getText();
                SaleOrderCostDetailReportFilterUI.this.loadCompany(object.toString());
                object = this.prmt.getValue();
            }
            if (object instanceof Object[]) {
                object = ((Object[])object)[0];
            }
            cp.setObject(this.getId(), object);
        }
    }
}

