/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.ncm.client.MaterialF7TreeListSelector;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.ncm.cal.rpt.client.AbstractMaterialCostStatRptFilterUI;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.SpinnerUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import java.util.HashSet;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class MaterialCostStatRptFilterUI
extends AbstractMaterialCostStatRptFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialCostStatRptFilterUI.class);
    private PeriodInfo currentPeriod;
    private PeriodInfo startPeriod;
    private PeriodInfo maxPeriod = null;
    private CustomerParams cp = null;

    public MaterialCostStatRptFilterUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        NCMClientUtils.checkIsStart();
    }

    public void onLoad() throws Exception {
        this.formatUI();
        super.onLoad();
    }

    private void formatUI() throws Exception {
        CompanyOrgUnitInfo companyOrg = this.getCompanyOrgInfoWithDefault();
        this.initPeriod(companyOrg);
        this.prmtCostObjectFrom.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.prmtCostObjectFrom, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, companyOrg.getId().toString());
        this.prmtCostObjectFrom.setSelector((KDPromptSelector)arg0);
        this.prmtCostObjectTo.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg1 = new CostObjectF7UISelector((Object)this, this.prmtCostObjectTo, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, companyOrg.getId().toString());
        this.prmtCostObjectTo.setSelector((KDPromptSelector)arg1);
        this.filterProject(this.prmtProjectFrom);
        this.filterProject(this.prmtProjectTo);
        this.filterTrack(this.prmtTrackFrom);
        this.filterTrack(this.prmtTrackTo);
        FilterInfo costItemFilterInfo = this.getCostItemFilter();
        this.setFilterInfoF7(this.prmtCostItemFrom, costItemFilterInfo);
        this.setFilterInfoF7(this.prmtCostItemTo, costItemFilterInfo);
        MaterialCostStatRptFilterUI.setF7CostItem(this.prmtCostItemFrom, new Integer("1"));
        MaterialCostStatRptFilterUI.setF7CostItem(this.prmtCostItemTo, new Integer("1"));
    }

    private void initPeriod(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        this.maxPeriod = NCMUtils.getMaxPeriod((CompanyOrgUnitInfo)company, (PeriodInfo)this.currentPeriod);
        this.startPeriod = NCMUtils.GetStartPeriod(null, (String)company.getId().toString());
        this.currentPeriod = NCMUtils.GetCurrentPeriod(null, (String)company.getId().toString());
        if (this.currentPeriod == null) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        if (this.startPeriod == null) {
            return;
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)this.currentPeriod);
    }

    protected void filterProject(KDBizPromptBox prmt) throws Exception {
        FilterInfo filter = ProjectFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), "id", "CU.id");
        EntityViewInfo view = null;
        view = prmt.getEntityViewInfo() != null ? prmt.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        prmt.setEntityViewInfo(view);
    }

    protected void filterTrack(KDBizPromptBox prmt) throws Exception {
        FilterInfo filter = TrackNumberFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), "id", "CU.id");
        EntityViewInfo view = null;
        view = prmt.getEntityViewInfo() != null ? prmt.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        prmt.setEntityViewInfo(view);
    }

    protected void setDefaultValue() {
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtCompanyOrg.setValue(null);
        this.prmtCompanyOrg.setValue((Object)companyOrg);
        this.prmtCostCenterFrom.setValue(null);
        this.prmtCostCenterTo.setValue(null);
        this.prmtCostObjectFrom.setValue(null);
        this.prmtCostObjectTo.setValue(null);
        this.prmtCostItemTo.setValue(null);
        this.prmtCostItemTo.setValue(null);
        this.prmtMaterialFrom.setValue(null);
        this.prmtMaterialTo.setValue(null);
        this.cbShowQty.setSelected(false);
        this.cbShowAssistQty.setSelected(false);
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)this.currentPeriod);
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CustomerParams params = this.cp;
        if (params != null) {
            this.loadOrder(params);
        }
    }

    private void loadOrder(CustomerParams params) {
        String orderNumberFromStr = "";
        String orderNumberToStr = "";
        if (params.getCustomerParam("prmtOrderNumberFrom") != null) {
            orderNumberFromStr = params.getCustomerParam("prmtOrderNumberFrom");
        }
        if (params.getCustomerParam("prmtOrderNumberTo") != null) {
            orderNumberToStr = params.getCustomerParam("prmtOrderNumberTo");
        }
        try {
            String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)orderNumberFromStr));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)orderNumberToStr));
            filter.setMaskString("#0 or #1");
            view.setFilter(filter);
            ManufactureOrderCollection orderNumberColl = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderCollection(view);
            if (orderNumberColl != null && orderNumberColl.size() > 0) {
                if (orderNumberColl.size() >= 2) {
                    for (int i = 0; i < orderNumberColl.size(); ++i) {
                        if (orderNumberColl.get(i).getNumber().equals(orderNumberFromStr)) {
                            this.prmtOrderNumberFrom.setData((Object)orderNumberColl.get(i));
                            continue;
                        }
                        this.prmtOrderNumberTo.setData((Object)orderNumberColl.get(i));
                    }
                } else if (orderNumberColl.size() < 2) {
                    if (orderNumberColl.get(0).getNumber().equals(orderNumberFromStr)) {
                        this.prmtOrderNumberFrom.setData((Object)orderNumberColl.get(0));
                    }
                    if (orderNumberColl.get(0).getNumber().equals(orderNumberToStr)) {
                        this.prmtOrderNumberTo.setData((Object)orderNumberColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtOrderNumberFrom.setData(null);
            this.prmtOrderNumberTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadPeriod(CustomerParams params) {
        PeriodInfo initPeriodFrom = this.currentPeriod;
        PeriodInfo initPeriodTo = this.currentPeriod;
        String initYearFrom = params.getCustomerParam("spYearFrom");
        String initMonthFrom = params.getCustomerParam("spPeriodFrom");
        String initYearTo = params.getCustomerParam("spYearTo");
        String initMonthTo = params.getCustomerParam("spPeriodTo");
        try {
            if (!StringUtils.isEmpty((String)initYearFrom) && !StringUtils.isEmpty((String)initMonthFrom)) {
                initPeriodFrom = new PeriodInfo();
                initPeriodFrom.setPeriodYear(Integer.parseInt(initYearFrom));
                initPeriodFrom.setPeriodNumber(Integer.parseInt(initMonthFrom));
            }
            if (!StringUtils.isEmpty((String)initYearTo) && !StringUtils.isEmpty((String)initMonthTo)) {
                initPeriodTo = new PeriodInfo();
                initPeriodTo.setPeriodYear(Integer.parseInt(initYearTo));
                initPeriodTo.setPeriodNumber(Integer.parseInt(initMonthTo));
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)initPeriodFrom, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)initPeriodTo);
    }

    private void loadShowItem(CustomerParams params) {
        boolean showQty = true;
        boolean showAssistQty = true;
        String temp = null;
        if (params.getCustomerParam("cbShowQty") != null && (temp = params.getCustomerParam("cbShowQty")) != null && temp.equalsIgnoreCase("false")) {
            showQty = false;
        }
        if (params.getCustomerParam("cbShowAssistQty") != null && (temp = params.getCustomerParam("cbShowAssistQty")) != null && temp.equalsIgnoreCase("false")) {
            showAssistQty = false;
        }
        this.cbShowQty.setSelected(showQty);
        this.cbShowAssistQty.setSelected(showAssistQty);
    }

    private void setSpinnerRange(int nDefault, int nMin, int nMax, int nStep, KDSpinner sp) {
        Integer value = nDefault;
        Integer min = nMin;
        Integer max = nMax;
        Integer step = nStep;
        SpinnerNumberModel model = new SpinnerNumberModel(value, min, max, step);
        sp.setModel((SpinnerModel)model);
    }

    private void setFilterInfoF7(KDBizPromptBox f7, FilterInfo filter) {
        EntityViewInfo view = f7.getEntityViewInfo() != null ? f7.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getAdminCUFieldName() {
        return "adminCU.id";
    }

    protected FilterInfo getCostItemFilter() throws Exception {
        return CostItemFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
    }

    public static void setF7CostItem(KDBizPromptBox bizBox, Integer itemType) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.appendFilterItem("ItemType", (Object)itemType);
        filterInfo.setMaskString("#0");
        viewInfo.setFilter(filterInfo);
        bizBox.setHasCUDefaultFilter(false);
        bizBox.setEntityViewInfo(viewInfo);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrg;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public KDBizPromptBox getCompanyF7() {
        return this.prmtCompanyOrg;
    }

    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    protected void registerF7() throws Exception {
        super.registerF7();
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenterFrom);
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenterTo);
        this.f7ContextManager.registerCostObjectF7(this.prmtCostObjectFrom, false);
        this.f7ContextManager.registerCostObjectF7(this.prmtCostObjectTo, false);
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> statuses = new HashSet<Integer>();
        statuses.add(5);
        statuses.add(8);
        statuses.add(7);
        statuses.add(11);
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", statuses, CompareType.INCLUDE));
        this.f7ContextManager.registerManufactureOrderF7(this.prmtOrderNumberFrom, filter);
        this.f7ContextManager.registerManufactureOrderF7(this.prmtOrderNumberTo, filter);
        this.f7ContextManager.registerMaterialTreeF7(this.prmtProductFrom, null);
        MaterialF7TreeListSelector selector_Prod = new MaterialF7TreeListSelector((Object)this, this.prmtProductFrom);
        this.prmtProductFrom.setSelector((KDPromptSelector)selector_Prod);
        this.f7ContextManager.registerMaterialTreeF7(this.prmtProductTo, null);
        selector_Prod = new MaterialF7TreeListSelector((Object)this, this.prmtProductTo);
        this.prmtProductTo.setSelector((KDPromptSelector)selector_Prod);
        this.f7ContextManager.registerMaterialTreeF7(this.prmtMaterialFrom, null);
        MaterialF7TreeListSelector selector = new MaterialF7TreeListSelector((Object)this, this.prmtMaterialFrom);
        this.prmtMaterialFrom.setSelector((KDPromptSelector)selector);
        this.f7ContextManager.registerMaterialTreeF7(this.prmtMaterialTo, null);
        selector = new MaterialF7TreeListSelector((Object)this, this.prmtMaterialTo);
        this.prmtMaterialTo.setSelector((KDPromptSelector)selector);
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                this.prmtCostCenterFrom.setData(null);
                this.prmtCostCenterTo.setData(null);
                this.prmtCostObjectFrom.setData(null);
                this.prmtCostObjectTo.setData(null);
                this.prmtOrderNumberFrom.setData(null);
                this.prmtOrderNumberTo.setData(null);
                this.prmtMaterialFrom.setData(null);
                this.prmtMaterialTo.setData(null);
                this.prmtOrderNumberFrom.setDisplayFormat("$number$");
                this.prmtOrderNumberTo.setDisplayFormat("$number$");
                this.initPeriod(this.getCompanyOrgInfoWithDefault());
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    protected String getReportViewPermissionItem() {
        return "MaterialCostStatReportView";
    }

    protected String getReportPrintPermissionItem() {
        return "MaterialCostStatReportPrint";
    }

    protected KDSpinner[] getPeriodSpinner() {
        return new KDSpinner[]{this.spYearFrom, this.spYearTo, this.spPeriodFrom, this.spPeriodTo};
    }

    protected KDSpinner getDisplayCountSpinner() {
        return null;
    }

    protected KDBizPromptBox[] getCostCenterF7() {
        return new KDBizPromptBox[]{this.prmtCostCenterFrom, this.prmtCostCenterTo};
    }

    protected KDBizPromptBox[] getCostObjectF7() {
        return new KDBizPromptBox[]{this.prmtCostObjectFrom, this.prmtCostObjectTo};
    }

    protected KDBizPromptBox[] getMaterialF7() {
        return new KDBizPromptBox[]{this.prmtMaterialFrom, this.prmtMaterialTo};
    }

    protected KDBizPromptBox[] getCostItemF7() {
        return new KDBizPromptBox[]{this.prmtCostItemFrom, this.prmtCostItemTo};
    }

    protected KDBizPromptBox[] getOrderNumberF7() {
        return new KDBizPromptBox[]{this.prmtOrderNumberFrom, this.prmtOrderNumberTo};
    }

    protected KDTextField[] getBatchNumberCtrls() {
        return new KDTextField[]{this.txtBatchFrom, this.txtBathTo};
    }

    protected KDBizPromptBox[] getProjectNumberF7() {
        return new KDBizPromptBox[]{this.prmtProjectFrom, this.prmtProjectTo};
    }

    protected KDBizPromptBox[] getTrackNumberF7() {
        return new KDBizPromptBox[]{this.prmtTrackFrom, this.prmtTrackTo};
    }

    public RptParams getParams() {
        RptParams params = new RptParams();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.getCompanyF7().getValue();
        String companyId = company.getId().toString();
        params.setString("companyId", companyId);
        params.setString("spYearFrom", "2012");
        params.setString("spPeriodFrom", "4");
        params.setString("spYearTo", "2012");
        params.setString("spPeriodTo", "4");
        params.setString("prmtOrderNumberFrom", this.getF7ObjectNumber(this.prmtOrderNumberFrom));
        params.setString("prmtOrderNumberTo", this.getF7ObjectNumber(this.prmtOrderNumberTo));
        params.setString("prmtCostCenterFrom", this.getF7ObjectNumber(this.prmtCostCenterFrom));
        params.setString("prmtCostCenterTo", this.getF7ObjectNumber(this.prmtCostCenterTo));
        params.setString("prmtCostObjectFrom", this.getF7ObjectNumber(this.prmtCostObjectFrom));
        params.setString("prmtCostObjectTo", this.getF7ObjectNumber(this.prmtCostObjectTo));
        params.setString("prmtCostItemFrom", this.getF7ObjectNumber(this.prmtCostItemFrom));
        params.setString("prmtCostItemTo", this.getF7ObjectNumber(this.prmtCostItemTo));
        params.setString("txtBatchFrom", this.txtBatchFrom.getText());
        params.setString("txtBatchTo", this.txtBathTo.getText());
        params.setString("prmtProjectFrom", this.getF7ObjectNumber(this.prmtProjectFrom));
        params.setString("prmtProjectTo", this.getF7ObjectNumber(this.prmtProjectTo));
        params.setString("prmtTrackFrom", this.getF7ObjectNumber(this.prmtTrackFrom));
        params.setString("prmtTrackTo", this.getF7ObjectNumber(this.prmtTrackTo));
        params.setString("prmtMaterialFrom", this.getF7ObjectNumber(this.prmtMaterialFrom));
        params.setString("prmtMaterialTo", this.getF7ObjectNumber(this.prmtMaterialTo));
        return params;
    }
}

