/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.client.context.OrgContextManager;
import com.kingdee.eas.framework.client.context.f7.IF7ContextChange;
import com.kingdee.eas.framework.client.context.f7.IF7Register;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.INCMCustomerParamsFacade;
import com.kingdee.eas.ncm.common.NCMCommonFacadeFactory;
import com.kingdee.eas.ncm.common.NCMCustomerParamsFacadeFactory;
import com.kingdee.eas.ncm.common.NCMIFilterParam;
import com.kingdee.eas.ncm.common.NCMIFilterParamSupportMultiOrg;
import com.kingdee.eas.ncm.common.client.AbstractCMBillBaseFilterUI;
import com.kingdee.eas.ncm.common.client.NCMF7ContextManager;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class CMBillBaseFilterUI
extends AbstractCMBillBaseFilterUI
implements IMultiOrgSupport {
    private static final long serialVersionUID = -4893565398430217876L;
    private static final Logger logger = CoreUIObject.getLogger(CMBillBaseFilterUI.class);
    protected boolean isNormal = true;
    protected Object ui = null;
    protected OrgContextManager orgContextManager = null;
    protected NCMF7ContextManager f7ContextManager;
    private String permissionItem = null;
    private IMetaDataPK metaDataPKForPemmission = null;
    private IMetaDataPK metaDataPKForPemmissionByUI = null;
    private static Map permissionItemMap = new HashMap();
    private String CompanyPick = "CompanyPick";
    private boolean mainOrgChangeCanceling = false;

    public CMBillBaseFilterUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
    }

    public CMBillBaseFilterUI(Object ui) throws Exception {
        this.ui = ui;
    }

    public void onLoad() throws Exception {
        this.isStart();
        super.onLoad();
        this.initOrgContextManager();
    }

    protected void initOrgContextManager() throws EASBizException, BOSException {
        this.orgContextManager = new OrgContextManager((IMultiOrgSupport)this, ContextTypeEnum.INQUERYING, null);
        this.orgContextManager.init(this.getUIContext());
        if (this.getCompanyF7() != null) {
            this.getCompanyF7().setSelector(null);
            if (this.isEnableMultiOrgSupport()) {
                this.getCompanyF7().setEnabled(true);
                this.getCompanyF7().setRequired(true);
                if (this.getCompanyF7().getQueryInfo() == null || this.getCompanyF7().getQueryInfo().trim().length() == 0) {
                    this.getCompanyF7().setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
                }
                this.getF7Register();
                try {
                    this.registerF7();
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
        }
    }

    protected void isStart() throws Exception {
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        if (!sysctrol.isStart(1001, SysContext.getSysContext().getCurrentFIUnit().getId().toString()) && this.isNormal) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
    }

    public String getUITitle() {
        return "";
    }

    public CustomerParams getCustomerParams() {
        CustomerParams customerParams = super.getCustomerParams();
        if (customerParams == null) {
            customerParams = new CustomerParams();
        }
        NCMIFilterParam filterParam = this.createNewFilterParam();
        this.storeFilterParam(filterParam);
        if (this.isEnableMultiOrgSupport()) {
            this.storeFilterParamSupportMultiOrg(filterParam);
        }
        this.storeBaseCustomerParams(customerParams, filterParam);
        if (this.isEnableMultiOrgSupport()) {
            this.storeBaseCustomerParamsSupportMultiOrg(customerParams, filterParam);
        }
        return customerParams;
    }

    public void setCustomerParams(CustomerParams customerParams) {
        super.setCustomerParams(customerParams);
        NCMIFilterParam filterParam = this.createNewFilterParam();
        if (this.isEnableMultiOrgSupport()) {
            this.loadBaseCustomerParamsSupportMultiOrg(customerParams, filterParam);
        }
        this.loadBaseCustomerParams(customerParams, filterParam);
        filterParam = this.loadOtherCustomerParams(filterParam);
        if (this.isEnableMultiOrgSupport() && ((NCMIFilterParamSupportMultiOrg)filterParam).getCompanyInfo() != null) {
            this.loadFilterParamSupportMultiOrg(filterParam);
        }
        this.loadFilterParam(filterParam);
    }

    protected abstract NCMIFilterParam createNewFilterParam();

    protected abstract void storeBaseCustomerParams(CustomerParams var1, NCMIFilterParam var2);

    protected void storeBaseCustomerParamsSupportMultiOrg(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (!(filterParam instanceof NCMIFilterParamSupportMultiOrg)) {
            return;
        }
        if (this.getMainOrgType() != OrgType.Company || !this.isEnableMultiOrgSupport()) {
            return;
        }
        NCMIFilterParamSupportMultiOrg param = (NCMIFilterParamSupportMultiOrg)filterParam;
        this.putIdByKey(customerParams, param.getCompanyInfo(), this.CompanyPick);
    }

    protected abstract void storeFilterParam(NCMIFilterParam var1);

    protected void storeFilterParamSupportMultiOrg(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof NCMIFilterParamSupportMultiOrg)) {
            return;
        }
        if (this.getMainOrgType() != OrgType.Company || !this.isEnableMultiOrgSupport()) {
            return;
        }
        NCMIFilterParamSupportMultiOrg param = (NCMIFilterParamSupportMultiOrg)filterParam;
        Object temp = null;
        temp = this.getCompanyF7().getData();
        if (temp != null && temp instanceof CompanyOrgUnitInfo) {
            param.setCompanyInfo((CompanyOrgUnitInfo)temp);
        }
    }

    protected abstract void loadBaseCustomerParams(CustomerParams var1, NCMIFilterParam var2);

    protected void loadBaseCustomerParamsSupportMultiOrg(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (!(filterParam instanceof NCMIFilterParamSupportMultiOrg)) {
            return;
        }
        if (this.getMainOrgType() != OrgType.Company || !this.isEnableMultiOrgSupport()) {
            return;
        }
        NCMIFilterParamSupportMultiOrg param = (NCMIFilterParamSupportMultiOrg)filterParam;
        CompanyOrgUnitInfo companyOrg = null;
        String companyPick = customerParams.getCustomerParam(this.CompanyPick);
        if (companyPick != null && companyPick.length() > 0) {
            companyOrg = new CompanyOrgUnitInfo();
            companyOrg.setId(BOSUuid.read((String)companyPick));
        }
        param.setCompanyInfo(companyOrg);
    }

    protected NCMIFilterParam loadOtherCustomerParams(NCMIFilterParam filterParam) {
        try {
            filterParam = this.getNCMCustomerParamsFacade().loadCustomerParams(filterParam);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        return filterParam;
    }

    protected abstract void loadFilterParam(NCMIFilterParam var1);

    protected void loadFilterParamSupportMultiOrg(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof NCMIFilterParamSupportMultiOrg)) {
            return;
        }
        if (this.getMainOrgType() != OrgType.Company || !this.isEnableMultiOrgSupport()) {
            return;
        }
        NCMIFilterParamSupportMultiOrg param = (NCMIFilterParamSupportMultiOrg)filterParam;
        try {
            if (!SCMGroupClientUtils.isAuthoriedForOrg((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)OrgType.Company, (IObjectPK)new ObjectStringPK(param.getCompanyInfo().getId().toString()), (String)this.getPermissionItem())) {
                MsgBox.showInfo((String)"\u6ca1\u6709\u8be5\u65b9\u6848\u6240\u9009\u8d22\u52a1\u7ec4\u7ec7\u7684\u6743\u9650");
                SysUtil.abort();
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        this.getCompanyF7().setData((Object)param.getCompanyInfo());
    }

    public FilterInfo getFilterInfo() {
        NCMIFilterParam filterParam = this.createNewFilterParam();
        this.loadBaseCustomerParams(this.getCustomerParams(), filterParam);
        if (this.isEnableMultiOrgSupport()) {
            this.loadBaseCustomerParamsSupportMultiOrg(this.getCustomerParams(), filterParam);
        }
        filterParam = this.loadOtherCustomerParams(filterParam);
        return filterParam.getFilter();
    }

    protected INCMCustomerParamsFacade getNCMCustomerParamsFacade() throws Exception {
        return NCMCustomerParamsFacadeFactory.getRemoteInstance();
    }

    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            this.removeNotify();
        }
        return re;
    }

    protected void putIdByKey(CustomerParams customerParams, Object value, String key) {
        if (value == null) {
            customerParams.removeCustomerParam(key);
            return;
        }
        if (value instanceof String) {
            customerParams.addCustomerParam(key, value.toString());
        } else if (value instanceof String[]) {
            String[] _value = (String[])value;
            ArrayList<String> tempList = new ArrayList<String>();
            int in = _value.length;
            for (int i = 0; i < in; ++i) {
                tempList.add(_value[i]);
            }
            if (!tempList.isEmpty()) {
                customerParams.addCustomerParam(key, this.encode(this.getBytes(tempList)));
            } else {
                customerParams.removeCustomerParam(key);
            }
        } else if (value instanceof Date) {
            Date _value = (Date)value;
            customerParams.addCustomerParam(key, String.valueOf(_value.getTime()));
        } else if (value instanceof IObjectValue) {
            IObjectValue _value = (IObjectValue)value;
            if (_value.get("id") != null) {
                customerParams.addCustomerParam(key, _value.get("id").toString());
            } else {
                customerParams.removeCustomerParam(key);
            }
        } else if (value instanceof IObjectValue[]) {
            IObjectValue[] _value = (IObjectValue[])value;
            if (_value.length != 0) {
                ArrayList<String> tempList = new ArrayList<String>();
                for (IObjectValue objectValue : _value) {
                    if (objectValue == null) continue;
                    tempList.add(objectValue.get("id").toString());
                }
                if (!tempList.isEmpty()) {
                    customerParams.addCustomerParam(key, this.encode(this.getBytes(tempList)));
                } else {
                    customerParams.removeCustomerParam(key);
                }
            } else {
                customerParams.removeCustomerParam(key);
            }
        } else if (value instanceof IObjectCollection) {
            IObjectCollection _value = (IObjectCollection)value;
            if (_value.size() != 0) {
                ArrayList<String> tempList = new ArrayList<String>();
                int in = _value.size();
                for (int i = 0; i < in; ++i) {
                    IObjectValue objectValue = _value.getObject(i);
                    if (objectValue == null) continue;
                    tempList.add(objectValue.get("id").toString());
                }
                if (!tempList.isEmpty()) {
                    customerParams.addCustomerParam(key, this.encode(this.getBytes(tempList)));
                } else {
                    customerParams.removeCustomerParam(key);
                }
            } else {
                customerParams.removeCustomerParam(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getBytes(Object obj) {
        if (obj == null) {
            return null;
        }
        byte[] objByte = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream out = null;
        try {
            baos = new ByteArrayOutputStream();
            out = new ObjectOutputStream(baos);
            out.writeObject(obj);
            objByte = ZipUtil.pack((ByteArrayOutputStream)baos);
            this.close(out);
            this.close(baos);
        }
        catch (IOException ex) {
            try {
                logger.error((Object)"", (Throwable)ex);
                this.close(out);
                this.close(baos);
            }
            catch (Throwable throwable) {
                this.close(out);
                this.close(baos);
                throw throwable;
            }
        }
        return objByte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObject(byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        Object obj = null;
        InputStream is = null;
        ObjectInputStream bais = null;
        try {
            is = ZipUtil.unpack((byte[])data);
            bais = new ObjectInputStream(is);
            obj = bais.readObject();
            this.close(bais);
            this.close(is);
        }
        catch (Exception e) {
            try {
                logger.error((Object)"", (Throwable)e);
                this.close(bais);
                this.close(is);
            }
            catch (Throwable throwable) {
                this.close(bais);
                this.close(is);
                throw throwable;
            }
        }
        return obj;
    }

    protected byte[] decode(String str) {
        if (!StringUtils.isEmpty((String)str)) {
            return Base64.decode((String)str);
        }
        return null;
    }

    protected String encode(byte[] bytes) {
        if (bytes != null && bytes.length > 0) {
            return Base64.encodeBytes((byte[])bytes);
        }
        return null;
    }

    private void close(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException ex) {
                logger.error((Object)"", (Throwable)ex);
            }
            finally {
                os = null;
            }
        }
    }

    private void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException ex) {
                logger.error((Object)"", (Throwable)ex);
            }
            finally {
                is = null;
            }
        }
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        if (this.mainOrgChangeCanceling) {
            return;
        }
        if (chgVo.isDiffrent()) {
            try {
                if (chgVo.getNewOrg() == null || !(chgVo.getNewOrg() instanceof CompanyOrgUnitInfo)) {
                    return;
                }
                CompanyOrgUnitInfo companyOrg = (CompanyOrgUnitInfo)chgVo.getNewOrg();
                if (companyOrg == null) {
                    return;
                }
                this.getUIContext().put("ORG.PK", new ObjectUuidPK(companyOrg.getId()));
                if (!NCMUtils.isStart(null, companyOrg.getId().toString())) {
                    throw new CMBillException(CMBillException.COST_NOTON);
                }
            }
            catch (Exception e) {
                MsgBox.showInfo((String)e.getMessage());
                if (this.getCompanyF7() != null) {
                    try {
                        this.mainOrgChangeCanceling = true;
                        this.getCompanyF7().setData(chgVo.getOldOrg());
                    }
                    finally {
                        this.mainOrgChangeCanceling = false;
                    }
                    this.getCompanyF7().requestFocus();
                }
                SysUtil.abort();
            }
        }
    }

    public IF7ContextChange getF7ContextManager() {
        return (NCMF7ContextManager)this.getF7Register();
    }

    public IF7Register getF7Register() {
        if (this.f7ContextManager == null) {
            this.f7ContextManager = new NCMF7ContextManager((Component)((Object)this), OrgType.Company, ContextTypeEnum.INQUERYING, 0);
        }
        return this.f7ContextManager;
    }

    protected void registerF7() throws Exception {
    }

    public KDBizPromptBox getMainOrg() {
        return this.getCompanyF7();
    }

    public KDBizPromptBox getCompanyF7() {
        return null;
    }

    public String getMainOrgKeyForCustomerParams(OrgType orgType) {
        return "company.id";
    }

    public OrgType getMainOrgType() {
        return OrgType.Company;
    }

    public String getPermissionItem() {
        if (this.permissionItem == null && this.metaDataPKForPemmissionByUI != null) {
            try {
                String permissionItemKey = "" + MetaDataTypeList.UIOBJECT + this.metaDataPKForPemmissionByUI;
                if (!permissionItemMap.containsKey(permissionItemKey)) {
                    MetaDataPK actionPK = new MetaDataPK("ActionOnLoad");
                    this.permissionItem = NCMCommonFacadeFactory.getRemoteInstance().getUIPermissiionItem(this.metaDataPKForPemmissionByUI, (IMetaDataPK)actionPK);
                    permissionItemMap.put(permissionItemKey, this.permissionItem);
                } else {
                    this.permissionItem = (String)permissionItemMap.get(permissionItemKey);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return this.permissionItem;
    }

    public void setMetaDataPKForPemmission(IMetaDataPK metaDataPKForPemmission) {
        this.metaDataPKForPemmission = metaDataPKForPemmission;
    }

    public void setMetaDataPKForPemmissionByUI(IMetaDataPK metaDataPKForPemmissionByUI) {
        this.metaDataPKForPemmissionByUI = metaDataPKForPemmissionByUI;
    }

    public boolean isSupportMultiOrgs() {
        return false;
    }

    public boolean isSupportVirturalOrgs() {
        return false;
    }

    public boolean isEnableMultiOrgSupport() {
        return false;
    }

    public OrgContextManager orgContextManager() {
        return this.orgContextManager;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getCompanyF7();
    }

    public boolean verify() {
        if (this.isEnableMultiOrgSupport()) {
            if (this.getCompanyF7().getData() == null) {
                MsgBox.showInfo((String)SCMGroupClientUtils.getMainOrgNullMsg((OrgType)OrgType.Company));
                this.getCompanyF7().requestFocus();
                SysUtil.abort();
            }
            try {
                if (!NCMUtils.isStart(null, ((CompanyOrgUnitInfo)this.getCompanyF7().getData()).getId().toString())) {
                    throw new CMBillException(CMBillException.COST_NOTON);
                }
            }
            catch (Exception e) {
                MsgBox.showInfo((String)e.getMessage());
                this.getCompanyF7().requestFocus();
                SysUtil.abort();
            }
        }
        return true;
    }

    protected CompanyOrgUnitInfo getCompanyOrgInfoWithDefault() {
        Object temp = null;
        Object object = temp = this.getCompanyF7() == null ? null : this.getCompanyF7().getData();
        if (temp != null && temp instanceof CompanyOrgUnitInfo) {
            if (!((CompanyOrgUnitInfo)temp).isLoaded() && ((CompanyOrgUnitInfo)temp).getId().toString().trim().length() > 0) {
                try {
                    temp = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(((CompanyOrgUnitInfo)temp).getId().toString()));
                }
                catch (EASBizException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
            return (CompanyOrgUnitInfo)temp;
        }
        return SysContext.getSysContext().getCurrentFIUnit();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(this.getCompanyOrgInfoWithDefault().getId());
    }

    public void clear() {
        if (this.isEnableMultiOrgSupport() && this.getCompanyF7() != null) {
            this.getCompanyF7().setData((Object)SysContext.getSysContext().getCurrentFIUnit());
        }
    }
}

