/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ncm.cal.MatAllocResultVoucheredFactory;
import com.kingdee.eas.ncm.cal.VoucherDAPTransImpl;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.NCMCommonFacadeFactory;
import com.kingdee.eas.ncm.common.client.AbstractCMVoucherBaseListUI;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMCommonQueryProcessor;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CMVoucherBaseListUI
extends AbstractCMVoucherBaseListUI {
    private static final Logger logger = CoreUIObject.getLogger(CMVoucherBaseListUI.class);
    private final String Col_ID = "id";
    private final String Col_EntryID = "entry.id";
    protected CompanyOrgUnitInfo _company;
    protected PeriodInfo _period;
    private final String QtyCol = "entry.baseQty";
    private final String PriceCol = "entry.unitActualCost";
    private final String AmtCol = "entry.actualCost";
    private FilterInfo _currFilterInfo = null;
    private CommonQueryDialog dialog = null;

    public CMVoucherBaseListUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        NCMClientUtils.checkIsStart();
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.actionLocate.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionStartWorkFlow.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionView.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.menuEdit.setVisible(false);
        this.menuWorkFlow.setVisible(false);
        this.menuBiz.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.btnViewBill.setIcon(this.btnTraceUp.getIcon());
        this.actionAuditResult.setVisible(false);
        this.actionVoucher.setVisible(false);
        this.actionVoucher.setEnabled(false);
        this.btnByAll.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.btnByBill.setIcon(EASResource.getIcon((String)"imgTbtn_flowexample"));
        this.btnViewAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.menuItemAutoAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.menuItemManuAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_flowexample"));
        this.menuItemViewAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.menuItemViewLog.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
    }

    @Override
    public void onLoad() throws Exception {
        this._company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
        this._period = this.GetCurrentPeriod();
        super.onLoad();
        this.initFormatTable();
    }

    protected void initDapButtons() throws Exception {
        super.initDapButtons();
        this.actionVoucher.setVisible(false);
        this.actionVoucher.setEnabled(false);
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.actionAuditResult.setVisible(false);
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MaterialReqBillFactory.getRemoteInstance();
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        try {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)String.valueOf(4)));
            filter.getFilterItems().add(new FilterItemInfo("companyOrg.id", (Object)this._company.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("costCenter.costCenterType", new HashSet<String>(Arrays.asList(String.valueOf(0), String.valueOf(1))), CompareType.INCLUDE));
            for (FilterItemInfo item : ev.getFilter().getFilterItems()) {
                if (!item.getPropertyName().equals("isAllocated")) continue;
                String tblResult = this.getResultTabel();
                int isAllocated = item.getInt("compareValue");
                int idx = ev.getFilter().getFilterItems().indexOf((IObjectValue)item);
                FilterItemInfo newItem = null;
                if (isAllocated == 1) {
                    newItem = new FilterItemInfo("entrys.id", (Object)("(Select FSourceBillEntryID from " + tblResult + ")"), CompareType.INNER, false);
                } else if (isAllocated == 0) {
                    newItem = new FilterItemInfo("entrys.id", (Object)("(Select FSourceBillEntryID from " + tblResult + ")"), CompareType.NOTINNER, false);
                }
                ev.getFilter().getFilterItems().set(idx, newItem);
                break;
            }
            try {
                ev.getFilter().mergeFilter(filter, "and");
                this._currFilterInfo = (FilterInfo)ev.getFilter().clone();
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    protected String getResultTabel() throws BOSException {
        return NCMCommonFacadeFactory.getRemoteInstance().getPhysicalTblName(this._company.getId().toString(), "T_NCM_AuxAllocResult");
    }

    private PeriodInfo GetCurrentPeriod() throws BOSException, EASBizException {
        return NCMUtils.GetCurrentPeriod(null, this._company.getId().toString());
    }

    @Override
    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog == null) {
            this.dialog = super.initCommonQueryDialog();
        }
        NCMCommonQueryProcessor cmcq = new NCMCommonQueryProcessor();
        cmcq.set("companyOrg", this._company.getId().toString());
        cmcq.set("query", "MaterialAllocQuery");
        this.dialog.setProcessor((IProcessor)cmcq);
        return this.dialog;
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        int amoutPre = 2;
        int priceprec = 8;
        int baseUnitprce = 8;
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                baseUnitprce = rowSet.getInt(this.getQtyPrecisionField());
                priceprec = rowSet.getInt(this.getPricePrecisionField());
                amoutPre = rowSet.getInt(this.getAmtPrecisionField());
                NCMClientUtils.iniColumnsPrecision(baseUnitprce, new String[]{this.getQtyQueryField()}, rowSet);
                NCMClientUtils.iniColumnsPrecision(priceprec, new String[]{this.getPriceQueryField()}, rowSet);
                NCMClientUtils.iniColumnsPrecision(amoutPre, new String[]{this.getAmtQueryField()}, rowSet);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    protected String getQtyQueryField() {
        return null;
    }

    protected String getPriceQueryField() {
        return null;
    }

    protected String getAmtQueryField() {
        return null;
    }

    public void initFormatTable() throws Exception {
        this.tblMain.getColumn(this.getQtycol()).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(this.getPricecol()).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(this.getAmtcol()).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat("yyyy-MM-dd HH:mm:ss");
        this.tblMain.getSelectManager().setSelectMode(10);
    }

    private FilterInfo GetManuFilter(FilterInfo filter) {
        int top = this.tblMain.getSelectManager().get(0).getBeginRow();
        String id = this.tblMain.getRow(top).getCell(this.getColId()).getValue().toString();
        String entryId = this.tblMain.getRow(top).getCell(this.getColEntryid()).getValue().toString();
        FilterInfo ret = new FilterInfo();
        try {
            FilterInfo addfilter = new FilterInfo();
            addfilter.getFilterItems().add(new FilterItemInfo(this.getColId(), (Object)id));
            addfilter.getFilterItems().add(new FilterItemInfo(this.getColEntryid(), (Object)entryId));
            try {
                ret.mergeFilter(filter, "and ");
                ret.mergeFilter(addfilter, "and");
                return ret;
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return ret;
    }

    @Override
    public void actionByAll_actionPerformed(ActionEvent e) throws Exception {
        this.check();
        BOTMappingInfo botMappingInfo = VoucherDAPTransImpl.getBotpInfo((CoreUI)this, null, (String)this.getAllocVoucherResultBOSType(), (CompanyOrgUnitInfo)this._company);
        if (botMappingInfo != null) {
            MatAllocResultVoucheredFactory.getRemoteInstance().addVoucherByAll((List)this.getSelectedIdValues(), this._company.getId().toString(), this._period.getId().toString(), botMappingInfo);
            this.refresh(e);
        }
    }

    @Override
    public void actionByBill_actionPerformed(ActionEvent e) throws Exception {
        this.check();
        BOTMappingInfo botMappingInfo = VoucherDAPTransImpl.getBotpInfo((CoreUI)this, null, (String)this.getAllocVoucherResultBOSType(), (CompanyOrgUnitInfo)this._company);
        if (botMappingInfo != null) {
            MatAllocResultVoucheredFactory.getRemoteInstance().addVoucherByBill((List)this.getSelectedIdValues(), this._company.getId().toString(), this._period.getId().toString(), botMappingInfo);
            this.refresh(e);
        }
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    @Override
    public void actionViewAlloc_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewAlloc_actionPerformed(e);
        this.showAllocEditUI("VIEW");
    }

    protected void showAllocEditUI(String operType) throws Exception {
        this.checkSelected();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("companyId", this._company.getId().toString());
        param.put("periodId", this._period.getId().toString());
        param.put("companyName", this._company.getName().toString());
        param.put("periodNumber", String.valueOf(this._period.getNumber()));
        param.put("filterInfo", (String)this.GetManuFilter(this._currFilterInfo));
        this.invokeShowAllocEditUI(operType, param);
    }

    protected void invokeShowAllocEditUI(String operType, Map param) throws Exception {
    }

    public void check() throws Exception {
        this.checkSelected();
        ISystemStatusCtrol ctrol = SystemStatusCtrolFactory.getRemoteInstance();
        if (!ctrol.isStart(1001, this._company.getId().toString())) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        if (!ctrol.isStart(6, this._company.getId().toString())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.common.COMMONAutoGenerateResource", (String)"5_CMVoucherBaseListUI"));
            SysUtil.abort();
        }
        if (!NCMUtils.isEquals(ctrol.getCacheCurrentPeriod(6, this._company.getId().toString()), this._period)) {
            throw new CMBillException(CMBillException.NOTEQUALS_VOUCHER);
        }
    }

    @Override
    protected ArrayList getSelectedIdValues() {
        return super.getSelectedIdValues();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.checkVoucherPermission("material_viewAlloc");
            this.actionViewAlloc_actionPerformed(null);
        }
    }

    private boolean checkVoucherPermission(String printPermission) throws Exception {
        boolean bPermission = false;
        if (!printPermission.equals("")) {
            PermissionHelper.checkFunctionPermission(null, null, (String)printPermission);
            bPermission = true;
        }
        return bPermission;
    }

    @Override
    public void actionViewBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public String[] getMergeColumnKeys() {
        String[] keys = new String[this.tblMain.getColumnCount()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = this.tblMain.getColumn(i).getKey();
        }
        return keys;
    }

    protected String getAllocVoucherResultBOSType() {
        return "D66B2978";
    }

    public String getQtyPrecisionField() {
        return "baseUnit.qtyPrecision";
    }

    public String getPricePrecisionField() {
        return "material.pricePrecision";
    }

    public String getAmtPrecisionField() {
        return "baseCurrency.precision";
    }

    public String getColId() {
        return "id";
    }

    public String getColEntryid() {
        return "entry.id";
    }

    public String getQtycol() {
        return "entry.baseQty";
    }

    public String getPricecol() {
        return "entry.unitActualCost";
    }

    public String getAmtcol() {
        return "entry.actualCost";
    }
}

