/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectSingleKey;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CostObjectGroupInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.ncm.common.DataToolGroupFactory;
import com.kingdee.eas.ncm.common.DataToolGroupInfo;
import com.kingdee.eas.ncm.common.DataToolSolutionFactory;
import com.kingdee.eas.ncm.common.DataToolSolutionInfo;
import com.kingdee.eas.ncm.common.client.AbstractDataToolSolutionUI;
import com.kingdee.eas.ncm.common.client.DataToolSolutionGroupEditUI;
import com.kingdee.eas.ncm.common.client.NCMDataExportUI;
import com.kingdee.eas.ncm.common.client.NCMDataImportUI;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class DataToolSolutionUI
extends AbstractDataToolSolutionUI {
    private static final Logger logger = CoreUIObject.getLogger(DataToolSolutionUI.class);
    private static final String Col_ID = "id";
    private static final String Col_IsDirty = "isDirty";
    private static final String Col_Number = "number";
    private static final String Col_Table = "tableName";
    private static final String Col_Where = "where";
    private static final String Col_IsRepeatExec = "isRepeatExec";
    private static final String Col_Description = "description";
    private static final String Col_GroupID = "DataToolGroup.id";
    private static final int FirstRowIndex = 0;
    private final ArrayList deletePkList = new ArrayList();
    private final ArrayList addObjList = new ArrayList();
    private final FillListener fillListener = new FillListener();
    private final KeyListener keyListener = new KeyListener(){

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent arg0) {
            if (arg0.getKeyCode() == 127) {
                arg0.setKeyChar('\u0000');
                arg0.setKeyCode(0);
                try {
                    DataToolSolutionUI.this.innerDoRemoveLine();
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                    DataToolSolutionUI.this.handUIException(e);
                }
            } else if (arg0.getKeyCode() == 10) {
                arg0.setKeyChar('\u0000');
                arg0.setKeyCode(0);
            }
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
            if (arg0.getKeyCode() == 127) {
                arg0.setKeyChar('\u0000');
                arg0.setKeyCode(0);
            }
        }
    };

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn(Col_GroupID).getStyleAttributes().setHided(true);
        this.tblMain.getColumn(Col_ID).getStyleAttributes().setHided(true);
        this.tblMain.getColumn(Col_IsDirty).getStyleAttributes().setHided(true);
        this.menuItemAddNew.setVisible(false);
        this.menuItemEdit.setVisible(false);
        this.menuItemView.setVisible(false);
        this.menuItemRemove.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.btnView.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnAddLine.setEnabled(true);
        this.actionRemoveLine.setEnabled(true);
        this.formatEntryTable();
    }

    private void formatEntryTable() {
        this.tblMain.getColumn(Col_Table).setRequired(true);
        this.tblMain.getColumn(Col_Number).setRequired(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getStyleAttributes().setLocked(false);
        KDCheckBox pro = new KDCheckBox();
        this.tblMain.getColumn(Col_IsRepeatExec).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)pro));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionRemoveLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.actionSave.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_save"));
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        if ((e.getValue() instanceof String || e.getValue() instanceof Boolean) && e.getValue() != e.getOldValue()) {
            ICell cell = this.tblMain.getRow(e.getRowIndex()).getCell(Col_IsDirty);
            cell.setValue((Object)String.valueOf(true));
            this.actionSave.setEnabled(true);
        }
        super.tblMain_editStopped(e);
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
        this.tblMain.addKeyListener(this.keyListener);
    }

    protected void initTableParams() {
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getSelectManager().setSelectMode(1);
        KDTableHelper.releaseTab((JComponent)this.tblMain);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable() != null) {
            this.addLine(this.getDetailTable(), 0);
        }
    }

    protected void addLine(KDTable table, int rowIndex) throws Exception {
        if (table == null) {
            return;
        }
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode.getUserObject().equals("\u6570\u636e\u811a\u672c\u5bfc\u51fa\u65b9\u6848")) {
            String msg = "\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u65b0\u589e\u65b9\u6848\uff01";
            MsgBox.showError((Component)((Object)this), (String)msg);
            return;
        }
        if (this.tblMain.getRowCount() == 0) {
            this.actionRemoveLine.setEnabled(true);
        }
        IRow row = table.addRow(rowIndex);
        this.formatAddline(row);
    }

    private void formatAddline(IRow row) throws Exception {
        row.getCell(Col_IsDirty).setValue((Object)String.valueOf(true));
        row.getCell(Col_IsRepeatExec).setValue((Object)true);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        try {
            this.updateSolution();
            this.refreshList();
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            MsgBox.showDetailAndOK((Component)((Object)this), (String)NCMClientUtils.getNcmBillResource("SAVE_FAIL"), (String)ex.getMessage(), (int)8188);
            SysUtil.abort();
        }
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
        this.innerDoRemoveLine();
    }

    void innerDoRemoveLine() throws Exception {
        this.checkSelected();
        this.removeLine(this.tblMain);
        if (this.tblMain.getRowCount() == 0) {
            this.tblMain.reLayoutAndPaint();
        }
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                int i;
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                if (8 == selectBlock.getMode()) {
                    for (i = 0; i < table.getRowCount(); ++i) {
                        indexSet.add(i);
                    }
                    continue;
                }
                for (i = top; i <= bottom; ++i) {
                    indexSet.add(i);
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            table.setRefresh(false);
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int index;
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
                ObjectSingleKey opk = new ObjectSingleKey(Col_ID, table.getRow(rowIndex).getCell(Col_ID).getValue());
                if (opk.getKeyValue(opk.getKeyFields()[0]) != null) {
                    this.deletePkList.add(opk);
                }
                this.actionSave.setEnabled(true);
                table.removeRow(rowIndex);
                IObjectCollection collection = (IObjectCollection)table.getUserObject();
                if (collection == null) {
                    logger.error((Object)"collection not be binded to table");
                    continue;
                }
                if (detailData == null || (index = this.getCollectionIndex(collection, detailData)) < 0 || collection.size() <= index) continue;
                collection.removeObject(index);
            }
            table.setRefresh(true);
            if (table.getRow(0) != null) {
                table.getSelectManager().select(0, 0, 0, 0);
            } else {
                this.actionRemoveLine.setEnabled(false);
            }
        }
    }

    private int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(NCMDataImportUI.class.getName(), (Map)uiContext, null);
        uiWindow.show();
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        this.selectNode();
        UIContext uiContext = new UIContext((Object)this);
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode == null) {
            return;
        }
        String treeID = null;
        treeID = treeNode.getUserObject() instanceof DataToolGroupInfo ? ((DataToolGroupInfo)treeNode.getUserObject()).getId().toString() : "00000";
        uiContext.put((Object)"TreeID", (Object)treeID);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(NCMDataExportUI.class.getName(), (Map)uiContext, null);
        uiWindow.show();
    }

    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() > 0) {
            String msg = "\u8be5\u5206\u7ec4\u4e0b\u5df2\u7ecf\u5b58\u5728\u6570\u636e\u811a\u672c\u5bfc\u51fa\u65b9\u6848\uff01";
            MsgBox.showError((Component)((Object)this), (String)msg);
            return;
        }
        super.actionGroupRemove_actionPerformed(e);
    }

    protected void prepareGroupUIContext(UIContext uiContext, ActionEvent e) {
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            if (uiContext.containsKey((Object)"ID") && uiContext.get((Object)"ID") != null) {
                if (treeNode.getParent() instanceof KDTreeNode) {
                    KDTreeNode parent = (KDTreeNode)treeNode.getParent();
                    if (parent.getUserObject().equals("\u6570\u636e\u811a\u672c\u5bfc\u51fa\u65b9\u6848")) {
                        uiContext.put((Object)"ParentNode", treeNode.getUserObject());
                    } else if (parent.getUserObject() instanceof CostObjectGroupInfo) {
                        uiContext.put((Object)"ParentNode", parent.getUserObject());
                    } else {
                        uiContext.put((Object)"ParentNode", null);
                    }
                } else {
                    uiContext.put((Object)"ParentNode", null);
                }
            } else {
                uiContext.put((Object)"ParentNode", treeNode.getUserObject());
            }
            uiContext.put((Object)"thisNode", treeNode.getUserObject());
        } else {
            uiContext.put((Object)"ParentNode", null);
        }
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return DataToolSolutionFactory.getRemoteInstance();
    }

    protected String getRootName() {
        return "\u6570\u636e\u811a\u672c\u5bfc\u51fa\u65b9\u6848";
    }

    protected boolean isIgnoreTreeCUFilter() {
        return true;
    }

    protected String getGroupEditUIName() {
        return DataToolSolutionGroupEditUI.class.getName();
    }

    protected String getQueryFieldName() {
        return Col_GroupID;
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return DataToolGroupFactory.getRemoteInstance();
    }

    protected boolean checkBeforeWindowClosing() {
        try {
            this.checkMustToSave();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            SysUtil.abort();
        }
        return true;
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        ev.getSorter().add(new SorterItemInfo(Col_Number));
    }

    private void checkMustToSave() throws Exception {
        if (this.CheckDirty()) {
            int ret = MsgBox.showConfirm3((String)NCMClientUtils.getNcmBillResource("CHECK_DIRTY"));
            if (ret == 0) {
                try {
                    this.updateSolution();
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)NCMClientUtils.getNcmBillResource("SAVE_FAIL"), (String)e.getMessage(), (int)8188);
                    SysUtil.abort();
                }
                catch (EASBizException e1) {
                    logger.error((Object)"", (Throwable)e1);
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)NCMClientUtils.getNcmBillResource("SAVE_FAIL"), (String)e1.getMessage(), (int)8188);
                    SysUtil.abort();
                }
            } else if (ret == 2) {
                SysUtil.abort();
            }
        }
    }

    private boolean CheckDirty() {
        int rowCount = this.tblMain.getRowCount();
        if (rowCount <= 0 && this.deletePkList.size() == 0) {
            return false;
        }
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            ICell isDirty = row.getCell(Col_IsDirty);
            if (isDirty.getValue() == null || !isDirty.getValue().toString().equals(String.valueOf(true))) continue;
            return true;
        }
        return this.deletePkList.size() > 0;
    }

    private void updateSolution() throws Exception {
        IRow row;
        int i;
        int rowCount = this.tblMain.getRowCount();
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (rowCount <= 0 && this.deletePkList.size() == 0) {
            return;
        }
        HashMap<Object, StringBuffer> data = new HashMap<Object, StringBuffer>();
        String where = "";
        String des = "";
        StringBuffer str = null;
        for (i = 0; i < rowCount; ++i) {
            str = new StringBuffer();
            row = this.tblMain.getRow(i);
            ICell id = row.getCell(Col_ID);
            ICell isDirty = row.getCell(Col_IsDirty);
            if (!isDirty.getValue().toString().equals(String.valueOf(true))) continue;
            if (id.getValue() != null) {
                if (row.getCell(Col_Where).getValue() != null) {
                    where = row.getCell(Col_Where).getValue().toString();
                }
                if (row.getCell(Col_Description).getValue() != null) {
                    des = row.getCell(Col_Description).getValue().toString();
                }
                str.append(row.getCell(Col_Number).getValue().toString()).append(",").append(row.getCell(Col_Table).getValue().toString()).append(",").append(where).append(",").append(row.getCell(Col_IsRepeatExec).getValue().toString()).append(",").append(des);
                data.put(id.getValue(), str);
                continue;
            }
            if (id.getValue() != null) continue;
            DataToolSolutionInfo info = new DataToolSolutionInfo();
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            info.setIsRepeatExec(Boolean.valueOf(row.getCell(Col_IsRepeatExec).getValue().toString()));
            info.setNumber(row.getCell(Col_Number).getValue().toString());
            if (row.getCell(Col_Description).getValue() != null) {
                info.setDescription(row.getCell(Col_Description).getValue().toString());
            } else {
                info.setDescription(null);
            }
            info.setTableName(row.getCell(Col_Table).getValue().toString());
            if (row.getCell(Col_Where).getValue() != null) {
                info.setWhere(row.getCell(Col_Where).getValue().toString());
            } else {
                info.setWhere(null);
            }
            info.setGroup((DataToolGroupInfo)treeNode.getUserObject());
            this.addObjList.add(info);
        }
        if (data.size() <= 0 && this.deletePkList.size() == 0 && this.addObjList.size() <= 0) {
            return;
        }
        try {
            DataToolSolutionFactory.getRemoteInstance().updateSoData(data, this.deletePkList, this.addObjList);
            this.deletePkList.clear();
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.addObjList.clear();
        }
        for (i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow(i);
            ICell isDirty = row.getCell(Col_IsDirty);
            if (!isDirty.getValue().toString().equals(String.valueOf(true))) continue;
            isDirty.setValue((Object)String.valueOf(false));
        }
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(DataToolSolutionUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                ICell cell = tblMain.getRow(i).getCell(DataToolSolutionUI.Col_IsDirty);
                if (cell == null) continue;
                cell.setValue((Object)String.valueOf(false));
            }
            DataToolSolutionUI.this.actionSave.setEnabled(false);
            DataToolSolutionUI.this.deletePkList.clear();
            if (tblMain.getRowCount() == 0) {
                DataToolSolutionUI.this.actionRemoveLine.setEnabled(false);
            } else {
                DataToolSolutionUI.this.actionRemoveLine.setEnabled(true);
            }
        }
    }
}

