/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.client;

import com.kingdee.eas.ncm.common.client.NCMClientVerifyHelper;
import com.kingdee.util.DateTimeUtils;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.log4j.Logger;

public final class DateHelper {
    Logger logger = Logger.getLogger(DateHelper.class);
    public static final int[] SEASON = new int[]{1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4};
    public static final String FORMAT_DAY = "yyyy-MM-dd";
    public static final String FORMAT_TIME = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_MONTH = "yyyy-MM";

    public static List getTimeList(int beginYear, int beginMonth, int endYear, int endMonth, int k) {
        ArrayList<List> list = new ArrayList<List>();
        if (beginYear == endYear) {
            for (int j = beginMonth; j <= endMonth; ++j) {
                list.add(DateHelper.getTimeList(beginYear, j, k));
            }
        } else {
            int j;
            for (j = beginMonth; j < 12; ++j) {
                list.add(DateHelper.getTimeList(beginYear, j, k));
            }
            for (int i = beginYear + 1; i < endYear; ++i) {
                for (int j2 = 0; j2 < 12; ++j2) {
                    list.add(DateHelper.getTimeList(i, j2, k));
                }
            }
            for (j = 0; j <= endMonth; ++j) {
                list.add(DateHelper.getTimeList(endYear, j, k));
            }
        }
        return list;
    }

    public static List getTimeList(int beginYear, int beginMonth, int k) {
        ArrayList<Date> list = new ArrayList<Date>();
        GregorianCalendar begincal = new GregorianCalendar(beginYear, beginMonth, 1);
        int max = ((Calendar)begincal).getActualMaximum(5);
        for (int i = 1; i < max; i += k) {
            list.add(begincal.getTime());
            ((Calendar)begincal).add(5, k);
        }
        begincal = new GregorianCalendar(beginYear, beginMonth, max);
        list.add(begincal.getTime());
        return list;
    }

    public static Date getDayBegin() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Timestamp getTimeStampDayBegin() {
        return new Timestamp(DateHelper.getDayBegin().getTime());
    }

    public static Date getDayEnd() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static Date getNextDay(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) + 1);
        return cal.getTime();
    }

    public static Date getNextMonth(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(2, cal.get(2) + 1);
        return cal.getTime();
    }

    public static java.sql.Date getSQLBegin(Date da) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(da);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        java.sql.Date ds = new java.sql.Date(cal.getTimeInMillis());
        return ds;
    }

    public static java.sql.Date getSQLEnd(Date da) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(da);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return new java.sql.Date(cal.getTimeInMillis());
    }

    public static Date getFirstSeasonDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int sean = DateHelper.getSeason(cal.get(2));
        cal.set(2, sean * 3 - 3);
        return cal.getTime();
    }

    public static Date getFirstYearDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, 0);
        cal.set(5, 1);
        return DateTimeUtils.truncateDate((Date)cal.getTime());
    }

    public static int getSeason(int mouth) {
        return SEASON[mouth];
    }

    public static Date getBeforeDay(Date thisDate) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(thisDate);
        ((Calendar)cal).add(5, -1);
        return cal.getTime();
    }

    public static Date getAfterDay(Date thisDate) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(thisDate);
        ((Calendar)cal).add(5, 1);
        return cal.getTime();
    }

    public static boolean isFirstDayOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2) == 0 && cal.get(5) == 1;
    }

    public static Date getFirstYearDate(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, 0);
        cal.set(5, 1);
        return DateTimeUtils.truncateDate((Date)cal.getTime());
    }

    public static Date stringToDate(String s) {
        Date d = null;
        if (NCMClientVerifyHelper.isEmpty(s)) {
            d = DateHelper.getDayBegin();
        } else {
            try {
                d = new SimpleDateFormat(FORMAT_DAY).parse(s);
            }
            catch (ParseException e) {
                try {
                    d = new SimpleDateFormat().parse(s);
                }
                catch (ParseException e1) {
                    d = DateHelper.getDayBegin();
                }
            }
        }
        return d;
    }

    public static String DateToString(Date s) {
        return new SimpleDateFormat(FORMAT_DAY).format(s);
    }

    public static Date getLastYearDate(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, 11);
        cal.set(5, 31);
        return DateTimeUtils.truncateDate((Date)cal.getTime());
    }

    public static long dateDiff(Date date1, Date date2) {
        long date1ms = date1.getTime();
        long date2ms = date2.getTime();
        return date2ms - date1ms;
    }

    public static Date getDayBegin(Date da) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(da);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date ds = new Date(cal.getTimeInMillis());
        return ds;
    }

    public static long dateDiff(String interval, Date dDate1, Date dDate2) {
        int field;
        Date date2;
        Date date1;
        int desiredField = 0;
        int coef = 1;
        if (dDate1.getTime() > dDate2.getTime()) {
            coef = -1;
            date1 = dDate2;
            date2 = dDate1;
        } else {
            date1 = dDate1;
            date2 = dDate2;
        }
        if (interval.equals("yyyy")) {
            field = 1;
        } else if (interval.equals("m")) {
            field = 2;
        } else if (interval.equals("d")) {
            field = 5;
        } else if (interval.equals("y")) {
            field = 5;
        } else if (interval.equals("w")) {
            field = 4;
        } else if (interval.equals("ww")) {
            field = 3;
        } else if (interval.equals("h")) {
            field = 5;
            desiredField = 11;
        } else if (interval.equals("n")) {
            field = 5;
            desiredField = 12;
        } else if (interval.equals("s")) {
            field = 5;
            desiredField = 13;
        } else {
            return -1L;
        }
        Calendar calTmp = Calendar.getInstance();
        calTmp.setTime(date1);
        long nbOccurence = 0L;
        calTmp.add(field, 1);
        Date dateTemp = calTmp.getTime();
        while (dateTemp.getTime() <= date2.getTime()) {
            calTmp.add(field, 1);
            dateTemp = calTmp.getTime();
            ++nbOccurence;
        }
        if (desiredField == 11 || desiredField == 12 || desiredField == 13) {
            calTmp.setTime(date1);
            calTmp.add(field, (int)nbOccurence);
            dateTemp = calTmp.getTime();
            switch (desiredField) {
                case 11: {
                    nbOccurence *= 24L;
                    break;
                }
                case 12: {
                    nbOccurence = nbOccurence * 24L * 60L;
                    break;
                }
                case 13: {
                    nbOccurence = nbOccurence * 24L * 60L * 60L;
                }
            }
            calTmp.add(desiredField, 1);
            dateTemp = calTmp.getTime();
            while (dateTemp.getTime() <= date2.getTime()) {
                calTmp.add(desiredField, 1);
                dateTemp = calTmp.getTime();
                ++nbOccurence;
            }
        }
        return nbOccurence * (long)coef;
    }

    public static Date getFirstDayOfCurMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.getActualMinimum(5));
        return DateTimeUtils.truncateDate((Date)cal.getTime());
    }

    public static Date getFirstDayOfMonth(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.set(5, cal.getActualMinimum(5));
        return DateTimeUtils.truncateDate((Date)cal.getTime());
    }

    public static Date getEndDayOfCurMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.getActualMaximum(5));
        return DateTimeUtils.truncateDate((Date)cal.getTime());
    }

    public static Date getLastDayOfCurMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.getActualMaximum(5));
        return DateTimeUtils.truncateDate((Date)cal.getTime());
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static String formatDate(Date d) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        return df.format(d);
    }

    public static String formatDate2(Date d) {
        SimpleDateFormat df = new SimpleDateFormat(FORMAT_DAY);
        return df.format(d);
    }

    public static Date max(Date date1, Date date2) {
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return date1;
        }
        if (date1.after(date2)) {
            return date1;
        }
        return date2;
    }

    public static Date min(Date date1, Date date2) {
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return date1;
        }
        if (date1.after(date2)) {
            return date2;
        }
        return date1;
    }

    public static java.sql.Date truncateSqlDate(java.sql.Date sqlDate) {
        Date date = new Date(sqlDate.getTime());
        return new java.sql.Date(DateTimeUtils.truncateDate((Date)date).getTime());
    }

    public static int getDiffDays(Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            throw new IllegalArgumentException("getDiffDays param is null!");
        }
        long diff = (endDate.getTime() - beginDate.getTime()) / 86400000L;
        int days = Long.valueOf(diff).intValue() + 1;
        return days;
    }

    public static Date getFirstDayOfWeek(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek);
        return cal.getTime();
    }

    public static Date getFirstDayByWeekNum(int year, int week) {
        if (year < 0 || week < 0) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, 0);
        cal.set(5, 1);
        int dayofweek = cal.get(7);
        cal.add(5, 7 * (week - 1) - dayofweek + 2);
        return cal.getTime();
    }
}

