/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.DataConditionBaseInfo;
import com.kingdee.eas.ncm.common.NCMDBUtilServerFacadeFactory;
import com.kingdee.eas.ncm.common.SqlFileSelector;
import com.kingdee.eas.ncm.common.client.AbstractNCMDataImportUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;

public class NCMDataImportUI
extends AbstractNCMDataImportUI {
    private static final Logger logger = CoreUIObject.getLogger(NCMDataImportUI.class);
    private SqlFileSelector sqlFileSelect = null;

    public void onLoad() throws Exception {
        this.sqlFileSelect = new SqlFileSelector((Component)((Object)this), "OPEN", 2, false);
        this.kDBizPrFilePath.setEnabledMultiSelection(true);
        this.kDBizPrFilePath.setSelector((KDPromptSelector)this.sqlFileSelect);
        this.kDTDetailInfo.setEditable(false);
    }

    @Override
    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
        final DataConditionBaseInfo condition = new DataConditionBaseInfo();
        final File file = (File)this.sqlFileSelect.getData();
        if (file == null || !file.exists()) {
            MsgBox.showInfo((String)"\u6240\u9009\u811a\u672c\u4e0d\u5b58\u5728\u3002");
            SysUtil.abort();
        }
        condition.setScriptType(this.kDComScriptType.getSelectedIndex());
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ZipFile zipFile = null;
                FileInputStream fin = null;
                ZipInputStream zin = null;
                try {
                    NCMDataImportUI.this.setKdButtonEnable(false);
                    if (file.getName().endsWith(".sql")) {
                        List<String> ksqls = NCMDataImportUI.this.loadFile(file.getPath());
                        condition.setKsqls(ksqls);
                        NCMDataImportUI.this.log("\u811a\u672c" + file.getName() + "\u5f00\u59cb\u6267\u884c", Color.BLACK);
                        NCMDBUtilServerFacadeFactory.getRemoteInstance().importData(condition);
                        NCMDataImportUI.this.log("\u811a\u672c" + file.getName() + "\u6267\u884c\u6210\u529f", Color.BLACK);
                    } else if (file.getName().endsWith(".ncm")) {
                        NCMDataImportUI.this.log("\u5f00\u59cb\u6267\u884c\u6587\u4ef6" + file.getPath(), Color.BLACK);
                        zipFile = new ZipFile(file.getPath());
                        fin = new FileInputStream(file.getPath());
                        zin = new ZipInputStream(fin);
                        ZipEntry entry = null;
                        while ((entry = zin.getNextEntry()) != null) {
                            NCMDataImportUI.this.log("\u811a\u672c" + entry.getName() + "\u5f00\u59cb\u6267\u884c", Color.BLACK);
                            if (entry.isDirectory()) {
                                NCMDataImportUI.this.log("\u811a\u672c" + entry.getName() + "\u6267\u884c\u6210\u529f", Color.BLACK);
                                continue;
                            }
                            List<List<String>> ksqls = NCMDataImportUI.loadZipFile(zipFile, entry);
                            for (List<String> sqls : ksqls) {
                                condition.setKsqls(sqls);
                                NCMDBUtilServerFacadeFactory.getRemoteInstance().importData(condition);
                            }
                            NCMDataImportUI.this.log("\u811a\u672c" + entry.getName() + "\u6267\u884c\u6210\u529f", Color.BLACK);
                        }
                        NCMDataImportUI.this.log("\u7ed3\u675f\u6267\u884c\u6587\u4ef6" + file.getPath(), Color.BLACK);
                    }
                    MsgBox.showInfo((String)"\u6570\u636e\u5bfc\u5165\u6210\u529f\u3002");
                    NCMDataImportUI.this.setKdButtonEnable(true);
                }
                catch (EASBizException e) {
                    NCMDataImportUI.this.log(e.getMessage(), Color.RED);
                }
                catch (BOSException e) {
                    NCMDataImportUI.this.log(e.getMessage(), Color.RED);
                }
                catch (Exception e) {
                    NCMDataImportUI.this.log(e.getMessage(), Color.RED);
                }
                finally {
                    try {
                        if (zipFile != null) {
                            zipFile.close();
                        }
                    }
                    catch (IOException ex) {
                        NCMDataImportUI.this.log(ex.getMessage(), Color.RED);
                    }
                    try {
                        if (fin != null) {
                            fin.close();
                        }
                    }
                    catch (IOException ex) {
                        NCMDataImportUI.this.log(ex.getMessage(), Color.RED);
                    }
                    try {
                        if (zin != null) {
                            zin.close();
                        }
                    }
                    catch (IOException ex) {
                        NCMDataImportUI.this.log(ex.getMessage(), Color.RED);
                    }
                }
            }
        }).start();
    }

    private synchronized void log(final String msg, final Color color) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleAttributeSet attributeSet = new SimpleAttributeSet();
                StyleConstants.setForeground(attributeSet, color);
                Document doc = NCMDataImportUI.this.kDTDetailInfo.getDocument();
                try {
                    doc.insertString(doc.getLength(), msg + "\n", attributeSet);
                }
                catch (BadLocationException ignore) {
                    logger.error((Object)ignore);
                }
                NCMDataImportUI.this.kDTDetailInfo.setSelectionStart(doc.getLength());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> loadFile(String filepath) {
        ArrayList<String> lines = new ArrayList<String>();
        File file = new File(filepath);
        if (file.isFile()) {
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    lines.add(line);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ignore) {
                        logger.error((Object)ignore);
                    }
                }
            }
        }
        return lines;
    }

    public static List<List<String>> loadZipFile(ZipFile file, ZipEntry entry) throws ZipException, IOException, BOSException {
        LinkedList<List<String>> lineList = new LinkedList<List<String>>();
        if (entry.isDirectory()) {
            return null;
        }
        ArrayList<String> lines = null;
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(file.getInputStream(entry), "UTF-8"));
            int j = 1;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || line.startsWith("--")) continue;
                if (lines == null) {
                    lines = new ArrayList<String>(2000);
                }
                lines.add(line);
                if (j % 2000 == 0) {
                    lineList.add(lines);
                    lines = null;
                }
                ++j;
            }
            if (lines != null && lines.size() > 0) {
                lineList.add((List<String>)lines);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignore) {
                    throw new BOSException((Throwable)ignore);
                }
            }
        }
        return lineList;
    }

    private synchronized void setKdButtonEnable(boolean isEnable) {
        this.kDbutImportData.setEnabled(isEnable);
    }
}

