/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ncm.common.client.AbstractProgressHintUI;
import com.kingdee.eas.ncm.common.client.ProgressHintListener;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.Assert;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class ProgressHintUI
extends AbstractProgressHintUI
implements ActionListener {
    private static Logger logger = Logger.getLogger((String)ProgressHintUI.class.getName());
    private Map _parentParam = null;
    private ProgressHintListener _listener = null;
    private Task _task;
    private javax.swing.Timer timer = null;
    public Exception _error = null;

    public static void showProgressHintUI(CoreUIObject ui, ProgressHintListener progressHintListener, Map param) throws Exception {
        try {
            Assert.that((ui != null ? 1 : 0) != 0);
            Assert.that((progressHintListener != null ? 1 : 0) != 0);
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"param", (Object)param);
            uiContext.put((Object)"listener", (Object)progressHintListener);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ProgressHintUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
            Exception error = ((ProgressHintUI)uiWindow.getUIObject())._error;
            if (error != null) {
                throw error;
            }
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this._parentParam = (Map)this.getUIContext().get("param");
        this._listener = (ProgressHintListener)this.getUIContext().get("listener");
    }

    public void onShow() throws Exception {
        super.onShow();
        this.timer = new javax.swing.Timer(300, this);
        this.timer.start();
    }

    public boolean destroyWindow() {
        return super.destroyWindow();
    }

    void fireProgressHint() {
        try {
            this._listener.doFunction(this._parentParam);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this._error = e;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.timer.stop();
            this.timer = null;
            this.fireProgressHint();
        }
        finally {
            this.destroyWindow();
        }
    }

    private class Task {
        private Timer timer;
        private TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    Task.this.timer.cancel();
                    ProgressHintUI.this.fireProgressHint();
                }
                finally {
                    ProgressHintUI.this.destroyWindow();
                }
            }
        };

        public Task() {
            this.timer = new Timer(false);
        }

        public void start(int delay, int internal) {
            this.timer.schedule(this.task, delay, (long)internal);
        }
    }
}

