/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.progress;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.progress.IProgressCombinTask;
import com.kingdee.eas.ncm.common.progress.IProgressTask;
import com.kingdee.eas.ncm.common.progress.ProgressMsgLevelEnum;
import com.kingdee.eas.ncm.common.progress.ProgressUtils;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.Assert;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.Uuid;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public abstract class ProgressBaseTask
implements IProgressTask {
    private String taskID = null;
    private Map param = null;
    private LinkedList items = new LinkedList();
    private Object synObj = new Object();
    private int level = 20;
    private Throwable throwable = null;
    private int stepAmount = 0;
    private int finishedStepAmount = 0;
    private int stepProgress = 0;
    protected boolean showTime = false;
    protected long submitTime = 0L;
    protected long startTime = 0L;
    protected long usedTime = 0L;
    protected long remainTime = 0L;
    private boolean finished = false;
    private boolean pausing = false;
    private boolean interrupting = false;
    protected IProgressCombinTask proxy = null;
    private Context ctx = null;
    private Timer timer = null;

    public ProgressBaseTask() {
        this.taskID = Uuid.create().toString();
    }

    public Map getParam() {
        return this.param;
    }

    public Context getContext() {
        return this.ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFinished() {
        Object object = this.synObj;
        synchronized (object) {
            return this.finished && this.items.size() == 0 && this.throwable == null;
        }
    }

    public IProgressCombinTask getProxy() {
        return this.proxy;
    }

    protected BOSObjectType getBOSType() {
        return new BOSObjectType("6FC9887C");
    }

    @Override
    public void init(Map param) {
        this.submitTime = System.currentTimeMillis();
        Assert.that((param != null ? 1 : 0) != 0);
        this.param = param;
        Object temp = param.get("task.msg.level");
        if (temp != null) {
            if (temp instanceof Integer) {
                this.level = (Integer)temp;
            } else if (temp instanceof ProgressMsgLevelEnum) {
                this.level = ((ProgressMsgLevelEnum)((Object)temp)).getValue();
            }
        }
        if (this.level < 10 || this.level > 40) {
            this.level = 20;
        }
        if ((temp = param.get("task.show.time")) != null && temp instanceof Boolean) {
            this.showTime = (Boolean)temp;
        }
        if ((temp = param.get("task.context")) != null && temp instanceof Context) {
            this.ctx = (Context)temp;
        }
    }

    @Override
    public void check() throws Throwable {
    }

    @Override
    public void execute() {
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.startTime = System.currentTimeMillis();
            this.doRun();
            Object object = this.synObj;
            synchronized (object) {
                HashMap<String, Integer> item = new HashMap<String, Integer>();
                item.put("task.section.progress", 100);
                item.put("task.step.progress", 100);
                item.put("task.finished.status", 1);
                this.addItem(item);
                this.finished = true;
            }
        }
        catch (AbortException e) {
            Object object = this.synObj;
            synchronized (object) {
                HashMap<String, Integer> item = new HashMap<String, Integer>();
                item.put("task.finished.status", -1);
                this.addItem(item);
                this.finished = true;
            }
        }
        catch (Throwable e) {
            Object object = this.synObj;
            synchronized (object) {
                this.throwable = e;
                this.finished = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRun() throws Throwable {
        try {
            this.doTaskBefore();
            int stepAmount = this.calculateStepAmount();
            Assert.that((stepAmount > 0 ? 1 : 0) != 0, (String)"\u4efb\u52a1\u7684\u5206\u6b65\u6570\u5fc5\u987b\u5927\u4e8e\u96f6\u3002");
            this.stepAmount = stepAmount;
            this.finishedStepAmount = 0;
            this.stepProgress = 0;
            int transactionLevel = this.getTransactionLevel();
            if (transactionLevel >= 0 && transactionLevel <= 6) {
                EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)this);
                Method method = this.getClass().getMethod("doTask", new Class[0]);
                txInvoker.invoke(method, new Object[0], transactionLevel);
            } else {
                this.doTask();
            }
        }
        finally {
            this.doTaskAfter();
        }
    }

    @Override
    public abstract int calculateStepAmount() throws Throwable;

    @Override
    public int estimateStepAmount() throws Throwable {
        return 0;
    }

    @Override
    public void doTaskBefore() throws Throwable {
        if (this.showTime && this.timer == null) {
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = ProgressBaseTask.this.synObj;
                    synchronized (object) {
                        if (!ProgressBaseTask.this.isFinished()) {
                            HashMap item = new HashMap();
                            ProgressBaseTask.this.addItem(item);
                        }
                    }
                }
            }, 3000L, 3000L);
        }
    }

    @Override
    public abstract void doTask() throws Throwable;

    @Override
    public void doTaskAfter() throws Throwable {
        if (this.showTime && this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    @Override
    public int getTransactionLevel() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List query() throws Throwable {
        ArrayList<Map> temp = new ArrayList<Map>();
        Object object = this.synObj;
        synchronized (object) {
            while (this.items.size() > 0) {
                Map item = (Map)this.items.removeFirst();
                temp.add(item);
            }
            if (temp.size() > 0) {
                return temp;
            }
            if (this.throwable != null) {
                throw this.throwable;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() throws Throwable {
        Object object = this.synObj;
        synchronized (object) {
            if (!this.interrupting) {
                this.pausing = !this.pausing;
                this.synObj.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt() throws Throwable {
        Object object = this.synObj;
        synchronized (object) {
            this.interrupting = true;
            this.synObj.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkInterruptAndPause() throws Throwable {
        if (this.proxy != null) {
            this.proxy.checkInterruptAndPause();
            return;
        }
        Object object = this.synObj;
        synchronized (object) {
            if (this.interrupting) {
                this.beforeInterrupt();
                SysUtil.abort();
            }
            if (this.pausing) {
                this.synObj.wait();
            }
        }
    }

    public void beforeInterrupt() throws Throwable {
        this.error("\u4efb\u52a1\u88ab\u4e2d\u65ad\u3002");
    }

    @Override
    public void setSectionName(String sectionName) {
        HashMap<String, String> item = new HashMap<String, String>();
        item.put("task.section.name", sectionName);
        this.addItem(item);
    }

    @Override
    public void setStepName(String stepName) {
        HashMap<String, String> item = new HashMap<String, String>();
        item.put("task.step.name", stepName);
        this.addItem(item);
    }

    @Override
    public void progress(int stepSpan) {
        Assert.that((stepSpan > 0 ? 1 : 0) != 0, (String)"\u63a8\u8fdb\u7684\u4efb\u52a1\u8de8\u5ea6\u5fc5\u987b\u5927\u4e8e\u96f6\u3002");
        if (stepSpan > 0) {
            HashMap<String, Integer> item = new HashMap<String, Integer>();
            item.put("task.step.span", stepSpan);
            this.addItem(item);
        }
    }

    @Override
    public void addUserObject(Object o) {
        if (o != null) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("task.user.object", o);
            this.addItem(item);
        }
    }

    @Override
    public void addStepAmount(int stepAmount) {
        if (this.proxy != null) {
            this.proxy.addStepAmount(stepAmount);
            return;
        }
        Assert.that((stepAmount > 0 ? 1 : 0) != 0, (String)"\u5206\u6b65\u6570\u5fc5\u987b\u5927\u4e8e\u96f6\u3002");
        this.stepAmount += stepAmount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addItem(Map item) {
        if (this.proxy != null) {
            this.proxy.addItem(item);
            return;
        }
        Object object = this.synObj;
        synchronized (object) {
            this.processProgress(item);
            this.processTime(item);
            if (item == null || item.size() == 0) {
                return;
            }
            this.items.add(item);
        }
    }

    protected void processProgress(Map item) {
        if (item.containsKey("task.step.amount") || item.containsKey("task.step.span")) {
            int iTemp;
            Object temp = item.get("task.step.amount");
            if (temp != null && temp instanceof Integer && (iTemp = ((Integer)temp).intValue()) > 0) {
                this.stepAmount += iTemp;
            }
            if (this.stepAmount > 0 && (temp = item.get("task.step.span")) != null && temp instanceof Integer && (iTemp = ((Integer)temp).intValue()) > 0) {
                this.finishedStepAmount += iTemp;
            }
            if (this.stepAmount > 0 && (iTemp = this.finishedStepAmount * 100 / this.stepAmount) > this.stepProgress) {
                this.stepProgress = iTemp;
                if (this.stepProgress >= 100) {
                    this.stepProgress = 99;
                }
            }
            item.put("task.step.progress", this.stepProgress);
        }
    }

    protected void processTime(Map item) {
        long currentTime = System.currentTimeMillis();
        if (item != null && item.size() > 0) {
            item.put("task.item.time", currentTime);
        }
        if (this.showTime) {
            this.usedTime = currentTime - this.startTime;
            if (this.stepProgress > 0) {
                this.remainTime = this.usedTime * 100L / (long)this.stepProgress - this.usedTime;
            }
            item.put("task.used.time", this.usedTime);
            item.put("task.remain.time", this.remainTime);
        }
    }

    @Override
    public void setProxy(IProgressCombinTask proxy) {
        this.proxy = proxy;
    }

    public boolean isDebugEnabled() {
        return 10 >= this.level;
    }

    public void debug(Object msg) {
        this.debug(msg, null);
    }

    public void debug(Object msg, Throwable t) {
        if (this.isDebugEnabled()) {
            HashMap item = new HashMap();
            ProgressUtils.debug(item, msg, t);
            this.addItem(item);
        }
    }

    public boolean isInfoEnabled() {
        return 20 >= this.level;
    }

    public void info(Object msg) {
        this.info(msg, null);
    }

    public void info(Object msg, Throwable t) {
        if (this.isInfoEnabled()) {
            HashMap item = new HashMap();
            ProgressUtils.info(item, msg, t);
            this.addItem(item);
        }
    }

    public boolean isWarnEnabled() {
        return 30 >= this.level;
    }

    public void warn(Object msg) {
        this.warn(msg, null);
    }

    public void warn(Object msg, Throwable t) {
        if (this.isWarnEnabled()) {
            HashMap item = new HashMap();
            ProgressUtils.warn(item, msg, t);
            this.addItem(item);
        }
    }

    public boolean isErrorEnabled() {
        return 40 >= this.level;
    }

    public void error(Object msg) {
        this.error(msg, null);
    }

    public void error(Object msg, Throwable t) {
        if (this.isErrorEnabled()) {
            HashMap item = new HashMap();
            ProgressUtils.error(item, msg, t);
            this.addItem(item);
        }
    }

    @Override
    public String getConcurrentID() {
        return null;
    }

    @Override
    public int getConcurrentSeq() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void beforeConcurrent() throws Throwable {
        IMutexServiceControl mutexServiceControl;
        boolean b;
        if (this.getConcurrentID() != null && this.getConcurrentID().length() > 0 && !(b = (mutexServiceControl = this.ctx != null ? MutexServiceControlFactory.getLocalInstance((Context)this.ctx) : MutexServiceControlFactory.getRemoteInstance()).requestObjIDForUpdate(this.getConcurrentID()))) {
            String name = this.ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request", (Locale)this.ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request");
            throw new EASBizException(new NumericExceptionSubItem("100", name));
        }
    }

    @Override
    public void afterConcurrent() throws Throwable {
        if (this.getConcurrentID() != null && this.getConcurrentID().length() > 0) {
            IMutexServiceControl mutexServiceControl = this.ctx != null ? MutexServiceControlFactory.getLocalInstance((Context)this.ctx) : MutexServiceControlFactory.getRemoteInstance();
            mutexServiceControl.releaseObjIDForUpdate(this.getConcurrentID());
        }
    }

    @Override
    public final String getTaskID() {
        return this.taskID;
    }

    @Override
    public String getTaskName() {
        return "unknown";
    }

    @Override
    public Long getSubmitTime() {
        return this.submitTime;
    }

    @Override
    public Long getStartTime() {
        return this.startTime;
    }

    @Override
    public Long getUsedTime() {
        return this.usedTime;
    }

    @Override
    public Long getRemainTime() {
        return this.remainTime;
    }

    @Override
    public Integer getProgress() {
        return this.stepProgress;
    }

    @Override
    public String getUserID() {
        if (this.ctx != null && ContextUtil.getCurrentUserInfo((Context)this.ctx) != null) {
            return ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString();
        }
        return null;
    }

    @Override
    public String getUserName() {
        if (this.ctx != null && ContextUtil.getCurrentUserInfo((Context)this.ctx) != null) {
            return ContextUtil.getCurrentUserInfo((Context)this.ctx).getName();
        }
        return null;
    }

    @Override
    public String getOrgID() {
        if (this.ctx != null && ContextUtil.getCurrentFIUnit((Context)this.ctx) != null) {
            return ContextUtil.getCurrentFIUnit((Context)this.ctx).getId().toString();
        }
        return null;
    }

    @Override
    public String getOrgName() {
        if (this.ctx != null && ContextUtil.getCurrentFIUnit((Context)this.ctx) != null) {
            return ContextUtil.getCurrentFIUnit((Context)this.ctx).getName();
        }
        return null;
    }

    @Override
    public String getRemark() {
        return null;
    }

    public String toString() {
        return this.getTaskID() + " : " + this.getTaskName();
    }
}

