/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.progress;

import com.kingdee.eas.ncm.common.progress.IProgressCombinTask;
import com.kingdee.eas.ncm.common.progress.IProgressTask;
import com.kingdee.eas.ncm.common.progress.ProgressBaseTask;
import com.kingdee.util.Assert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class ProgressCombinBaseTask
extends ProgressBaseTask
implements IProgressCombinTask {
    private int sectionAmount = 0;
    private int finishedSectionAmount = 0;
    private int sectionProgress = 0;
    private int stepAmount = 0;
    private int finishedStepAmount = 0;
    private int stepProgress = 0;
    protected List tasks = null;
    protected List finishedTasks = null;
    protected Map tasksStepAmountMap = new HashMap();
    protected IProgressTask currentTask = null;

    @Override
    public void doRun() throws Throwable {
        try {
            this.doTaskBefore();
            int sectionAmount = this.calculateStepAmount();
            Assert.that((sectionAmount > 0 ? 1 : 0) != 0, (String)"\u4efb\u52a1\u6570\u5fc5\u987b\u5927\u4e8e\u96f6\u3002");
            this.sectionAmount = sectionAmount;
            this.finishedSectionAmount = 0;
            this.sectionProgress = 0;
            this.doTask();
        }
        finally {
            this.doTaskAfter();
        }
    }

    @Override
    public int calculateStepAmount() throws Throwable {
        this.tasks = this.getTasks();
        if (this.tasks == null) {
            return 0;
        }
        return this.tasks.size();
    }

    @Override
    public void doTaskBefore() throws Throwable {
    }

    @Override
    public void doTask() throws Throwable {
        IProgressTask task = null;
        for (int i = 0; i < this.tasks.size(); ++i) {
            task = (IProgressTask)this.tasks.get(i);
            task.setProxy(this);
            task.init(this.getParam());
        }
        ArrayList undealtTasks = new ArrayList(this.tasks.size());
        undealtTasks.addAll(this.tasks);
        this.finishedTasks = new ArrayList(this.tasks.size());
        while (undealtTasks.size() > 0) {
            this.progressTask(undealtTasks);
        }
    }

    @Override
    public void doTaskAfter() throws Throwable {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void progressTask(List undealtTasks) throws Throwable {
        this.currentTask = (IProgressTask)undealtTasks.get(0);
        try {
            this.currentTask.doTaskBefore();
            int stepAmount = 0;
            IProgressTask task = null;
            for (int i = 0; i < undealtTasks.size(); ++i) {
                task = (IProgressTask)undealtTasks.get(i);
                if (i == 0) {
                    stepAmount = task.calculateStepAmount();
                    Assert.that((stepAmount > 0 ? 1 : 0) != 0, (String)"\u4efb\u52a1\u7684\u5206\u6b65\u6570\u5fc5\u987b\u5927\u4e8e\u96f6\u3002");
                    this.stepAmount = stepAmount;
                } else {
                    stepAmount = task.estimateStepAmount();
                    if (stepAmount <= 0) {
                        int iTemp = 0;
                        Iterator it = this.tasksStepAmountMap.values().iterator();
                        while (it.hasNext()) {
                            iTemp += ((Integer)it.next()).intValue();
                        }
                        stepAmount = iTemp / this.tasksStepAmountMap.size();
                        if (stepAmount <= 0) {
                            stepAmount = 1;
                        }
                    }
                }
                this.tasksStepAmountMap.put(task, stepAmount);
            }
            this.finishedStepAmount = 0;
            this.stepProgress = 0;
            this.currentTask.doTask();
        }
        finally {
            this.currentTask.doTaskAfter();
        }
        ++this.finishedSectionAmount;
        undealtTasks.remove(this.currentTask);
        this.finishedTasks.add(this.currentTask);
    }

    @Override
    public void addStepAmount(int stepAmount) {
        super.addStepAmount(stepAmount);
        this.tasksStepAmountMap.put(this.currentTask, this.stepAmount);
    }

    @Override
    protected void processProgress(Map item) {
        Object temp = null;
        int iTemp = 0;
        if (item.containsKey("task.step.amount") || item.containsKey("task.step.span")) {
            temp = item.get("task.step.amount");
            if (temp != null && temp instanceof Integer && (iTemp = ((Integer)temp).intValue()) > 0) {
                this.stepAmount += iTemp;
            }
            if (this.stepAmount > 0) {
                temp = item.get("task.step.span");
                if (temp != null && temp instanceof Integer && (iTemp = ((Integer)temp).intValue()) > 0) {
                    this.finishedStepAmount = this.finishedStepAmount + iTemp > this.stepAmount ? this.stepAmount : (this.finishedStepAmount += iTemp);
                }
                if ((iTemp = this.finishedStepAmount * 100 / this.stepAmount) > this.stepProgress) {
                    this.stepProgress = iTemp;
                    if (this.stepProgress >= 100) {
                        this.stepProgress = 99;
                    }
                }
            }
            if (this.sectionAmount > 0 && this.stepAmount > 0) {
                int totalAmount = 0;
                int totalFinishedAmount = 0;
                IProgressTask task2 = null;
                for (IProgressTask task2 : this.tasks) {
                    iTemp = (Integer)this.tasksStepAmountMap.get(task2);
                    totalAmount += iTemp;
                    if (this.finishedTasks.contains(task2)) {
                        totalFinishedAmount += iTemp;
                        continue;
                    }
                    if (task2 != this.currentTask) continue;
                    totalFinishedAmount += this.finishedStepAmount;
                }
                iTemp = totalFinishedAmount * 100 / totalAmount;
                if (iTemp > this.sectionProgress) {
                    this.sectionProgress = iTemp;
                    if (this.sectionProgress > 100) {
                        this.sectionProgress = 99;
                    }
                }
            }
            item.put("task.section.progress", this.sectionProgress);
            item.put("task.step.progress", this.stepProgress);
        }
    }

    @Override
    protected void processTime(Map item) {
        long currentTime = System.currentTimeMillis();
        if (item != null && item.size() > 0) {
            item.put("task.item.time", currentTime);
        }
        if (this.showTime) {
            this.usedTime = currentTime - this.startTime;
            if (this.sectionProgress > 0) {
                this.remainTime = this.usedTime * 100L / (long)this.sectionProgress - this.usedTime;
            }
            item.put("task.used.time", this.usedTime);
            item.put("task.remain.time", this.remainTime);
        }
    }
}

