/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.progress.client;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTextPane;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeBorders;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.progress.IProgressTask;
import com.kingdee.eas.ncm.common.progress.ProgressExampleTask;
import com.kingdee.eas.ncm.common.progress.ProgressException;
import com.kingdee.eas.ncm.common.progress.ProgressMsgLevelEnum;
import com.kingdee.eas.ncm.common.progress.ProgressUtils;
import com.kingdee.eas.ncm.common.progress.client.ProgressHintListener;
import com.kingdee.eas.ncm.common.progress.client.ProgressOptionUI;
import com.kingdee.eas.ncm.common.progress.client.ProgressRemoteTask;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.Assert;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;

public class ProgressHintUI
extends KDDialog
implements Runnable {
    private static Logger logger = Logger.getLogger(ProgressHintUI.class);
    private static final long serialVersionUID = -5606338525193482932L;
    protected static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss SSS >> ";
    private KDLabel lbSection;
    private KDProgressBar pbSection;
    private KDLabel lbStep;
    private KDProgressBar pbStep;
    private KDLabel lbUsedTime;
    private KDLabel lbRemainTime;
    private KDButton btnOption;
    private KDButton btnMsg;
    private KDButton btnOk;
    private KDButton btnCancel;
    private Box boxMsg;
    private KDWorkButton btnRefresh;
    private KDWorkButton btnCopy;
    private KDWorkButton btnClear;
    private KDTextPane tpMsg;
    private ProgressOptionUI optionUI = null;
    private int INIT_WIDTH = 460;
    private Dimension INIT_SIZE = null;
    private boolean doSection = false;
    private boolean doStep = false;
    private boolean showDetail = false;
    private int accessSpaceTime = 500;
    private boolean supportOption = false;
    private boolean supportPause = false;
    private boolean pausing = false;
    private boolean supportInterrupt = false;
    private boolean interrupting = false;
    private boolean showTime = false;
    private IProgressTask task = null;
    private Map param;
    private Thread taskThread = null;
    private ProgressHintListener listener;
    private List userObjects = new ArrayList();
    private boolean isRunning = false;

    public List getUserObjects() {
        return this.userObjects;
    }

    private ProgressHintUI(Frame owner, IProgressTask task, Map param) throws Exception {
        super(owner, "\u8fdb\u5ea6\u4fe1\u606f", true);
        this.init(task, param);
    }

    private ProgressHintUI(Dialog owner, IProgressTask task, Map param) throws Exception {
        super(owner, "\u8fdb\u5ea6\u4fe1\u606f", true);
        this.init(task, param);
    }

    private void init(IProgressTask task, Map param) throws Exception {
        Assert.that((task != null ? 1 : 0) != 0);
        this.task = task;
        this.param = param;
        task.init(param);
        Object temp = param.get("task.do.section");
        this.doSection = temp != null && temp instanceof Boolean ? (Boolean)temp : false;
        this.doStep = this.doSection ? true : ((temp = param.get("task.do.step")) != null && temp instanceof Boolean ? (Boolean)temp : true);
        temp = param.get("task.support.option");
        if (temp != null && temp instanceof Boolean) {
            this.supportOption = (Boolean)temp;
        }
        if ((temp = param.get("task.support.pause")) != null && temp instanceof Boolean) {
            this.supportPause = (Boolean)temp;
        }
        if ((temp = param.get("task.support.interrupt")) != null && temp instanceof Boolean) {
            this.supportInterrupt = (Boolean)temp;
        }
        if ((temp = param.get("task.show.time")) != null && temp instanceof Boolean) {
            this.showTime = (Boolean)temp;
        }
        if ((temp = param.get("task.listener")) != null && temp instanceof ProgressHintListener) {
            this.listener = (ProgressHintListener)temp;
        }
        param.remove("task.listener");
        this.jbInit();
    }

    protected void jbInit() {
        int totalHeight = 10;
        JPanel contentPane = new JPanel(){
            private static final long serialVersionUID = 3844671767898500030L;

            @Override
            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (e.isControlDown() && pressed) {
                    if (e.getKeyCode() == 69) {
                        e.consume();
                        ProgressHintUI.this.btnMsg.doClick();
                        return true;
                    }
                    if (e.getKeyCode() == 79 && ProgressHintUI.this.supportOption) {
                        e.consume();
                        ProgressHintUI.this.btnOption.doClick();
                        return true;
                    }
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }
        };
        this.setContentPane(contentPane);
        contentPane.setLayout(new BorderLayout());
        Box boxMain = Box.createVerticalBox();
        boxMain.setBorder(new EmptyBorder(10, 10, 10, 10));
        totalHeight += 10;
        contentPane.add((Component)boxMain, "Center");
        Box boxProgress = Box.createVerticalBox();
        boxProgress.setAlignmentX(0.0f);
        boxMain.add(boxProgress);
        int progressHeight = 0;
        if (this.doSection) {
            boxProgress.add(Box.createVerticalStrut(5));
            this.lbSection = new KDLabel("\u70b9\u51fb\u786e\u5b9a\u5c06\u5f00\u59cb\u6267\u884c\u4efb\u52a1");
            this.lbSection.setAlignmentX(0.0f);
            boxProgress.add((Component)this.lbSection);
            boxProgress.add(Box.createVerticalStrut(5));
            this.pbSection = new KDProgressBar();
            this.pbSection.setStringPainted(true);
            this.pbSection.setPreferredSize(new Dimension(200, 20));
            this.pbSection.setAlignmentX(0.0f);
            boxProgress.add((Component)this.pbSection);
            progressHeight += 50;
        }
        boxProgress.add(Box.createVerticalStrut(5));
        this.lbStep = new KDLabel("\u70b9\u51fb\u786e\u5b9a\u5c06\u5f00\u59cb\u6267\u884c\u4efb\u52a1");
        this.lbStep.setPreferredSize(new Dimension(200, 20));
        this.lbStep.setAlignmentX(0.0f);
        boxProgress.add((Component)this.lbStep);
        boxProgress.add(Box.createVerticalStrut(5));
        this.pbStep = new KDProgressBar();
        this.pbStep.setStringPainted(true);
        this.pbStep.setPreferredSize(new Dimension(200, 20));
        this.pbStep.setAlignmentX(0.0f);
        boxProgress.add((Component)this.pbStep);
        progressHeight += 50;
        boxProgress.add(Box.createVerticalStrut(5));
        Box timeBox = Box.createHorizontalBox();
        timeBox.setAlignmentX(0.0f);
        timeBox.add(Box.createHorizontalGlue());
        timeBox.add((Component)new KDLabel("\u7528\u65f6 "));
        this.lbUsedTime = new KDLabel("00:00:00");
        this.lbUsedTime.setPreferredSize(new Dimension(60, 20));
        this.lbUsedTime.setAlignmentX(1.0f);
        timeBox.add((Component)this.lbUsedTime);
        timeBox.add(Box.createHorizontalStrut(5));
        timeBox.add((Component)new KDLabel("\u4f59\u65f6 "));
        this.lbRemainTime = new KDLabel("00:00:00");
        this.lbRemainTime.setPreferredSize(new Dimension(60, 20));
        this.lbRemainTime.setAlignmentX(1.0f);
        timeBox.add((Component)this.lbRemainTime);
        if (this.showTime) {
            boxProgress.add(timeBox);
            progressHeight += 25;
        }
        boxProgress.add(Box.createVerticalStrut(5));
        Box progressBtnBox = Box.createHorizontalBox();
        progressBtnBox.setMaximumSize(new Dimension(Integer.MAX_VALUE, 22));
        progressBtnBox.setPreferredSize(new Dimension(400, 22));
        progressBtnBox.setMinimumSize(new Dimension(400, 22));
        progressBtnBox.setAlignmentX(0.0f);
        boxProgress.add(progressBtnBox);
        progressBtnBox.add(Box.createHorizontalGlue());
        progressBtnBox.add(Box.createHorizontalStrut(5));
        this.btnOption = new KDButton("\u9009\u9879");
        this.btnOption.setMargin(new Insets(1, 1, 1, 1));
        progressBtnBox.add((Component)this.btnOption);
        this.btnOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressHintUI.this.btnOptionActionPerformed(e);
            }
        });
        this.btnOption.setVisible(false);
        progressBtnBox.add(Box.createHorizontalStrut(5));
        this.btnMsg = new KDButton("\u4fe1\u606f");
        this.btnMsg.setMargin(new Insets(1, 1, 1, 1));
        progressBtnBox.add((Component)this.btnMsg);
        this.btnMsg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressHintUI.this.btnMsgActionPerformed(e);
            }
        });
        this.btnMsg.setVisible(false);
        progressBtnBox.add(Box.createHorizontalStrut(5));
        this.btnOk = new KDButton("\u786e\u5b9a");
        this.btnOk.setActionCommand("ok");
        this.btnOk.setMargin(new Insets(1, 1, 1, 1));
        progressBtnBox.add((Component)this.btnOk);
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressHintUI.this.btnOkActionPerformed(e);
            }
        });
        progressBtnBox.add(Box.createHorizontalStrut(5));
        this.btnCancel = new KDButton("\u53d6\u6d88");
        this.btnCancel.setActionCommand("close");
        this.btnCancel.setMargin(new Insets(1, 1, 1, 1));
        progressBtnBox.add((Component)this.btnCancel);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressHintUI.this.btnCancelActionPerformed(e);
            }
        });
        boxProgress.setMaximumSize(new Dimension(Integer.MAX_VALUE, progressHeight += 27));
        boxProgress.setPreferredSize(new Dimension(400, progressHeight));
        boxProgress.setMinimumSize(new Dimension(400, progressHeight));
        totalHeight += progressHeight;
        this.boxMsg = Box.createVerticalBox();
        this.boxMsg.setAlignmentX(0.0f);
        this.boxMsg.add(Box.createVerticalStrut(10));
        this.boxMsg.setVisible(false);
        boxMain.add(this.boxMsg);
        Box boxMsgContent = Box.createVerticalBox();
        boxMsgContent.setBorder(KingdeeBorders.createEditorBorder());
        this.boxMsg.add(boxMsgContent);
        boxMsgContent.add(Box.createVerticalStrut(2));
        KDToolBar msgToolBar = new KDToolBar(){
            private static final long serialVersionUID = 5751821512503771177L;

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(new Color(231, 237, 242));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        msgToolBar.setOpaque(true);
        msgToolBar.removeAll();
        msgToolBar.setLayout((LayoutManager)new BoxLayout((Container)msgToolBar, 0));
        msgToolBar.add(Box.createHorizontalGlue());
        msgToolBar.setMaximumSize(new Dimension(Integer.MAX_VALUE, 22));
        msgToolBar.setPreferredSize(new Dimension(400, 22));
        msgToolBar.setMinimumSize(new Dimension(400, 22));
        boxMsgContent.add((Component)msgToolBar);
        this.btnRefresh = new KDWorkButton();
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnRefresh.setToolTipText("\u5237\u65b0");
        msgToolBar.add((Component)this.btnRefresh);
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressHintUI.this.btnRefreshActionPerformed(e);
            }
        });
        this.btnCopy = new KDWorkButton();
        this.btnCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        this.btnCopy.setToolTipText("\u590d\u5236");
        this.btnCopy.setMargin(new Insets(1, 1, 1, 1));
        msgToolBar.add((Component)this.btnCopy);
        this.btnCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressHintUI.this.btnCopyActionPerformed(e);
            }
        });
        this.btnClear = new KDWorkButton();
        this.btnClear.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnClear.setToolTipText("\u6e05\u7a7a");
        this.btnClear.setMargin(new Insets(1, 1, 1, 1));
        this.btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressHintUI.this.btnClearActionPerformed(e);
            }
        });
        msgToolBar.add((Component)this.btnClear);
        boxMsgContent.add(Box.createVerticalStrut(2));
        KDSeparator sp = new KDSeparator();
        sp.setPreferredSize(new Dimension(1, 2));
        sp.setMaximumSize(new Dimension(Integer.MAX_VALUE, 2));
        boxMsgContent.add((Component)sp);
        KDScrollPane scrollPane = new KDScrollPane();
        this.tpMsg = new KDTextPane();
        this.tpMsg.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        this.tpMsg.setEditable(false);
        this.tpMsg.setBackground(new Color(231, 237, 242));
        scrollPane.setViewportView((Component)this.tpMsg);
        boxMsgContent.add((Component)scrollPane);
        this.setResizable(true);
        this.INIT_SIZE = new Dimension(this.INIT_WIDTH, totalHeight);
        ((JPanel)this.getContentPane()).setPreferredSize(this.INIT_SIZE);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (ProgressHintUI.this.btnCancel.isEnabled() && "close".equals(ProgressHintUI.this.btnCancel.getActionCommand())) {
                    ProgressHintUI.this.setVisible(false);
                    ProgressHintUI.this.dispose();
                }
            }
        });
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void btnOptionActionPerformed(ActionEvent e) {
        if (this.optionUI == null) {
            this.optionUI = ProgressOptionUI.getInstance((Component)((Object)this), true, this.param);
        }
        this.optionUI.setEditable(!this.isRunning);
        this.optionUI.setVisible(true);
        this.task.init(this.param);
    }

    private void btnMsgActionPerformed(ActionEvent e) {
        if (this.showDetail) {
            this.showDetail = false;
            Dimension oldSize = ((JPanel)this.getContentPane()).getSize();
            Dimension newSize = new Dimension();
            newSize.width = oldSize.width;
            newSize.height = oldSize.height > this.INIT_SIZE.height ? this.INIT_SIZE.height : oldSize.height;
            ((JPanel)this.getContentPane()).setPreferredSize(newSize);
            this.boxMsg.setVisible(false);
            this.pack();
        } else {
            this.showDetail = true;
            Dimension oldSize = ((JPanel)this.getContentPane()).getSize();
            Dimension newSize = new Dimension();
            newSize.width = oldSize.width;
            newSize.height = oldSize.height > this.INIT_SIZE.height + 200 ? oldSize.height : this.INIT_SIZE.height + 200;
            ((JPanel)this.getContentPane()).setPreferredSize(newSize);
            this.boxMsg.setVisible(true);
            this.pack();
        }
    }

    private synchronized void btnOkActionPerformed(ActionEvent e) {
        if (this.btnOk.isEnabled()) {
            if ("ok".equalsIgnoreCase(this.btnOk.getActionCommand()) || "retry".equals(this.btnOk.getActionCommand())) {
                this.taskThread = new Thread(this);
                this.taskThread.start();
            } else if ("pause".equals(this.btnOk.getActionCommand())) {
                this.pausing = true;
                this.taskThread.interrupt();
            }
        }
    }

    private synchronized void btnCancelActionPerformed(ActionEvent e) {
        if ("interrupt".equals(this.btnCancel.getActionCommand())) {
            this.btnCancel.setEnabled(false);
            this.interrupting = true;
            this.taskThread.interrupt();
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    private synchronized void btnRefreshActionPerformed(ActionEvent e) {
        if (this.taskThread != null) {
            this.taskThread.interrupt();
        }
    }

    private void btnCopyActionPerformed(ActionEvent e) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection tText = new StringSelection(this.tpMsg.getText());
        clipboard.setContents(tText, null);
    }

    private void btnClearActionPerformed(ActionEvent e) {
        this.tpMsg.setText("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.isRunning = true;
        this.btnOk.setEnabled(false);
        this.btnCancel.setEnabled(false);
        try {
            if (this.listener != null) {
                this.listener.beforeTaskExecute(this.param);
            }
        }
        catch (AbortException e) {
            this.btnOk.setEnabled(true);
            this.btnCancel.setEnabled(true);
            this.isRunning = false;
            return;
        }
        catch (Throwable t) {
            HashMap item = new HashMap();
            ProgressUtils.error(item, null, t);
            this.log(item);
            if (!this.showDetail) {
                this.btnMsg.doClick();
            }
            this.btnOk.setEnabled(true);
            this.btnCancel.setEnabled(true);
            this.isRunning = false;
            return;
        }
        int iTemp = 0;
        int stepProcess = 0;
        int sectionProcess = 0;
        this.task.execute();
        try {
            Thread.sleep(this.accessSpaceTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.supportInterrupt) {
            this.btnCancel.setActionCommand("interrupt");
            this.btnCancel.setEnabled(true);
        } else {
            this.btnCancel.setEnabled(false);
        }
        boolean goOn = true;
        int accessWaitTime = 500;
        List result = null;
        boolean retry = false;
        try {
            while (true) {
                if ((result = this.task.query()) == null || result.size() <= 0) {
                    try {
                        Thread.sleep(accessWaitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if ((accessWaitTime += accessWaitTime) <= 120000) continue;
                    accessWaitTime = this.accessSpaceTime;
                    continue;
                }
                accessWaitTime = this.accessSpaceTime;
                for (HashMap item : result) {
                    Object temp;
                    if (this.doStep) {
                        temp = item.get("task.step.name");
                        if (temp != null) {
                            this.lbStep.setText(temp.toString());
                        }
                        if ((temp = item.get("task.step.progress")) != null && temp instanceof Integer) {
                            iTemp = (Integer)temp;
                            stepProcess = iTemp <= 0 ? 0 : (iTemp >= 100 ? 100 : iTemp);
                        }
                        this.pbStep.setValue(stepProcess);
                    }
                    if (this.doSection) {
                        temp = item.get("task.section.name");
                        if (temp != null) {
                            this.lbSection.setText(temp.toString());
                        }
                        if ((temp = item.get("task.section.progress")) != null && temp instanceof Integer) {
                            iTemp = (Integer)temp;
                            sectionProcess = iTemp <= 0 ? 0 : (iTemp >= 100 ? 100 : iTemp);
                        }
                        this.pbSection.setValue(sectionProcess);
                    }
                    this.showTime(item);
                    this.log(item);
                    temp = item.get("task.user.object");
                    if (temp != null) {
                        this.userObjects.add(temp);
                    }
                    if ((temp = item.get("task.finished.status")) == null) continue;
                    if ((Integer)temp == 1) {
                        if (this.doStep) {
                            stepProcess = 100;
                            this.pbStep.setValue(stepProcess);
                        }
                        if (this.doSection) {
                            sectionProcess = 100;
                            this.pbSection.setValue(stepProcess);
                        }
                    }
                    goOn = false;
                }
                if (!goOn) {
                    break;
                }
                if (this.interrupting) {
                    try {
                        this.task.interrupt();
                    }
                    catch (Throwable t) {
                        HashMap item;
                        item = new HashMap();
                        ProgressUtils.error(item, null, t);
                        this.log(item);
                    }
                    finally {
                        this.interrupting = false;
                    }
                    continue;
                }
                try {
                    Thread.sleep(this.accessSpaceTime);
                }
                catch (InterruptedException t) {}
            }
        }
        catch (ProgressException e) {
            if (ProgressException.SERVER_BUSY.getCode().equals(e.getSubCode())) {
                String msg = e.getMessage();
                if (this.doSection) {
                    this.lbSection.setText(msg);
                } else {
                    this.lbStep.setText(msg);
                }
                this.info(msg);
                retry = true;
            } else {
                ExceptionHandler.handle((Throwable)((Object)e));
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (Throwable t) {
            HashMap item = new HashMap();
            ProgressUtils.error(item, null, t);
            this.log(item);
            if (!this.showDetail) {
                this.btnMsg.doClick();
            }
        }
        finally {
            block61: {
                try {
                    if (this.listener != null) {
                        this.listener.afterTaskExecute(this.param, this.userObjects);
                    }
                }
                catch (Throwable t) {
                    HashMap item = new HashMap();
                    ProgressUtils.error(item, null, t);
                    this.log(item);
                    if (this.showDetail) break block61;
                    this.btnMsg.doClick();
                }
            }
        }
        this.isRunning = false;
        if (retry) {
            this.btnOk.setActionCommand("retry");
            this.btnOk.setText("\u91cd\u8bd5");
            this.btnOk.setEnabled(true);
            this.btnCancel.setActionCommand("close");
            this.btnCancel.setText("\u53d6\u6d88");
            this.btnCancel.setEnabled(true);
        } else {
            this.btnCancel.setActionCommand("close");
            this.btnCancel.setEnabled(true);
            this.btnCancel.setText("\u5173\u95ed");
        }
    }

    private void info(String msg) {
        HashMap<String, String> item = new HashMap<String, String>();
        item.put("task.msg", msg);
        this.log(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(Map item) {
        String msg = (String)item.get("task.msg");
        String msgex = (String)item.get("task.msg.exception");
        if (!StringUtils.isEmpty((String)msg) || !StringUtils.isEmpty((String)msgex)) {
            String levelName;
            int level = 20;
            Object temp = item.get("task.msg.level");
            if (temp != null && temp instanceof Integer) {
                level = (Integer)temp;
            }
            Color color = Color.BLACK;
            if (10 == level) {
                levelName = ProgressMsgLevelEnum.DEBUG.getName();
                color = Color.GRAY;
            } else if (20 == level) {
                levelName = ProgressMsgLevelEnum.INFO.getName();
                color = Color.BLACK;
            } else if (30 == level) {
                levelName = ProgressMsgLevelEnum.WARN.getName();
                color = Color.YELLOW;
            } else if (40 == level) {
                levelName = ProgressMsgLevelEnum.ERROR.getName();
                color = Color.RED;
            } else {
                levelName = ProgressMsgLevelEnum.INFO.getName();
                color = Color.BLACK;
            }
            levelName = levelName + " ";
            String date = "";
            temp = item.get("task.item.time");
            if (temp != null && temp instanceof Long) {
                date = new SimpleDateFormat(DATE_FORMAT).format(new Date((Long)temp));
            }
            date = date + levelName;
            SimpleAttributeSet attrset = new SimpleAttributeSet();
            StyleConstants.setForeground(attrset, color);
            Document docs = this.tpMsg.getDocument();
            try {
                ProgressHintUI progressHintUI = this;
                synchronized (progressHintUI) {
                    if (!StringUtils.isEmpty((String)msg)) {
                        docs.insertString(docs.getLength(), date + msg + "\n", attrset);
                    }
                    if (!StringUtils.isEmpty((String)msgex)) {
                        docs.insertString(docs.getLength(), date + msgex + "\n", attrset);
                    }
                }
            }
            catch (BadLocationException ble) {
                logger.error((Object)"", (Throwable)ble);
            }
            this.tpMsg.setSelectionStart(this.tpMsg.getDocument().getLength());
        }
    }

    private void showTime(Map item) {
        if (!this.showTime) {
            return;
        }
        if (item.containsKey("task.used.time") && item.containsKey("task.remain.time")) {
            long lTemp = 0L;
            Object temp = item.get("task.used.time");
            if (temp != null && temp instanceof Long && (lTemp = ((Long)temp).longValue()) < 0L) {
                lTemp = 0L;
            }
            String usedTime = ProgressUtils.calTime(lTemp);
            temp = item.get("task.remain.time");
            if (temp != null && temp instanceof Long && (lTemp = ((Long)temp).longValue()) < 0L) {
                lTemp = 0L;
            }
            String remainTime = ProgressUtils.calTime(lTemp);
            this.lbUsedTime.setText(usedTime);
            this.lbRemainTime.setText(remainTime);
        }
    }

    public static ProgressHintUI showProgressHintUI(Map param) throws Exception {
        return ProgressHintUI.showProgressHintUI(null, (IProgressTask)null, param);
    }

    public static ProgressHintUI showProgressHintUI(Component comp, Map param) throws Exception {
        return ProgressHintUI.showProgressHintUI(comp, (IProgressTask)null, param);
    }

    public static ProgressHintUI showProgressHintUI(Component comp, String taskClazzName, Map param) throws Exception {
        if (param == null) {
            param = new HashMap<String, String>();
        }
        param.put("task.class", taskClazzName);
        return ProgressHintUI.showProgressHintUI(comp, (IProgressTask)null, param);
    }

    public static ProgressHintUI showProgressHintUI(Component comp, IProgressTask task, Map param) throws Exception {
        Window ownerWindow;
        if (task == null) {
            task = new ProgressRemoteTask();
        }
        ProgressHintUI hintUI = (ownerWindow = ComponentUtil.getOwnerWindow((Component)comp)) instanceof Frame ? new ProgressHintUI((Frame)ownerWindow, task, param) : (ownerWindow instanceof Dialog ? new ProgressHintUI((Dialog)ownerWindow, task, param) : new ProgressHintUI((Frame)null, task, param));
        hintUI.show();
        return hintUI;
    }

    public static void test() throws Exception {
        HashMap<String, Boolean> param = new HashMap<String, Boolean>();
        param.put("task.support.option", Boolean.TRUE);
        param.put("task.support.pause", Boolean.TRUE);
        param.put("task.support.interrupt", Boolean.TRUE);
        param.put("task.show.time", Boolean.TRUE);
        param.put("task.do.section", Boolean.TRUE);
        ProgressHintUI.showProgressHintUI(null, "com.kingdee.eas.ncm.common.progress.ProgressExampleTask", param);
    }

    public static void main(String[] args) throws Exception {
        KingdeeLookAndFeel lnf = new KingdeeLookAndFeel();
        UIManager.setLookAndFeel((LookAndFeel)lnf);
        HashMap<String, Boolean> param = new HashMap<String, Boolean>();
        param.put("task.support.option", Boolean.TRUE);
        param.put("task.support.pause", Boolean.TRUE);
        param.put("task.support.interrupt", Boolean.TRUE);
        param.put("task.show.time", Boolean.TRUE);
        param.put("task.do.section", Boolean.TRUE);
        ProgressHintUI.showProgressHintUI(null, new ProgressExampleTask(), param);
    }
}

