/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.progress.client;

import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTextPane;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeBorders;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel;
import com.kingdee.eas.ncm.common.progress.client.ProgressHintProcessor;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class ProgressMessageUI
extends KDDialog {
    private static final long serialVersionUID = -6141978462052772188L;
    private Box boxMsg;
    private KDWorkButton btnRefresh;
    private KDWorkButton btnCopy;
    private KDWorkButton btnClear;
    private KDTextPane tpMsg = null;
    private ProgressHintProcessor processor = null;

    public static ProgressMessageUI getInstance(Component owner, boolean modal) {
        ProgressMessageUI messageUI = null;
        Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
        messageUI = ownerWindow instanceof Frame ? new ProgressMessageUI((Frame)ownerWindow, "\u8fdb\u5ea6\u6d88\u606f", modal) : (ownerWindow instanceof Dialog ? new ProgressMessageUI((Dialog)ownerWindow, "\u8fdb\u5ea6\u6d88\u606f", modal) : new ProgressMessageUI((Frame)null, "\u8fdb\u5ea6\u6d88\u606f", modal));
        messageUI.setSize(400, 240);
        messageUI.setResizable(true);
        messageUI.setLocationRelativeTo(null);
        return messageUI;
    }

    private ProgressMessageUI(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.jbInit();
    }

    private ProgressMessageUI(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
        this.jbInit();
    }

    public KDTextPane getMessageComponent() {
        return this.tpMsg;
    }

    public synchronized void setProcessor(ProgressHintProcessor processor) {
        this.processor = processor;
    }

    private void jbInit() {
        JPanel contentPane = (JPanel)this.getContentPane();
        Box boxMain = Box.createVerticalBox();
        boxMain.setBorder(new EmptyBorder(10, 10, 10, 10));
        contentPane.add((Component)boxMain, "Center");
        this.boxMsg = Box.createVerticalBox();
        this.boxMsg.setAlignmentX(0.0f);
        boxMain.add(this.boxMsg);
        Box boxMsgContent = Box.createVerticalBox();
        boxMsgContent.setBorder(KingdeeBorders.createEditorBorder());
        this.boxMsg.add(boxMsgContent);
        boxMsgContent.add(Box.createVerticalStrut(2));
        KDToolBar msgToolBar = new KDToolBar(){
            private static final long serialVersionUID = 5751821512503771177L;

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(new Color(231, 237, 242));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        msgToolBar.setOpaque(true);
        msgToolBar.removeAll();
        msgToolBar.setLayout((LayoutManager)new BoxLayout((Container)msgToolBar, 0));
        msgToolBar.add(Box.createHorizontalGlue());
        msgToolBar.setMaximumSize(new Dimension(Integer.MAX_VALUE, 22));
        msgToolBar.setPreferredSize(new Dimension(400, 22));
        msgToolBar.setMinimumSize(new Dimension(400, 22));
        boxMsgContent.add((Component)msgToolBar);
        this.btnRefresh = new KDWorkButton();
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnRefresh.setToolTipText("\u5237\u65b0");
        msgToolBar.add((Component)this.btnRefresh);
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressMessageUI.this.btnRefreshActionPerformed(e);
            }
        });
        this.btnCopy = new KDWorkButton();
        this.btnCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        this.btnCopy.setToolTipText("\u590d\u5236");
        this.btnCopy.setMargin(new Insets(1, 1, 1, 1));
        msgToolBar.add((Component)this.btnCopy);
        this.btnCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressMessageUI.this.btnCopyActionPerformed(e);
            }
        });
        this.btnClear = new KDWorkButton();
        this.btnClear.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnClear.setToolTipText("\u6e05\u7a7a");
        this.btnClear.setMargin(new Insets(1, 1, 1, 1));
        this.btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressMessageUI.this.btnClearActionPerformed(e);
            }
        });
        msgToolBar.add((Component)this.btnClear);
        boxMsgContent.add(Box.createVerticalStrut(2));
        KDSeparator sp = new KDSeparator();
        sp.setPreferredSize(new Dimension(1, 2));
        sp.setMaximumSize(new Dimension(Integer.MAX_VALUE, 2));
        boxMsgContent.add((Component)sp);
        KDScrollPane scrollPane = new KDScrollPane();
        this.tpMsg = new KDTextPane();
        this.tpMsg.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        this.tpMsg.setEditable(false);
        this.tpMsg.setBackground(new Color(231, 237, 242));
        scrollPane.setViewportView((Component)this.tpMsg);
        boxMsgContent.add((Component)scrollPane);
    }

    private synchronized void btnRefreshActionPerformed(ActionEvent e) {
        if (this.processor != null) {
            this.processor.refresh();
        }
    }

    private void btnCopyActionPerformed(ActionEvent e) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection tText = new StringSelection(this.tpMsg.getText());
        clipboard.setContents(tText, null);
    }

    private void btnClearActionPerformed(ActionEvent e) {
        this.tpMsg.setText("");
    }

    public static void main(String[] args) throws Exception {
        KingdeeLookAndFeel lnf = new KingdeeLookAndFeel();
        UIManager.setLookAndFeel((LookAndFeel)lnf);
        ProgressMessageUI messageUI = ProgressMessageUI.getInstance(null, true);
        messageUI.setVisible(true);
    }
}

