/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.task.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.client.AbstractHidedMenuItem;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ncm.cal.client.LogReportPickUI;
import com.kingdee.eas.ncm.common.task.CostTaskCollection;
import com.kingdee.eas.ncm.common.task.CostTaskEntryInfo;
import com.kingdee.eas.ncm.common.task.CostTaskFactory;
import com.kingdee.eas.ncm.common.task.CostTaskInfo;
import com.kingdee.eas.ncm.common.task.CostTaskResultEnum;
import com.kingdee.eas.ncm.common.task.CostTaskUtils;
import com.kingdee.eas.ncm.common.task.ICostTask;
import com.kingdee.eas.ncm.common.task.client.AbstractCostTaskEditUI;
import com.kingdee.eas.ncm.common.task.client.ProgressRenderer;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class CostTaskEditUI
extends AbstractCostTaskEditUI
implements KDTMouseListener,
Runnable {
    private static final Logger logger = CoreUIObject.getLogger(CostTaskEditUI.class);
    private static final ImageIcon iconRunning = new ImageIcon(CostTaskEditUI.class.getResource("/com/kingdee/eas/ncm/common/resource/pic/ncm_running.png"));
    private ProgressRenderer progressRenderer = null;
    private Icon successIcon = EASResource.getIcon((String)"imgTable_success");
    private Icon failureIcon = EASResource.getIcon((String)"imgTable_failure");
    private Icon warnIcon = EASResource.getIcon((String)"imgTable_high");
    private Thread refreshThread = null;
    private Object synObj = new Object();
    private boolean running = false;
    private CostTaskCollection costTasks = null;
    private CostTaskInfo costTask = null;
    private String taskId = null;
    private static final int Max_Interval_Time = 5000;
    private static final int Min_Interval_Time = 200;
    private int intervalTime = 200;
    private int progress = 0;

    public CostTaskEditUI() throws Exception {
        this.lbPicture.setIcon((Icon)iconRunning);
        this.pgHint.setStringPainted(true);
        this.progressRenderer = new ProgressRenderer();
        this.kdtEntries.checkParsed();
        this.kdtEntries.getStyleAttributes().setLocked(true);
        this.kdtEntries.addKDTMouseListener((KDTMouseListener)this);
        this.kdtEntries.getColumn("usedTime").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)2));
        this.pkBeginTime.setDatePattern("yyyy-MM-dd,HH:mm:ss");
        this.pkEndTime.setDatePattern("yyyy-MM-dd,HH:mm:ss");
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtPeriod.setEditFormat("$periodYear$$periodNumber$");
        this.prmtPeriod.setCommitFormat("periodYear$$periodNumber$");
        this.pkBeginTime.setValue(null);
        this.pkEndTime.setValue(null);
        this.costTasks = (CostTaskCollection)((Object)this.getUIContext().get("costTasks"));
        if (this.costTasks == null) {
            this.costTasks = new CostTaskCollection();
        }
        this.menuFile.add((JMenuItem)new AbstractHidedMenuItem("ctrl E"){

            public void action_actionPerformed() {
                CostTaskEditUI.this.showCostTaskExcepeion();
            }
        });
    }

    private void showCostTaskExcepeion() {
        try {
            IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"costTask", (Object)this.costTask);
            IUIWindow wnd = fy.create("com.kingdee.eas.ncm.common.task.client.CostTaskExceptionUI", (Map)uiContext);
            wnd.show();
        }
        catch (UIException e) {
            SysUtil.abort((Throwable)e);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.costTasks.size() <= 1) {
            this.actionFirst.setEnabled(false);
            this.actionPrev.setEnabled(false);
            this.actionNext.setEnabled(false);
            this.actionLast.setEnabled(false);
        }
        if (this.costTasks.size() > 0) {
            this.costTask = this.costTasks.get(0);
        }
        if (this.costTasks.size() <= 1) {
            this.refresh();
        } else {
            this.actionFirst_actionPerformed(null);
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refresh();
    }

    @Override
    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        this.costTask = this.costTasks.get(0);
        this.actionFirst.setEnabled(false);
        this.actionPrev.setEnabled(false);
        this.actionNext.setEnabled(true);
        this.actionLast.setEnabled(true);
        this.refresh();
    }

    @Override
    public void actionPrev_actionPerformed(ActionEvent e) throws Exception {
        if (this.costTask == null) {
            return;
        }
        int index = this.costTasks.indexOf(this.costTask);
        if (--index < 0) {
            return;
        }
        this.costTask = this.costTasks.get(index);
        if (index == 0) {
            this.actionFirst.setEnabled(false);
            this.actionPrev.setEnabled(false);
        } else {
            this.actionFirst.setEnabled(true);
            this.actionPrev.setEnabled(true);
        }
        this.actionNext.setEnabled(true);
        this.actionLast.setEnabled(true);
        this.refresh();
    }

    @Override
    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        if (this.costTask == null) {
            return;
        }
        int index = this.costTasks.indexOf(this.costTask);
        if (++index >= this.costTasks.size()) {
            return;
        }
        this.costTask = this.costTasks.get(index);
        this.actionFirst.setEnabled(true);
        this.actionPrev.setEnabled(true);
        if (index == this.costTasks.size() - 1) {
            this.actionNext.setEnabled(false);
            this.actionLast.setEnabled(false);
        } else {
            this.actionNext.setEnabled(true);
            this.actionLast.setEnabled(true);
        }
        this.refresh();
    }

    @Override
    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        this.costTask = this.costTasks.get(this.costTasks.size() - 1);
        this.actionFirst.setEnabled(true);
        this.actionPrev.setEnabled(true);
        this.actionNext.setEnabled(false);
        this.actionLast.setEnabled(false);
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        this.running = false;
        if (this.refreshThread != null) {
            this.refreshThread.interrupt();
        }
        Object object = this.synObj;
        synchronized (object) {
            this.running = true;
            this.refreshThread = new Thread(this);
            this.refreshThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.synObj;
        synchronized (object) {
            this.doRefresh();
        }
    }

    private void doRefresh() {
        this.intervalTime = 200;
        this.lbHint.setText("");
        this.pgHint.setValue(0);
        this.kdtEntries.removeRows();
        try {
            if (this.costTask == null) {
                return;
            }
            EntityViewInfo view = new EntityViewInfo();
            String companyId = this.costTask.getCompany().getId().toString();
            String periodId = this.costTask.getPeriod().getId().toString();
            String taskNumber = this.costTask.getNumber();
            String taskId = this.costTask.getId().toString();
            FilterInfo filter = new FilterInfo();
            if (companyId != null && periodId != null && taskNumber != null) {
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
                filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)periodId));
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)taskNumber));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)taskId));
            }
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("name");
            selector.add("subSys");
            selector.add("catagory");
            selector.add("function");
            selector.add("progress");
            selector.add("status");
            selector.add("result");
            selector.add("beginTime");
            selector.add("endTime");
            selector.add("company.id");
            selector.add("company.number");
            selector.add("company.name");
            selector.add("period.id");
            selector.add("period.periodYear");
            selector.add("period.periodNumber");
            selector.add("entries.*");
            SorterItemCollection sorter = new SorterItemCollection();
            sorter.add(new SorterItemInfo("entries.typeSeq"));
            sorter.add(new SorterItemInfo("entries.seq"));
            view.setSelector(selector);
            view.setFilter(filter);
            view.setSorter(sorter);
            ICostTask iCostTask = CostTaskFactory.getRemoteInstance();
            while (this.running) {
                CostTaskCollection coll = iCostTask.getCostTaskCollection(view);
                CostTaskInfo costTask = null;
                if (coll.size() > 0) {
                    costTask = coll.get(0);
                    if (this.taskId == null) {
                        this.taskId = costTask.getId().toString();
                    } else if (!this.taskId.equals(costTask.getId().toString())) {
                        this.taskId = costTask.getId().toString();
                        this.lbHint.setText("");
                        this.pgHint.setValue(0);
                        this.kdtEntries.removeRows();
                    }
                    this.prmtCompany.setValue((Object)costTask.getCompany());
                    this.prmtPeriod.setValue((Object)costTask.getPeriod());
                    this.setUITitle(costTask.getName() + "\u8fdb\u5ea6");
                    this.fillCostTask(costTask);
                    if (costTask.getStatus().getValue() == 0) {
                        this.lbHint.setText(costTask.getName() + "\u672a\u5f00\u59cb\u3002");
                    } else if (costTask.getStatus().getValue() == 1) {
                        this.lbHint.setText(costTask.getName() + "\u6b63\u5728\u6392\u961f\uff0c\u8bf7\u7a0d\u5019...");
                    } else if (costTask.getStatus().getValue() == 2) {
                        this.lbHint.setText(costTask.getName() + "\u6b63\u5728\u8fdb\u884c\uff0c\u8bf7\u7a0d\u5019...");
                    } else if (costTask.getStatus().getValue() == 9) {
                        if (costTask.getResult().getValue() == 1) {
                            this.lbHint.setText(costTask.getName() + "\u6210\u529f\uff01");
                        } else if (costTask.getResult().getValue() == 3) {
                            this.lbHint.setText(costTask.getName() + "\u6210\u529f\uff01");
                        } else {
                            this.lbHint.setText(costTask.getName() + "\u5931\u8d25\u3002");
                        }
                    } else {
                        this.lbHint.setText("");
                    }
                    this.pgHint.setValue(costTask.getProgress());
                    this.pkBeginTime.setValue((Object)costTask.getBeginTime());
                    if (costTask.getStatus().getValue() == 9) {
                        this.pkEndTime.setValue((Object)costTask.getEndTime());
                    } else {
                        this.pkEndTime.setValue(null);
                    }
                    if (costTask.getProgress() != this.progress) {
                        this.progress = costTask.getProgress();
                        this.intervalTime = 200;
                    }
                    if (this.intervalTime < 5000) {
                        Thread.sleep(this.intervalTime);
                        this.intervalTime = (int)((double)this.intervalTime + (double)this.intervalTime * 0.5);
                        continue;
                    }
                    Thread.sleep(5000L);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException view) {
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void fillCostTask(CostTaskInfo costTask) {
        boolean addRow = false;
        for (int i = 0; i < costTask.getEntries().size(); ++i) {
            CostTaskEntryInfo newItem = costTask.getEntries().get(i);
            if (this.kdtEntries.getRowCount() == 0) {
                this.addRow(newItem, i);
                addRow = true;
                continue;
            }
            if (this.kdtEntries.getRowCount() < i + 1) {
                this.addRow(newItem, i);
                addRow = true;
                continue;
            }
            CostTaskEntryInfo oldItem = (CostTaskEntryInfo)this.kdtEntries.getCell(i, "name").getValue();
            if (newItem.getId().equals((Object)oldItem.getId())) {
                long usedTime;
                newItem.setExpanded(oldItem.isExpanded());
                this.kdtEntries.getCell(i, "name").setValue((Object)newItem);
                this.kdtEntries.getCell(i, "progressInfo").setValue((Object)newItem.getProgressInfo());
                if (newItem.getNumber() == null || !newItem.getNumber().equals("sum")) {
                    this.kdtEntries.getCell(i, "iconResult").setValue((Object)newItem.getResult());
                    this.kdtEntries.getCell(i, "textResult").setValue((Object)newItem.getResult());
                }
                BigDecimal b = null;
                if (newItem.getBeginTime() != null && newItem.getEndTime() != null && (b = new BigDecimal(usedTime = newItem.getEndTime().getTime() - newItem.getBeginTime().getTime()).divide(new BigDecimal(1000), 2, 4)).compareTo(SysConstant.BIGZERO) < 0) {
                    b = SysConstant.BIGZERO;
                }
                this.kdtEntries.getCell(i, "usedTime").setValue(b);
                this.kdtEntries.getCell(i, "report").setValue((Object)newItem);
                continue;
            }
            this.addRow(newItem, i);
            addRow = true;
        }
        if (addRow) {
            this.kdtEntries.revalidate();
        }
    }

    private void addRow(CostTaskEntryInfo item, int index) {
        double usedTime;
        IRow row = this.kdtEntries.addRow(index);
        row.getCell("name").setValue((Object)item);
        row.getCell("name").setRenderer((IBasicRender)this.progressRenderer);
        row.getCell("progressInfo").setValue((Object)item.getProgressInfo());
        if (item.getNumber() != null && item.getNumber().equals("sum")) {
            row.getCell("iconResult").setValue((Object)"");
            row.getCell("textResult").setValue((Object)"");
        } else {
            row.getCell("iconResult").setValue((Object)item.getResult());
            row.getCell("iconResult").setRenderer((IBasicRender)new IconRender());
            row.getCell("textResult").setValue((Object)item.getResult());
            row.getCell("textResult").setRenderer((IBasicRender)new TextRender());
        }
        BigDecimal b = null;
        if (item.getBeginTime() != null && item.getEndTime() != null && (b = new BigDecimal(usedTime = (double)(item.getEndTime().getTime() - item.getBeginTime().getTime())).divide(new BigDecimal(1000), 2, 4)).compareTo(SysConstant.BIGZERO) < 0) {
            b = SysConstant.BIGZERO;
        }
        row.getCell("usedTime").setValue(b);
        if (item.getBackground() != 0) {
            row.getStyleAttributes().setBackground(new Color(item.getBackground()));
        }
        row.getCell("report").setRenderer((IBasicRender)new ReportRenderer());
        row.getCell("report").setValue((Object)item);
        boolean hide = false;
        for (int parentIndex = index - 1; parentIndex >= 0; --parentIndex) {
            CostTaskEntryInfo parentItem = (CostTaskEntryInfo)this.kdtEntries.getCell(parentIndex, "name").getValue();
            if (parentItem.getLevel() >= item.getLevel()) continue;
            hide = !parentItem.isExpanded();
            break;
        }
        if (item.getLevel() > 0) {
            item.setExpanded(false);
        }
        row.getStyleAttributes().setHided(hide);
    }

    public void tableClicked(KDTMouseEvent e) {
        int rowIndex = e.getRowIndex();
        int columnIndex = e.getColIndex();
        if (columnIndex != this.kdtEntries.getColumn("name").getColumnIndex()) {
            return;
        }
        IColumn column = this.kdtEntries.getColumn(columnIndex);
        if (column == null) {
            return;
        }
        if (e.getClickCount() == 1 && e.getType() == 1) {
            this.cellClicked(rowIndex, columnIndex, e.getX(), e.getY());
        }
    }

    private void cellClicked(int row, int column, int x, int y) {
        CostTaskEntryInfo dataItem = (CostTaskEntryInfo)this.kdtEntries.getRow(row).getCell(column).getValue();
        if (this.progressRenderer.inRect(dataItem, x, y)) {
            try {
                this.doExpand(dataItem, row, column);
            }
            catch (Exception e) {
                logger.info((Object)e);
            }
        }
    }

    private void doExpand(CostTaskEntryInfo hiberarchyObject, int rowIndex, int column) throws Exception {
        int rowCount = this.kdtEntries.getExpandedRowCount();
        if (hiberarchyObject.isLeaf()) {
            return;
        }
        this.kdtEntries.setRefresh(false);
        if (hiberarchyObject.isExpanded()) {
            IRow row2 = null;
            Object obj = null;
            CostTaskEntryInfo dataItem2 = null;
            for (int i = rowIndex + 1; i < rowCount; ++i) {
                row2 = this.kdtEntries.getRow(i);
                obj = row2.getCell(column).getValue();
                if (obj == null) {
                    row2.getStyleAttributes().setHided(true);
                    continue;
                }
                if (!(obj instanceof CostTaskEntryInfo)) continue;
                dataItem2 = (CostTaskEntryInfo)obj;
                if (dataItem2.getLevel() <= hiberarchyObject.getLevel()) break;
                row2.getStyleAttributes().setHided(true);
                hiberarchyObject.setExpanded(false);
            }
            hiberarchyObject.setExpanded(false);
        } else {
            this.expandRow(rowIndex, column);
            hiberarchyObject.setExpanded(true);
        }
        this.kdtEntries.setRefresh(true);
        this.kdtEntries.revalidate();
        this.kdtEntries.repaint();
    }

    private int expandRow(int rowIndex, int column) {
        IRow row = this.kdtEntries.getRow(rowIndex);
        CostTaskEntryInfo dataItem = (CostTaskEntryInfo)row.getCell(column).getValue();
        int rowCount = this.kdtEntries.getExpandedRowCount();
        while (++rowIndex < rowCount) {
            IRow row2 = this.kdtEntries.getRow(rowIndex);
            Object obj = row2.getCell(column).getValue();
            if (!(obj instanceof CostTaskEntryInfo)) continue;
            CostTaskEntryInfo dataItem2 = (CostTaskEntryInfo)obj;
            if (dataItem2.getLevel() > dataItem.getLevel()) {
                row2.getStyleAttributes().setHided(false);
                if (dataItem2.isExpanded()) {
                    rowIndex = this.expandRow(rowIndex, column);
                    continue;
                }
                if (dataItem2.isLeaf()) continue;
                rowIndex = this.expandSkipChildren(rowIndex, column);
                continue;
            }
            --rowIndex;
            break;
        }
        return rowIndex;
    }

    private int expandSkipChildren(int rowIndex, int column) {
        CostTaskEntryInfo dataItem2;
        IRow row2;
        Object obj;
        IRow row = this.kdtEntries.getRow(rowIndex);
        CostTaskEntryInfo dataItem = (CostTaskEntryInfo)row.getCell(column).getValue();
        int rowCount = this.kdtEntries.getRowCount3();
        while (!(++rowIndex >= rowCount || (obj = (row2 = this.kdtEntries.getRow(rowIndex)).getCell(column).getValue()) instanceof CostTaskEntryInfo && (dataItem2 = (CostTaskEntryInfo)obj).getLevel() == dataItem.getLevel())) {
        }
        return rowIndex - 1;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(LogReportPickUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        ((UIModelDialog)uiWindow).setVisible(true);
    }

    @Override
    protected void kdtEntries_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 1 && e.getColIndex() == this.kdtEntries.getColumnIndex("report")) {
            IRow row = this.kdtEntries.getRow(e.getRowIndex());
            if (row == null || row.getCell("name").getValue() == null || !(row.getCell("name").getValue() instanceof CostTaskEntryInfo)) {
                return;
            }
            CostTaskEntryInfo costTaskEntry = (CostTaskEntryInfo)row.getCell("name").getValue();
            if (costTaskEntry.getResult() != null && costTaskEntry.getResult().equals((Object)CostTaskResultEnum.EXCEPTION)) {
                this.showCostTaskExcepeion();
                return;
            }
            if (costTaskEntry.getFunction() == null) {
                return;
            }
            Map param = CostTaskUtils.decode(costTaskEntry.getParam());
            Class<?> clazz = Class.forName(costTaskEntry.getFunction());
            if (CoreUI.class.isAssignableFrom(clazz)) {
                UIContext uiContext = new UIContext((Object)this);
                String id = this.costTask.getCompany().getId().toString() + "_" + costTaskEntry.getId().toString();
                uiContext.put((Object)"ID", (Object)id);
                uiContext.put((Object)"key.cost.task.entry.param", (Object)param);
                IUIFactory uiFactory = UIFactory.createUIFactory((String)this.getUIFactoryName(param));
                IUIWindow window = uiFactory.create(costTaskEntry.getFunction(), (Map)uiContext, null);
                window.show();
            }
        }
    }

    private String getUIFactoryName(Map param) {
        String uiFactoryName = (String)param.get("UIFactoryName");
        if (uiFactoryName != null) {
            if ("com.kingdee.eas.base.uiframe.client.UIFixTabFactory".endsWith(uiFactoryName)) {
                return "com.kingdee.eas.base.uiframe.client.UIFixTabFactory";
            }
            if ("com.kingdee.eas.base.uiframe.client.UINewTabFactory".endsWith(uiFactoryName)) {
                return "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
            }
            if ("com.kingdee.eas.base.uiframe.client.UINewSessionFactory".endsWith(uiFactoryName)) {
                return "com.kingdee.eas.base.uiframe.client.UINewSessionFactory";
            }
            if ("com.kingdee.eas.base.uiframe.client.UIModelDialogFactory".endsWith(uiFactoryName)) {
                return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
            }
        }
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.running = false;
        super.actionExitCurrent_actionPerformed(e);
    }

    protected boolean checkBeforeWindowClosing() {
        this.running = false;
        return super.checkBeforeWindowClosing();
    }

    class ReportRenderer
    extends KDLabel
    implements IBasicRender {
        public ReportRenderer() {
            this.setUnderline(true);
            this.setHorizontalAlignment(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
            int diff;
            CostTaskEntryInfo item = null;
            String text = "";
            if (object instanceof CostTaskEntryInfo) {
                item = (CostTaskEntryInfo)object;
                if (item.getResult().getValue() >= 7) {
                    this.setForeground(Color.RED);
                    this.setUnderlineColor(Color.RED);
                } else if (item.getResult().getValue() == 3) {
                    this.setForeground(Color.BLUE);
                    this.setUnderlineColor(Color.BLUE);
                } else {
                    this.setForeground(new Color(0, 128, 0));
                    this.setUnderlineColor(new Color(0, 128, 0));
                }
                if (item.getReport() != null) {
                    text = item.getReport();
                }
            }
            this.setText(text);
            Rectangle rect = clip.getBounds();
            Dimension d = this.getPreferredSize();
            if (rect.width > d.width) {
                diff = rect.width - d.width;
                rect.x += diff / 2;
                rect.width = d.width;
            }
            if (rect.height > d.height) {
                diff = rect.height - d.height;
                rect.y += diff / 2;
                rect.height = d.height;
            }
            this.setBounds(rect);
            Graphics cg = graphics.create(rect.x, rect.y, rect.width, rect.height);
            try {
                this.paint(cg);
            }
            finally {
                cg.dispose();
            }
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (!this.isUnderline()) {
                return;
            }
            if (this.isEnabled()) {
                Color color = this.getUnderlineColor();
                if (color == null) {
                    color = UIManager.getColor("Label.underlineColor");
                }
                g.setColor(color);
            } else {
                g.setColor(this.getBackground().darker());
            }
            Dimension dim = this.getSize();
            g.drawLine(1, dim.height - 2, dim.width - 2, dim.height - 2);
        }
    }

    class TextRender
    extends ObjectValueRender {
        TextRender() {
        }

        public String getText(Object object) {
            CostTaskResultEnum result = CostTaskResultEnum.NULL;
            if (object instanceof CostTaskResultEnum) {
                result = (CostTaskResultEnum)((Object)object);
            }
            return this.getFormattedText(result.getAlias());
        }

        public String getFormattedText(Object object) {
            String text = super.getFormattedText(object);
            return text;
        }
    }

    class IconRender
    extends KDLabel
    implements IBasicRender {
        public IconRender() {
            this.setHorizontalAlignment(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
            CostTaskResultEnum result = CostTaskResultEnum.NULL;
            if (object instanceof CostTaskResultEnum) {
                result = (CostTaskResultEnum)((Object)object);
            }
            if (result.getValue() == 1) {
                this.setIcon(CostTaskEditUI.this.successIcon);
            } else if (result.getValue() == 7 || result.getValue() == 9) {
                this.setIcon(CostTaskEditUI.this.failureIcon);
            } else if (result.getValue() == 3) {
                this.setIcon(CostTaskEditUI.this.warnIcon);
            } else {
                this.setText("");
            }
            Rectangle rect = clip.getBounds();
            this.setBounds(rect);
            Graphics cg = graphics.create(rect.x, rect.y, rect.width, rect.height);
            try {
                this.paint(cg);
            }
            finally {
                cg.dispose();
            }
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
        }
    }
}

