/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.task.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.common.NCMCommonFacadeFactory;
import com.kingdee.eas.ncm.common.NCMIFilterParam;
import com.kingdee.eas.ncm.common.task.CostTaskConstants;
import com.kingdee.eas.ncm.common.task.client.AbstractCostTaskFilterUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import org.apache.log4j.Logger;

public class CostTaskFilterUI
extends AbstractCostTaskFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CostTaskFilterUI.class);
    private List types;

    public CostTaskFilterUI() throws Exception {
        this.jbInit();
    }

    private void jbInit() throws Exception {
        Map TYPES_FACT = CostTaskConstants.getTypes(null);
        this.types = new ArrayList(TYPES_FACT.size());
        for (Map.Entry entry : TYPES_FACT.entrySet()) {
            KDCheckBox checkBox = new KDCheckBox((String)TYPES_FACT.get(entry.getKey()));
            checkBox.setName(entry.getKey().toString());
            checkBox.setSelected(true);
            this.types.add(checkBox);
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kDPanel2.removeAll();
        this.kDPanel2.setLayout((LayoutManager)new BorderLayout());
        Box boxMain = Box.createVerticalBox();
        this.kDPanel2.add((Component)boxMain, (Object)"Center");
        int col = 3;
        Box row = null;
        for (int i = 0; i < this.types.size(); ++i) {
            if (i % col == 0) {
                row = Box.createHorizontalBox();
                row.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
                boxMain.add(row);
            }
            if (i % col == 0) {
                row.add(Box.createHorizontalStrut(20));
            }
            row.add((Component)((KDCheckBox)this.types.get(i)));
            if (i % col == col - 1) {
                row.add(Box.createHorizontalStrut(20));
                continue;
            }
            row.add(Box.createHorizontalGlue());
        }
        boxMain.add(Box.createVerticalGlue());
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        this.prmtCompany.setDisplayFormat("$name$");
        this.prmtCompany.setEditFormat("$number$");
        this.prmtCompany.setCommitFormat("$number$");
        this.prmtCompany.setFilterInfoProducer(this.getPermissionProducer());
    }

    public IFilterInfoProducer getPermissionProducer() throws EASBizException, BOSException {
        MetaDataPK actionPK = new MetaDataPK("ActionOnLoad");
        String permissionItem = NCMCommonFacadeFactory.getRemoteInstance().getUIPermissiionItem(this.getMetaDataPK(), (IMetaDataPK)actionPK);
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company, permissionItem);
        iProducer.getModel().setShowVirtual(false);
        return iProducer;
    }

    @Override
    public void clear() {
        super.clear();
        this.prmtCompany.setValue((Object)SysContext.getSysContext().getCurrentFIUnit());
        for (int i = 0; i < this.types.size(); ++i) {
            KDCheckBox checkBox = (KDCheckBox)this.types.get(i);
            checkBox.setSelected(true);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private Set getCompanyIds() {
        HashSet<String> companyIds = new HashSet<String>();
        Object value = this.prmtCompany.getValue();
        if (value instanceof CompanyOrgUnitInfo) {
            companyIds.add(((CompanyOrgUnitInfo)value).getId().toString());
        } else if (value instanceof Object[]) {
            Object[] vs = (Object[])value;
            for (int i = 0; i < vs.length; ++i) {
                if (!(vs[i] instanceof CompanyOrgUnitInfo)) continue;
                companyIds.add(((CompanyOrgUnitInfo)vs[i]).getId().toString());
            }
        }
        return companyIds;
    }

    private Map getCatagorys() {
        HashMap<String, String> catagorys = new HashMap<String, String>();
        for (int i = 0; i < this.types.size(); ++i) {
            KDCheckBox checkBox = (KDCheckBox)this.types.get(i);
            if (checkBox.isSelected()) {
                catagorys.put(checkBox.getName(), "true");
                continue;
            }
            catagorys.put(checkBox.getName(), "false");
        }
        return catagorys;
    }

    @Override
    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        Set companyIds = this.getCompanyIds();
        if (companyIds.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyIds, CompareType.INCLUDE));
        }
        HashSet catagorys = new HashSet();
        Map map = this.getCatagorys();
        for (Map.Entry entry : map.entrySet()) {
            if (!"true".equals(entry.getValue())) continue;
            catagorys.add(entry.getKey());
        }
        if (catagorys.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("catagory", catagorys, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("catagory", (Object)((Object)((Object)this)).getClass().getName()));
        }
        return filter;
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        HashSet<String> companyIds = new HashSet<String>();
        HashSet<String> catagorys = new HashSet<String>();
        for (String key : cp.getKeys()) {
            String value;
            if (key.startsWith("companyId_")) {
                companyIds.add(key.substring("companyId_".length()));
                continue;
            }
            if (!key.startsWith("catagory_") || !"true".equals(value = cp.getCustomerParam(key))) continue;
            catagorys.add(key.substring("catagory_".length()));
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", companyIds, CompareType.INCLUDE));
        view.setFilter(filter);
        try {
            CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
            if (coll.size() < 1) {
                this.prmtCompany.setValue(null);
            } else if (coll.size() == 1) {
                this.prmtCompany.setValue((Object)coll.get(0));
            } else {
                Object[] vs = new Object[coll.size()];
                for (int i = 0; i < coll.size(); ++i) {
                    vs[i] = coll.get(i);
                }
                this.prmtCompany.setValue((Object)vs);
            }
        }
        catch (Exception e) {
            this.prmtCompany.setValue(null);
            this.handUIException(e);
        }
        for (int i = 0; i < this.types.size(); ++i) {
            KDCheckBox checkBox = (KDCheckBox)this.types.get(i);
            if (catagorys.contains(checkBox.getName())) {
                checkBox.setSelected(true);
                continue;
            }
            checkBox.setSelected(false);
        }
    }

    @Override
    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        Set companyIds = this.getCompanyIds();
        Iterator it = companyIds.iterator();
        while (it.hasNext()) {
            cp.addCustomerParam("companyId_" + it.next(), "true");
        }
        Map catagorys = this.getCatagorys();
        for (Map.Entry entry : catagorys.entrySet()) {
            cp.addCustomerParam("catagory_" + entry.getKey().toString(), (String)entry.getValue());
        }
        return cp;
    }

    @Override
    protected NCMIFilterParam createNewFilterParam() {
        return null;
    }

    @Override
    protected void storeBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
    }

    @Override
    protected void storeFilterParam(NCMIFilterParam filterParam) {
    }

    @Override
    protected void loadBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
    }

    @Override
    protected void loadFilterParam(NCMIFilterParam filterParam) {
    }
}

