/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.task.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.common.task.CostTaskConstants;
import com.kingdee.eas.ncm.common.task.CostTaskFactory;
import com.kingdee.eas.ncm.common.task.CostTaskInfo;
import com.kingdee.eas.ncm.common.task.client.AbstractCostTaskListUI;
import com.kingdee.eas.ncm.common.task.client.CostTaskClientUtils;
import com.kingdee.eas.ncm.common.task.client.CostTaskEditUI;
import com.kingdee.eas.ncm.common.task.client.CostTaskFilterUI;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CostTaskListUI
extends AbstractCostTaskListUI
implements Runnable {
    private static final Logger logger = CoreUIObject.getLogger(CostTaskListUI.class);
    private final long refreshSpaceTime = 10000L;
    private CommonQueryDialog dialog = null;
    private CostTaskFilterUI filterUI = null;
    private Thread refreshThread = null;
    private Object synObj = new Object();
    private boolean running = false;

    public CostTaskListUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        NCMClientUtils.checkIsStart();
        this.menuEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.tblMain.checkParsed();
        this.tblMain.getColumn("catagory").setRenderer((IBasicRender)new TypeRenderer());
        this.tblMain.getColumn("progress").setRenderer((IBasicRender)new ProgressBarRender());
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                CostTaskListUI.this.tblMain_afterDataFill(e);
            }
        });
    }

    public void tblMain_afterDataFill(KDTDataRequestEvent e) {
        int firstRowIndex = e.getFirstRow();
        int lastRowIndex = e.getLastRow();
        IRow row = null;
        Object value = null;
        for (int i = firstRowIndex; i <= lastRowIndex; ++i) {
            row = this.tblMain.getRow(i);
            value = row.getCell("result").getValue();
            if (value == null || !(value instanceof BizEnumValueDTO)) continue;
            BizEnumValueDTO dto = (BizEnumValueDTO)value;
            if (dto.getInt() == 0) {
                row.getCell("result").setValue((Object)"");
            }
            if (dto.getInt() < 7) continue;
            row.getCell("result").getStyleAttributes().setFontColor(Color.RED);
        }
    }

    protected String getEditUIName() {
        return CostTaskEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CostTaskFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
    }

    public void onShow() throws Exception {
        super.onShow();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CostTaskListUI.this.refresh();
            }
        });
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        FilterInfo filter = ev.getFilter();
        if (filter == null) {
            filter = new FilterInfo();
            ev.setFilter(filter);
        }
        if (filter.getFilterItems().size() == 0) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
        }
        if (ev.getSorter().size() == 0) {
            SorterItemCollection sort = ev.getSorter();
            sort.add(new SorterItemInfo("createTime"));
        }
        super.beforeExcutQuery(ev);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void refreshList() throws Exception {
        this.refresh();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        this.running = false;
        if (this.refreshThread != null) {
            this.refreshThread.interrupt();
        }
        Object object = this.synObj;
        synchronized (object) {
            this.running = true;
            this.refreshThread = new Thread(this);
            this.refreshThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.synObj;
        synchronized (object) {
            while (this.running) {
                try {
                    this.refresh(null);
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (Exception e) {
                    this.handUIException(e);
                    return;
                }
            }
        }
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.running = false;
        super.actionExitCurrent_actionPerformed(e);
    }

    protected boolean checkBeforeWindowClosing() {
        this.running = false;
        return super.checkBeforeWindowClosing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.running = false;
        if (this.refreshThread != null) {
            this.refreshThread.interrupt();
        }
        Object object = this.synObj;
        synchronized (object) {
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            if (selectRows == null || selectRows.length == 0) {
                return;
            }
            boolean selectedUnfinishedTask = false;
            for (int i = 0; i < selectRows.length; ++i) {
                BizEnumValueDTO dto;
                Object value = this.tblMain.getCell(selectRows[i], "status").getValue();
                if (!(value instanceof BizEnumValueDTO) || (dto = (BizEnumValueDTO)value).getInt() == 9) continue;
                selectedUnfinishedTask = true;
                break;
            }
            try {
                if (selectedUnfinishedTask) {
                    int result = MsgBox.showConfirm2((String)"\u9009\u4e2d\u7684\u4efb\u52a1\u4e2d\u5305\u542b\u672a\u5b8c\u6210\u7684\u4efb\u52a1\uff0c\u5220\u9664\u540e\u8be5\u4efb\u52a1\u4ecd\u4f1a\u5728\u540e\u53f0\u7ee7\u7eed\u8fd0\u884c\uff0c\u4e14\u65e0\u6cd5\u76d1\u63a7\u3002");
                    if (result == 0) {
                        this.Remove();
                    }
                } else {
                    this.Remove();
                }
            }
            finally {
                this.refresh();
            }
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        String taskId = this.getSelectedKeyValue();
        String companyId = (String)row.getCell("company.id").getValue();
        String periodId = (String)row.getCell("period.id").getValue();
        String number = (String)row.getCell("number").getValue();
        CostTaskInfo costTask = new CostTaskInfo();
        costTask.setId(BOSUuid.read((String)taskId));
        costTask.setNumber(number);
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        costTask.setCompany(company);
        PeriodInfo period = new PeriodInfo();
        period.setId(BOSUuid.read((String)periodId));
        costTask.setPeriod(period);
        CostTaskClientUtils.showProgress(costTask, (CoreUIObject)this, false);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = super.initCommonQueryDialog();
        if (this.getFilterUI() != null) {
            this.dialog.addUserPanel((KDPanel)this.getFilterUI());
        }
        this.dialog.setWidth(450);
        this.dialog.setHeight(320);
        return this.dialog;
    }

    protected boolean initDefaultFilter() {
        return super.initDefaultFilter();
    }

    protected CustomerQueryPanel getFilterUI() {
        if (this.filterUI == null) {
            try {
                this.filterUI = new CostTaskFilterUI();
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return this.filterUI;
    }

    class TypeRenderer
    extends ObjectValueRender {
        public String getText(Object object) {
            String name;
            if (object instanceof String && (name = (String)CostTaskConstants.getTypes(null).get(object)) != null) {
                return name;
            }
            if (object != null) {
                return object.toString();
            }
            return "";
        }

        public String getFormattedText(Object object) {
            String text = super.getFormattedText(object);
            return text;
        }
    }

    class DateRenderer
    extends ObjectValueRender {
        private DateFormat format = null;

        public DateRenderer(String format) {
            this.format = new SimpleDateFormat(format);
        }

        public String getText(Object object) {
            if (object instanceof Date) {
                return this.format.format(object);
            }
            return "";
        }

        public String getFormattedText(Object object) {
            String text = super.getFormattedText(object);
            return text;
        }
    }

    private static class ProgressBarRender
    extends KDProgressBar
    implements IBasicRender {
        public ProgressBarRender() {
            this.setStringPainted(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
            if (object instanceof Integer) {
                this.setValue((Integer)object);
            }
            Rectangle rect = clip.getBounds();
            rect.x -= 3;
            rect.width += 6;
            this.setBounds(rect);
            Graphics cg = graphics.create(rect.x, rect.y, rect.width, rect.height);
            try {
                this.paint(cg);
            }
            finally {
                cg.dispose();
            }
        }
    }
}

