/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.utils;

import com.kingdee.eas.basedata.assistant.PeriodInfo;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class SpinnerUtils {
    private static final int PERIOD_MAX_MONTH = 12;

    public static void initSpinner(PeriodInfo minPeriod, PeriodInfo maxPeriod, PeriodInfo defPeriod, JSpinner spYearFrom, JSpinner spMonthFrom, PeriodInfo initPeriodFrom, JSpinner spYearTo, JSpinner spMonthTo, PeriodInfo initPeriodTo) {
        SpinnerUtils.initSpinner(minPeriod.getPeriodYear(), minPeriod.getPeriodNumber(), maxPeriod.getPeriodYear(), maxPeriod.getPeriodNumber(), defPeriod.getPeriodYear(), defPeriod.getPeriodNumber(), spYearFrom, spMonthFrom, initPeriodFrom.getPeriodYear(), initPeriodFrom.getPeriodNumber(), spYearTo, spMonthTo, initPeriodTo.getPeriodYear(), initPeriodTo.getPeriodNumber());
    }

    public static void initSpinner(int minYear, int minMonth, int maxYear, int maxMonth, int defYear, int defMonth, JSpinner spYearFrom, JSpinner spMonthFrom, int initYearFrom, int initMonthFrom, JSpinner spYearTo, JSpinner spMonthTo, int initYearTo, int initMonthTo) {
        int toPeriod;
        int minPeriod = SpinnerUtils.getNumberOfPeriod(minYear, minMonth);
        int maxPeriod = SpinnerUtils.getNumberOfPeriod(maxYear, maxMonth);
        int defPeriod = SpinnerUtils.getNumberOfPeriod(defYear, defMonth);
        if (minPeriod > maxPeriod || defPeriod < minPeriod || defPeriod > maxPeriod) {
            throw new IllegalArgumentException("\u671f\u95f4\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef\u3002");
        }
        int fromPeriod = SpinnerUtils.getNumberOfPeriod(initYearFrom, initMonthFrom);
        if (fromPeriod > (toPeriod = SpinnerUtils.getNumberOfPeriod(initYearTo, initMonthTo)) || fromPeriod < minPeriod || fromPeriod > maxPeriod || toPeriod < minPeriod || toPeriod > maxPeriod) {
            initYearFrom = defYear;
            initMonthFrom = defMonth;
            initYearTo = defYear;
            initMonthTo = defMonth;
        }
        SpinnerUtils.initSpinner(minYear, minMonth, maxYear, maxMonth, spYearFrom, spMonthFrom, initYearFrom, initMonthFrom, spYearTo, spMonthTo, initYearTo, initMonthTo);
    }

    private static void initSpinner(final int minYear, final int minMonth, final int maxYear, final int maxMonth, final JSpinner spYearFrom, final JSpinner spMonthFrom, int initYearFrom, int initMonthFrom, final JSpinner spYearTo, final JSpinner spMonthTo, int initYearTo, int initMonthTo) {
        SpinnerNumberModel spYearFromSNM = new SpinnerNumberModel(){

            public Comparable getMinimum() {
                return Integer.valueOf(minYear);
            }

            public Comparable getMaximum() {
                return Integer.valueOf(maxYear);
            }

            @Override
            public Object getNextValue() {
                int curYear = (Integer)spYearFrom.getValue();
                int curMonth = (Integer)spMonthFrom.getValue();
                if (curYear >= maxYear) {
                    return maxYear;
                }
                if (curYear + 1 >= maxYear && curMonth > maxMonth) {
                    spMonthFrom.setValue(maxMonth);
                }
                return curYear + 1;
            }

            @Override
            public Object getPreviousValue() {
                int curYear = (Integer)spYearFrom.getValue();
                int curMonth = (Integer)spMonthFrom.getValue();
                if (curYear <= minYear) {
                    return minYear;
                }
                if (curYear - 1 <= minYear && curMonth < minMonth) {
                    spYearFrom.setValue(curYear - 1);
                    spMonthFrom.setValue(minMonth);
                }
                return curYear - 1;
            }

            @Override
            public Number getStepSize() {
                return 1;
            }

            @Override
            public void setValue(Object value) {
                int oldValue = (Integer)spYearFrom.getValue();
                int newValue = (Integer)value;
                super.setValue(value);
                if (newValue > oldValue) {
                    this.syncPeriodTo();
                }
            }

            private void syncPeriodTo() {
                int fromYear = (Integer)spYearFrom.getValue();
                int fromMonth = (Integer)spMonthFrom.getValue();
                int toYear = (Integer)spYearTo.getValue();
                int toMonth = (Integer)spMonthTo.getValue();
                if (SpinnerUtils.getNumberOfPeriod(fromYear, fromMonth) > SpinnerUtils.getNumberOfPeriod(toYear, toMonth)) {
                    spYearTo.setValue(spYearFrom.getValue());
                    spMonthTo.setValue(spMonthFrom.getValue());
                }
            }
        };
        SpinnerNumberModel spMonthFromSNM = new SpinnerNumberModel(){

            public Comparable getMinimum() {
                if ((Integer)spYearFrom.getValue() == minYear) {
                    return Integer.valueOf(minMonth);
                }
                return Integer.valueOf(1);
            }

            public Comparable getMaximum() {
                if ((Integer)spYearFrom.getValue() == maxYear) {
                    return Integer.valueOf(maxMonth);
                }
                return Integer.valueOf(12);
            }

            @Override
            public Object getNextValue() {
                int curYear = (Integer)spYearFrom.getValue();
                int curMonth = (Integer)spMonthFrom.getValue();
                if (curMonth >= 12 && curYear < maxYear) {
                    spMonthFrom.setValue(1);
                    spYearFrom.setValue(curYear + 1);
                    return 1;
                }
                if (curMonth >= (Integer)this.getMaximum()) {
                    return curMonth;
                }
                return curMonth + 1;
            }

            @Override
            public Object getPreviousValue() {
                int curYear = (Integer)spYearFrom.getValue();
                int curMonth = (Integer)spMonthFrom.getValue();
                if (curMonth <= 1 && curYear > minYear) {
                    spYearFrom.setValue(curYear - 1);
                    return 12;
                }
                if (curMonth == (Integer)this.getMinimum()) {
                    return curMonth;
                }
                return curMonth - 1;
            }

            @Override
            public Number getStepSize() {
                return 1;
            }

            @Override
            public void setValue(Object value) {
                int oldValue = (Integer)spMonthFrom.getValue();
                int newValue = (Integer)value;
                super.setValue(value);
                if (newValue > oldValue) {
                    this.syncPeriodTo();
                }
            }

            private void syncPeriodTo() {
                int fromYear = (Integer)spYearFrom.getValue();
                int fromMonth = (Integer)spMonthFrom.getValue();
                int toYear = (Integer)spYearTo.getValue();
                int toMonth = (Integer)spMonthTo.getValue();
                if (SpinnerUtils.getNumberOfPeriod(fromYear, fromMonth) > SpinnerUtils.getNumberOfPeriod(toYear, toMonth)) {
                    spYearTo.setValue(spYearFrom.getValue());
                    spMonthTo.setValue(spMonthFrom.getValue());
                }
            }
        };
        SpinnerNumberModel spYearToSNM = new SpinnerNumberModel(){

            public Comparable getMinimum() {
                return Integer.valueOf(minYear);
            }

            public Comparable getMaximum() {
                return Integer.valueOf(maxYear);
            }

            @Override
            public Object getNextValue() {
                int curYear = (Integer)spYearTo.getValue();
                int curMonth = (Integer)spMonthTo.getValue();
                if (curYear >= maxYear) {
                    return maxYear;
                }
                if (curYear + 1 >= maxYear && curMonth > maxMonth) {
                    spYearTo.setValue(curYear + 1);
                    spMonthTo.setValue(maxMonth);
                }
                return curYear + 1;
            }

            @Override
            public Object getPreviousValue() {
                int curYear = (Integer)spYearTo.getValue();
                int curMonth = (Integer)spMonthTo.getValue();
                if (curYear <= minYear) {
                    return minYear;
                }
                if (curYear - 1 <= minYear && curMonth < minMonth) {
                    spMonthTo.setValue(minMonth);
                }
                return curYear - 1;
            }

            @Override
            public Number getStepSize() {
                return 1;
            }

            @Override
            public void setValue(Object value) {
                int oldValue = (Integer)spYearTo.getValue();
                int newValue = (Integer)value;
                super.setValue(value);
                if (newValue < oldValue) {
                    this.syncPeriodFrom();
                }
            }

            private void syncPeriodFrom() {
                int fromYear = (Integer)spYearFrom.getValue();
                int fromMonth = (Integer)spMonthFrom.getValue();
                int toYear = (Integer)spYearTo.getValue();
                int toMonth = (Integer)spMonthTo.getValue();
                if (SpinnerUtils.getNumberOfPeriod(fromYear, fromMonth) > SpinnerUtils.getNumberOfPeriod(toYear, toMonth)) {
                    spYearFrom.setValue(spYearTo.getValue());
                    spMonthFrom.setValue(spMonthTo.getValue());
                }
            }
        };
        SpinnerNumberModel spMonthToSNM = new SpinnerNumberModel(){

            public Comparable getMinimum() {
                if ((Integer)spYearTo.getValue() == minYear) {
                    return Integer.valueOf(minMonth);
                }
                return Integer.valueOf(1);
            }

            public Comparable getMaximum() {
                if ((Integer)spYearTo.getValue() == maxYear) {
                    return Integer.valueOf(maxMonth);
                }
                return Integer.valueOf(12);
            }

            @Override
            public Object getNextValue() {
                int curYear = (Integer)spYearTo.getValue();
                int curMonth = (Integer)spMonthTo.getValue();
                if (curMonth >= 12 && curYear < maxYear) {
                    spYearTo.setValue(curYear + 1);
                    return 1;
                }
                if (curMonth >= (Integer)this.getMaximum()) {
                    return curMonth;
                }
                return curMonth + 1;
            }

            @Override
            public Object getPreviousValue() {
                int curYear = (Integer)spYearTo.getValue();
                int curMonth = (Integer)spMonthTo.getValue();
                if (curMonth == 1 && curYear > minYear) {
                    spMonthTo.setValue(12);
                    spYearTo.setValue(curYear - 1);
                    return 12;
                }
                if (curMonth == (Integer)this.getMinimum()) {
                    return curMonth;
                }
                return curMonth - 1;
            }

            @Override
            public Number getStepSize() {
                return 1;
            }

            @Override
            public void setValue(Object value) {
                int oldValue = (Integer)spMonthTo.getValue();
                int newValue = (Integer)value;
                super.setValue(value);
                if (newValue < oldValue) {
                    this.syncPeriodFrom();
                }
            }

            private void syncPeriodFrom() {
                int fromYear = (Integer)spYearFrom.getValue();
                int fromMonth = (Integer)spMonthFrom.getValue();
                int toYear = (Integer)spYearTo.getValue();
                int toMonth = (Integer)spMonthTo.getValue();
                if (SpinnerUtils.getNumberOfPeriod(fromYear, fromMonth) > SpinnerUtils.getNumberOfPeriod(toYear, toMonth)) {
                    spYearFrom.setValue(spYearTo.getValue());
                    spMonthFrom.setValue(spMonthTo.getValue());
                }
            }
        };
        spYearFrom.setModel(spYearFromSNM);
        spMonthFrom.setModel(spMonthFromSNM);
        spYearTo.setModel(spYearToSNM);
        spMonthTo.setModel(spMonthToSNM);
        spYearFrom.setValue(initYearFrom);
        spMonthFrom.setValue(initMonthFrom);
        spYearTo.setValue(initYearTo);
        spMonthTo.setValue(initMonthTo);
    }

    public static void initSpinner(PeriodInfo minPeriod, PeriodInfo maxPeriod, PeriodInfo defPeriod, JSpinner spYear, JSpinner spMonth, PeriodInfo initPeriod) {
        SpinnerUtils.initSpinner(minPeriod.getPeriodYear(), minPeriod.getPeriodNumber(), maxPeriod.getPeriodYear(), maxPeriod.getPeriodNumber(), defPeriod.getPeriodYear(), defPeriod.getPeriodNumber(), spYear, spMonth, initPeriod.getPeriodYear(), initPeriod.getPeriodNumber());
    }

    public static void initSpinner(int minYear, int minMonth, int maxYear, int maxMonth, int defYear, int defMonth, JSpinner spYear, JSpinner spMonth, int initYear, int initMonth) {
        int minPeriod = SpinnerUtils.getNumberOfPeriod(minYear, minMonth);
        int maxPeriod = SpinnerUtils.getNumberOfPeriod(maxYear, maxMonth);
        int defPeriod = SpinnerUtils.getNumberOfPeriod(defYear, defMonth);
        if (minPeriod > maxPeriod || defPeriod < minPeriod || defPeriod > maxPeriod) {
            throw new IllegalArgumentException("\u671f\u95f4\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef\u3002");
        }
        int period = SpinnerUtils.getNumberOfPeriod(initYear, initMonth);
        if (period < minPeriod || period > maxPeriod) {
            initYear = defYear;
            initMonth = defMonth;
        }
        SpinnerUtils.initSpinner(minYear, minMonth, maxYear, maxMonth, spYear, spMonth, initYear, initMonth);
    }

    public static void initSpinner(final int minYear, final int minMonth, final int maxYear, final int maxMonth, final JSpinner spYear, final JSpinner spMonth, int initYear, int initMonth) {
        SpinnerNumberModel spYearSNM = new SpinnerNumberModel(){

            public Comparable getMinimum() {
                return Integer.valueOf(minYear);
            }

            public Comparable getMaximum() {
                return Integer.valueOf(maxYear);
            }

            @Override
            public Object getNextValue() {
                int curYear = (Integer)spYear.getValue();
                int curMonth = (Integer)spMonth.getValue();
                if (curYear == maxYear) {
                    return null;
                }
                if (curYear + 1 == maxYear && curMonth > maxMonth) {
                    spMonth.setValue(maxMonth);
                }
                return curYear + 1;
            }

            @Override
            public Object getPreviousValue() {
                int curYear = (Integer)spYear.getValue();
                int curMonth = (Integer)spMonth.getValue();
                if (curYear == minYear) {
                    return null;
                }
                if (curYear - 1 == minYear && curMonth < minMonth) {
                    spMonth.setValue(minMonth);
                }
                return curYear - 1;
            }

            @Override
            public Number getStepSize() {
                return 1;
            }
        };
        spYear.setModel(spYearSNM);
        spYear.setValue(initYear);
        SpinnerNumberModel spMonthSNM = new SpinnerNumberModel(){

            public Comparable getMinimum() {
                if ((Integer)spYear.getValue() == minYear) {
                    return Integer.valueOf(minMonth);
                }
                return Integer.valueOf(1);
            }

            public Comparable getMaximum() {
                if ((Integer)spYear.getValue() == maxYear) {
                    return Integer.valueOf(maxMonth);
                }
                return Integer.valueOf(12);
            }

            @Override
            public Object getNextValue() {
                int curYear = (Integer)spYear.getValue();
                int curMonth = (Integer)spMonth.getValue();
                if (curMonth == 12 && curYear < maxYear) {
                    spYear.setValue(curYear + 1);
                    return 1;
                }
                if (curMonth == (Integer)this.getMaximum()) {
                    return null;
                }
                return curMonth + 1;
            }

            @Override
            public Object getPreviousValue() {
                int curYear = (Integer)spYear.getValue();
                int curMonth = (Integer)spMonth.getValue();
                if (curMonth == 1 && curYear > minYear) {
                    spYear.setValue(curYear - 1);
                    return 12;
                }
                if (curMonth == (Integer)this.getMinimum()) {
                    return null;
                }
                return curMonth - 1;
            }

            @Override
            public Number getStepSize() {
                return 1;
            }
        };
        spMonth.setModel(spMonthSNM);
        spMonth.setValue(initMonth);
    }

    public static int getNumberOfPeriod(int periodYear, int periodNumber) {
        if (periodYear < 0 || periodYear > 9999) {
            periodYear = 0;
        }
        return (periodYear *= 100) + periodNumber;
    }
}

