/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.utils.algorithm;

import com.kingdee.bos.Context;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.Assert;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Locale;
import org.apache.log4j.Logger;

public final class GaussJordan {
    private static Logger logger = Logger.getLogger((String)GaussJordan.class.getName());
    private static int SCALE = 16;
    private static int[] UnkownNumbersPrecissions;

    public static void main(String[] args) {
        double[][] coef = new double[][]{{50.0, 0.0, -2.7, -6.9}, {0.0, 150.0, -4.3, -6.2}, {-5.5, -15.0, 15.0, 0.0}, {-4.5, -45.0, 0.0, 25.0}};
        double[] b = new double[]{87.5, 262.5, 180.0, 300.0};
        BigDecimal[][] c = new BigDecimal[coef.length][];
        for (int i = 0; i < coef.length; ++i) {
            c[i] = GaussJordan.convert(coef[i]);
        }
        BigDecimal[] result = GaussJordan.solve(c, GaussJordan.convert(b), null);
        for (int i = 0; i < result.length; ++i) {
        }
    }

    public static BigDecimal[] convert(double[] a) {
        Assert.that((a != null ? 1 : 0) != 0);
        BigDecimal[] b = new BigDecimal[a.length];
        for (int i = 0; i < a.length; ++i) {
            b[i] = new BigDecimal(String.valueOf(a[i]));
        }
        return b;
    }

    private static void checkParameter(BigDecimal[][] coef, BigDecimal[] b, Context ctx) {
        if (coef == null || b == null) {
            throw new NullPointerException(ResourceBase.getString((String)"com.kingdee.eas.ncm.common.COMMONAutoGenerateResource", (String)"12_GaussJordan", (Locale)ctx.getLocale()));
        }
    }

    private static void checkParameter(BigDecimal[][] coef, BigDecimal[] b, int[] unkownNumbersPrecission, Context ctx) {
        GaussJordan.checkParameter(coef, b, ctx);
        if (unkownNumbersPrecission == null) {
            throw new NullPointerException(ResourceBase.getString((String)"com.kingdee.eas.ncm.common.COMMONAutoGenerateResource", (String)"12_GaussJordan", (Locale)ctx.getLocale()));
        }
        if (b.length > unkownNumbersPrecission.length) {
            throw new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.ncm.common.COMMONAutoGenerateResource", (String)"13_GaussJordan", (Locale)ctx.getLocale()));
        }
    }

    public static BigDecimal[] solve(BigDecimal[][] coef, BigDecimal[] b, int[] unkownNumbersPrecission, int scale, Context ctx) {
        BigDecimal[] tmp = (BigDecimal[])b.clone();
        int[] tmpUnkownNumbersPrecission = (int[])unkownNumbersPrecission.clone();
        BigDecimal[][] tmpCoef = (BigDecimal[][])coef.clone();
        GaussJordan.checkParameter(tmpCoef, tmp, tmpUnkownNumbersPrecission, ctx);
        SCALE = scale;
        UnkownNumbersPrecissions = tmpUnkownNumbersPrecission;
        return GaussJordan.resolve(tmpCoef, tmp, ctx);
    }

    public static BigDecimal[] solve(BigDecimal[][] coef, BigDecimal[] b, int[] unkownNumbersPrecission, Context ctx) {
        BigDecimal[] tmp = (BigDecimal[])b.clone();
        int[] tmpUnkownNumbersPrecission = (int[])unkownNumbersPrecission.clone();
        BigDecimal[][] tmpCoef = (BigDecimal[][])coef.clone();
        GaussJordan.checkParameter(tmpCoef, tmp, tmpUnkownNumbersPrecission, ctx);
        UnkownNumbersPrecissions = tmpUnkownNumbersPrecission;
        return GaussJordan.resolve(tmpCoef, tmp, ctx);
    }

    public static BigDecimal[] solve(BigDecimal[][] coef, BigDecimal[] b, Context ctx) {
        GaussJordan.checkParameter(coef, b, ctx);
        UnkownNumbersPrecissions = new int[b.length];
        Arrays.fill(UnkownNumbersPrecissions, SCALE);
        return GaussJordan.resolve(coef, b, ctx);
    }

    private static BigDecimal[] resolve(BigDecimal[][] coef, BigDecimal[] b, Context ctx) {
        int n = coef.length;
        int[] shift = new int[n];
        for (int i = 0; i < n; ++i) {
            shift[i] = i;
        }
        for (int rows = 0; rows < n; ++rows) {
            int i;
            BigDecimal rightLowMax = SysConstant.BIGZERO;
            int pickedRow = 0;
            int pickedColumn = 0;
            for (i = rows; i < n; ++i) {
                for (int j = rows; j < n; ++j) {
                    if (rightLowMax.compareTo(coef[i][j].abs()) >= 0) continue;
                    rightLowMax = coef[i][j];
                    pickedRow = i;
                    pickedColumn = j;
                }
            }
            if (pickedColumn != rows) {
                for (i = 0; i < n; ++i) {
                    GaussJordan.swap(coef, i, rows, i, pickedColumn);
                }
                GaussJordan.swap(shift, rows, pickedColumn);
            }
            if (pickedRow != rows) {
                for (int j = rows; j < n; ++j) {
                    GaussJordan.swap(coef, rows, j, pickedRow, j);
                }
                GaussJordan.swap(b, rows, pickedRow);
            }
            for (int subrows = 0; subrows < n; ++subrows) {
                if (subrows == rows) continue;
                if (SysConstant.BIGZERO.compareTo(coef[rows][rows]) == 0) {
                    throw new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.ncm.common.COMMONAutoGenerateResource", (String)"14_GaussJordan", (Locale)ctx.getLocale()));
                }
                BigDecimal m = coef[subrows][rows].divide(coef[rows][rows], SCALE, 4);
                for (int rowsRight = rows; rowsRight < n; ++rowsRight) {
                    coef[subrows][rowsRight] = coef[subrows][rowsRight].subtract(coef[rows][rowsRight].multiply(m));
                }
                b[subrows] = b[subrows].subtract(b[rows].multiply(m));
            }
        }
        BigDecimal[] x = new BigDecimal[n];
        for (int rows = 0; rows < n; ++rows) {
            for (int i = 0; i < n; ++i) {
                if (shift[i] != rows) continue;
                x[shift[i]] = SysConstant.BIGZERO.compareTo(coef[i][i]) == 0 ? SysConstant.BIGZERO : b[i].divide(coef[i][i], UnkownNumbersPrecissions[shift[i]], 4);
            }
        }
        return x;
    }

    public static void swap(BigDecimal[] a, int x, int y) {
        BigDecimal tmp = a[x];
        a[x] = a[y];
        a[y] = tmp;
    }

    public static void swap(int[] a, int x, int y) {
        int tmp = a[x];
        a[x] = a[y];
        a[y] = tmp;
    }

    public static void swap(BigDecimal[][] a, int x1, int y1, int x2, int y2) {
        BigDecimal tmp = a[x1][y1];
        a[x1][y1] = a[x2][y2];
        a[x2][y2] = tmp;
    }
}

