/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.utils.algorithm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.backport.concurrent.Callable;
import com.kingdee.bos.util.backport.concurrent.ConcurrentHashMap;
import com.kingdee.bos.util.backport.concurrent.ConcurrentMap;
import com.kingdee.bos.util.backport.concurrent.CopyOnWriteArrayList;
import com.kingdee.bos.util.backport.concurrent.ExecutionException;
import com.kingdee.bos.util.backport.concurrent.Executor;
import com.kingdee.bos.util.backport.concurrent.ExecutorCompletionService;
import com.kingdee.bos.util.backport.concurrent.ExecutorService;
import com.kingdee.bos.util.backport.concurrent.Executors;
import com.kingdee.bos.util.backport.concurrent.Future;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LowLevelCode {
    private static final int ONE = 1;
    private static final Integer NEGATIVE_ONE = Integer.valueOf("-1");
    private static final Map co_reference = new HashMap();
    private static final List uncalc_cos = new ArrayList();
    private static final List cycledCO = new CopyOnWriteArrayList();
    private static ConcurrentMap computedResults;
    private static int n_CPUcores;
    private static boolean costObjectRankByLow;
    private static Map cycledCO_billMap;

    public static void main(String[] args) {
    }

    public static Object[] calculateAll(boolean isCostObjectRankByLow, IRowSet rs) throws BOSException, EASBizException {
        costObjectRankByLow = isCostObjectRankByLow;
        LowLevelCode.init(rs);
        LowLevelCode.computeLLC();
        if (!costObjectRankByLow) {
            LowLevelCode.resetLevelCode();
        }
        return new Object[]{cycledCO, computedResults, co_reference, cycledCO_billMap};
    }

    private static void resetLevelCode() {
        String key2 = null;
        int result = 0;
        int maxResult = 0;
        Set computedResultsSet = computedResults.keySet();
        for (String key2 : computedResultsSet) {
            result = (Integer)computedResults.get((Object)key2);
            if (maxResult >= result) continue;
            maxResult = result;
        }
        for (String key2 : computedResultsSet) {
            result = (Integer)computedResults.get((Object)key2);
            computedResults.replace((Object)key2, (Object)(maxResult - result));
        }
    }

    private static void initByLow(IRowSet rs) throws BOSException {
        co_reference.clear();
        uncalc_cos.clear();
        cycledCO.clear();
        computedResults = new ConcurrentHashMap(rs.size());
        String co1 = null;
        String co2 = null;
        HashSet<String> referenced = null;
        try {
            while (rs.next()) {
                co1 = rs.getString(1);
                co2 = rs.getString(2);
                if (co1 != null) {
                    if (!uncalc_cos.contains(co1)) {
                        uncalc_cos.add(co1);
                    }
                    computedResults.putIfAbsent((Object)co1, (Object)NEGATIVE_ONE);
                }
                if (co2 == null) continue;
                if (!uncalc_cos.contains(co2)) {
                    uncalc_cos.add(co2);
                }
                computedResults.putIfAbsent((Object)co2, (Object)NEGATIVE_ONE);
                referenced = (HashSet<String>)co_reference.get(co2);
                if (referenced == null) {
                    referenced = new HashSet<String>();
                }
                if (co1 != null) {
                    referenced.add(co1);
                }
                if (referenced.contains(co2)) {
                    uncalc_cos.remove(co2);
                    if (cycledCO.contains(co2)) continue;
                    cycledCO.add(co2);
                    continue;
                }
                if (referenced.isEmpty()) continue;
                co_reference.put(co2, referenced);
            }
            Set keys = computedResults.keySet();
            Iterator ite = keys.iterator();
            String key = null;
            while (ite.hasNext()) {
                key = (String)ite.next();
                if (co_reference.get(key) != null && !((Set)co_reference.get(key)).isEmpty()) continue;
                computedResults.replace((Object)key, (Object)Integer.valueOf("0"));
                uncalc_cos.remove(key);
            }
            uncalc_cos.remove(null);
            co_reference.remove(null);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private static void init(IRowSet rs) throws BOSException {
        if (costObjectRankByLow) {
            LowLevelCode.initByLow(rs);
        } else {
            LowLevelCode.initByHigh(rs);
        }
    }

    private static void initByHigh(IRowSet rs) throws BOSException {
        co_reference.clear();
        uncalc_cos.clear();
        cycledCO.clear();
        computedResults = new ConcurrentHashMap(rs.size());
        String co1 = null;
        String co2 = null;
        HashSet<String> referenced = null;
        try {
            rs.beforeFirst();
            while (rs.next()) {
                co1 = rs.getString(1);
                co2 = rs.getString(2);
                if (co2 != null) {
                    if (!uncalc_cos.contains(co2)) {
                        uncalc_cos.add(co2);
                    }
                    computedResults.putIfAbsent((Object)co2, (Object)NEGATIVE_ONE);
                }
                if (co1 == null) continue;
                if (!uncalc_cos.contains(co1)) {
                    uncalc_cos.add(co1);
                }
                computedResults.putIfAbsent((Object)co1, (Object)NEGATIVE_ONE);
                referenced = (HashSet<String>)co_reference.get(co1);
                if (referenced == null) {
                    referenced = new HashSet<String>();
                }
                if (co2 != null) {
                    referenced.add(co2);
                }
                if (referenced.contains(co1)) {
                    uncalc_cos.remove(co1);
                    if (cycledCO.contains(co1)) continue;
                    cycledCO.add(co1);
                    continue;
                }
                if (referenced.isEmpty()) continue;
                co_reference.put(co1, referenced);
            }
            Set keys = computedResults.keySet();
            Iterator ite = keys.iterator();
            String key = null;
            while (ite.hasNext()) {
                key = (String)ite.next();
                if (co_reference.get(key) != null && !((Set)co_reference.get(key)).isEmpty()) continue;
                computedResults.replace((Object)key, (Object)Integer.valueOf("0"));
                uncalc_cos.remove(key);
            }
            uncalc_cos.remove(null);
            co_reference.remove(null);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private static void computeLLC() throws BOSException, EASBizException {
        LowLevelCode.sequentialRanking();
    }

    protected static void sequentialRanking() throws EASBizException, BOSException {
        Set refs = null;
        for (String me : uncalc_cos) {
            refs = (Set)co_reference.get(me);
            HashSet callers = new HashSet();
            ArrayList referces = new ArrayList();
            LowLevelCode.ranking(refs, callers, me, cycledCO, referces);
        }
    }

    protected static void parallelRanking() throws BOSException, EASBizException {
        ExecutorService exec = Executors.newFixedThreadPool((int)n_CPUcores);
        ExecutorCompletionService ecs = new ExecutorCompletionService((Executor)exec);
        int length = uncalc_cos.size() / n_CPUcores;
        int mod = uncalc_cos.size() % n_CPUcores;
        int start = 0;
        int end = 0;
        Future[] tasks = new Future[n_CPUcores];
        for (int i = 0; i < n_CPUcores; ++i) {
            if (i == 0) {
                start = 0;
                end = length + mod;
            } else {
                start = end;
                end = start + length;
            }
            tasks[i] = ecs.submit(LowLevelCode.buildRankingTask(start, end));
        }
        try {
            for (int j = 0; j < tasks.length; ++j) {
                ecs.take().get();
            }
        }
        catch (InterruptedException e) {
            throw new BOSException((Throwable)e);
        }
        catch (ExecutionException e) {
            for (int k = 0; k < tasks.length; ++k) {
                tasks[k].cancel(true);
            }
            throw (EASBizException)e.getCause();
        }
        finally {
            exec.shutdown();
        }
    }

    private static Callable buildRankingTask(final int start, final int end) {
        Callable callable = new Callable(){

            public Object call() throws EASBizException, BOSException {
                for (int j = start; j < end; ++j) {
                    String me = (String)uncalc_cos.get(j);
                    Set refs = (Set)co_reference.get(me);
                    HashSet callers = new HashSet();
                    ArrayList referces = new ArrayList();
                    LowLevelCode.ranking(refs, callers, me, cycledCO, referces);
                }
                return null;
            }
        };
        return callable;
    }

    private static int ranking(Set referenced, Set callers, String me, List cycledCO, List referces) throws EASBizException, BOSException {
        if (me == null) {
            referces.remove(referces.size() - 1);
            return -1;
        }
        referces.add(me);
        Integer result = (Integer)computedResults.get((Object)me);
        if (result.compareTo(NEGATIVE_ONE) != 0) {
            referces.remove(referces.size() - 1);
            return result;
        }
        if (!callers.add(me)) {
            if (!cycledCO.contains(me)) {
                cycledCO.add(me);
            }
            cycledCO_billMap.put(me, referces);
            return -1;
        }
        if (referenced == null || referenced.isEmpty()) {
            computedResults.replace((Object)me, (Object)Integer.valueOf("0"));
            referces.remove(referces.size() - 1);
            return 0;
        }
        Iterator refIt = referenced.iterator();
        int[] subRanks = new int[referenced.size()];
        int i = 0;
        String nextme = null;
        Set subRefs = null;
        do {
            nextme = (String)refIt.next();
            subRefs = (Set)co_reference.get(nextme);
            subRanks[i++] = LowLevelCode.ranking(subRefs, callers, nextme, cycledCO, referces);
        } while (refIt.hasNext());
        int retval = LowLevelCode.max(subRanks) + 1;
        computedResults.replace((Object)me, (Object)retval);
        return retval;
    }

    public static int max(int[] subRanks) {
        Arrays.sort(subRanks);
        return subRanks[subRanks.length - 1];
    }

    static {
        costObjectRankByLow = true;
        cycledCO_billMap = new HashMap();
    }
}

