/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.utils.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.DefaultPromptBoxFactory;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.ArrayList;

public class NCMMaterialPromptBoxFactory
extends DefaultPromptBoxFactory {
    private CustomerQueryPanel filterUI = null;
    private OrgType mainOrgType = null;
    private F7ContextManager f7Manager = null;
    private CompanyOrgUnitInfo currCompany = null;
    private boolean isBOMMaterial = false;

    public NCMMaterialPromptBoxFactory(CustomerQueryPanel filterUI, OrgType mainOrgType) {
        this.filterUI = filterUI;
        this.mainOrgType = mainOrgType;
        this.currCompany = SysContext.getSysContext().getCurrentFIUnit();
        try {
            this.f7Manager = new F7ContextManager((Component)filterUI, mainOrgType, 1);
        }
        catch (EASBizException e) {
            filterUI.handUIException((Throwable)e);
        }
        catch (BOSException e) {
            filterUI.handUIException((Throwable)e);
        }
    }

    public KDPromptBox create(String f7QueryName, QueryInfo mainQuery, String queryFieldName) {
        String mainEntityName = NCMMaterialPromptBoxFactory.getMainEntityName(f7QueryName);
        String mainqueryName = mainQuery.getFullName();
        KDBizPromptBox promptBox = (KDBizPromptBox)super.create(f7QueryName, mainQuery, queryFieldName);
        if (mainEntityName == null) {
            return promptBox;
        }
        if ("com.kingdee.eas.ncm.std.bill.app.STDCostEstimateTypeQuery".equals(mainqueryName) || "com.kingdee.eas.ncm.std.bill.app.STDCostDataQuery".equals(mainqueryName)) {
            this.f7Manager.registerBizMaterialF7(promptBox, null, null, null, false);
            this.isBOMMaterial = false;
            this.addF7SelectorListener(promptBox);
        } else if ("com.kingdee.eas.ncm.std.bill.app.STDCostMaterialBOMQuery".equals(mainqueryName)) {
            this.isBOMMaterial = true;
            this.addF7SelectorListener(promptBox);
        }
        return promptBox;
    }

    private void addF7SelectorListener(final KDBizPromptBox f7) {
        f7.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                CustomerParams params = NCMMaterialPromptBoxFactory.this.filterUI.getCustomerParams();
                String storageOrgId = params.getCustomerParam("StorageOrgUnitId");
                if (storageOrgId == null || storageOrgId.length() == 0) {
                    MsgBox.showInfo((String)SCMGroupClientUtils.getMainOrgNullMsg((OrgType)NCMMaterialPromptBoxFactory.this.mainOrgType));
                    NCMMaterialPromptBoxFactory.this.filterUI.requestFocus();
                    SysUtil.abort();
                } else {
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgId, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)NCMMaterialPromptBoxFactory.this.currCompany.getId().toString(), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("FIInfo.status", (Object)1, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("MaterialInventory.status", (Object)1, CompareType.EQUALS));
                    if (NCMMaterialPromptBoxFactory.this.isBOMMaterial) {
                        filter.getFilterItems().add(new FilterItemInfo("stdEstimateType.estimateType", (Object)2, CompareType.EQUALS));
                    }
                    try {
                        NCMUtils.materialTreeDisplay(NCMMaterialPromptBoxFactory.this.filterUI, f7, filter);
                    }
                    catch (BOSException ex) {
                        NCMMaterialPromptBoxFactory.this.filterUI.handUIException((Throwable)ex);
                    }
                }
            }
        });
    }

    private static String getMainEntityName(String queryName) {
        QueryInfo queryInfo = Util.getQueryInfo((String)queryName);
        ArrayList entityNames = NCMMaterialPromptBoxFactory.getEntitiyNames(queryInfo);
        if (entityNames.size() > 0) {
            return (String)entityNames.get(0);
        }
        return null;
    }

    private static ArrayList getEntitiyNames(QueryInfo queryInfo) {
        ArrayList<String> entityNames = new ArrayList<String>();
        if (queryInfo == null) {
            return entityNames;
        }
        SubObjectCollection subObjectCollection = queryInfo.getSubObjects();
        int size = subObjectCollection.size();
        for (int i = 0; i < size; ++i) {
            SubObjectInfo subObjectInfo = subObjectCollection.get(i);
            if (!(subObjectInfo instanceof SubEntityInfo)) continue;
            SubEntityInfo subEntityInfo = (SubEntityInfo)subObjectInfo;
            String entityName = subEntityInfo.getEntityRef().getPackage() + "." + subEntityInfo.getEntityRef().getName();
            entityNames.add(entityName);
        }
        return entityNames;
    }
}

