/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.bill.client.AllocBuilder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.ncm.bill.AllocTypeEnum;
import com.kingdee.eas.ncm.bill.MatAllocWizardSchemeEntryCollection;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.AllocDirector;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.Allocator;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.Builder.AllocatorBuilder;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.Builder.WizOtherAllocatorBuilder;
import com.kingdee.eas.ncm.common.AllocSourceBillEnum;
import com.kingdee.eas.ncm.common.NCMCommonFacadeFactory;
import com.kingdee.eas.ncm.common.client.ProgressHintListener;
import com.kingdee.eas.ncm.common.client.ProgressHintUI;
import com.kingdee.eas.ncm.dynamic.bill.client.AllocBuilder.Builder.DynAutoCostAdjustAllocatorBuilder;
import com.kingdee.eas.ncm.dynamic.bill.client.AllocBuilder.Builder.DynAutoMatAllocatorBuilder;
import com.kingdee.eas.ncm.dynamic.bill.client.AllocBuilder.Builder.DynAutoOtherAllocatorBuilder;
import com.kingdee.eas.ncm.dynamic.bill.client.AllocBuilder.Builder.DynAutoOtherInWHAllocatorBuilder;
import com.kingdee.eas.ncm.dynamic.bill.client.AllocBuilder.Builder.DynCalWizCostAdjustAllocatorBuilder;
import com.kingdee.eas.ncm.dynamic.bill.client.AllocBuilder.Builder.DynCalWizMatAllocatorBuilder;
import com.kingdee.eas.ncm.dynamic.bill.client.AllocBuilder.Builder.DynCalWizOtherAllocatorBuilder;
import com.kingdee.eas.ncm.dynamic.bill.client.AllocBuilder.Builder.DynCalWizOtherInwarehsAllocatorBuilder;
import com.kingdee.eas.ncm.dynamic.bill.client.AllocBuilder.Builder.DynManuCostAdjustAllocatorBuilder;
import com.kingdee.eas.ncm.dynamic.bill.client.AllocBuilder.Builder.DynManuMatAllocatorBuilder;
import com.kingdee.eas.ncm.dynamic.bill.client.AllocBuilder.Builder.DynManuOtherAllocatorBuilder;
import com.kingdee.eas.ncm.dynamic.bill.client.AllocBuilder.Builder.DynManuOtherInWarehsAllocatorBuilder;
import com.kingdee.eas.ncm.dynamic.bill.client.AllocBuilder.Builder.DynWizMatAllocatorBuilder;
import com.kingdee.util.Assert;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class DynAllocClientDispatch {
    private static Logger logger = Logger.getLogger((String)DynAllocClientDispatch.class.getName());
    Allocator allocator = null;

    public Allocator DoMatAllocate(CoreUIObject parentUI, AllocTypeEnum allocType, Map param) throws Exception {
        param.put("allocSourceBill", AllocSourceBillEnum.MaterialReqBill);
        Allocator allocator = null;
        if (allocType.equals((Object)AllocTypeEnum.AUTO)) {
            AutoMatProgressHintListener listener = new AutoMatProgressHintListener();
            ProgressHintUI.showProgressHintUI((CoreUIObject)parentUI, (ProgressHintListener)listener, (Map)param);
            if (param.containsKey("allocator")) {
                allocator = (Allocator)param.get("allocator");
            }
        } else if (allocType.equals((Object)AllocTypeEnum.MANU)) {
            DynManuMatAllocatorBuilder builder = new DynManuMatAllocatorBuilder(param, parentUI);
            AllocDirector director = new AllocDirector();
            director.CreateAllocator((AllocatorBuilder)builder);
            allocator = builder.getAllocator();
        } else if (allocType.equals((Object)AllocTypeEnum.WIZ)) {
            WizMatProgressHintListener listener = new WizMatProgressHintListener();
            ProgressHintUI.showProgressHintUI((CoreUIObject)parentUI, (ProgressHintListener)listener, (Map)param);
            if (param.containsKey("allocator")) {
                allocator = (Allocator)param.get("allocator");
            }
        }
        return allocator;
    }

    public Allocator DoOtherInWHAllocate(CoreUIObject parentUI, AllocTypeEnum allocType, Map param) throws Exception {
        param.put("allocSourceBill", AllocSourceBillEnum.OtherInWarehsBill);
        Allocator allocator = null;
        if (allocType.equals((Object)AllocTypeEnum.AUTO)) {
            AutoOtherInWHProgressHintListener listener = new AutoOtherInWHProgressHintListener();
            ProgressHintUI.showProgressHintUI((CoreUIObject)parentUI, (ProgressHintListener)listener, (Map)param);
            if (param.containsKey("allocator")) {
                allocator = (Allocator)param.get("allocator");
            }
        } else if (allocType.equals((Object)AllocTypeEnum.MANU)) {
            DynManuOtherInWarehsAllocatorBuilder builder = new DynManuOtherInWarehsAllocatorBuilder(param, parentUI);
            AllocDirector director = new AllocDirector();
            director.CreateAllocator((AllocatorBuilder)builder);
            allocator = builder.getAllocator();
        } else if (allocType.equals((Object)AllocTypeEnum.WIZ)) {
            WizMatProgressHintListener listener = new WizMatProgressHintListener();
            ProgressHintUI.showProgressHintUI((CoreUIObject)parentUI, (ProgressHintListener)listener, (Map)param);
            if (param.containsKey("allocator")) {
                allocator = (Allocator)param.get("allocator");
            }
        }
        return allocator;
    }

    public Allocator DoCostAdjustAllocate(CoreUIObject parentUI, AllocTypeEnum allocType, Map param) throws Exception {
        param.put("allocSourceBill", AllocSourceBillEnum.CostAjustBill);
        Allocator allocator = null;
        if (allocType.equals((Object)AllocTypeEnum.AUTO)) {
            AutoCostAdjustProgressHintListener listener = new AutoCostAdjustProgressHintListener();
            ProgressHintUI.showProgressHintUI((CoreUIObject)parentUI, (ProgressHintListener)listener, (Map)param);
            if (param.containsKey("allocator")) {
                allocator = (Allocator)param.get("allocator");
            }
        } else if (allocType.equals((Object)AllocTypeEnum.MANU)) {
            DynManuCostAdjustAllocatorBuilder builder = new DynManuCostAdjustAllocatorBuilder(param, parentUI);
            AllocDirector director = new AllocDirector();
            director.CreateAllocator((AllocatorBuilder)builder);
            allocator = builder.getAllocator();
        } else if (allocType.equals((Object)AllocTypeEnum.WIZ)) {
            WizMatProgressHintListener listener = new WizMatProgressHintListener();
            ProgressHintUI.showProgressHintUI((CoreUIObject)parentUI, (ProgressHintListener)listener, (Map)param);
            if (param.containsKey("allocator")) {
                allocator = (Allocator)param.get("allocator");
            }
        }
        return allocator;
    }

    public Allocator DoOtherAllocate(CoreUIObject parentUI, AllocTypeEnum allocType, Map param) throws Exception {
        param.put("allocSourceBill", AllocSourceBillEnum.OtherFeeBill);
        Allocator allocator = null;
        if (allocType.equals((Object)AllocTypeEnum.AUTO)) {
            AutoOtherProgressHintListener listener = new AutoOtherProgressHintListener();
            ProgressHintUI.showProgressHintUI((CoreUIObject)parentUI, (ProgressHintListener)listener, (Map)param);
            if (param.containsKey("allocator")) {
                allocator = (Allocator)param.get("allocator");
            }
        } else if (allocType.equals((Object)AllocTypeEnum.MANU)) {
            DynManuOtherAllocatorBuilder builder = new DynManuOtherAllocatorBuilder(param, parentUI);
            AllocDirector director = new AllocDirector();
            director.CreateAllocator((AllocatorBuilder)builder);
            allocator = builder.getAllocator();
        } else if (allocType.equals((Object)AllocTypeEnum.WIZ)) {
            WizOtherProgressHintListener listener = new WizOtherProgressHintListener();
            ProgressHintUI.showProgressHintUI((CoreUIObject)parentUI, (ProgressHintListener)listener, (Map)param);
            if (param.containsKey("allocator")) {
                allocator = (Allocator)param.get("allocator");
            }
        }
        return allocator;
    }

    public Allocator DoMatAllocateFromMatAllocWizard(CoreUIObject parentUI, Map param, MatAllocWizardSchemeEntryCollection entrys) throws Exception {
        Allocator allocator = null;
        Assert.that((parentUI != null ? 1 : 0) != 0);
        Assert.that((boolean)param.containsKey("company"));
        Assert.that((boolean)param.containsKey("period"));
        Assert.that((boolean)param.containsKey("billType"));
        Assert.that((boolean)param.containsKey("parentUi"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo filter = this.getFilterForMatAlloc(param);
        CoreUIObject parentUi = (CoreUIObject)param.get("parentUi");
        HashMap<String, Object> matParam = new HashMap<String, Object>();
        matParam.put("filterInfo", filter);
        matParam.put("companyId", company.getId().toString());
        matParam.put("periodId", period.getId().toString());
        matParam.put("userId", SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        matParam.put("billType", param.get("billType"));
        matParam.put("allocSourceBill", AllocSourceBillEnum.MaterialReqBill);
        DynWizMatAllocatorBuilder builder = new DynWizMatAllocatorBuilder(matParam, parentUi, entrys);
        AllocDirector director = new AllocDirector();
        director.CreateAllocator((AllocatorBuilder)builder);
        allocator = builder.getAllocator();
        param.put("allocator", allocator);
        if (allocator != null && String.valueOf(false).equals(allocator.getResultInfo().get("HasError"))) {
            ((ListUI)parentUi).refreshList();
        }
        return allocator;
    }

    private FilterInfo getFilterForMatAlloc(Map param) throws BOSException {
        Assert.that((boolean)param.containsKey("company"));
        Assert.that((boolean)param.containsKey("period"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo cuFilter = this.getDefaultCUFilter();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)period.getBeginDate(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)period.getEndDate(), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)String.valueOf(4)));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)company.getId().toString()));
        HashSet<Integer> ccoTypeSet = new HashSet<Integer>();
        ccoTypeSet.add(new Integer(0));
        ccoTypeSet.add(new Integer(1));
        filter.getFilterItems().add(new FilterItemInfo("costCenterOrgUnit.costCenterType", ccoTypeSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("transactionType.isManuCostCalculate", (Object)String.valueOf(true)));
        cuFilter.mergeFilter(filter, "and");
        return cuFilter;
    }

    private FilterInfo getDefaultCUFilter() {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        filter.setMaskString("#0 or #1 or #2");
        return filter;
    }

    public Allocator DoMatAllocateFromCalWizard(CoreUIObject parentUI, Map param) throws Exception {
        Map matParam = this.makeMatAllocParamFromCalWizard(parentUI, param);
        DynCalWizMatAllocatorBuilder builder = new DynCalWizMatAllocatorBuilder(matParam, parentUI);
        return this.getAllocorFromCalWizard(builder);
    }

    public Allocator DoOIAllocateFromCalWizard(CoreUIObject parentUI, Map param) throws Exception {
        Map matParam = this.makeOIAllocParamFromCalWizard(parentUI, param);
        DynCalWizOtherInwarehsAllocatorBuilder builder = new DynCalWizOtherInwarehsAllocatorBuilder(matParam, parentUI);
        return this.getAllocorFromCalWizard(builder);
    }

    public Allocator DoCAAllocateFromCalWizard(CoreUIObject parentUI, Map param) throws Exception {
        Map matParam = this.makeCAAllocParamFromCalWizard(parentUI, param);
        DynCalWizCostAdjustAllocatorBuilder builder = new DynCalWizCostAdjustAllocatorBuilder(matParam, parentUI);
        return this.getAllocorFromCalWizard(builder);
    }

    private Map makeMatAllocParamFromCalWizard(CoreUIObject parentUI, Map param) throws BOSException {
        Assert.that((parentUI != null ? 1 : 0) != 0);
        Assert.that((boolean)param.containsKey("company"));
        Assert.that((boolean)param.containsKey("period"));
        Assert.that((boolean)param.containsKey("isOnlyUnAlloced"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo filter = this.getFilterForMatAlloc(param);
        HashMap<String, Object> matParam = new HashMap<String, Object>();
        matParam.put("filterInfo", filter);
        matParam.put("companyId", company.getId().toString());
        matParam.put("periodId", period.getId().toString());
        matParam.put("isNormal", "false");
        matParam.put("companyName", company.getName().toString());
        matParam.put("periodNumber", String.valueOf(period.getNumber()));
        matParam.put("allocSourceBill", AllocSourceBillEnum.MaterialReqBill);
        if (param.get("isOnlyUnAlloced").equals(String.valueOf(true))) {
            matParam.put("isOnlyUnAlloced", String.valueOf(true));
        } else {
            matParam.put("bFilter_all", String.valueOf(true));
        }
        return matParam;
    }

    private Map makeOIAllocParamFromCalWizard(CoreUIObject parentUI, Map param) throws BOSException {
        Assert.that((parentUI != null ? 1 : 0) != 0);
        Assert.that((boolean)param.containsKey("company"));
        Assert.that((boolean)param.containsKey("period"));
        Assert.that((boolean)param.containsKey("isOnlyUnAlloced"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo filter = this.getFilterForOIAlloc(param);
        HashMap<String, Object> matParam = new HashMap<String, Object>();
        matParam.put("filterInfo", filter);
        matParam.put("companyId", company.getId().toString());
        matParam.put("periodId", period.getId().toString());
        matParam.put("isNormal", "false");
        matParam.put("companyName", company.getName().toString());
        matParam.put("periodNumber", String.valueOf(period.getNumber()));
        matParam.put("allocSourceBill", AllocSourceBillEnum.OtherInWarehsBill);
        if (param.get("isOnlyUnAlloced").equals(String.valueOf(true))) {
            matParam.put("isOnlyUnAlloced", String.valueOf(true));
        } else {
            matParam.put("bFilter_all", String.valueOf(true));
        }
        return matParam;
    }

    private Map makeCAAllocParamFromCalWizard(CoreUIObject parentUI, Map param) throws BOSException {
        Assert.that((parentUI != null ? 1 : 0) != 0);
        Assert.that((boolean)param.containsKey("company"));
        Assert.that((boolean)param.containsKey("period"));
        Assert.that((boolean)param.containsKey("isOnlyUnAlloced"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo filter = this.getFilterForCAAlloc(param);
        HashMap<String, Object> matParam = new HashMap<String, Object>();
        matParam.put("filterInfo", filter);
        matParam.put("companyId", company.getId().toString());
        matParam.put("periodId", period.getId().toString());
        matParam.put("isNormal", "false");
        matParam.put("companyName", company.getName().toString());
        matParam.put("periodNumber", String.valueOf(period.getNumber()));
        matParam.put("isNormal", "false");
        matParam.put("allocSourceBill", AllocSourceBillEnum.CostAjustBill);
        if (param.get("isOnlyUnAlloced").equals(String.valueOf(true))) {
            matParam.put("isOnlyUnAlloced", String.valueOf(true));
        } else {
            matParam.put("bFilter_all", String.valueOf(true));
        }
        return matParam;
    }

    public Allocator DoOtherAllocateFromCalWizard(CoreUIObject parentUI, Map param) throws Exception {
        Allocator allocator = null;
        Assert.that((parentUI != null ? 1 : 0) != 0);
        Assert.that((boolean)param.containsKey("isOnlyUnAlloced"));
        Assert.that((boolean)param.containsKey("company"));
        Assert.that((boolean)param.containsKey("period"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo filter = this.getFilterForOtherAlloc(param);
        HashMap<String, Object> matParam = new HashMap<String, Object>();
        matParam.put("filterInfo", filter);
        matParam.put("companyId", company.getId().toString());
        matParam.put("periodId", period.getId().toString());
        matParam.put("isNormal", "false");
        matParam.put("companyName", company.getName().toString());
        matParam.put("periodNumber", String.valueOf(period.getNumber()));
        matParam.put("allocSourceBill", AllocSourceBillEnum.OtherFeeBill);
        try {
            AllocDirector director = new AllocDirector();
            DynCalWizOtherAllocatorBuilder builder = new DynCalWizOtherAllocatorBuilder(matParam, parentUI);
            director.CreateAllocator((AllocatorBuilder)builder);
            allocator = builder.getAllocator();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return allocator;
    }

    private Allocator getAllocorFromCalWizard(AllocatorBuilder builder) {
        try {
            AllocDirector director = new AllocDirector();
            director.CreateAllocator(builder);
            this.allocator = builder.getAllocator();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return this.allocator;
    }

    private FilterInfo getFilterForOIAlloc(Map param) throws BOSException {
        Assert.that((boolean)param.containsKey("isOnlyUnAlloced"));
        Assert.that((boolean)param.containsKey("company"));
        Assert.that((boolean)param.containsKey("period"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo cuFilter = this.getDefaultCUFilter();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)period.getBeginDate(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)period.getEndDate(), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)String.valueOf(4)));
        filter.getFilterItems().add(new FilterItemInfo("isReversed", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("costCenterOrgUnit.costCenterType", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("transactionType.isManuCostCalculate", (Object)String.valueOf(true)));
        HashSet<Integer> effectManufactureCostSet = new HashSet<Integer>();
        effectManufactureCostSet.add(new Integer(1));
        effectManufactureCostSet.add(new Integer(-1));
        filter.getFilterItems().add(new FilterItemInfo("transactionType.effectManufactureCost", effectManufactureCostSet, CompareType.INCLUDE));
        cuFilter.mergeFilter(filter, "and");
        return cuFilter;
    }

    private FilterInfo getFilterForCAAlloc(Map param) throws BOSException {
        Assert.that((boolean)param.containsKey("isOnlyUnAlloced"));
        Assert.that((boolean)param.containsKey("company"));
        Assert.that((boolean)param.containsKey("period"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo cuFilter = this.getDefaultCUFilter();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)period.getBeginDate(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)period.getEndDate(), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)String.valueOf(4)));
        filter.getFilterItems().add(new FilterItemInfo("isReversed", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("calculateKind", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("issueType", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("costCenterOrgUnit.costCenterType", (Object)new Integer(0)));
        cuFilter.mergeFilter(filter, "and");
        return cuFilter;
    }

    private FilterInfo getFilterForOtherAlloc(Map param) throws BOSException {
        Assert.that((boolean)param.containsKey("isOnlyUnAlloced"));
        Assert.that((boolean)param.containsKey("company"));
        Assert.that((boolean)param.containsKey("period"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo cuFilter = this.getDefaultCUFilter();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)period.getBeginDate(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)period.getEndDate(), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)String.valueOf(4)));
        filter.getFilterItems().add(new FilterItemInfo("companyOrg.id", (Object)company.getId().toString()));
        HashSet<Integer> ccoTypeSet = new HashSet<Integer>();
        ccoTypeSet.add(new Integer(0));
        ccoTypeSet.add(new Integer(1));
        filter.getFilterItems().add(new FilterItemInfo("costCenter.costCenterType", ccoTypeSet, CompareType.INCLUDE));
        if (param.get("isOnlyUnAlloced").equals(String.valueOf(true))) {
            String tblResult = NCMCommonFacadeFactory.getRemoteInstance().getPhysicalTblName(company.getId().toString(), "T_NCM_DynOtherAllocResult");
            filter.getFilterItems().add(new FilterItemInfo("entries.id", (Object)("(Select FSourceBillEntryID from " + tblResult + ")"), CompareType.NOTINNER, false));
        }
        cuFilter.mergeFilter(filter, "and");
        return cuFilter;
    }

    private FilterInfo getFilterForCCOAlloc(Map param) throws BOSException {
        Assert.that((boolean)param.containsKey("isOnlyUnAlloced"));
        Assert.that((boolean)param.containsKey("company"));
        Assert.that((boolean)param.containsKey("period"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo cuFilter = this.getDefaultCUFilter();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)period.getBeginDate(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)period.getEndDate(), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)String.valueOf(4)));
        filter.getFilterItems().add(new FilterItemInfo("companyOrg.id", (Object)company.getId().toString()));
        if (param.get("isOnlyUnAlloced").equals(String.valueOf(true))) {
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("entries.isAlloced", (Object)Boolean.FALSE));
            filter1.getFilterItems().add(new FilterItemInfo("entries.isAlloced", null));
            filter1.setMaskString("#0 or #1");
            filter.mergeFilter(filter1, "and");
        }
        cuFilter.mergeFilter(filter, "and");
        return cuFilter;
    }

    static final class WizMatProgressHintListener
    implements ProgressHintListener {
        WizMatProgressHintListener() {
        }

        public void doFunction(Map param) throws Exception {
            Assert.that((boolean)param.containsKey("parentUi"));
            CoreUIObject parentUi = (CoreUIObject)param.get("parentUi");
            param.remove("parentUi");
            DynWizMatAllocatorBuilder builder = new DynWizMatAllocatorBuilder(param, parentUi, null);
            AllocDirector director = new AllocDirector();
            director.CreateAllocator((AllocatorBuilder)builder);
            Allocator alloc = builder.getAllocator();
            param.put("allocator", alloc);
            if (alloc.getResultInfo().get("HasError") == String.valueOf(false)) {
                ((ListUI)parentUi).refreshList();
            }
        }
    }

    static final class AutoMatProgressHintListener
    implements ProgressHintListener {
        AutoMatProgressHintListener() {
        }

        public void doFunction(Map param) throws Exception {
            Assert.that((boolean)param.containsKey("parentUi"));
            CoreUIObject parentUi = (CoreUIObject)param.get("parentUi");
            param.remove("parentUi");
            DynAutoMatAllocatorBuilder builder = new DynAutoMatAllocatorBuilder(param, parentUi);
            AllocDirector director = new AllocDirector();
            director.CreateAllocator((AllocatorBuilder)builder);
            Allocator alloc = builder.getAllocator();
            param.put("allocator", alloc);
            if (alloc.getResultInfo().get("HasError") == String.valueOf(false)) {
                ((ListUI)parentUi).refreshList();
            }
        }
    }

    static final class AutoOtherInWHProgressHintListener
    implements ProgressHintListener {
        AutoOtherInWHProgressHintListener() {
        }

        public void doFunction(Map param) throws Exception {
            Assert.that((boolean)param.containsKey("parentUi"));
            CoreUIObject parentUi = (CoreUIObject)param.get("parentUi");
            param.remove("parentUi");
            DynAutoOtherInWHAllocatorBuilder builder = new DynAutoOtherInWHAllocatorBuilder(param, parentUi);
            AllocDirector director = new AllocDirector();
            director.CreateAllocator((AllocatorBuilder)builder);
            Allocator alloc = builder.getAllocator();
            param.put("allocator", alloc);
            if (alloc.getResultInfo().get("HasError") == String.valueOf(false)) {
                ((ListUI)parentUi).refreshList();
            }
        }
    }

    static final class AutoCostAdjustProgressHintListener
    implements ProgressHintListener {
        AutoCostAdjustProgressHintListener() {
        }

        public void doFunction(Map param) throws Exception {
            Assert.that((boolean)param.containsKey("parentUi"));
            CoreUIObject parentUi = (CoreUIObject)param.get("parentUi");
            param.remove("parentUi");
            DynAutoCostAdjustAllocatorBuilder builder = new DynAutoCostAdjustAllocatorBuilder(param, parentUi);
            AllocDirector director = new AllocDirector();
            director.CreateAllocator((AllocatorBuilder)builder);
            Allocator alloc = builder.getAllocator();
            param.put("allocator", alloc);
            if (alloc.getResultInfo().get("HasError") == String.valueOf(false)) {
                ((ListUI)parentUi).refreshList();
            }
        }
    }

    static final class WizOtherProgressHintListener
    implements ProgressHintListener {
        WizOtherProgressHintListener() {
        }

        public void doFunction(Map param) throws Exception {
            Assert.that((boolean)param.containsKey("parentUi"));
            CoreUIObject parentUi = (CoreUIObject)param.get("parentUi");
            param.remove("parentUi");
            WizOtherAllocatorBuilder builder = new WizOtherAllocatorBuilder(param, parentUi);
            AllocDirector director = new AllocDirector();
            director.CreateAllocator((AllocatorBuilder)builder);
            Allocator alloc = builder.getAllocator();
            param.put("allocator", alloc);
            if (alloc.getResultInfo().get("HasError") == String.valueOf(false)) {
                ((ListUI)parentUi).refreshList();
            }
        }
    }

    static final class AutoOtherProgressHintListener
    implements ProgressHintListener {
        AutoOtherProgressHintListener() {
        }

        public void doFunction(Map param) throws Exception {
            Assert.that((boolean)param.containsKey("parentUi"));
            CoreUIObject parentUi = (CoreUIObject)param.get("parentUi");
            param.remove("parentUi");
            DynAutoOtherAllocatorBuilder builder = null;
            builder = new DynAutoOtherAllocatorBuilder(param, parentUi);
            AllocDirector director = new AllocDirector();
            director.CreateAllocator((AllocatorBuilder)builder);
            Allocator alloc = builder.getAllocator();
            param.put("allocator", alloc);
            if (alloc.getResultInfo().get("HasError") == String.valueOf(false)) {
                ((ListUI)parentUi).refreshList();
            }
        }
    }
}

