/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.list.exception.ObjectNotFoundException;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.ncm.PeriodStatuEnum;
import com.kingdee.eas.basedata.ncm.PeriodStatusCollection;
import com.kingdee.eas.basedata.ncm.PeriodStatusFactory;
import com.kingdee.eas.ncm.bill.AllocTypeEnum;
import com.kingdee.eas.ncm.bill.client.OtherAllocListUI;
import com.kingdee.eas.ncm.bill.client.OtherAllocLogReportUI;
import com.kingdee.eas.ncm.common.utils.client.NCMCommonQueryProcessor;
import com.kingdee.eas.ncm.dynamic.bill.client.AllocBuilder.DynAllocClientDispatch;
import com.kingdee.eas.ncm.dynamic.bill.client.OtherAllocFilterUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class DCOtherAllocListUI
extends OtherAllocListUI {
    private static final long serialVersionUID = 1L;
    private CommonQueryDialog dialog = null;
    private OtherAllocFilterUI filterUI = null;
    private PeriodInfo periodDyn;

    public DCOtherAllocListUI() throws Exception {
        this.isNormal = false;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn("calculatePeriod.number").getStyleAttributes().setHided(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionAutoAlloc_actionPerformed(ActionEvent e) throws Exception {
        IPermission iPermisstion = PermissionFactory.getRemoteInstance();
        iPermisstion.checkFunctionPermission(this.getUserPk(), this.getOrgPK(), "ncmdm_DCOtherAlloc_auto");
        this.periodDyn = this.getPeriod();
        this.checkPeriod(this.periodDyn);
        this.requestMutex(this._company.getId().toString());
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("filterInfo", this._currFilterInfo);
            param.put("bFilter_all", String.valueOf(this.bFilter_all));
            param.put("companyId", this._company.getId().toString());
            param.put("periodId", this.periodDyn.getId().toString());
            param.put("parentUi", (Object)this);
            param.put("isNormal", new Integer(1));
            param.put("companyName", this._company.getName().toString());
            param.put("periodNumber", String.valueOf(this.periodDyn.getNumber()));
            DynAllocClientDispatch disp = new DynAllocClientDispatch();
            disp.DoOtherAllocate((CoreUIObject)this, AllocTypeEnum.AUTO, param);
        }
        finally {
            this.releaseMutex(this._company.getId().toString());
        }
        this.setLogInfo("actionAutoAlloc", "OtherAlloc_Auto");
    }

    public void actionViewLog_actionPerformed(ActionEvent e) throws Exception {
        IPermission iPermisstion = PermissionFactory.getRemoteInstance();
        iPermisstion.checkFunctionPermission(this.getUserPk(), this.getOrgPK(), "ncmdm_DCOtherAlloc_viewLog");
        this.periodDyn = this.getPeriod();
        this.checkPeriod(this.periodDyn);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("companyId", this._company.getId().toString());
        param.put("periodId", this.periodDyn.getId().toString());
        param.put("companyName", this._company.getName().toString());
        param.put("periodNumber", String.valueOf(this.periodDyn.getNumber()));
        param.put("logTblName", "T_NCM_LOG_DynOther");
        this.setLogInfo("actionViewLog", "OtherAlloc_Error");
        OtherAllocLogReportUI.showAllocReportUI((CoreUIObject)this, param);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog == null) {
            this.dialog = super.initCommonQueryDialog();
        }
        if (this.getFilterUI() != null) {
            this.dialog.addUserPanel((KDPanel)this.getFilterUI());
        }
        this.dialog.setWidth(400);
        this.dialog.setHeight(250);
        NCMCommonQueryProcessor cmcq = new NCMCommonQueryProcessor();
        cmcq.set("companyOrg", (Object)this._company.getId().toString());
        cmcq.set("query", (Object)"OtherAllocQuery");
        this.dialog.setProcessor((IProcessor)cmcq);
        return this.dialog;
    }

    protected CustomerQueryPanel getFilterUI() {
        if (this.filterUI == null) {
            try {
                this.filterUI = new OtherAllocFilterUI();
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
        }
        return this.filterUI;
    }

    private PeriodInfo getPeriod() {
        PeriodInfo periodInfo = (PeriodInfo)this.filterUI.prmtBizPeriod.getValue();
        return periodInfo;
    }

    private void checkPeriod(PeriodInfo periodInfo) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)periodInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this._company.getId().toString()));
        ev.setFilter(filter);
        PeriodStatusCollection periodStatusColl = null;
        try {
            periodStatusColl = PeriodStatusFactory.getRemoteInstance().getPeriodStatusCollection(ev);
        }
        catch (ObjectNotFoundException exc) {
            this.handUIException(exc);
        }
        if (periodStatusColl == null) {
            return;
        }
        if (periodStatusColl.get(0).getStatu().equals((Object)PeriodStatuEnum.CLOSE)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.bill.client.BILLCLIENTAutoGenerateResource", (String)"2_DCCostAdjustAllocListUI"));
            this.abort();
        }
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        try {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)String.valueOf(4)));
            filter.getFilterItems().add(new FilterItemInfo("companyOrg.id", (Object)this._company.getId().toString()));
            HashSet<Integer> ccoTypeSet = new HashSet<Integer>();
            ccoTypeSet.add(new Integer(0));
            ccoTypeSet.add(new Integer(1));
            filter.getFilterItems().add(new FilterItemInfo("costCenter.costCenterType", ccoTypeSet, CompareType.INCLUDE));
            for (FilterItemInfo item : ev.getFilter().getFilterItems()) {
                if (!item.getPropertyName().equals("isAllocated")) continue;
                String tblResult = this.getResultTblName();
                int isAllocated = item.getInt("compareValue");
                int idx = ev.getFilter().getFilterItems().indexOf((IObjectValue)item);
                FilterItemInfo newItem = null;
                if (isAllocated == 1) {
                    newItem = new FilterItemInfo("entries.id", (Object)("(Select FSourceBillEntryID from " + tblResult + ")"), CompareType.INNER, false);
                } else if (isAllocated == 0) {
                    newItem = new FilterItemInfo("entries.id", (Object)("(Select FSourceBillEntryID from " + tblResult + ")"), CompareType.NOTINNER, false);
                }
                ev.getFilter().getFilterItems().set(idx, newItem);
                break;
            }
            try {
                ev.getFilter().mergeFilter(filter, "and");
                this._currFilterInfo = (FilterInfo)ev.getFilter().clone();
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void setPeriodForDaily(Map param, String operType) throws BOSException {
        this.periodDyn = this.getPeriod();
        if ("ADJUST".equals(operType)) {
            this.checkPeriod(this.periodDyn);
        }
        param.put("periodId", this.periodDyn.getId().toString());
        param.put("periodNumber", String.valueOf(this.periodDyn.getNumber()));
    }

    public void actionManuAlloc_actionPerformed(ActionEvent e) throws Exception {
        IPermission iPermisstion = PermissionFactory.getRemoteInstance();
        iPermisstion.checkFunctionPermission(this.getUserPk(), this.getOrgPK(), "ncmdm_DCOtherAlloc_manu");
        super.actionManuAlloc_actionPerformed(e);
    }

    public void actionViewAlloc_actionPerformed(ActionEvent e) throws Exception {
        IPermission iPermisstion = PermissionFactory.getRemoteInstance();
        iPermisstion.checkFunctionPermission(this.getUserPk(), this.getOrgPK(), "ncmdm_DCOtherAlloc_viewAlloc");
        super.actionViewAlloc_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        IPermission iPermisstion = PermissionFactory.getRemoteInstance();
        iPermisstion.checkFunctionPermission(this.getUserPk(), this.getOrgPK(), "ncmdm_DCOtherAlloc_print");
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        IPermission iPermisstion = PermissionFactory.getRemoteInstance();
        iPermisstion.checkFunctionPermission(this.getUserPk(), this.getOrgPK(), "ncmdm_DCOtherAlloc_print");
        super.actionPrintPreview_actionPerformed(e);
    }
}

