/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.PeriodFactory;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.ncm.utils.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.common.NCMIFilterParam;
import com.kingdee.eas.ncm.dynamic.bill.DCOtherInWarehsAllocFilterParam;
import com.kingdee.eas.ncm.dynamic.bill.client.AbstractDCOtherInWarehsAllocFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class DCOtherInWarehsAllocFilterUI
extends AbstractDCOtherInWarehsAllocFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(DCOtherInWarehsAllocFilterUI.class);
    private static final String COSTCENTER_IDS = "CostCenterIds";
    private static final String MATIERL_IDS = "MaterialIds";
    private static final String COSTOBJECT_IDS = "CostObjectIds";
    private static final String BIZPERIOD_IDS = "BizPeriodIds";

    public DCOtherInWarehsAllocFilterUI() throws Exception {
        this.isNormal = false;
        this.initPeriod();
    }

    public void storeFields() {
        super.storeFields();
    }

    private void initPeriod() throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        com.kingdee.eas.basedata.assistant.PeriodInfo currPeriod = sysctrol.getCacheCurrentPeriod(2, companyInfo.getId().toString());
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("PeriodStatus.statu", (Object)new Integer(1)));
        if (currPeriod != null) {
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)PeriodUtils.getDayBegin((Date)currPeriod.getBeginDate()), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)PeriodUtils.getDayEnd((Date)currPeriod.getEndDate()), CompareType.LESS_EQUALS));
        }
        ev.setFilter(filter);
        this.prmtBizPeriod.setEntityViewInfo(ev);
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.ncm.dynamic.bill.app.PeriodFilterF7Query"));
        exec.setObjectView(ev);
        IRowSet rs = exec.executeQuery();
        exec.getSQL();
        String strId = null;
        try {
            if (rs.next()) {
                strId = rs.getString("ID");
            }
        }
        catch (SQLException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (strId == null) {
            return;
        }
        PeriodInfo periodInfo = PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectStringPK(strId));
        this.prmtBizPeriod.setValue((Object)periodInfo);
    }

    protected NCMIFilterParam createNewFilterParam() {
        return new DCOtherInWarehsAllocFilterParam();
    }

    protected void loadBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof DCOtherInWarehsAllocFilterParam)) {
            return;
        }
        DCOtherInWarehsAllocFilterParam _filterParam = (DCOtherInWarehsAllocFilterParam)filterParam;
        String bizPeriodIds = customerParams.getCustomerParam(BIZPERIOD_IDS);
        if (bizPeriodIds != null) {
            if (!StringUtils.isEmpty((String)bizPeriodIds)) {
                _filterParam.setBizPeriod(new PeriodInfo());
                _filterParam.getBizPeriod().setId(BOSUuid.read((String)bizPeriodIds));
            } else {
                _filterParam.setBizPeriod(null);
            }
        } else {
            _filterParam.setBizPeriod(null);
        }
        List DcCostCenterIds = (List)this.getObject(this.decode(customerParams.getCustomerParam(COSTCENTER_IDS)));
        if (DcCostCenterIds != null) {
            _filterParam.setCostCenters(new CostCenterOrgUnitInfo[DcCostCenterIds.size()]);
            String id = null;
            int in = DcCostCenterIds.size();
            for (int i = 0; i < in; ++i) {
                id = (String)DcCostCenterIds.get(i);
                if (StringUtils.isEmpty((String)id)) continue;
                _filterParam.getCostCenters()[i] = new CostCenterOrgUnitInfo();
                _filterParam.getCostCenters()[i].setId(BOSUuid.read((String)id));
            }
        } else {
            _filterParam.setCostCenters(null);
        }
        List materialIds = (List)this.getObject(this.decode(customerParams.getCustomerParam(MATIERL_IDS)));
        if (materialIds != null) {
            _filterParam.setMaterials(new MaterialInfo[materialIds.size()]);
            String id = null;
            int in = materialIds.size();
            for (int i = 0; i < in; ++i) {
                id = (String)materialIds.get(i);
                if (StringUtils.isEmpty((String)id)) continue;
                _filterParam.getMaterials()[i] = new MaterialInfo();
                _filterParam.getMaterials()[i].setId(BOSUuid.read((String)id));
            }
        } else {
            _filterParam.setMaterials(null);
        }
        List costObjcetIds = (List)this.getObject(this.decode(customerParams.getCustomerParam(COSTOBJECT_IDS)));
        if (costObjcetIds != null) {
            _filterParam.setCostObject(new CostObjectInfo[costObjcetIds.size()]);
            String id = null;
            int in = costObjcetIds.size();
            for (int i = 0; i < in; ++i) {
                id = (String)costObjcetIds.get(i);
                if (StringUtils.isEmpty((String)id)) continue;
                _filterParam.getCostObject()[i] = new CostObjectInfo();
                _filterParam.getCostObject()[i].setId(BOSUuid.read((String)id));
            }
        } else {
            _filterParam.setCostObject(null);
        }
    }

    protected void storeBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof DCOtherInWarehsAllocFilterParam)) {
            return;
        }
        DCOtherInWarehsAllocFilterParam _filterParam = (DCOtherInWarehsAllocFilterParam)filterParam;
        super.putIdByKey(customerParams, (Object)_filterParam.getBizPeriod(), BIZPERIOD_IDS);
        super.putIdByKey(customerParams, (Object)_filterParam.getCostCenters(), COSTCENTER_IDS);
        super.putIdByKey(customerParams, (Object)_filterParam.getMaterials(), MATIERL_IDS);
        super.putIdByKey(customerParams, (Object)_filterParam.getCostObject(), COSTOBJECT_IDS);
    }

    protected void loadFilterParam(NCMIFilterParam filterParam) {
        if (filterParam != null && filterParam instanceof DCOtherInWarehsAllocFilterParam) {
            DCOtherInWarehsAllocFilterParam _filterParam = (DCOtherInWarehsAllocFilterParam)filterParam;
            if (_filterParam.getBizPeriod() != null) {
                this.prmtBizPeriod.setValue((Object)_filterParam.getBizPeriod());
            } else {
                this.prmtBizPeriod.setValue(null);
            }
            if (_filterParam.getCostCenters() != null) {
                this.kDBizPromptCostCenter.setValue((Object)_filterParam.getCostCenters());
            } else {
                this.kDBizPromptCostCenter.setValue(null);
            }
            if (_filterParam.getMaterials() != null) {
                this.kDBizPromptMaterial.setValue((Object)_filterParam.getMaterials());
            } else {
                this.kDBizPromptMaterial.setValue(null);
            }
            if (_filterParam.getCostObject() != null) {
                this.kDBizPromptCostObject.setValue((Object)_filterParam.getCostObject());
            } else {
                this.kDBizPromptCostObject.setValue(null);
            }
        }
    }

    protected void storeFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof DCOtherInWarehsAllocFilterParam)) {
            return;
        }
        DCOtherInWarehsAllocFilterParam _filterParam = (DCOtherInWarehsAllocFilterParam)filterParam;
        PeriodInfo bizPeriodInfo = (PeriodInfo)this.prmtBizPeriod.getData();
        _filterParam.setBizPeriod(bizPeriodInfo);
        CostCenterOrgUnitInfo[] costCenters = null;
        Object costCenterObject = this.kDBizPromptCostCenter.getData();
        if (costCenterObject instanceof CostCenterOrgUnitInfo) {
            costCenters = new CostCenterOrgUnitInfo[]{(CostCenterOrgUnitInfo)costCenterObject};
        } else if (costCenterObject instanceof Object[]) {
            costCenters = new CostCenterOrgUnitInfo[((Object[])costCenterObject).length];
            System.arraycopy(costCenterObject, 0, costCenters, 0, ((Object[])costCenterObject).length);
        }
        _filterParam.setCostCenters(costCenters);
        MaterialInfo[] materils = null;
        Object material = this.kDBizPromptMaterial.getData();
        if (material instanceof MaterialInfo) {
            materils = new MaterialInfo[]{(MaterialInfo)material};
        } else if (material instanceof Object[]) {
            materils = new MaterialInfo[((Object[])material).length];
            System.arraycopy(material, 0, materils, 0, ((Object[])material).length);
        }
        _filterParam.setMaterials(materils);
        CostObjectInfo[] costObjects = null;
        Object costObject = this.kDBizPromptCostObject.getData();
        if (costObject instanceof CostObjectInfo) {
            costObjects = new CostObjectInfo[]{(CostObjectInfo)costObject};
        } else if (costObject instanceof Object[]) {
            costObjects = new CostObjectInfo[((Object[])costObject).length];
            System.arraycopy(costObject, 0, costObjects, 0, ((Object[])costObject).length);
        }
        _filterParam.setCostObject(costObjects);
    }

    public boolean verify() {
        if (this.prmtBizPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.bill.client.BILLCLIENTAutoGenerateResource", (String)"3_DCOtherInWarehsAllocFilterUI"));
            SysUtil.abort();
        }
        return super.verify();
    }
}

