/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.ncm.PeriodFactory;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.ncm.utils.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.common.NCMIFilterParam;
import com.kingdee.eas.ncm.dynamic.bill.OtherAllocFilterParam;
import com.kingdee.eas.ncm.dynamic.bill.client.AbstractOtherAllocFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.Logger;

public class OtherAllocFilterUI
extends AbstractOtherAllocFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(OtherAllocFilterUI.class);
    private static final String BIZPERIOD_IDS = "BizPeriodIds";

    public OtherAllocFilterUI() throws Exception {
        this.isNormal = false;
        this.init();
    }

    public void storeFields() {
        super.storeFields();
    }

    private void init() throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        this.kDBizPromptCompany.setValue((Object)company);
        this.initPeriod(company);
    }

    private void initPeriod(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        com.kingdee.eas.basedata.assistant.PeriodInfo currPeriod = sysctrol.getCacheCurrentPeriod(2, company.getId().toString());
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("PeriodStatus.statu", (Object)new Integer(1)));
        if (currPeriod != null) {
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)PeriodUtils.getDayBegin((Date)currPeriod.getBeginDate()), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)PeriodUtils.getDayEnd((Date)currPeriod.getEndDate()), CompareType.LESS_EQUALS));
        }
        ev.setFilter(filter);
        this.prmtBizPeriod.setEntityViewInfo(ev);
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.ncm.dynamic.bill.app.PeriodFilterF7Query"));
        exec.setObjectView(ev);
        IRowSet rs = exec.executeQuery();
        String strId = null;
        try {
            if (rs.next()) {
                strId = rs.getString("ID");
            }
        }
        catch (SQLException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (strId == null) {
            return;
        }
        PeriodInfo periodInfo = PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectStringPK(strId));
        this.prmtBizPeriod.setValue((Object)periodInfo);
    }

    protected NCMIFilterParam createNewFilterParam() {
        return new OtherAllocFilterParam();
    }

    protected void loadBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof OtherAllocFilterParam)) {
            return;
        }
        OtherAllocFilterParam _filterParam = (OtherAllocFilterParam)filterParam;
        String costCenterIds = customerParams.getCustomerParam(BIZPERIOD_IDS);
        if (costCenterIds != null) {
            if (!StringUtils.isEmpty((String)costCenterIds)) {
                _filterParam.setBizPeriod(new PeriodInfo());
                _filterParam.getBizPeriod().setId(BOSUuid.read((String)costCenterIds));
            } else {
                _filterParam.setBizPeriod(null);
            }
        } else {
            _filterParam.setBizPeriod(null);
        }
    }

    protected void loadFilterParam(NCMIFilterParam filterParam) {
        if (filterParam != null && filterParam instanceof OtherAllocFilterParam) {
            OtherAllocFilterParam _filterParam = (OtherAllocFilterParam)filterParam;
            if (_filterParam.getBizPeriod() != null) {
                this.prmtBizPeriod.setValue((Object)_filterParam.getBizPeriod());
            } else {
                this.prmtBizPeriod.setValue(null);
            }
        }
    }

    protected void storeBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof OtherAllocFilterParam)) {
            return;
        }
        OtherAllocFilterParam _filterParam = (OtherAllocFilterParam)filterParam;
        super.putIdByKey(customerParams, (Object)_filterParam.getBizPeriod(), BIZPERIOD_IDS);
    }

    protected void storeFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof OtherAllocFilterParam)) {
            return;
        }
        OtherAllocFilterParam _filterParam = (OtherAllocFilterParam)filterParam;
        PeriodInfo bizPeriodInfo = (PeriodInfo)this.prmtBizPeriod.getData();
        _filterParam.setBizPeriod(bizPeriodInfo);
    }

    public boolean verify() {
        if (this.prmtBizPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.bill.client.BILLCLIENTAutoGenerateResource", (String)"3_DCOtherInWarehsAllocFilterUI"));
            SysUtil.abort();
        }
        return super.verify();
    }
}

