/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ncm.cal.CalCostFacadeFactory;
import com.kingdee.eas.ncm.dynamic.cal.DynCalcLogCollection;
import com.kingdee.eas.ncm.dynamic.cal.DynCalcLogEntryCollection;
import com.kingdee.eas.ncm.dynamic.cal.DynCalcLogInfo;
import com.kingdee.eas.ncm.dynamic.cal.client.AbstractDCCostCalcLogReportUI;
import com.kingdee.eas.ncm.dynamic.cal.client.DCCostCalcLogDetailReportUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.Assert;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DCCostCalcLogReportUI
extends AbstractDCCostCalcLogReportUI {
    private static final Logger logger = CoreUIObject.getLogger(DCCostCalcLogReportUI.class);
    public com.kingdee.eas.basedata.assistant.PeriodInfo fiPeriod = null;
    public PeriodInfo bizPeriod = null;
    private Map _parentParam = null;
    private String _companyId = null;
    private String _periodId = null;
    private String _companyName = null;
    private String _periodNumber = null;
    private DynCalcLogCollection _logData = null;

    public static void showCalcReportUI(CoreUIObject ui, Map param) throws Exception {
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("companyName"));
        Assert.that((boolean)param.containsKey("periodNumber"));
        Assert.that((boolean)param.containsKey("periodId"));
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"param", (Object)param);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DCCostCalcLogReportUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtPeriod.setEnabled(false);
        this._parentParam = (Map)this.getUIContext().get("param");
        this._companyId = (String)this._parentParam.get("companyId");
        this._periodId = (String)this._parentParam.get("periodId");
        this._companyName = (String)this._parentParam.get("companyName");
        this._periodNumber = (String)this._parentParam.get("periodNumber");
        this.fiPeriod = (com.kingdee.eas.basedata.assistant.PeriodInfo)this._parentParam.get("fiPeriod");
        this.bizPeriod = (PeriodInfo)this._parentParam.get("bizPeriod");
        this.txtPeriod.setText(String.valueOf(this.fiPeriod.getNumber()));
        this.prmtPeriod.setValue((Object)this.bizPeriod);
        this.prmtPeriod.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
            }
        });
        this._logData = this._parentParam.containsKey("logData") ? (DynCalcLogCollection)((Object)this._parentParam.get("logData")) : CalCostFacadeFactory.getRemoteInstance().getDynCalcLogData(this._companyId, this._periodId);
        this.kDTable.checkParsed();
        this.kDTable.getGroupManager().setGroup(true);
        this.kDTable.getColumn("calcRank").setGroup(true);
        this.kDTable.getColumn("calcRank").setMergeable(true);
        this.loadFields();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    public void loadFields() {
        super.loadFields();
        this.fillReportData();
    }

    private void fillReportData() {
        this.txtCompany.setText(this._companyName);
        if (this._logData == null) {
            return;
        }
        boolean isHandle = false;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < this._logData.size(); ++i) {
            DynCalcLogInfo item = this._logData.get(i);
            if (!isHandle) {
                this.txtLogTime.setText(sdf.format(item.getCreateTime()));
                this.txtLogUser.setText(item.getCreator().getName());
                isHandle = true;
            }
            IRow row = this.kDTable.addRow();
            row.getCell("calcRank").setValue((Object)item.getCalcRank());
            row.getCell("costObjectDispName").setValue((Object)item.getCostObjectDispName());
            row.getCell("calcItem").setValue((Object)item.getCalcItem());
            row.getCell("status").setValue((Object)item.getStatus());
            row.getCell("attachment").setValue((Object)item.getAttachment());
            row.getCell("logDetail").setValue((Object)item.getEntries());
            if (item.getEntries().size() <= 0) continue;
            row.getStyleAttributes().setBackground(new Color(246, 246, 191));
        }
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kDTable);
        this.kDTable.getPrintManager().print();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kDTable);
        this.kDTable.getPrintManager().printPreview();
    }

    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
    }

    protected void kDTable_tableClicked(KDTMouseEvent e) throws Exception {
        DynCalcLogEntryCollection item;
        super.kDTable_tableClicked(e);
        if (e.getClickCount() == 2 && e.getColIndex() == this.kDTable.getColumnIndex("attachment") && (item = (DynCalcLogEntryCollection)((Object)this.kDTable.getCell(e.getRowIndex(), this.kDTable.getColumnIndex("logDetail")).getValue())).size() > 0) {
            HashMap<String, DynCalcLogEntryCollection> param = new HashMap<String, DynCalcLogEntryCollection>();
            param.put("logDetail", item);
            DCCostCalcLogDetailReportUI.showCalcDetailReportUI((CoreUIObject)this, param);
        }
    }
}

