/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.ncm.ExpenseCollection;
import com.kingdee.eas.basedata.ncm.ExpenseFactory;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.dynamic.cal.report.client.AbstractDCCCFeeTotalReportFilterUI;
import com.kingdee.eas.ncm.dynamic.cal.report.client.SingleComPromptFilterElement;
import com.kingdee.eas.ncm.dynamic.cal.utils.CalPeriodUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class DCCCFeeTotalReportFilterUI
extends AbstractDCCCFeeTotalReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(DCCCFeeTotalReportFilterUI.class);
    private CustomerParams cp = null;

    public DCCCFeeTotalReportFilterUI() throws Exception {
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        com.kingdee.eas.basedata.assistant.PeriodInfo currentPeriod = sysctrol.getCacheCurrentPeriod(2, companyOrg.getId().toString());
        if (currentPeriod == null) {
            throw new CMBillException(CMBillException.NCMDIRECTSHOWMESG, new Object[]{EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"71_DCByClassCostCalReportFilterUI")});
        }
        CalPeriodUtils.initDailyPeriodStatusForView(this.prmtPeriodFrom);
        CalPeriodUtils.initDailyPeriodStatusForView(this.prmtPeriodTo);
        this.prmtCompanyOrg.setValue((Object)companyOrg);
        BDCMClientUtils.setBizOrgF7ByType((KDBizPromptBox)this.prmtCompanyOrg, (OrgType)OrgType.Company);
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterFrom, (String)companyOrg.getId().toString());
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterTo, (String)companyOrg.getId().toString());
        FilterInfo expenseBaseFilter = this.getExpenseBaseFilter();
        this.setFilterInfoF7(this.prmtExpenseFrom, expenseBaseFilter);
        this.setFilterInfoF7(this.prmtExpenseTo, expenseBaseFilter);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleBizPromptFilterElement filterElement = new SingleBizPromptFilterElement("companyorg", this.prmtCompanyOrg);
        filterElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"74_DCByClassCostCalReportFilterUI")));
        elements.add((FilterElement)filterElement);
        SingleComPromptFilterElement element = new SingleComPromptFilterElement("periodFrom", this.prmtPeriodFrom);
        element.setDefaultValue(CalPeriodUtils.getFirstPeriod(currentPeriod, companyOrg));
        elements.add((FilterElement)element);
        element = new SingleComPromptFilterElement("periodTo", this.prmtPeriodTo);
        element.setDefaultValue(CalPeriodUtils.getFirstPeriod(currentPeriod, companyOrg));
        elements.add((FilterElement)element);
        elements.add((FilterElement)new SingleFilterElement("costcenterfrom", (Component)this.prmtCostCenterFrom));
        elements.add((FilterElement)new SingleFilterElement("costcenterto", (Component)this.prmtCostCenterTo));
        elements.add((FilterElement)new SingleFilterElement("expensefrom", (Component)this.prmtExpenseFrom));
        elements.add((FilterElement)new SingleFilterElement("expenseto", (Component)this.prmtExpenseTo));
        this.getFilterManager().setElement((FilterElement)elements);
    }

    private void setFilterInfoF7(KDBizPromptBox f7, FilterInfo filter) {
        EntityViewInfo view = f7.getEntityViewInfo() != null ? f7.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    protected FilterInfo getExpenseBaseFilter() throws Exception {
        return ExpenseFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), "id", "adminCU.id");
    }

    protected FilterInfo getCostItemFilter() throws Exception {
        return CostItemFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
    }

    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getAdminCUFieldName() {
        return "adminCU.id";
    }

    private void filterItemF7(KDBizPromptBox f7, String compnayID) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)compnayID));
        this.setFilterInfoF7(f7, filter);
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    public void clear() {
        this.getFilterManager().clearAll();
        this.setDefaultValue();
    }

    protected void setDefaultValue() {
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtCompanyOrg.setValue((Object)companyOrg);
        BDCMClientUtils.setBizOrgF7ByType((KDBizPromptBox)this.prmtCompanyOrg, (OrgType)OrgType.Company);
        this.prmtCostCenterFrom.setValue(null);
        this.prmtCostCenterTo.setValue(null);
        this.prmtExpenseFrom.setValue(null);
        this.prmtExpenseTo.setValue(null);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrg;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public boolean verify() {
        boolean ok = super.verify();
        PeriodInfo startPeriod = (PeriodInfo)this.prmtPeriodFrom.getValue();
        PeriodInfo endPeriod = (PeriodInfo)this.prmtPeriodTo.getValue();
        if (startPeriod == null || endPeriod == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"75_DCCCFeeTotalReportFilterUI"));
            return false;
        }
        if (startPeriod.getBeginDate().after(endPeriod.getBeginDate())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"76_DCCCFeeTotalReportFilterUI"));
            return false;
        }
        return ok;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        CustomerParams params;
        super.loadData(entityViewInfo);
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtCompanyOrg.setValue((Object)companyOrg);
        if (this.cp != null) {
            try {
                String periodFrom = this.cp.getCustomerParam("prmtPeriodFrom");
                String periodTo = this.cp.getCustomerParam("prmtPeriodTo");
                HashSet<String> numbers = new HashSet<String>();
                if (periodFrom != null) {
                    numbers.add(periodFrom);
                }
                if (periodTo != null) {
                    numbers.add(periodTo);
                }
                Map periods = CalPeriodUtils.getPeriods(companyOrg.getId().toString(), numbers);
                if (periodFrom != null) {
                    this.prmtPeriodFrom.setText(null);
                    this.prmtPeriodFrom.setValue(periods.get(periodFrom));
                } else {
                    this.prmtPeriodFrom.setData(null);
                }
                if (periodTo != null) {
                    this.prmtPeriodTo.setText(null);
                    this.prmtPeriodTo.setValue(periods.get(periodTo));
                } else {
                    this.prmtPeriodTo.setData(null);
                }
            }
            catch (BOSException e) {
                this.prmtPeriodFrom.setData(null);
                this.prmtPeriodTo.setData(null);
                logger.error((Object)"", (Throwable)e);
            }
        }
        if ((params = this.getCustomerParams()) != null) {
            this.loadExpense(params);
            this.loadCostCenter(params);
        }
    }

    private void loadCostCenter(CustomerParams params) {
        String costCenterFrom = "";
        String costCenterTo = "";
        if (params.getCustomerParam("prmtCostCenterFrom") != null) {
            costCenterFrom = params.getCustomerParam("prmtCostCenterFrom");
        }
        if (params.getCustomerParam("prmtCostCenterTo") != null) {
            costCenterTo = params.getCustomerParam("prmtCostCenterTo");
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterFrom));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterTo));
            view.setFilter(filter);
            view.getFilter().setMaskString("#0 or #1");
            CostCenterOrgUnitCollection costCenterColl = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(view);
            if (costCenterColl != null && costCenterColl.size() > 0) {
                if (costCenterColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (costCenterColl.get(i).getNumber().equals(costCenterFrom)) {
                            this.prmtCostCenterFrom.setData((Object)costCenterColl.get(0));
                            continue;
                        }
                        this.prmtCostCenterTo.setData((Object)costCenterColl.get(1));
                    }
                } else if (costCenterColl.size() == 1) {
                    if (costCenterColl.get(0).getNumber().equals(costCenterFrom)) {
                        this.prmtCostCenterFrom.setData((Object)costCenterColl.get(0));
                    }
                    if (costCenterColl.get(0).getNumber().equals(costCenterTo)) {
                        this.prmtCostCenterTo.setData((Object)costCenterColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtCostCenterFrom.setData(null);
            this.prmtCostCenterTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadExpense(CustomerParams params) {
        String expenseFrom = "";
        String expenseTo = "";
        if (params.getCustomerParam("prmtExpenseFrom") != null) {
            expenseFrom = params.getCustomerParam("prmtExpenseFrom");
        }
        if (params.getCustomerParam("prmtExpenseTo") != null) {
            expenseTo = params.getCustomerParam("prmtExpenseTo");
        }
        try {
            ExpenseCollection expenseColl = ExpenseFactory.getRemoteInstance().getExpenseCollection("select * where number ='" + expenseFrom + "' or number = '" + expenseTo + "'");
            if (expenseColl != null && expenseColl.size() > 0) {
                if (expenseColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (expenseColl.get(i).getNumber().equals(expenseFrom)) {
                            this.prmtExpenseFrom.setData((Object)expenseColl.get(0));
                            continue;
                        }
                        this.prmtExpenseTo.setData((Object)expenseColl.get(1));
                    }
                } else if (expenseColl.size() == 1) {
                    if (expenseColl.get(0).getNumber().equals(expenseFrom)) {
                        this.prmtExpenseFrom.setData((Object)expenseColl.get(0));
                    }
                    if (expenseColl.get(0).getNumber().equals(expenseTo)) {
                        this.prmtExpenseTo.setData((Object)expenseColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtExpenseFrom.setData(null);
            this.prmtExpenseTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    class SingleBizPromptFilterElement
    extends SingleFilterElement {
        KDBizPromptBox prmt;

        public SingleBizPromptFilterElement(String id, KDBizPromptBox component) {
            super(id, (Component)component);
            this.prmt = component;
        }

        public void addRptParams(RptParams cp) {
            Object object = this.prmt.getValue();
            if (object == null) {
                try {
                    this.prmt.commitEdit();
                }
                catch (ParseException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                object = this.prmt.getValue();
            }
            if (object instanceof Object[]) {
                object = ((Object[])object)[0];
            }
            cp.setObject(this.getId(), object);
        }
    }
}

