/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.dynamic.cal.report.client.AbstractDCCostBatchTotalReportFilterUI;
import com.kingdee.eas.ncm.dynamic.cal.report.client.SingleComPromptFilterElement;
import com.kingdee.eas.ncm.dynamic.cal.utils.CalPeriodUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class DCCostBatchTotalReportFilterUI
extends AbstractDCCostBatchTotalReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(DCCostBatchTotalReportFilterUI.class);
    private CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
    private CustomerParams cp = null;

    public DCCostBatchTotalReportFilterUI() throws Exception {
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        com.kingdee.eas.basedata.assistant.PeriodInfo currentPeriod = sysctrol.getCacheCurrentPeriod(2, this.companyOrg.getId().toString());
        CalPeriodUtils.initDailyPeriodStatusForView(this.prmtPeriodFrom);
        CalPeriodUtils.initDailyPeriodStatusForView(this.prmtPeriodTo);
        if (currentPeriod == null) {
            throw new CMBillException(CMBillException.NCMDIRECTSHOWMESG, new Object[]{EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"71_DCByClassCostCalReportFilterUI")});
        }
        this.prmtCompanyOrg.setValue((Object)this.companyOrg);
        BDCMClientUtils.setBizOrgF7ByType((KDBizPromptBox)this.prmtCompanyOrg, (OrgType)OrgType.Company);
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterFrom, (String)this.companyOrg.getId().toString());
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterTo, (String)this.companyOrg.getId().toString());
        this.prmtCostObjectFrom.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.prmtCostObjectFrom, Boolean.TRUE);
        this.prmtCostObjectFrom.setSelector((KDPromptSelector)arg0);
        this.prmtCostObjectTo.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg1 = new CostObjectF7UISelector((Object)this, this.prmtCostObjectTo, Boolean.TRUE);
        this.prmtCostObjectTo.setSelector((KDPromptSelector)arg1);
        this.filterCostObject(this.prmtCostObjectFrom);
        this.filterCostObject(this.prmtCostObjectTo);
        BDCMClientUtils.filterF7((KDBizPromptBox)this.prmtProductFrom, (String)"company.id", (Object)this.companyOrg.getId().toString());
        BDCMClientUtils.filterF7((KDBizPromptBox)this.prmtProductTo, (String)"company.id", (Object)this.companyOrg.getId().toString());
        FilterInfo filterPrmt = this.prmtProductFrom.getEntityViewInfo().getFilter();
        filterPrmt.getFilterItems().add(new FilterItemInfo("FIInfo.status", (Object)String.valueOf(1), CompareType.EQUALS));
        this.prmtProductFrom = NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)this.prmtProductFrom, (FilterInfo)filterPrmt);
        this.prmtProductTo = NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)this.prmtProductTo, (FilterInfo)filterPrmt);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleComPromptFilterElement filterElement = new SingleComPromptFilterElement("companyorg", this.prmtCompanyOrg);
        filterElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"74_DCByClassCostCalReportFilterUI")));
        elements.add((FilterElement)filterElement);
        SingleComPromptFilterElement element = new SingleComPromptFilterElement("periodFrom", this.prmtPeriodFrom);
        element.setDefaultValue(CalPeriodUtils.getLastClsoePeriodBefroeOpen(currentPeriod, this.companyOrg));
        elements.add((FilterElement)element);
        element = new SingleComPromptFilterElement("periodTo", this.prmtPeriodTo);
        element.setDefaultValue(CalPeriodUtils.getLastClsoePeriodBefroeOpen(currentPeriod, this.companyOrg));
        elements.add((FilterElement)element);
        elements.add((FilterElement)new SingleFilterElement("costcenterFrom", (Component)this.prmtCostCenterFrom));
        elements.add((FilterElement)new SingleFilterElement("costcenterTo", (Component)this.prmtCostCenterTo));
        elements.add((FilterElement)new SingleFilterElement("costobjectFrom", (Component)this.prmtCostObjectFrom));
        elements.add((FilterElement)new SingleFilterElement("costobjectTo", (Component)this.prmtCostObjectTo));
        elements.add((FilterElement)new SingleFilterElement("productFrom", (Component)this.prmtProductFrom));
        elements.add((FilterElement)new SingleFilterElement("productTo", (Component)this.prmtProductTo));
        elements.add((FilterElement)new SingleFilterElement("batchFrom", (Component)this.txtBatchFrom));
        elements.add((FilterElement)new SingleFilterElement("batchTo", (Component)this.txtBatchTo));
        this.getFilterManager().setElement((FilterElement)elements);
    }

    public void filterCostObject(KDBizPromptBox f7) {
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyOrg.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("COSTOBJECT.calculateMode", (Object)"4", CompareType.EQUALS));
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public void storeFields() {
        super.storeFields();
    }

    public void clear() {
        this.getFilterManager().clearAll();
        this.setDefaultValue();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrg;
    }

    public boolean verify() {
        boolean ok = super.verify();
        PeriodInfo startPeriod = (PeriodInfo)this.prmtPeriodFrom.getData();
        PeriodInfo endPeriod = (PeriodInfo)this.prmtPeriodTo.getData();
        if (startPeriod == null || endPeriod == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"75_DCCCFeeTotalReportFilterUI"));
            return false;
        }
        if (startPeriod.getBeginDate().after(endPeriod.getBeginDate())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"76_DCCCFeeTotalReportFilterUI"));
            return false;
        }
        return ok;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected void setDefaultValue() {
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtCompanyOrg.setValue((Object)companyOrg);
        BDCMClientUtils.setBizOrgF7ByType((KDBizPromptBox)this.prmtCompanyOrg, (OrgType)OrgType.Company);
        this.prmtCostCenterFrom.setValue(null);
        this.prmtCostCenterTo.setValue(null);
        this.prmtCostObjectFrom.setValue(null);
        this.prmtCostObjectTo.setValue(null);
        this.prmtProductFrom.setValue(null);
        this.prmtProductTo.setValue(null);
        this.txtBatchFrom.setText("");
        this.txtBatchTo.setText("");
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        CustomerParams params;
        super.loadData(entityViewInfo);
        this.companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtCompanyOrg.setValue((Object)this.companyOrg);
        if (this.cp != null) {
            try {
                String periodFrom = this.cp.getCustomerParam("prmtPeriodFrom");
                String periodTo = this.cp.getCustomerParam("prmtPeriodTo");
                HashSet<String> numbers = new HashSet<String>();
                if (periodFrom != null) {
                    numbers.add(periodFrom);
                }
                if (periodTo != null) {
                    numbers.add(periodTo);
                }
                Map periods = CalPeriodUtils.getPeriods(this.companyOrg.getId().toString(), numbers);
                if (periodFrom != null) {
                    this.prmtPeriodFrom.setText(null);
                    this.prmtPeriodFrom.setValue(periods.get(periodFrom));
                } else {
                    this.prmtPeriodFrom.setData(null);
                }
                if (periodTo != null) {
                    this.prmtPeriodTo.setText(null);
                    this.prmtPeriodTo.setValue(periods.get(periodTo));
                } else {
                    this.prmtPeriodTo.setData(null);
                }
            }
            catch (BOSException e) {
                this.prmtPeriodFrom.setData(null);
                this.prmtPeriodTo.setData(null);
                logger.error((Object)"", (Throwable)e);
            }
        }
        if ((params = this.getCustomerParams()) != null) {
            this.loadCostCenter(params);
            this.loadCostObject(params);
            this.loadMaterial(params);
        }
    }

    private void loadCostCenter(CustomerParams params) {
        String costCenterFrom = "";
        String costCenterTo = "";
        if (params.getCustomerParam("prmtCostCenterFrom") != null) {
            costCenterFrom = params.getCustomerParam("prmtCostCenterFrom");
        }
        if (params.getCustomerParam("prmtCostCenterTo") != null) {
            costCenterTo = params.getCustomerParam("prmtCostCenterTo");
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterFrom));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterTo));
            view.setFilter(filter);
            view.getFilter().setMaskString("#0 or #1");
            CostCenterOrgUnitCollection costCenterColl = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(view);
            if (costCenterColl != null && costCenterColl.size() > 0) {
                if (costCenterColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (costCenterColl.get(i).getNumber().equals(costCenterFrom)) {
                            this.prmtCostCenterFrom.setData((Object)costCenterColl.get(i));
                            continue;
                        }
                        this.prmtCostCenterTo.setData((Object)costCenterColl.get(i));
                    }
                } else if (costCenterColl.size() == 1) {
                    if (costCenterColl.get(0).getNumber().equals(costCenterFrom)) {
                        this.prmtCostCenterFrom.setData((Object)costCenterColl.get(0));
                    }
                    if (costCenterColl.get(0).getNumber().equals(costCenterTo)) {
                        this.prmtCostCenterTo.setData((Object)costCenterColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtCostCenterFrom.setData(null);
            this.prmtCostCenterTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadCostObject(CustomerParams params) {
        String costObjectFrom = "";
        String costObjectTo = "";
        if (params.getCustomerParam("prmtCostObjectFrom") != null) {
            costObjectFrom = params.getCustomerParam("prmtCostObjectFrom");
        }
        if (params.getCustomerParam("prmtCostObjectTo") != null) {
            costObjectTo = params.getCustomerParam("prmtCostObjectTo");
        }
        try {
            String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            String oql = " select * where company.id = '" + companyId + "' " + " and ( number = '" + costObjectFrom + "' or number = '" + costObjectTo + "')";
            CostObjectCollection costObjectColl = CostObjectFactory.getRemoteInstance().getCostObjectCollection(oql);
            if (costObjectColl != null && costObjectColl.size() > 0) {
                if (costObjectColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (costObjectColl.get(i).getNumber().equals(costObjectFrom)) {
                            this.prmtCostObjectFrom.setData((Object)costObjectColl.get(i));
                            continue;
                        }
                        this.prmtCostObjectTo.setData((Object)costObjectColl.get(i));
                    }
                } else if (costObjectColl.size() == 1) {
                    if (costObjectColl.get(0).getNumber().equals(costObjectFrom)) {
                        this.prmtCostObjectFrom.setData((Object)costObjectColl.get(0));
                    }
                    if (costObjectColl.get(0).getNumber().equals(costObjectTo)) {
                        this.prmtCostObjectTo.setData((Object)costObjectColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtCostObjectFrom.setData(null);
            this.prmtCostObjectTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadMaterial(CustomerParams params) {
        String materialFrom = "";
        String materialTo = "";
        if (params.getCustomerParam("prmtProductFrom") != null) {
            materialFrom = params.getCustomerParam("prmtProductFrom");
        }
        if (params.getCustomerParam("prmtProductTo") != null) {
            materialTo = params.getCustomerParam("prmtProductTo");
        }
        try {
            String sql = "select mateial.id,mateial.name,mateial.number where (mateial.number ='" + materialFrom + "' or mateial.number = '" + materialTo + "') AND company='" + this.companyOrg.getId().toString() + "'";
            MaterialCompanyInfoCollection expenseColl = MaterialCompanyInfoFactory.getRemoteInstance().getMaterialCompanyInfoCollection(sql);
            if (expenseColl != null && expenseColl.size() > 0) {
                if (expenseColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (expenseColl.get(i).getMateial().getNumber().equals(materialFrom)) {
                            this.prmtProductFrom.setData((Object)expenseColl.get(i).getMateial());
                            continue;
                        }
                        this.prmtProductTo.setData((Object)expenseColl.get(i).getMateial());
                    }
                } else if (expenseColl.size() == 1) {
                    if (expenseColl.get(0).getMateial().getNumber().equals(materialFrom)) {
                        this.prmtProductFrom.setData((Object)expenseColl.get(0).getMateial());
                    }
                    if (expenseColl.get(0).getMateial().getNumber().equals(materialTo)) {
                        this.prmtProductTo.setData((Object)expenseColl.get(0).getMateial());
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtProductFrom.setData(null);
            this.prmtProductTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }
}

