/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.dynamic.cal.report.client.AbstractDCCostCalTotalReportFilterUI;
import com.kingdee.eas.ncm.dynamic.cal.report.client.SingleComPromptFilterElement;
import com.kingdee.eas.ncm.dynamic.cal.utils.CalPeriodUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class DCCostCalTotalReportFilterUI
extends AbstractDCCostCalTotalReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(DCCostCalTotalReportFilterUI.class);
    private CustomerParams cp = null;

    public DCCostCalTotalReportFilterUI() throws Exception {
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        com.kingdee.eas.basedata.assistant.PeriodInfo currentPeriod = sysctrol.getCacheCurrentPeriod(2, companyOrg.getId().toString());
        if (currentPeriod == null) {
            throw new CMBillException(CMBillException.NCMDIRECTSHOWMESG, new Object[]{EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"71_DCByClassCostCalReportFilterUI")});
        }
        CalPeriodUtils.initDailyPeriodStatusForView(this.prmtPeriodFrom);
        CalPeriodUtils.initDailyPeriodStatusForView(this.prmtPeriodTo);
        this.prmtCompanyOrg.setValue((Object)companyOrg);
        BDCMClientUtils.setBizOrgF7ByType((KDBizPromptBox)this.prmtCompanyOrg, (OrgType)OrgType.Company);
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterFrom, (String)companyOrg.getId().toString());
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterTo, (String)companyOrg.getId().toString());
        this.prmtCostObjectFrom.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.prmtCostObjectFrom, Boolean.TRUE);
        this.prmtCostObjectFrom.setSelector((KDPromptSelector)arg0);
        this.prmtCostObjectTo.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg1 = new CostObjectF7UISelector((Object)this, this.prmtCostObjectTo, Boolean.TRUE);
        this.prmtCostObjectTo.setSelector((KDPromptSelector)arg1);
        BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)this.prmtCostObjectFrom, (String)companyOrg.getId().toString());
        BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)this.prmtCostObjectTo, (String)companyOrg.getId().toString());
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleComPromptFilterElement filterElement = new SingleComPromptFilterElement("companyorg", this.prmtCompanyOrg);
        filterElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"74_DCByClassCostCalReportFilterUI")));
        elements.add((FilterElement)filterElement);
        SingleComPromptFilterElement element = new SingleComPromptFilterElement("periodFrom", this.prmtPeriodFrom);
        element.setDefaultValue(CalPeriodUtils.getLastClsoePeriodBefroeOpen(currentPeriod, companyOrg));
        elements.add((FilterElement)element);
        element = new SingleComPromptFilterElement("periodTo", this.prmtPeriodTo);
        element.setDefaultValue(CalPeriodUtils.getLastClsoePeriodBefroeOpen(currentPeriod, companyOrg));
        elements.add((FilterElement)element);
        elements.add((FilterElement)new SingleFilterElement("costcenterFrom", (Component)this.prmtCostCenterFrom));
        elements.add((FilterElement)new SingleFilterElement("costcenterTo", (Component)this.prmtCostCenterTo));
        elements.add((FilterElement)new SingleFilterElement("costobjectFrom", (Component)this.prmtCostObjectFrom));
        elements.add((FilterElement)new SingleFilterElement("costobjectTo", (Component)this.prmtCostObjectTo));
        this.getFilterManager().setElement((FilterElement)elements);
    }

    public void storeFields() {
        super.storeFields();
    }

    public void clear() {
        this.getFilterManager().clearAll();
        this.setDefaultValue();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrg;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public boolean verify() {
        boolean ok = super.verify();
        PeriodInfo startPeriod = (PeriodInfo)this.prmtPeriodFrom.getValue();
        PeriodInfo endPeriod = (PeriodInfo)this.prmtPeriodTo.getValue();
        if (startPeriod == null || endPeriod == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"75_DCCCFeeTotalReportFilterUI"));
            return false;
        }
        if (startPeriod.getBeginDate().after(endPeriod.getBeginDate())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"76_DCCCFeeTotalReportFilterUI"));
            return false;
        }
        return ok;
    }

    protected void setDefaultValue() {
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtCompanyOrg.setValue((Object)companyOrg);
        BDCMClientUtils.setBizOrgF7ByType((KDBizPromptBox)this.prmtCompanyOrg, (OrgType)OrgType.Company);
        this.prmtCostCenterFrom.setValue(null);
        this.prmtCostCenterTo.setValue(null);
        this.prmtCostObjectFrom.setValue(null);
        this.prmtCostObjectTo.setValue(null);
    }

    private void setFilterInfoF7(KDBizPromptBox f7, FilterInfo filter) {
        EntityViewInfo view = f7.getEntityViewInfo() != null ? f7.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    protected FilterInfo getCostItemFilter() throws Exception {
        return CostItemFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
    }

    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getAdminCUFieldName() {
        return "adminCU.id";
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        if (this.cp != null) {
            try {
                String periodFrom = this.cp.getCustomerParam("prmtPeriodFrom");
                String periodTo = this.cp.getCustomerParam("prmtPeriodTo");
                HashSet<String> numbers = new HashSet<String>();
                if (periodFrom != null) {
                    numbers.add(periodFrom);
                }
                if (periodTo != null) {
                    numbers.add(periodTo);
                }
                Map periods = CalPeriodUtils.getPeriods(companyOrg.getId().toString(), numbers);
                if (periodFrom != null) {
                    this.prmtPeriodFrom.setText(null);
                    this.prmtPeriodFrom.setValue(periods.get(periodFrom));
                } else {
                    this.prmtPeriodFrom.setData(null);
                }
                if (periodTo != null) {
                    this.prmtPeriodTo.setText(null);
                    this.prmtPeriodTo.setValue(periods.get(periodTo));
                } else {
                    this.prmtPeriodTo.setData(null);
                }
            }
            catch (BOSException e) {
                this.prmtPeriodFrom.setData(null);
                this.prmtPeriodTo.setData(null);
                logger.error((Object)"", (Throwable)e);
            }
        }
    }
}

