/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.report.client.BizPromptFilterElement;
import com.kingdee.eas.ncm.cal.report.client.SpinnerFilterElement;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.dynamic.cal.report.client.AbstractDCFinishedProductCostDetailReportFilterUI;
import com.kingdee.eas.ncm.dynamic.cal.report.client.SingleComPromptFilterElement;
import com.kingdee.eas.ncm.dynamic.cal.utils.CalPeriodUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.Assert;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class DCFinishedProductCostDetailReportFilterUI
extends AbstractDCFinishedProductCostDetailReportFilterUI {
    private static final long serialVersionUID = -868760541117198062L;
    private static final Logger logger = CoreUIObject.getLogger(DCFinishedProductCostDetailReportFilterUI.class);
    private int selectedTotalCheckBoxNum = 2;
    private PeriodInfo currentPeriod = null;
    private CustomerParams cp = null;

    public DCFinishedProductCostDetailReportFilterUI() throws Exception {
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        this.currentPeriod = sysctrol.getCacheCurrentPeriod(2, this.companyOrg.getId().toString());
        if (this.currentPeriod == null) {
            throw new CMBillException(CMBillException.NCMDIRECTSHOWMESG, new Object[]{EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"71_DCByClassCostCalReportFilterUI")});
        }
        CalPeriodUtils.initDailyPeriodStatusForView(this.prmtPeriodFrom);
        CalPeriodUtils.initDailyPeriodStatusForView(this.prmtPeriodTo);
        BDCMClientUtils.setBizOrgF7ByType((KDBizPromptBox)this.prmtCompanyOrg, (OrgType)OrgType.Company);
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterFrom, (String)this.companyOrg.getId().toString());
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterTo, (String)this.companyOrg.getId().toString());
        this.prmtCostObjectFrom.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.prmtCostObjectFrom, Boolean.TRUE);
        this.prmtCostObjectFrom.setSelector((KDPromptSelector)arg0);
        this.prmtCostObjectTo.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg1 = new CostObjectF7UISelector((Object)this, this.prmtCostObjectTo, Boolean.TRUE);
        this.prmtCostObjectTo.setSelector((KDPromptSelector)arg1);
        BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)this.prmtCostObjectFrom, (String)this.companyOrg.getId().toString());
        BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)this.prmtCostObjectTo, (String)this.companyOrg.getId().toString());
        this.chkIsTotalCostItem.setSelected(true);
        this.chkIsTotalMaterial.setSelected(true);
        this.spCostItemLevel.setModel((SpinnerModel)new SpinnerNumberModel(1, 1, 100, 1));
        this.spMaterialLevel.setModel((SpinnerModel)new SpinnerNumberModel(1, 1, 100, 1));
        this.spExpenseLevel.setModel((SpinnerModel)new SpinnerNumberModel(1, 1, 100, 1));
        this.chkIsDisplayTotalRowsOnly.setVisible(false);
        this.chkIsDisplayTotalRowsOnly.setEditable(false);
        this.spCostObjectNum.setModel((SpinnerModel)new SpinnerNumberModel(1, 1, 1000, 1));
        this.setElement();
    }

    private void setElement() throws EASBizException, BOSException {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        Assert.that((this.getCompanyF7() != null ? 1 : 0) != 0);
        SingleComPromptFilterElement filterElement = new SingleComPromptFilterElement(this.getCompanyF7().getName(), this.getCompanyF7());
        filterElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"74_DCByClassCostCalReportFilterUI")));
        elements.add((FilterElement)filterElement);
        SingleComPromptFilterElement element = new SingleComPromptFilterElement("periodFrom", this.prmtPeriodFrom);
        elements.add((FilterElement)element);
        element = new SingleComPromptFilterElement("periodTo", this.prmtPeriodTo);
        elements.add((FilterElement)element);
        if (this.getCostCenterF7() != null && this.getCostCenterF7().length == 2) {
            elements.add((FilterElement)new SingleFilterElement(this.getCostCenterF7()[0].getName(), (Component)this.getCostCenterF7()[0]));
            elements.add((FilterElement)new SingleFilterElement(this.getCostCenterF7()[1].getName(), (Component)this.getCostCenterF7()[1]));
        }
        if (this.getCostObjectF7() != null && this.getCostObjectF7().length == 2) {
            elements.add((FilterElement)new SingleFilterElement(this.getCostObjectF7()[0].getName(), (Component)this.getCostObjectF7()[0]));
            elements.add((FilterElement)new SingleFilterElement(this.getCostObjectF7()[1].getName(), (Component)this.getCostObjectF7()[1]));
        }
        if (this.getCostItemF7() != null && this.getCostItemF7().length == 2) {
            elements.add((FilterElement)new SingleFilterElement(this.getCostItemF7()[0].getName(), (Component)this.getCostItemF7()[0]));
            elements.add((FilterElement)new SingleFilterElement(this.getCostItemF7()[1].getName(), (Component)this.getCostItemF7()[1]));
        }
        if (this.getDisplayCountSpinner() != null) {
            element = new SpinnerFilterElement(this.getDisplayCountSpinner().getName(), (Component)this.getDisplayCountSpinner());
            elements.add((FilterElement)element);
        }
        if (this.getOtherComponent() != null) {
            for (int i = 0; i < this.getOtherComponent().length; ++i) {
                element = new SingleFilterElement(this.getOtherComponent()[i].getName(), (Component)this.getOtherComponent()[i]);
                elements.add((FilterElement)element);
            }
        }
        this.getFilterManager().setElement((FilterElement)elements);
    }

    public void setUIParam() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        Set allLeafComponents = ClientVerifyHelper.getAllComponents((Container)((Object)this));
        for (Component comp : allLeafComponents) {
            if (!(comp instanceof IKDTextComponent)) continue;
            if (comp instanceof KDTextField) {
                elements.add((FilterElement)new SingleFilterElement(comp.getName(), comp));
                IKDTextComponent txtComp = (IKDTextComponent)comp;
                if (txtComp.isRequired()) {
                    ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)((KDTextField)comp));
                }
            } else if (comp instanceof KDBizPromptBox) {
                BizPromptFilterElement filterElement = new BizPromptFilterElement(comp.getName(), (KDBizPromptBox)comp);
                IKDTextComponent txtComp = (IKDTextComponent)comp;
                elements.add((FilterElement)filterElement);
            } else if (comp instanceof KDSpinner) {
                elements.add((FilterElement)new SpinnerFilterElement(comp.getName(), comp));
            } else if (comp instanceof KDLabelContainer) {
                KDLabelContainer lbl = (KDLabelContainer)comp;
                lbl.setBoundLabelUnderline(true);
            } else {
                elements.add((FilterElement)new SingleFilterElement(comp.getName(), comp));
            }
            this.getFilterManager().setElement((FilterElement)elements);
        }
    }

    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kDLabelContainer15.setLocation(this.chkIsDisplayTotalRowsOnly.getLocation());
        this.repaint();
    }

    protected void chkIsTotalCostItem_itemStateChanged(ItemEvent e) throws Exception {
        if (this.chkIsTotalCostItem.isSelected()) {
            this.spCostItemLevel.setEnabled(true);
            ++this.selectedTotalCheckBoxNum;
        } else {
            this.spCostItemLevel.setEnabled(false);
            this.spCostItemLevel.setValue((Object)Integer.valueOf("1"));
            --this.selectedTotalCheckBoxNum;
        }
        this.chkIsDisplayTotalRowsOnly.setEnabled(this.selectedTotalCheckBoxNum > 0);
    }

    protected void chkIsTotalMaterial_itemStateChanged(ItemEvent e) throws Exception {
        if (this.chkIsTotalMaterial.isSelected()) {
            this.spMaterialLevel.setEnabled(true);
            ++this.selectedTotalCheckBoxNum;
        } else {
            this.spMaterialLevel.setEnabled(false);
            this.spMaterialLevel.setValue((Object)Integer.valueOf("1"));
            --this.selectedTotalCheckBoxNum;
        }
        this.chkIsDisplayTotalRowsOnly.setEnabled(this.selectedTotalCheckBoxNum > 0);
    }

    protected void chkIsTotalExpense_itemStateChanged(ItemEvent e) throws Exception {
        if (this.chkIsTotalExpense.isSelected()) {
            this.spExpenseLevel.setEnabled(true);
            ++this.selectedTotalCheckBoxNum;
        } else {
            this.spExpenseLevel.setEnabled(false);
            this.spExpenseLevel.setValue((Object)Integer.valueOf("1"));
            --this.selectedTotalCheckBoxNum;
        }
        this.chkIsDisplayTotalRowsOnly.setEnabled(this.selectedTotalCheckBoxNum > 0);
    }

    protected void chkIsDisplayTotalRowsOnly_itemStateChanged(ItemEvent e) throws Exception {
        super.chkIsDisplayTotalRowsOnly_itemStateChanged(e);
    }

    protected KDBizPromptBox getCompanyF7() {
        return this.prmtCompanyOrg;
    }

    protected KDBizPromptBox[] getCostCenterF7() {
        return new KDBizPromptBox[]{this.prmtCostCenterFrom, this.prmtCostCenterTo};
    }

    protected KDBizPromptBox[] getCostItemF7() {
        return new KDBizPromptBox[]{this.prmtCostItemFrom, this.prmtCostItemTo};
    }

    protected KDBizPromptBox[] getCostObjectF7() {
        return new KDBizPromptBox[]{this.prmtCostObjectFrom, this.prmtCostObjectTo};
    }

    protected KDBizPromptBox[] getMaterialF7() {
        return null;
    }

    protected KDSpinner getDisplayCountSpinner() {
        return this.spCostObjectNum;
    }

    public boolean verify() {
        boolean ok = super.verify();
        com.kingdee.eas.basedata.ncm.PeriodInfo startPeriod = (com.kingdee.eas.basedata.ncm.PeriodInfo)this.prmtPeriodFrom.getValue();
        com.kingdee.eas.basedata.ncm.PeriodInfo endPeriod = (com.kingdee.eas.basedata.ncm.PeriodInfo)this.prmtPeriodTo.getValue();
        if (startPeriod == null || endPeriod == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"75_DCCCFeeTotalReportFilterUI"));
            return false;
        }
        if (startPeriod.getBeginDate().after(endPeriod.getBeginDate())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"76_DCCCFeeTotalReportFilterUI"));
            return false;
        }
        return ok;
    }

    public void setDefaultValue() {
        super.setDefaultValue();
        try {
            this.prmtPeriodFrom.setValue((Object)CalPeriodUtils.getLastClsoePeriodBefroeOpen(this.currentPeriod, this.companyOrg));
            this.prmtPeriodTo.setValue((Object)CalPeriodUtils.getLastClsoePeriodBefroeOpen(this.currentPeriod, this.companyOrg));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    public void initComp() throws Exception {
    }

    protected void checkPeriod() throws Exception {
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        if (this.cp != null) {
            try {
                String periodFrom = this.cp.getCustomerParam("prmtPeriodFrom");
                String periodTo = this.cp.getCustomerParam("prmtPeriodTo");
                HashSet<String> numbers = new HashSet<String>();
                if (periodFrom != null) {
                    numbers.add(periodFrom);
                }
                if (periodTo != null) {
                    numbers.add(periodTo);
                }
                Map periods = CalPeriodUtils.getPeriods(this.companyOrg.getId().toString(), numbers);
                if (periodFrom != null) {
                    this.prmtPeriodFrom.setText(null);
                    this.prmtPeriodFrom.setValue(periods.get(periodFrom));
                } else {
                    this.prmtPeriodFrom.setData(null);
                }
                if (periodTo != null) {
                    this.prmtPeriodTo.setText(null);
                    this.prmtPeriodTo.setValue(periods.get(periodTo));
                } else {
                    this.prmtPeriodTo.setData(null);
                }
            }
            catch (BOSException e) {
                this.prmtPeriodFrom.setData(null);
                this.prmtPeriodTo.setData(null);
                logger.error((Object)"", (Throwable)e);
            }
        }
    }
}

