/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.dynamic.cal.report.client.AbstractDCMAAllocDetailReportFilterUI;
import com.kingdee.eas.ncm.dynamic.cal.utils.CalPeriodUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class DCMAAllocDetailReportFilterUI
extends AbstractDCMAAllocDetailReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(DCMAAllocDetailReportFilterUI.class);
    private CustomerParams cp = null;

    public DCMAAllocDetailReportFilterUI() throws Exception {
        com.kingdee.eas.basedata.assistant.PeriodInfo currentPeriod = SystemStatusCtrolFactory.getRemoteInstance().getCacheCurrentPeriod(2, this.companyOrg.getId().toString());
        CalPeriodUtils.initDailyPeriodStatusForView(this.prmtNorStartPeriod);
        CalPeriodUtils.initDailyPeriodStatusForView(this.prmtNorEndPeriod);
        if (currentPeriod == null) {
            throw new CMBillException(CMBillException.NCMDIRECTSHOWMESG, new Object[]{EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"71_DCByClassCostCalReportFilterUI")});
        }
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleBizPromptFilterElement filterElement = new SingleBizPromptFilterElement("companyorg", this.prmtCompanyOrg);
        filterElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"74_DCByClassCostCalReportFilterUI")));
        elements.add((FilterElement)filterElement);
        SingleBizPromptFilterElement filterElnorStartPeriod = new SingleBizPromptFilterElement("norStartPeriod", this.prmtNorStartPeriod);
        filterElnorStartPeriod.setDefaultValue(CalPeriodUtils.getFirstPeriod(currentPeriod, this.companyOrg));
        elements.add((FilterElement)filterElnorStartPeriod);
        SingleBizPromptFilterElement filterElnorEndPeriod = new SingleBizPromptFilterElement("norEndPeriod", this.prmtNorEndPeriod);
        filterElnorEndPeriod.setDefaultValue(CalPeriodUtils.getFirstPeriod(currentPeriod, this.companyOrg));
        elements.add((FilterElement)filterElnorEndPeriod);
        elements.add((FilterElement)new SingleFilterElement("costcenterFrom", (Component)this.prmtCostCenterFrom));
        elements.add((FilterElement)new SingleFilterElement("costcenterTo", (Component)this.prmtCostCenterTo));
        elements.add((FilterElement)new SingleFilterElement("itemFrom", (Component)this.prmtItemFrom));
        elements.add((FilterElement)new SingleFilterElement("itemTo", (Component)this.prmtItemTo));
        elements.add((FilterElement)new SingleFilterElement("costobjectFrom", (Component)this.prmtCostObjectFrom));
        elements.add((FilterElement)new SingleFilterElement("costobjectTo", (Component)this.prmtCostObjectTo));
        elements.add((FilterElement)new SingleFilterElement("costitemFrom", (Component)this.prmtCostItemFrom));
        elements.add((FilterElement)new SingleFilterElement("costitemTo", (Component)this.prmtCostItemTo));
        this.getFilterManager().setElement((FilterElement)elements);
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void setDefaultValue() {
        this.companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtCompanyOrg.setValue((Object)this.companyOrg);
        this.prmtCostCenterFrom.setValue(null);
        this.prmtCostCenterTo.setValue(null);
        this.prmtCostObjectFrom.setValue(null);
        this.prmtCostObjectTo.setValue(null);
        this.prmtItemFrom.setValue(null);
        this.prmtItemTo.setValue(null);
        this.prmtCostItemTo.setValue(null);
        this.prmtCostItemTo.setValue(null);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrg;
    }

    public void clear() {
        this.getFilterManager().clearAll();
        this.setDefaultValue();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        if (this.cp != null) {
            try {
                String periodFrom = this.cp.getCustomerParam("prmtNorStartPeriod");
                String periodTo = this.cp.getCustomerParam("prmtNorEndPeriod");
                HashSet<String> numbers = new HashSet<String>();
                if (periodFrom != null) {
                    numbers.add(periodFrom);
                }
                if (periodTo != null) {
                    numbers.add(periodTo);
                }
                Map periods = CalPeriodUtils.getPeriods(this.companyOrg.getId().toString(), numbers);
                if (periodFrom != null) {
                    this.prmtNorStartPeriod.setText(null);
                    this.prmtNorStartPeriod.setValue(periods.get(periodFrom));
                } else {
                    this.prmtNorStartPeriod.setData(null);
                }
                if (periodTo != null) {
                    this.prmtNorEndPeriod.setText(null);
                    this.prmtNorEndPeriod.setValue(periods.get(periodTo));
                } else {
                    this.prmtNorEndPeriod.setData(null);
                }
            }
            catch (BOSException e) {
                this.prmtNorStartPeriod.setData(null);
                this.prmtNorEndPeriod.setData(null);
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    public boolean verify() {
        this.isNormal = true;
        boolean ok = super.verify();
        PeriodInfo startPeriod = (PeriodInfo)this.prmtNorStartPeriod.getValue();
        PeriodInfo endPeriod = (PeriodInfo)this.prmtNorEndPeriod.getValue();
        if (startPeriod == null || endPeriod == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"75_DCCCFeeTotalReportFilterUI"));
            return false;
        }
        if (startPeriod.getBeginDate().after(endPeriod.getBeginDate())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"76_DCCCFeeTotalReportFilterUI"));
            return false;
        }
        return ok;
    }

    class SingleBizPromptFilterElement
    extends SingleFilterElement {
        KDBizPromptBox prmt;

        public SingleBizPromptFilterElement(String id, KDBizPromptBox component) {
            super(id, (Component)component);
            this.prmt = component;
        }

        public void addRptParams(RptParams cp) {
            Object object = this.prmt.getValue();
            if (object == null) {
                try {
                    this.prmt.commitEdit();
                }
                catch (ParseException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                object = this.prmt.getValue();
            }
            if (object instanceof Object[]) {
                object = ((Object[])object)[0];
            }
            cp.setObject(this.getId(), object);
        }
    }
}

