/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostItemCollection;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.client.BizPromptFilterElement;
import com.kingdee.eas.ncm.cal.report.client.SpinnerFilterElement;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.dynamic.cal.report.client.AbstractDCMaterialCostStatReportFilterUI;
import com.kingdee.eas.ncm.dynamic.cal.utils.CalPeriodUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Map;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class DCMaterialCostStatReportFilterUI
extends AbstractDCMaterialCostStatReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(DCMaterialCostStatReportFilterUI.class);
    private CustomerParams cp = null;

    public DCMaterialCostStatReportFilterUI() throws Exception {
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtCompanyOrg.setValue((Object)companyOrg);
        BDCMClientUtils.setBizOrgF7ByType((KDBizPromptBox)this.prmtCompanyOrg, (OrgType)OrgType.Company);
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        PeriodInfo currentPeriod = sysctrol.getCacheCurrentPeriod(2, companyOrg.getId().toString());
        if (currentPeriod == null) {
            throw new CMBillException(CMBillException.NCMDIRECTSHOWMESG, new Object[]{EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"71_DCByClassCostCalReportFilterUI")});
        }
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterFrom, (String)companyOrg.getId().toString());
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterTo, (String)companyOrg.getId().toString());
        this.prmtCostObjectFrom.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.prmtCostObjectFrom, Boolean.TRUE);
        this.prmtCostObjectFrom.setSelector((KDPromptSelector)arg0);
        this.prmtCostObjectTo.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg1 = new CostObjectF7UISelector((Object)this, this.prmtCostObjectTo, Boolean.TRUE);
        this.prmtCostObjectTo.setSelector((KDPromptSelector)arg1);
        BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)this.prmtCostObjectFrom, (String)companyOrg.getId().toString());
        BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)this.prmtCostObjectTo, (String)companyOrg.getId().toString());
        FilterInfo costItemFilterInfo = this.getCostItemFilter();
        this.setFilterInfoF7(this.prmtCostItemFrom, costItemFilterInfo);
        this.setFilterInfoF7(this.prmtCostItemTo, costItemFilterInfo);
        DCMaterialCostStatReportFilterUI.setF7CostItem(this.prmtCostItemFrom, new Integer("1"));
        DCMaterialCostStatReportFilterUI.setF7CostItem(this.prmtCostItemTo, new Integer("1"));
        CompositeFilterElement elements = new CompositeFilterElement(0);
        BizPromptFilterElement filterElement = new BizPromptFilterElement("companyorg", this.prmtCompanyOrg);
        filterElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"74_DCByClassCostCalReportFilterUI")));
        elements.add((FilterElement)filterElement);
        CalPeriodUtils.initDailyPeriodStatusForView(this.prmtPeriodFrom);
        CalPeriodUtils.initDailyPeriodStatusForView(this.prmtPeriodTo);
        this.setSpinnerRange(1, 1, 100, 1, this.spCountPerPage);
        SingleComPromptFilterElement element = new SingleComPromptFilterElement("periodFrom", this.prmtPeriodFrom);
        element.setDefaultValue(CalPeriodUtils.getLastClsoePeriodBefroeOpen(currentPeriod, companyOrg));
        elements.add((FilterElement)element);
        element = new SingleComPromptFilterElement("periodTo", this.prmtPeriodTo);
        element.setDefaultValue(CalPeriodUtils.getLastClsoePeriodBefroeOpen(currentPeriod, companyOrg));
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("costobjectPerPage", (Component)this.spCountPerPage);
        elements.add((FilterElement)element);
        elements.add((FilterElement)new SingleFilterElement("costcenterFrom", (Component)this.prmtCostCenterFrom));
        elements.add((FilterElement)new SingleFilterElement("costcenterTo", (Component)this.prmtCostCenterTo));
        elements.add((FilterElement)new SingleFilterElement("costobjectFrom", (Component)this.prmtCostObjectFrom));
        elements.add((FilterElement)new SingleFilterElement("costobjectTo", (Component)this.prmtCostObjectTo));
        elements.add((FilterElement)new SingleFilterElement("costitemFrom", (Component)this.prmtCostItemFrom));
        elements.add((FilterElement)new SingleFilterElement("costitemTo", (Component)this.prmtCostItemTo));
        this.getFilterManager().setElement((FilterElement)elements);
    }

    protected void setDefaultValue() {
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtCompanyOrg.setValue((Object)companyOrg);
        BDCMClientUtils.setBizOrgF7ByType((KDBizPromptBox)this.prmtCompanyOrg, (OrgType)OrgType.Company);
        this.prmtCostCenterFrom.setValue(null);
        this.prmtCostCenterTo.setValue(null);
        this.prmtCostObjectFrom.setValue(null);
        this.prmtCostObjectTo.setValue(null);
        this.prmtCostItemTo.setValue(null);
        this.prmtCostItemTo.setValue(null);
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        CustomerParams params;
        super.loadData(entityViewInfo);
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtCompanyOrg.setValue((Object)companyOrg);
        if (this.cp != null) {
            try {
                String periodFrom = this.cp.getCustomerParam("prmtPeriodFrom");
                String periodTo = this.cp.getCustomerParam("prmtPeriodTo");
                HashSet<String> numbers = new HashSet<String>();
                if (periodFrom != null) {
                    numbers.add(periodFrom);
                }
                if (periodTo != null) {
                    numbers.add(periodTo);
                }
                Map periods = CalPeriodUtils.getPeriods(companyOrg.getId().toString(), numbers);
                if (periodFrom != null) {
                    this.prmtPeriodFrom.setText(null);
                    this.prmtPeriodFrom.setValue(periods.get(periodFrom));
                } else {
                    this.prmtPeriodFrom.setData(null);
                }
                if (periodTo != null) {
                    this.prmtPeriodTo.setText(null);
                    this.prmtPeriodTo.setValue(periods.get(periodTo));
                } else {
                    this.prmtPeriodTo.setData(null);
                }
            }
            catch (BOSException e) {
                this.prmtPeriodFrom.setData(null);
                this.prmtPeriodTo.setData(null);
                logger.error((Object)"", (Throwable)e);
            }
        }
        if ((params = this.getCustomerParams()) != null) {
            this.loadCostCenter(params);
            this.loadCostObject(params);
            this.loadCostItem(params);
        }
    }

    private void loadCostItem(CustomerParams params) {
        String costItemFrom = "";
        String costItemTo = "";
        if (params.getCustomerParam("prmtCostItemFrom") != null) {
            costItemFrom = params.getCustomerParam("prmtCostItemFrom");
        }
        if (params.getCustomerParam("prmtCostItemTo") != null) {
            costItemTo = params.getCustomerParam("prmtCostItemTo");
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costItemFrom));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costItemTo));
            filter.setMaskString("#0 or #1");
            try {
                FilterInfo costItemFilterInfo = this.getCostItemFilter();
                costItemFilterInfo.mergeFilter(filter, "and");
                view.setFilter(costItemFilterInfo);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
            CostItemCollection costItemColl = CostItemFactory.getRemoteInstance().getCostItemCollection(view);
            if (costItemColl != null && costItemColl.size() > 0) {
                if (costItemColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (costItemColl.get(i).getNumber().equals(costItemFrom)) {
                            this.prmtCostItemFrom.setData((Object)costItemColl.get(i));
                            continue;
                        }
                        this.prmtCostItemTo.setData((Object)costItemColl.get(i));
                    }
                } else if (costItemColl.size() == 1) {
                    if (costItemColl.get(0).getNumber().equals(costItemFrom)) {
                        this.prmtCostItemFrom.setData((Object)costItemColl.get(0));
                    }
                    if (costItemColl.get(0).getNumber().equals(costItemTo)) {
                        this.prmtCostItemTo.setData((Object)costItemColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtCostItemFrom.setData(null);
            this.prmtCostItemTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadCostObject(CustomerParams params) {
        String costObjectFrom = "";
        String costObjectTo = "";
        if (params.getCustomerParam("prmtCostObjectFrom") != null) {
            costObjectFrom = params.getCustomerParam("prmtCostObjectFrom");
        }
        if (params.getCustomerParam("prmtCostObjectTo") != null) {
            costObjectTo = params.getCustomerParam("prmtCostObjectTo");
        }
        try {
            String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            String oql = " select * where company.id = '" + companyId + "' " + " and ( number = '" + costObjectFrom + "' or number = '" + costObjectTo + "')";
            CostObjectCollection costObjectColl = CostObjectFactory.getRemoteInstance().getCostObjectCollection(oql);
            if (costObjectColl != null && costObjectColl.size() > 0) {
                if (costObjectColl.size() == 2) {
                    this.prmtCostObjectFrom.setData((Object)costObjectColl.get(0));
                    this.prmtCostObjectTo.setData((Object)costObjectColl.get(1));
                } else if (costObjectColl.size() == 1) {
                    if (costObjectColl.get(0).getNumber().equals(costObjectFrom)) {
                        this.prmtCostObjectFrom.setData((Object)costObjectColl.get(0));
                    }
                    if (costObjectColl.get(0).getNumber().equals(costObjectTo)) {
                        this.prmtCostObjectTo.setData((Object)costObjectColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtCostObjectFrom.setData(null);
            this.prmtCostObjectTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadCostCenter(CustomerParams params) {
        String costCenterFrom = "";
        String costCenterTo = "";
        if (params.getCustomerParam("prmtCostCenterFrom") != null) {
            costCenterFrom = params.getCustomerParam("prmtCostCenterFrom");
        }
        if (params.getCustomerParam("prmtCostCenterTo") != null) {
            costCenterTo = params.getCustomerParam("prmtCostCenterTo");
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterFrom));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterTo));
            view.setFilter(filter);
            view.getFilter().setMaskString("#0 or #1");
            CostCenterOrgUnitCollection costCenterColl = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(view);
            if (costCenterColl != null && costCenterColl.size() > 0) {
                if (costCenterColl.size() == 2) {
                    this.prmtCostCenterFrom.setData((Object)costCenterColl.get(0));
                    this.prmtCostCenterTo.setData((Object)costCenterColl.get(1));
                } else if (costCenterColl.size() == 1) {
                    if (costCenterColl.get(0).getNumber().equals(costCenterFrom)) {
                        this.prmtCostCenterFrom.setData((Object)costCenterColl.get(0));
                    }
                    if (costCenterColl.get(0).getNumber().equals(costCenterTo)) {
                        this.prmtCostCenterTo.setData((Object)costCenterColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtCostCenterFrom.setData(null);
            this.prmtCostCenterTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void setSpinnerRange(int nDefault, int nMin, int nMax, int nStep, KDSpinner sp) {
        Integer value = new Integer(nDefault);
        Integer min = new Integer(nMin);
        Integer max = new Integer(nMax);
        Integer step = new Integer(nStep);
        SpinnerNumberModel model = new SpinnerNumberModel(value, min, max, step);
        sp.setModel((SpinnerModel)model);
    }

    private void setFilterInfoF7(KDBizPromptBox f7, FilterInfo filter) {
        EntityViewInfo view = f7.getEntityViewInfo() != null ? f7.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getAdminCUFieldName() {
        return "adminCU.id";
    }

    protected FilterInfo getCostItemFilter() throws Exception {
        return CostItemFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
    }

    public static void setF7CostItem(KDBizPromptBox bizBox, Integer itemType) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.appendFilterItem("ItemType", (Object)itemType);
        filterInfo.setMaskString("#0");
        viewInfo.setFilter(filterInfo);
        bizBox.setHasCUDefaultFilter(false);
        bizBox.setEntityViewInfo(viewInfo);
    }

    public void storeFields() {
        super.storeFields();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrg;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public boolean verify() {
        boolean ok = super.verify();
        com.kingdee.eas.basedata.ncm.PeriodInfo startPeriod = (com.kingdee.eas.basedata.ncm.PeriodInfo)this.prmtPeriodFrom.getValue();
        com.kingdee.eas.basedata.ncm.PeriodInfo endPeriod = (com.kingdee.eas.basedata.ncm.PeriodInfo)this.prmtPeriodTo.getValue();
        if (startPeriod == null || endPeriod == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"75_DCCCFeeTotalReportFilterUI"));
            return false;
        }
        if (startPeriod.getBeginDate().after(endPeriod.getBeginDate())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"76_DCCCFeeTotalReportFilterUI"));
            return false;
        }
        return ok;
    }

    class SingleComPromptFilterElement
    extends SingleFilterElement {
        private Logger logger;
        KDBizPromptBox prmt;

        public SingleComPromptFilterElement(String id, KDBizPromptBox component) {
            super(id, (Component)component);
            this.logger = Logger.getLogger((String)SingleComPromptFilterElement.class.getName());
            this.prmt = component;
        }

        public void addRptParams(RptParams cp) {
            Object object = this.prmt.getValue();
            if (object == null) {
                try {
                    this.prmt.commitEdit();
                }
                catch (ParseException e) {
                    this.logger.error((Object)"", (Throwable)e);
                }
                object = this.prmt.getValue();
            }
            if (object instanceof Object[]) {
                object = ((Object[])object)[0];
            }
            cp.setObject(this.getId(), object);
        }
    }
}

