/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostItemCollection;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectGroupCollection;
import com.kingdee.eas.basedata.assistant.CostObjectGroupFactory;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.cal.report.client.BizPromptFilterElement;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.dynamic.cal.report.client.AbstractDCMaterialCostTotalReportFilterUI;
import com.kingdee.eas.ncm.dynamic.cal.report.client.SingleComPromptFilterElement;
import com.kingdee.eas.ncm.dynamic.cal.utils.CalPeriodUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class DCMaterialCostTotalReportFilterUI
extends AbstractDCMaterialCostTotalReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(DCMaterialCostTotalReportFilterUI.class);
    private CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
    private CustomerParams cp = null;

    public DCMaterialCostTotalReportFilterUI() throws Exception {
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        PeriodInfo currentPeriod = sysctrol.getCacheCurrentPeriod(2, this.companyOrg.getId().toString());
        if (currentPeriod == null) {
            throw new CMBillException(CMBillException.NCMDIRECTSHOWMESG, new Object[]{EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"71_DCByClassCostCalReportFilterUI")});
        }
        CalPeriodUtils.initDailyPeriodStatusForView(this.prmtPeriodFrom);
        CalPeriodUtils.initDailyPeriodStatusForView(this.prmtPeriodTo);
        this.prmtCompanyOrg.setValue((Object)this.companyOrg);
        BDCMClientUtils.setBizOrgF7ByType((KDBizPromptBox)this.prmtCompanyOrg, (OrgType)OrgType.Company);
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterFrom, (String)this.companyOrg.getId().toString());
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterTo, (String)this.companyOrg.getId().toString());
        this.costobjectFrom.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.costobjectFrom, Boolean.TRUE);
        this.costobjectFrom.setSelector((KDPromptSelector)arg0);
        this.costobjectTo.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg1 = new CostObjectF7UISelector((Object)this, this.costobjectTo, Boolean.TRUE);
        this.costobjectTo.setSelector((KDPromptSelector)arg1);
        BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)this.costobjectFrom, (String)this.companyOrg.getId().toString());
        BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)this.costobjectTo, (String)this.companyOrg.getId().toString());
        BDCMClientUtils.filterF7((KDBizPromptBox)this.materialIdFrom, (String)"company.id", (Object)this.companyOrg.getId().toString());
        BDCMClientUtils.filterF7((KDBizPromptBox)this.materialIdTo, (String)"company.id", (Object)this.companyOrg.getId().toString());
        FilterInfo filterPrmt = this.materialIdFrom.getEntityViewInfo().getFilter();
        filterPrmt.getFilterItems().add(new FilterItemInfo("FIInfo.status", (Object)String.valueOf(1), CompareType.EQUALS));
        this.materialIdFrom = NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)this.materialIdFrom, (FilterInfo)filterPrmt);
        this.materialIdTo = NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)this.materialIdTo, (FilterInfo)filterPrmt);
        BDCMClientUtils.filterF7((KDBizPromptBox)this.costObjectGroupFrom, (String)"company.id", (Object)this.companyOrg.getId().toString());
        BDCMClientUtils.filterF7((KDBizPromptBox)this.costObjectGroupTo, (String)"company.id", (Object)this.companyOrg.getId().toString());
        FilterInfo costItemFilterInfo = this.getCostItemFilter();
        this.setFilterInfoF7(this.prmtCostItemFrom, costItemFilterInfo);
        this.setFilterInfoF7(this.prmtCostItemTo, costItemFilterInfo);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        BizPromptFilterElement filterElement = new BizPromptFilterElement("companyorg", this.prmtCompanyOrg);
        filterElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"74_DCByClassCostCalReportFilterUI")));
        elements.add((FilterElement)filterElement);
        SingleComPromptFilterElement element = new SingleComPromptFilterElement("periodFrom", this.prmtPeriodFrom);
        element.setDefaultValue(CalPeriodUtils.getFirstPeriod(currentPeriod, this.companyOrg));
        elements.add((FilterElement)element);
        element = new SingleComPromptFilterElement("periodTo", this.prmtPeriodTo);
        element.setDefaultValue(CalPeriodUtils.getFirstPeriod(currentPeriod, this.companyOrg));
        elements.add((FilterElement)element);
        elements.add((FilterElement)new SingleFilterElement("prmtCostCenterFrom", (Component)this.prmtCostCenterFrom));
        elements.add((FilterElement)new SingleFilterElement("prmtCostCenterTo", (Component)this.prmtCostCenterTo));
        elements.add((FilterElement)new SingleFilterElement("costobjectFrom", (Component)this.costobjectFrom));
        elements.add((FilterElement)new SingleFilterElement("costobjectTo", (Component)this.costobjectTo));
        elements.add((FilterElement)new SingleFilterElement("costitemFrom", (Component)this.prmtCostItemFrom));
        elements.add((FilterElement)new SingleFilterElement("costitemTo", (Component)this.prmtCostItemTo));
        elements.add((FilterElement)new SingleFilterElement("materialIdFrom", (Component)this.materialIdFrom));
        elements.add((FilterElement)new SingleFilterElement("materialIdTo", (Component)this.materialIdTo));
        elements.add((FilterElement)new SingleFilterElement("costObjectGroupFrom", (Component)this.costObjectGroupFrom));
        elements.add((FilterElement)new SingleFilterElement("costObjectGroupTo", (Component)this.costObjectGroupTo));
        this.getFilterManager().setElement((FilterElement)elements);
    }

    protected void setDefaultValue() {
        this.companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtCompanyOrg.setValue((Object)this.companyOrg);
        BDCMClientUtils.setBizOrgF7ByType((KDBizPromptBox)this.prmtCompanyOrg, (OrgType)OrgType.Company);
        this.prmtCostCenterFrom.setValue(null);
        this.prmtCostCenterTo.setValue(null);
        this.costobjectFrom.setValue(null);
        this.costobjectTo.setValue(null);
        this.prmtCostItemTo.setValue(null);
        this.prmtCostItemTo.setValue(null);
        this.materialIdFrom.setValue(null);
        this.materialIdTo.setValue(null);
        this.costObjectGroupTo.setValue(null);
        this.costObjectGroupFrom.setValue(null);
    }

    private void setFilterInfoF7(KDBizPromptBox f7, FilterInfo filter) {
        EntityViewInfo view = f7.getEntityViewInfo() != null ? f7.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getAdminCUFieldName() {
        return "adminCU.id";
    }

    protected FilterInfo getCostItemFilter() throws Exception {
        return CostItemFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
    }

    public void storeFields() {
        super.storeFields();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrg;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        CustomerParams params;
        super.loadData(entityViewInfo);
        this.companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtCompanyOrg.setValue((Object)this.companyOrg);
        if (this.cp != null) {
            try {
                String periodFrom = this.cp.getCustomerParam("prmtPeriodFrom");
                String periodTo = this.cp.getCustomerParam("prmtPeriodTo");
                HashSet<String> numbers = new HashSet<String>();
                if (periodFrom != null) {
                    numbers.add(periodFrom);
                }
                if (periodTo != null) {
                    numbers.add(periodTo);
                }
                Map periods = CalPeriodUtils.getPeriods(this.companyOrg.getId().toString(), numbers);
                if (periodFrom != null) {
                    this.prmtPeriodFrom.setText(null);
                    this.prmtPeriodFrom.setValue(periods.get(periodFrom));
                } else {
                    this.prmtPeriodFrom.setData(null);
                }
                if (periodTo != null) {
                    this.prmtPeriodTo.setText(null);
                    this.prmtPeriodTo.setValue(periods.get(periodTo));
                } else {
                    this.prmtPeriodTo.setData(null);
                }
            }
            catch (BOSException e) {
                this.prmtPeriodFrom.setData(null);
                this.prmtPeriodTo.setData(null);
                logger.error((Object)"", (Throwable)e);
            }
        }
        if ((params = this.getCustomerParams()) != null) {
            this.loadCostCenter(params);
            this.loadCostObject(params);
            this.loadCostItem(params);
            this.loadCostObjectGroup(params);
            this.loadMaterial(params);
        }
    }

    private void loadCostCenter(CustomerParams params) {
        String costCenterFromStr = "";
        String costCenterToStr = "";
        if (params.getCustomerParam("prmtCostCenterFrom") != null) {
            costCenterFromStr = params.getCustomerParam("prmtCostCenterFrom");
        }
        if (params.getCustomerParam("prmtCostCenterTo") != null) {
            costCenterToStr = params.getCustomerParam("prmtCostCenterTo");
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterFromStr));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterToStr));
            view.setFilter(filter);
            view.getFilter().setMaskString("#0 or #1");
            CostCenterOrgUnitCollection costCenterColl = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(view);
            if (costCenterColl != null && costCenterColl.size() > 0) {
                if (costCenterColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (costCenterColl.get(i).getNumber().equals(costCenterFromStr)) {
                            this.prmtCostCenterFrom.setData((Object)costCenterColl.get(i));
                            continue;
                        }
                        this.prmtCostCenterTo.setData((Object)costCenterColl.get(i));
                    }
                } else if (costCenterColl.size() == 1) {
                    if (costCenterColl.get(0).getNumber().equals(costCenterFromStr)) {
                        this.prmtCostCenterFrom.setData((Object)costCenterColl.get(0));
                    }
                    if (costCenterColl.get(0).getNumber().equals(costCenterToStr)) {
                        this.prmtCostCenterTo.setData((Object)costCenterColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtCostCenterFrom.setData(null);
            this.prmtCostCenterTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadCostObject(CustomerParams params) {
        String costObjectFromStr = "";
        String costObjectToStr = "";
        if (params.getCustomerParam("costobjectFrom") != null) {
            costObjectFromStr = params.getCustomerParam("costobjectFrom");
        }
        if (params.getCustomerParam("costobjectTo") != null) {
            costObjectToStr = params.getCustomerParam("costobjectTo");
        }
        try {
            String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            String oql = " select * where company.id = '" + companyId + "' " + " and ( number = '" + costObjectFromStr + "' or number = '" + costObjectToStr + "')";
            CostObjectCollection costObjectColl = CostObjectFactory.getRemoteInstance().getCostObjectCollection(oql);
            if (costObjectColl != null && costObjectColl.size() > 0) {
                if (costObjectColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (costObjectColl.get(i).getNumber().equals(costObjectFromStr)) {
                            this.costobjectFrom.setData((Object)costObjectColl.get(i));
                            continue;
                        }
                        this.costobjectTo.setData((Object)costObjectColl.get(i));
                    }
                } else if (costObjectColl.size() == 1) {
                    if (costObjectColl.get(0).getNumber().equals(costObjectFromStr)) {
                        this.costobjectFrom.setData((Object)costObjectColl.get(0));
                    }
                    if (costObjectColl.get(0).getNumber().equals(costObjectToStr)) {
                        this.costobjectTo.setData((Object)costObjectColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.costobjectFrom.setData(null);
            this.costobjectTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadCostObjectGroup(CustomerParams params) {
        String costobjectgroupfromStr = "";
        String costobjectgrouptoStr = "";
        if (params.getCustomerParam("costObjectGroupFrom") != null) {
            costobjectgroupfromStr = params.getCustomerParam("costObjectGroupFrom");
        }
        if (params.getCustomerParam("costObjectGroupTo") != null) {
            costobjectgrouptoStr = params.getCustomerParam("costObjectGroupTo");
        }
        try {
            CostObjectGroupCollection costobjectgroupColl = CostObjectGroupFactory.getRemoteInstance().getCostObjectGroupCollection("select * where number ='" + costobjectgroupfromStr + "' or number = '" + costobjectgrouptoStr + "'");
            if (costobjectgroupColl != null && costobjectgroupColl.size() > 0) {
                if (costobjectgroupColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (costobjectgroupColl.get(i).getNumber().equals(costobjectgroupfromStr)) {
                            this.costObjectGroupFrom.setData((Object)costobjectgroupColl.get(i));
                            continue;
                        }
                        this.costObjectGroupTo.setData((Object)costobjectgroupColl.get(i));
                    }
                } else if (costobjectgroupColl.size() == 1) {
                    if (costobjectgroupColl.get(0).getNumber().equals(costobjectgroupfromStr)) {
                        this.costObjectGroupFrom.setData((Object)costobjectgroupColl.get(0));
                    }
                    if (costobjectgroupColl.get(0).getNumber().equals(costobjectgrouptoStr)) {
                        this.costObjectGroupTo.setData((Object)costobjectgroupColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.costObjectGroupFrom.setData(null);
            this.costObjectGroupTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadCostItem(CustomerParams params) {
        String costItemFromStr = "";
        String costItemToStr = "";
        if (params.getCustomerParam("prmtCostItemFrom") != null) {
            costItemFromStr = params.getCustomerParam("prmtCostItemFrom");
        }
        if (params.getCustomerParam("prmtCostItemTo") != null) {
            costItemToStr = params.getCustomerParam("prmtCostItemTo");
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costItemFromStr));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costItemToStr));
            filter.setMaskString("#0 or #1");
            try {
                FilterInfo costItemFilterInfo = this.getCostItemFilter();
                costItemFilterInfo.mergeFilter(filter, "and");
                view.setFilter(costItemFilterInfo);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            CostItemCollection costItemColl = CostItemFactory.getRemoteInstance().getCostItemCollection(view);
            if (costItemColl != null && costItemColl.size() > 0) {
                if (costItemColl.size() == 2) {
                    this.prmtCostItemFrom.setData((Object)costItemColl.get(0));
                    this.prmtCostItemTo.setData((Object)costItemColl.get(1));
                    for (int i = 0; i < 2; ++i) {
                        if (costItemColl.get(i).getNumber().equals(costItemFromStr)) {
                            this.prmtCostItemFrom.setData((Object)costItemColl.get(i));
                            continue;
                        }
                        this.prmtCostItemTo.setData((Object)costItemColl.get(i));
                    }
                } else if (costItemColl.size() == 1) {
                    if (costItemColl.get(0).getNumber().equals(costItemFromStr)) {
                        this.prmtCostItemFrom.setData((Object)costItemColl.get(0));
                    }
                    if (costItemColl.get(0).getNumber().equals(costItemToStr)) {
                        this.prmtCostItemTo.setData((Object)costItemColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtCostItemFrom.setData(null);
            this.prmtCostItemTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadMaterial(CustomerParams params) {
        String materialFromStr = "";
        String materialToStr = "";
        if (params.getCustomerParam("materialIdFrom") != null) {
            materialFromStr = params.getCustomerParam("materialIdFrom");
        }
        if (params.getCustomerParam("materialIdTo") != null) {
            materialToStr = params.getCustomerParam("materialIdTo");
        }
        try {
            String sql = "select mateial.id,mateial.name,mateial.number where (mateial.number ='" + materialFromStr + "' or mateial.number = '" + materialToStr + "') AND company='" + this.companyOrg.getId().toString() + "'";
            MaterialCompanyInfoCollection expenseColl = MaterialCompanyInfoFactory.getRemoteInstance().getMaterialCompanyInfoCollection(sql);
            if (expenseColl != null && expenseColl.size() > 0) {
                if (expenseColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (expenseColl.get(i).getMateial().getNumber().equals(materialFromStr)) {
                            this.materialIdFrom.setData((Object)expenseColl.get(i).getMateial());
                            continue;
                        }
                        this.materialIdTo.setData((Object)expenseColl.get(i).getMateial());
                    }
                } else if (expenseColl.size() == 1) {
                    if (expenseColl.get(0).getMateial().getNumber().equals(materialFromStr)) {
                        this.materialIdFrom.setData((Object)expenseColl.get(0).getMateial());
                    }
                    if (expenseColl.get(0).getMateial().getNumber().equals(materialToStr)) {
                        this.materialIdTo.setData((Object)expenseColl.get(0).getMateial());
                    }
                }
            }
        }
        catch (BOSException e) {
            this.materialIdFrom.setData(null);
            this.materialIdTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    public boolean verify() {
        boolean ok = super.verify();
        com.kingdee.eas.basedata.ncm.PeriodInfo startPeriod = (com.kingdee.eas.basedata.ncm.PeriodInfo)this.prmtPeriodFrom.getData();
        com.kingdee.eas.basedata.ncm.PeriodInfo endPeriod = (com.kingdee.eas.basedata.ncm.PeriodInfo)this.prmtPeriodTo.getData();
        if (startPeriod == null || endPeriod == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"75_DCCCFeeTotalReportFilterUI"));
            return false;
        }
        if (startPeriod.getBeginDate().after(endPeriod.getBeginDate())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"76_DCCCFeeTotalReportFilterUI"));
            return false;
        }
        return ok;
    }
}

