/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.client.NCMReportFilterUI;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.dynamic.cal.report.client.AbstractDCOtherCostAllocTotalRptFilterUI;
import com.kingdee.eas.ncm.dynamic.cal.report.client.DCOtherCostAllocTotalReportFilterUI;
import com.kingdee.eas.ncm.dynamic.cal.utils.CalPeriodUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class DCOtherCostAllocTotalRptFilterUI
extends AbstractDCOtherCostAllocTotalRptFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(DCOtherCostAllocTotalReportFilterUI.class);
    private CustomerParams cp = null;

    public DCOtherCostAllocTotalRptFilterUI() throws Exception {
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        com.kingdee.eas.basedata.assistant.PeriodInfo currentPeriod = SystemStatusCtrolFactory.getRemoteInstance().getCacheCurrentPeriod(2, companyOrg.getId().toString());
        if (currentPeriod == null) {
            throw new CMBillException(CMBillException.NCMDIRECTSHOWMESG, new Object[]{EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"71_DCByClassCostCalReportFilterUI")});
        }
        CalPeriodUtils.initDailyPeriodStatusForView(this.prmtNorStartPeriod);
        CalPeriodUtils.initDailyPeriodStatusForView(this.prmtNorEndPeriod);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleBizPromptFilterElement filterElement = new SingleBizPromptFilterElement("companyorg", this.prmtCompanyOrg);
        filterElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"74_DCByClassCostCalReportFilterUI")));
        elements.add((FilterElement)filterElement);
        NCMReportFilterUI.SingleComPromptFilterElement element = new NCMReportFilterUI.SingleComPromptFilterElement((NCMReportFilterUI)this, "norStartPeriod", this.prmtNorStartPeriod);
        element.setDefaultValue((Object)CalPeriodUtils.getFirstPeriod(currentPeriod, companyOrg));
        elements.add((FilterElement)element);
        element = new NCMReportFilterUI.SingleComPromptFilterElement((NCMReportFilterUI)this, "norEndPeriod", this.prmtNorEndPeriod);
        element.setDefaultValue((Object)CalPeriodUtils.getFirstPeriod(currentPeriod, companyOrg));
        elements.add((FilterElement)element);
        elements.add((FilterElement)new SingleFilterElement("costcenterFrom", (Component)this.prmtCostCenterFrom));
        elements.add((FilterElement)new SingleFilterElement("costcenterTo", (Component)this.prmtCostCenterTo));
        elements.add((FilterElement)new SingleFilterElement("expenseFrom", (Component)this.prmtExpenseFrom));
        elements.add((FilterElement)new SingleFilterElement("expenseTo", (Component)this.prmtExpenseTo));
        elements.add((FilterElement)new SingleFilterElement("costobjectFrom", (Component)this.prmtCostObjectFrom));
        elements.add((FilterElement)new SingleFilterElement("costobjectTo", (Component)this.prmtCostObjectTo));
        elements.add((FilterElement)new SingleFilterElement("costitemFrom", (Component)this.prmtCostItemFrom));
        elements.add((FilterElement)new SingleFilterElement("costitemTo", (Component)this.prmtCostItemTo));
        this.getFilterManager().setElement((FilterElement)elements);
    }

    public void storeFields() {
        super.storeFields();
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        if (this.cp != null) {
            try {
                String periodFrom = this.cp.getCustomerParam("prmtNorStartPeriod");
                String periodTo = this.cp.getCustomerParam("prmtNorEndPeriod");
                HashSet<String> numbers = new HashSet<String>();
                if (periodFrom != null) {
                    numbers.add(periodFrom);
                }
                if (periodTo != null) {
                    numbers.add(periodTo);
                }
                Map periods = CalPeriodUtils.getPeriods(companyOrg.getId().toString(), numbers);
                if (periodFrom != null) {
                    this.prmtNorStartPeriod.setText(null);
                    this.prmtNorStartPeriod.setValue(periods.get(periodFrom));
                } else {
                    this.prmtNorStartPeriod.setData(null);
                }
                if (periodTo != null) {
                    this.prmtNorEndPeriod.setText(null);
                    this.prmtNorEndPeriod.setValue(periods.get(periodTo));
                } else {
                    this.prmtNorEndPeriod.setData(null);
                }
            }
            catch (BOSException e) {
                this.prmtNorStartPeriod.setData(null);
                this.prmtNorEndPeriod.setData(null);
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    public boolean verify() {
        this.isNormal = true;
        boolean ok = super.verify();
        PeriodInfo startPeriod = (PeriodInfo)this.prmtNorStartPeriod.getValue();
        PeriodInfo endPeriod = (PeriodInfo)this.prmtNorEndPeriod.getValue();
        if (startPeriod == null || endPeriod == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"75_DCCCFeeTotalReportFilterUI"));
            return false;
        }
        if (startPeriod.getBeginDate().after(endPeriod.getBeginDate())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"76_DCCCFeeTotalReportFilterUI"));
            return false;
        }
        return ok;
    }

    class SingleBizPromptFilterElement
    extends SingleFilterElement {
        KDBizPromptBox prmt;

        public SingleBizPromptFilterElement(String id, KDBizPromptBox component) {
            super(id, (Component)component);
            this.prmt = component;
        }

        public void addRptParams(RptParams cp) {
            Object object = this.prmt.getValue();
            if (object == null) {
                try {
                    this.prmt.commitEdit();
                }
                catch (ParseException e) {
                    DCOtherCostAllocTotalRptFilterUI.this.handUIException(e);
                }
                object = this.prmt.getValue();
            }
            if (object instanceof Object[]) {
                object = ((Object[])object)[0];
            }
            cp.setObject(this.getId(), object);
        }
    }
}

