/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.std.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.dynamic.cal.utils.CalPeriodUtils;
import com.kingdee.eas.ncm.dynamic.std.report.client.AbstractDCSTDCostDiffReportFilterUI;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class DCSTDCostDiffReportFilterUI
extends AbstractDCSTDCostDiffReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(DCSTDCostDiffReportFilterUI.class);
    private CustomerParams cp = null;

    public DCSTDCostDiffReportFilterUI() throws Exception {
        this.isNormal = false;
        this.initPeriod();
        this.init();
    }

    protected void init() throws Exception {
        this.prmtCompany.setValue((Object)this.company);
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenter, (String)this.company.getId().toString());
        this.filterSchemeNumberBox();
        BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)this.prmtCostObject, (String)this.company.getId().toString());
        FilterInfo costItemFilter = CostItemFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
        EntityViewInfo costItemView = null;
        costItemView = this.prmtCostItem.getEntityViewInfo() != null ? this.prmtCostItem.getEntityViewInfo() : new EntityViewInfo();
        costItemView.setFilter(costItemFilter);
        this.prmtCostItem.setEntityViewInfo(costItemView);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new SingleBizPromptFilterElement("companyOrg", this.prmtCompany));
        PeriodInfo currentPeriod = SystemStatusCtrolFactory.getRemoteInstance().getCacheCurrentPeriod(1001, this.company.getId().toString());
        SingleFilterElement element = new SingleFilterElement("norStartPeriod", (Component)this.prmtNorStartPeriod);
        elements.add((FilterElement)element);
        elements.add((FilterElement)new SingleFilterElement("costCenters", (Component)this.prmtCostCenter));
        elements.add((FilterElement)new SingleBizPromptFilterElement("scheme", this.prmtScheme));
        elements.add((FilterElement)new SingleFilterElement("costObjects", (Component)this.prmtCostObject));
        elements.add((FilterElement)new SingleFilterElement("costItems", (Component)this.prmtCostItem));
        this.getFilterManager().setElement((FilterElement)elements);
    }

    private void initPeriod() throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        PeriodInfo currentPeriod = sysctrol.getCacheCurrentPeriod(2, companyInfo.getId().toString());
        if (currentPeriod == null) {
            throw new CMBillException(CMBillException.NCMDIRECTSHOWMESG, new Object[]{EASResource.getString((String)"com.kingdee.eas.ncm.dynamic.std.report.REPORTAutoGenerateResource", (String)"12_DCSTDCostDiffReportFilterUI")});
        }
        this.prmtNorStartPeriod.setRequired(true);
        this.prmtNorStartPeriod.setDisplayFormat("$number$");
        this.prmtNorStartPeriod.setEditFormat("$number$");
        this.prmtNorStartPeriod.setCommitFormat("$number$");
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId()));
        ev.setFilter(filter);
        this.prmtNorStartPeriod.setEntityViewInfo(ev);
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected void setDefaultValue() {
        this.company = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtCompany.setValue((Object)this.company);
    }

    public void clear() {
        this.getFilterManager().clearAll();
        this.setDefaultValue();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompany;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public boolean verify() {
        if (this.prmtNorStartPeriod.getValue() == null) {
            MsgBox.showWarning((String)"\u4e1a\u52a1\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return false;
        }
        boolean ok = super.verify();
        return ok;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        if (this.cp != null) {
            try {
                String periodFrom = this.cp.getCustomerParam("prmtNorStartPeriod");
                HashSet<String> numbers = new HashSet<String>();
                if (periodFrom != null) {
                    numbers.add(periodFrom);
                }
                Map periods = CalPeriodUtils.getPeriods(this.company.getId().toString(), numbers);
                if (periodFrom != null) {
                    this.prmtNorStartPeriod.setText(null);
                    this.prmtNorStartPeriod.setValue(periods.get(periodFrom));
                } else {
                    this.prmtNorStartPeriod.setData(null);
                }
            }
            catch (BOSException e) {
                this.prmtNorStartPeriod.setData(null);
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    class SingleBizPromptFilterElement
    extends SingleFilterElement {
        KDBizPromptBox prmt;

        public SingleBizPromptFilterElement(String id, KDBizPromptBox component) {
            super(id, (Component)component);
            this.prmt = component;
        }

        public void addRptParams(RptParams cp) {
            Object object = this.prmt.getValue();
            if (object == null) {
                try {
                    this.prmt.commitEdit();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                object = this.prmt.getValue();
            }
            if (object instanceof Object[]) {
                object = ((Object[])object)[0];
            }
            cp.setObject(this.getId(), object);
        }
    }
}

