/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.alloc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.ncm.AllocStdFactory;
import com.kingdee.eas.basedata.ncm.AllocStdInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterType;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ncm.common.client.ProgressHintListener;
import com.kingdee.eas.ncm.common.client.ProgressHintUI;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.order.fact.alloc.OCAllocFacadeFactory;
import com.kingdee.eas.ncm.order.fact.alloc.client.AbstractOCMaterialAllocEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class OCMaterialAllocEditUI
extends AbstractOCMaterialAllocEditUI {
    private static final long serialVersionUID = 838078085343045990L;
    private static final Logger logger = CoreUIObject.getLogger(OCMaterialAllocEditUI.class);
    private static final String Col_ID = "FID";
    private static final String Col_AllocStdData = "costDriverData";
    private static final String Col_CostItem = "costItem";
    private static final String Col_Qty = "qty";
    private static final String Col_BaseQty = "baseQty";
    private static final String Col_AssistQty = "assistQty";
    private static final String Col_Price = "Price";
    private static final String Col_Amount = "Amount";
    private Map _parentParam = null;
    private String _companyId = null;
    private String _periodId = null;
    private String _sourceBillId = null;
    private String _sourceBillEntryId = null;
    private String _CostCenterId = null;
    private CoreUIObject _parentUI;
    private tblMainIterator _iterator;
    private String _operType = null;
    private IRowSet _Data = null;
    private Task _task;
    private boolean _allocating = false;
    private boolean _updating = false;
    private boolean _isDirty = false;
    private BigDecimal _totalQty = null;
    private BigDecimal _totalAmount = null;
    private BigDecimal _totalCommonQty = null;
    private BigDecimal _totalAssistQty = null;
    private String _unit = null;
    private int unitQtyPrecision = 0;
    private String _baseunit = null;
    private int baseUnitQtyPrecision = 0;
    private String _assistUnit = null;
    private int assistUnitQtyPrecision = 0;
    private int pricePrecision = 0;
    private int amountPrecision = 0;
    private final KeyListener keyListener = new KeyListener(){

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent arg0) {
            if (arg0.getKeyCode() == 127 && OCMaterialAllocEditUI.this.kDTable.getSelectManager().getActiveColumnIndex() == OCMaterialAllocEditUI.this.kDTable.getColumnIndex(OCMaterialAllocEditUI.Col_AllocStdData)) {
                arg0.setKeyChar('\u0000');
                arg0.setKeyCode(0);
            } else if (arg0.getKeyCode() == 10) {
                arg0.setKeyChar('\u0000');
                arg0.setKeyCode(0);
            }
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
            if (arg0.getKeyCode() == 127 && OCMaterialAllocEditUI.this.kDTable.getSelectManager().getActiveColumnIndex() == OCMaterialAllocEditUI.this.kDTable.getColumnIndex(OCMaterialAllocEditUI.Col_AllocStdData)) {
                arg0.setKeyChar('\u0000');
                arg0.setKeyCode(0);
            }
        }
    };

    public static void showAllocEditUI(CoreUIObject ui, Map param, String operType, KDTable tblMain) throws Exception {
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("filterInfo"));
        Assert.that((tblMain != null ? 1 : 0) != 0);
        Assert.that((operType.equals("VIEW") || operType.equals("ADJUST") ? 1 : 0) != 0);
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"param", (Object)param);
            uiContext.put((Object)"operType", (Object)operType);
            uiContext.put((Object)"tblMain", (Object)tblMain);
            uiContext.put((Object)"parentUI", (Object)ui);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(OCMaterialAllocEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this._parentParam = (Map)this.getUIContext().get("param");
        this._operType = (String)this.getUIContext().get("operType");
        KDTable tbl = (KDTable)this.getUIContext().get("tblMain");
        this._parentUI = (CoreUIObject)this.getUIContext().get("parentUI");
        this._iterator = new tblMainIterator(tbl);
        this._companyId = (String)this._parentParam.get("companyId");
        this._periodId = (String)this._parentParam.get("periodId");
        this.formatControls();
        if (this._operType.equals("ADJUST")) {
            this.setUITitle(NCMClientUtils.getNcmBillResource((String)"MatAllocListEditUI_Title_Adjust"));
        }
        this.fillData();
        if (this._operType.equals("VIEW")) {
            this.kDTable.getStyleAttributes().setLocked(true);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this._operType.equals("ADJUST")) {
            this._task = new Task();
            this._task.start(100, 1000);
        }
    }

    private void doManuAlloc(AllocStdInfo allocStd, boolean isOnlyRangeChange) throws Exception {
    }

    protected void requestMutex(String comID) throws Exception {
        try {
            this.setOprtState("CLOSING");
            this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=" + comID);
        }
        catch (Throwable t) {
            this.handUIException(t);
            this.abort();
        }
    }

    protected void releaseMutex(String comID) throws Exception {
        this.setOprtState("RELEASEALL");
        try {
            this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=" + comID);
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
    }

    private void formatControls() {
        this.kDTable.checkParsed();
        KDBizPromptBox prmtCostItem = new KDBizPromptBox();
        prmtCostItem.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostItemTreeListQuery");
        prmtCostItem.setVisible(true);
        prmtCostItem.setEditable(true);
        prmtCostItem.setDisplayFormat("$number$");
        prmtCostItem.setEditFormat("$number$");
        prmtCostItem.setCommitFormat("$number$");
        KDTDefaultCellEditor ceCostItem = new KDTDefaultCellEditor((IKDEditor)prmtCostItem);
        this.kDTable.getColumn(Col_CostItem).setEditor((ICellEditor)ceCostItem);
        ObjectValueRender ovrCostItem = new ObjectValueRender();
        ovrCostItem.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kDTable.getColumn(Col_CostItem).setRenderer((IBasicRender)ovrCostItem);
        this.kDTable.getColumn(Col_AllocStdData).setRequired(true);
        this.kDTable.getColumn(Col_CostItem).setRequired(true);
        if (this._operType.equals("VIEW")) {
            this.kdbpbAllocStd.setEditable(false);
            this.kdbpbAllocStd.setEnabled(false);
            this.kDTable.getColumn(Col_AllocStdData).getStyleAttributes().setLocked(true);
            this.kDTable.getColumn(Col_CostItem).getStyleAttributes().setLocked(true);
            this.actionSave.setVisible(false);
            this.btnOnlyNotZero.setVisible(false);
        } else {
            this.kdbpbAllocStd.setEditable(true);
            this.kdbpbAllocStd.setEnabled(true);
            this.kDTable.getColumn(Col_AllocStdData).getStyleAttributes().setLocked(false);
            this.kDTable.getColumn(Col_CostItem).getStyleAttributes().setLocked(false);
            this.actionSave.setVisible(true);
            this.actionSave.setEnabled(false);
            this.btnOnlyNotZero.setVisible(true);
            KDFormattedTextField txtAllocStdData = new KDFormattedTextField();
            txtAllocStdData.setDataType(1);
            txtAllocStdData.setPrecision(8);
            txtAllocStdData.setHorizontalAlignment(4);
            txtAllocStdData.setDecimalSeparatorAlwaysShown(true);
            txtAllocStdData.setRemoveingZeroInDispaly(true);
            txtAllocStdData.setMinimumValue((Comparable)SysConstant.BIGZERO);
            this.kDTable.getColumn(Col_AllocStdData).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtAllocStdData));
            this.kDTable.getColumn(Col_AllocStdData).getStyleAttributes().setNumberFormat("%{0.##########}f");
        }
        this.kDTable.getColumn(Col_BaseQty).getStyleAttributes().setNumberFormat("%{0.##########}f");
        this.kDTable.getColumn(Col_Qty).getStyleAttributes().setNumberFormat("%{0.##########}f");
        this.kDTable.getColumn(Col_AssistQty).getStyleAttributes().setNumberFormat("%{0.##########}f");
        this.kDTable.getColumn(Col_Price).getStyleAttributes().setNumberFormat("%{0.##########}f");
        this.kDTable.getColumn(Col_Amount).getStyleAttributes().setNumberFormat("%{0.##########}f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initKDTable() throws Exception {
        if (this._Data != null) {
            IRow row;
            boolean isSetted = false;
            this.kDTable.removeRows();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            BigDecimal totalAllocStdData = BigDecimal.valueOf(0L);
            BigDecimal totalAmount = BigDecimal.valueOf(0L);
            BigDecimal totalPrice = BigDecimal.valueOf(0L);
            BigDecimal totalQty = BigDecimal.valueOf(0L);
            BigDecimal totalcommonQty = BigDecimal.valueOf(0L);
            BigDecimal totalAssistQty = BigDecimal.valueOf(0L);
            this._Data.first();
            while (this._Data.getRow() > 0 && !this._Data.isAfterLast()) {
                if (!isSetted) {
                    if (this._operType.equals("VIEW")) {
                        this.kdbpbAllocStd.setText(this._Data.getString("FAllocStdName"));
                    } else {
                        try {
                            this._allocating = true;
                            if (this._Data.getString("FAllocStdId") != null) {
                                ObjectUuidPK pk = new ObjectUuidPK(this._Data.getString("FAllocStdId"));
                                AllocStdInfo std = AllocStdFactory.getRemoteInstance().getAllocStdInfo((IObjectPK)pk);
                                this.kdbpbAllocStd.setValue((Object)std);
                            } else {
                                this.kdbpbAllocStd.setValue(null);
                            }
                        }
                        finally {
                            this._allocating = false;
                        }
                    }
                    this.txtCreater.setText(this._Data.getString("FCreatorName"));
                    this.txtAdjuster.setText(this._Data.getString("FAdjustUserName"));
                    this.txtCreateTime.setText(sdf.format(this._Data.getTime("FCreateTime")));
                    if (this._Data.getString("FAdjustUserName") != null) {
                        this.txtAdjustTime.setText(sdf.format(this._Data.getTime("FAdjustTime")));
                    } else {
                        this.txtAdjustTime.setText("");
                    }
                    isSetted = true;
                }
                row = this.kDTable.addRow();
                row.getCell("orderId").setValue((Object)this._Data.getString("FOrderID"));
                row.getCell("orderNumber").setValue((Object)this._Data.getString("FOrderNumber"));
                row.getCell("orderStorageName").setValue((Object)this._Data.getString("FOrderStorageName"));
                row.getCell("operation.name").setValue((Object)this._Data.getString("FOperationName"));
                row.getCell("orderMaterailName").setValue((Object)this._Data.getString("FOrderMaterailName"));
                row.getCell("orderMaterialLot").setValue((Object)this._Data.getString("FOrderMaterialLot"));
                row.getCell(Col_AllocStdData).setValue((Object)this._Data.getBigDecimal("FAllocStdData"));
                totalAllocStdData = totalAllocStdData.add(this._Data.getBigDecimal("FAllocStdData"));
                row.getCell(Col_Qty).setValue((Object)this._Data.getBigDecimal("FQty"));
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell(Col_Qty), (int)this.unitQtyPrecision, (boolean)true);
                totalcommonQty = this._Data.getBigDecimal("FQty") == null ? totalcommonQty.add(new BigDecimal(0)) : totalcommonQty.add(this._Data.getBigDecimal("FQty"));
                row.getCell(Col_BaseQty).setValue((Object)this._Data.getBigDecimal("FBaseQty"));
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell(Col_BaseQty), (int)this.baseUnitQtyPrecision, (boolean)true);
                totalQty = this._Data.getBigDecimal("FBaseQty") == null ? totalQty.add(new BigDecimal(0)) : totalQty.add(this._Data.getBigDecimal("FBaseQty"));
                row.getCell(Col_AssistQty).setValue((Object)this._Data.getBigDecimal("FAssistQty"));
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell(Col_AssistQty), (int)this.assistUnitQtyPrecision, (boolean)true);
                totalAssistQty = this._Data.getBigDecimal("FAssistQty") == null ? totalAssistQty.add(new BigDecimal(0)) : totalAssistQty.add(this._Data.getBigDecimal("FAssistQty"));
                row.getCell("baseUnit.name").setValue((Object)this._baseunit);
                row.getCell("Unit.name").setValue((Object)this._unit);
                row.getCell("entry.assistUnit").setValue((Object)this._assistUnit);
                row.getCell(Col_Price).setValue((Object)this._Data.getBigDecimal("FPrice"));
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell(Col_Price), (int)this.pricePrecision, (boolean)true);
                totalPrice = totalPrice.add(this._Data.getBigDecimal("FPrice"));
                row.getCell(Col_Amount).setValue((Object)this._Data.getBigDecimal("FAmount"));
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell(Col_Amount), (int)this.amountPrecision, (boolean)true);
                totalAmount = totalAmount.add(this._Data.getBigDecimal("FAmount"));
                row.getCell(Col_CostItem).setValue((Object)this._Data.getString("FCostItemName"));
                if (this._operType.equals("ADJUST")) {
                    row.getCell(Col_ID).setValue((Object)this._Data.getString(Col_ID));
                    row.getCell(Col_CostItem).setUserObject((Object)this._Data.getString("FCostItemID"));
                }
                this._Data.next();
            }
            if (!totalAllocStdData.equals(BigDecimal.valueOf(0L))) {
                row = this.kDTable.addRow();
                row.getCell("orderStorageName").setValue((Object)NCMClientUtils.getNcmBillResource((String)"SubTotal"));
                row.getCell(Col_AllocStdData).setValue((Object)totalAllocStdData);
                row.getCell(Col_Amount).setValue((Object)totalAmount);
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell(Col_Amount), (int)this.amountPrecision, (boolean)true);
                row.getCell(Col_Qty).setValue((Object)totalcommonQty);
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell(Col_Qty), (int)this.unitQtyPrecision, (boolean)true);
                row.getCell(Col_BaseQty).setValue((Object)totalQty);
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell(Col_BaseQty), (int)this.baseUnitQtyPrecision, (boolean)true);
                row.getCell(Col_AssistQty).setValue((Object)totalAssistQty);
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell(Col_AssistQty), (int)this.assistUnitQtyPrecision, (boolean)true);
                row.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
                row.getStyleAttributes().setLocked(true);
            }
        }
    }

    private IRowSet GetAdjustData() throws Exception {
        IRowSet rs = null;
        boolean forAdjust = this._operType.equals("ADJUST");
        rs = OCAllocFacadeFactory.getRemoteInstance().getMatAdjustData(this._companyId, this._periodId, this._sourceBillId, this._sourceBillEntryId, forAdjust);
        return rs;
    }

    private void fillData() throws Exception {
        Object temp;
        IRow row = this._iterator.CurrentRow();
        if (row == null) {
            return;
        }
        this.checkMustToSave();
        try {
            temp = row.getCell("unit.qtyPrecision").getValue();
            if (temp != null && temp instanceof Integer) {
                this.unitQtyPrecision = (Integer)temp;
            }
            if ((temp = row.getCell("baseUnit.qtyPrecision").getValue()) != null && temp instanceof Integer) {
                this.baseUnitQtyPrecision = (Integer)temp;
            }
            if ((temp = row.getCell("assistUnit.qtyPrecision").getValue()) != null && temp instanceof Integer) {
                this.assistUnitQtyPrecision = (Integer)temp;
            }
            if ((temp = row.getCell("material.pricePrecision").getValue()) != null && temp instanceof Integer) {
                this.pricePrecision = (Integer)temp;
            }
            if ((temp = row.getCell("baseCurrency.precision").getValue()) != null && temp instanceof Integer) {
                this.amountPrecision = (Integer)temp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.txtNumber.setText((String)row.getCell("number").getValue());
        this.txtEntrySeq.setText(String.valueOf(row.getCell("entry.seq").getValue()));
        this.txtCostCenterNumber.setText((String)row.getCell("costCenterOrgUnit.number").getValue());
        this.txtCostCenterName.setText((String)row.getCell("costCenterOrgUnit.name").getValue());
        this.txtMaterialNumber.setText((String)row.getCell("material.number").getValue());
        this.txtMaterialName.setText((String)row.getCell("material.name").getValue());
        this.txtModle.setText((String)row.getCell("material.model").getValue());
        temp = row.getCell("Unit.name").getValue();
        this._unit = temp != null ? temp.toString() : "";
        this.txtCommonUnit.setText(this._unit);
        temp = row.getCell("baseUnit.name").getValue();
        this._baseunit = temp != null ? temp.toString() : "";
        this.txtUnit.setText(this._baseunit);
        temp = row.getCell("entry.assistUnit").getValue();
        if (temp != null) {
            this._assistUnit = temp.toString();
        } else {
            this._baseunit = "";
        }
        this.txtAssistUnit.setText(this._assistUnit);
        this.txtLot.setText((String)row.getCell("entry.lot").getValue());
        temp = row.getCell("entry.qty").getValue();
        if (temp == null) {
            this.txtCommonQty.setText("0");
            this._totalCommonQty = BigDecimal.valueOf(0L);
        } else {
            this.txtCommonQty.setText(row.getCell("entry.qty").getFormattedValue().toString());
            this._totalCommonQty = (BigDecimal)row.getCell("entry.qty").getValue();
        }
        if (row.getCell("entry.baseQty").getValue() == null) {
            this.txtQty.setText("0");
            this._totalQty = BigDecimal.valueOf(0L);
        } else {
            this.txtQty.setText(row.getCell("entry.baseQty").getFormattedValue().toString());
            this._totalQty = (BigDecimal)row.getCell("entry.baseQty").getValue();
        }
        if (row.getCell("entry.assistQty").getValue() == null) {
            this.txtAssistQty.setText("0");
            this._totalAssistQty = BigDecimal.valueOf(0L);
        } else {
            this.txtAssistQty.setText(row.getCell("entry.assistQty").getFormattedValue().toString());
            this._totalAssistQty = (BigDecimal)row.getCell("entry.assistQty").getValue();
        }
        if (row.getCell("entry.actualCost").getValue() == null) {
            this.txtAmount.setText("0");
            this._totalAmount = BigDecimal.valueOf(0L);
        } else {
            this.txtAmount.setText(row.getCell("entry.actualCost").getFormattedValue().toString());
            this._totalAmount = (BigDecimal)row.getCell("entry.actualCost").getValue();
        }
        this._sourceBillId = (String)row.getCell("id").getValue();
        this._sourceBillEntryId = (String)row.getCell("entry.id").getValue();
        this._CostCenterId = (String)row.getCell("costCenterOrgUnit.id").getValue();
        this.kdbpbAllocStd.setText("");
        this.setAllicStdTypeFilterByCC(this._CostCenterId);
        this.tfOrderNumber.setText((String)row.getCell("manuOrder.number").getValue());
        this.tfOperation.setText((String)row.getCell("operation.name").getValue());
        this._Data = this.GetAdjustData();
        this.initKDTable();
    }

    private void setAllicStdTypeFilterByCC(String id) throws EASBizException, BOSException {
        CostCenterType ccType = this.getCostCenterTypeById(id);
        Integer allocStdType = null;
        if (CostCenterType.DirectProdDept.equals((Object)ccType)) {
            allocStdType = new Integer(2);
        } else if (CostCenterType.AssistantProdDept.equals((Object)ccType)) {
            allocStdType = new Integer(5);
        }
        BDCMClientUtils.filterDataBaseDF7((String)"D9EA44BF", (KDBizPromptBox)this.kdbpbAllocStd, (String)"allocStdType", (Object)allocStdType, (CompareType)CompareType.EQUALS);
    }

    private CostCenterType getCostCenterTypeById(String id) throws BOSException {
        ICostCenterOrgUnit iCostCenterOrgUnit = CostCenterOrgUnitFactory.getRemoteInstance();
        CostCenterOrgUnitInfo costCenter = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        view.setFilter(filter);
        CostCenterOrgUnitCollection coll = iCostCenterOrgUnit.getCostCenterOrgUnitCollection(view);
        if (coll != null && coll.size() > 0) {
            costCenter = coll.get(0);
            return costCenter.getCostCenterType();
        }
        return null;
    }

    @Override
    protected void btnOnlyNotZero_itemStateChanged(ItemEvent e) throws Exception {
        super.btnOnlyNotZero_itemStateChanged(e);
        if (e.getStateChange() == 2) {
            this.btnOnlyNotZero.setText(EASResource.getString((String)"com.kingdee.eas.ncm.bill.BillResource", (String)"Adjust_Range_ALL"));
            this.btnOnlyNotZero.setToolTipText(EASResource.getString((String)"com.kingdee.eas.ncm.bill.BillResource", (String)"Adjust_Range_ALL_Hint"));
        } else {
            this.btnOnlyNotZero.setText(EASResource.getString((String)"com.kingdee.eas.ncm.bill.BillResource", (String)"Adjust_Range_Default"));
            this.btnOnlyNotZero.setToolTipText(EASResource.getString((String)"com.kingdee.eas.ncm.bill.BillResource", (String)"Adjust_Range_Default_Hint"));
        }
        this.checkMustToSave();
        if (this._allocating) {
            return;
        }
        AllocStdInfo std = (AllocStdInfo)this.kdbpbAllocStd.getValue();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("allocStd", std);
        param.put("isOnlyRangeChange", String.valueOf(true));
        this.progressManuAlloc(param);
    }

    @Override
    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this._iterator.First();
        this.fillData();
    }

    @Override
    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this._iterator.Last();
        this.fillData();
    }

    @Override
    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this._iterator.Next();
        this.fillData();
    }

    @Override
    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this._iterator.Pre();
        this.fillData();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.fillData();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kDTable);
        this.kDTable.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kDTable);
        this.kDTable.getPrintManager().printPreview();
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnFirst.setIcon(EASResource.getIcon((String)"imgTbtn_first"));
        this.btnPre.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.btnNext.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.btnLast.setIcon(EASResource.getIcon((String)"imgTbtn_last"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnOnlyNotZero.setIcon(EASResource.getIcon((String)"imgTbtn_entirely"));
        this.btnOnlyNotZero.setSelectedIcon(EASResource.getIcon((String)"imgTbtn_partshow"));
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
    }

    private void progressManuAlloc(Map param) throws Exception {
        Assert.that((boolean)param.containsKey("allocStd"));
        Assert.that((boolean)param.containsKey("isOnlyRangeChange"));
        allocProgressHintListener listener = new allocProgressHintListener();
        ProgressHintUI.showProgressHintUI((CoreUIObject)this, (ProgressHintListener)listener, (Map)param);
    }

    private boolean hasAllocData() throws SQLException {
        if (this._Data == null) {
            return false;
        }
        this._Data.first();
        return this._Data.getRow() != 0;
    }

    @Override
    protected void kdbpbAllocStd_dataChanged(DataChangeEvent e) throws Exception {
    }

    private void checkMustToSave() throws Exception {
    }

    private void updateManuAdjustData() throws Exception {
    }

    protected boolean checkBeforeWindowClosing() {
        try {
            this.checkMustToSave();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return true;
    }

    @Override
    protected void kDTable_editStopped(KDTEditEvent e) throws Exception {
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
    }

    private void setLogInfo(String methodName, String logItemName) {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
        IObjectPK pk = LogUtil.beginLog(null, (String)methodName, (BOSObjectType)new BOSObjectType("DE8319CC"), null, (String)(company.getNumber() + " " + company.getName()), (String)logItemName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    public void set_isDirty(boolean dirty) throws Exception {
        this._isDirty = dirty;
        this.actionSave.setEnabled(dirty);
        if (!dirty) {
            this.fillData();
        }
    }

    private void updateAlloc() {
        BigDecimal tempQty;
        ICell allocStdData;
        IRow row;
        int i;
        BigDecimal totalAllocStdData = BigDecimal.valueOf(0L);
        BigDecimal totalAllocedQty = BigDecimal.valueOf(0L);
        BigDecimal totalAllocedAmount = BigDecimal.valueOf(0L);
        BigDecimal totalAllocedCommonQty = BigDecimal.valueOf(0L);
        BigDecimal totalAllocedAssistQty = BigDecimal.valueOf(0L);
        BigDecimal maxAllocStdData = BigDecimal.valueOf(0L);
        int maxRateRowIndex = 0;
        for (i = 0; i < this.kDTable.getRowCount() - 1; ++i) {
            row = this.kDTable.getRow(i);
            allocStdData = row.getCell(Col_AllocStdData);
            totalAllocStdData = totalAllocStdData.add((BigDecimal)allocStdData.getValue());
        }
        for (i = 0; i < this.kDTable.getRowCount() - 1; ++i) {
            row = this.kDTable.getRow(i);
            allocStdData = row.getCell(Col_AllocStdData);
            ICell qty = row.getCell(Col_BaseQty);
            ICell commonQty = row.getCell(Col_Qty);
            ICell assistQty = row.getCell(Col_AssistQty);
            ICell price = row.getCell(Col_Price);
            ICell amount = row.getCell(Col_Amount);
            BigDecimal value = (BigDecimal)allocStdData.getValue();
            if (value == null) {
                value = BigDecimal.valueOf(0L);
            }
            if (maxAllocStdData.compareTo(value) < 0) {
                maxAllocStdData = value;
                maxRateRowIndex = i;
            }
            BigDecimal rate = null;
            rate = totalAllocStdData.compareTo(BigDecimal.valueOf(0L)) <= 0 ? BigDecimal.valueOf(0L) : value.divide(totalAllocStdData, 12, 4);
            BigDecimal tempCommonQty = this._totalCommonQty.multiply(rate).setScale(this.unitQtyPrecision, 4);
            totalAllocedCommonQty = totalAllocedCommonQty.add(tempCommonQty);
            commonQty.setValue((Object)tempCommonQty);
            BigDecimal tempQty2 = this._totalQty.multiply(rate).setScale(this.baseUnitQtyPrecision, 4);
            totalAllocedQty = totalAllocedQty.add(tempQty2);
            qty.setValue((Object)tempQty2);
            BigDecimal tempAssistQty = this._totalAssistQty.multiply(rate).setScale(this.assistUnitQtyPrecision, 4);
            totalAllocedAssistQty = totalAllocedAssistQty.add(tempAssistQty);
            assistQty.setValue((Object)tempAssistQty);
            BigDecimal tempAmount = this._totalAmount.multiply(rate).setScale(this.amountPrecision, 4);
            totalAllocedAmount = totalAllocedAmount.add(tempAmount);
            amount.setValue((Object)tempAmount);
            BigDecimal tempPrice = null;
            tempPrice = tempQty2.compareTo(BigDecimal.valueOf(0L)) == 0 ? BigDecimal.valueOf(0L) : tempAmount.divide(tempQty2, this.pricePrecision, 4);
            price.setValue((Object)tempPrice);
        }
        if (this._totalAmount.compareTo(totalAllocedAmount) != 0 && maxAllocStdData.compareTo(BigDecimal.valueOf(0L)) > 0) {
            IRow row2 = this.kDTable.getRow(maxRateRowIndex);
            ICell amount = row2.getCell(Col_Amount);
            BigDecimal tempAmt = ((BigDecimal)amount.getValue()).add(this._totalAmount).subtract(totalAllocedAmount);
            totalAllocedAmount = totalAllocedAmount.add(this._totalAmount).subtract(totalAllocedAmount);
            amount.setValue((Object)tempAmt);
        }
        if (this._totalQty.compareTo(totalAllocedQty) != 0 && maxAllocStdData.compareTo(BigDecimal.valueOf(0L)) > 0) {
            IRow row3 = this.kDTable.getRow(maxRateRowIndex);
            ICell qty = row3.getCell(Col_BaseQty);
            tempQty = ((BigDecimal)qty.getValue()).add(this._totalQty).subtract(totalAllocedQty);
            totalAllocedQty = totalAllocedQty.add(this._totalQty).subtract(totalAllocedQty);
            qty.setValue((Object)tempQty);
        }
        if (this._totalCommonQty.compareTo(totalAllocedCommonQty) != 0 && maxAllocStdData.compareTo(BigDecimal.valueOf(0L)) > 0) {
            IRow row4 = this.kDTable.getRow(maxRateRowIndex);
            ICell assistQty = row4.getCell(Col_Qty);
            tempQty = ((BigDecimal)assistQty.getValue()).add(this._totalCommonQty).subtract(totalAllocedCommonQty);
            totalAllocedCommonQty = totalAllocedCommonQty.add(this._totalCommonQty).subtract(totalAllocedCommonQty);
            assistQty.setValue((Object)tempQty);
        }
        if (this._totalAssistQty.compareTo(totalAllocedAssistQty) != 0 && maxAllocStdData.compareTo(BigDecimal.valueOf(0L)) > 0) {
            IRow row5 = this.kDTable.getRow(maxRateRowIndex);
            ICell commonQty = row5.getCell(Col_AssistQty);
            tempQty = ((BigDecimal)commonQty.getValue()).add(this._totalAssistQty).subtract(totalAllocedAssistQty);
            totalAllocedAssistQty = totalAllocedAssistQty.add(this._totalAssistQty).subtract(totalAllocedAssistQty);
            commonQty.setValue((Object)tempQty);
        }
        if ((this._totalAmount.compareTo(totalAllocedAmount) != 0 || this._totalQty.compareTo(totalAllocedQty) != 0) && maxAllocStdData.compareTo(BigDecimal.valueOf(0L)) > 0) {
            IRow row6 = this.kDTable.getRow(maxRateRowIndex);
            BigDecimal tempPrice = null;
            tempPrice = ((BigDecimal)row6.getCell(Col_BaseQty).getValue()).compareTo(BigDecimal.valueOf(0L)) == 0 ? BigDecimal.valueOf(0L) : ((BigDecimal)row6.getCell(Col_Amount).getValue()).divide((BigDecimal)row6.getCell(Col_BaseQty).getValue(), this.amountPrecision, 4);
            row6.getCell(Col_Price).setValue((Object)tempPrice);
        }
        this.kDTable.getRow(this.kDTable.getRowCount() - 1).getCell(Col_AllocStdData).setValue((Object)totalAllocStdData);
        this.kDTable.getRow(this.kDTable.getRowCount() - 1).getCell(Col_BaseQty).setValue((Object)totalAllocedQty);
        this.kDTable.getRow(this.kDTable.getRowCount() - 1).getCell(Col_Qty).setValue((Object)totalAllocedCommonQty);
        this.kDTable.getRow(this.kDTable.getRowCount() - 1).getCell(Col_AssistQty).setValue((Object)totalAllocedAssistQty);
        this.kDTable.getRow(this.kDTable.getRowCount() - 1).getCell(Col_Amount).setValue((Object)totalAllocedAmount);
    }

    protected void initListener() {
        super.initListener();
        this.kDTable.addKeyListener(this.keyListener);
    }

    private class Task {
        private Timer timer;
        private TimerTask task = new TimerTask(){

            @Override
            public void run() {
                block6: {
                    try {
                        Task.this.timer.cancel();
                        if (!OCMaterialAllocEditUI.this._operType.equals("ADJUST") || OCMaterialAllocEditUI.this.hasAllocData()) break block6;
                        try {
                            HashMap<String, String> param = new HashMap<String, String>();
                            param.put("allocStd", null);
                            param.put("isOnlyRangeChange", String.valueOf(false));
                            OCMaterialAllocEditUI.this.progressManuAlloc(param);
                        }
                        catch (Exception e) {
                            logger.error((Object)"", (Throwable)e);
                            OCMaterialAllocEditUI.this.handUIException(e);
                        }
                    }
                    catch (SQLException e) {
                        logger.error((Object)"", (Throwable)e);
                    }
                }
            }
        };

        public Task() {
            this.timer = new Timer(false);
        }

        public void start(int delay, int internal) {
            this.timer.schedule(this.task, delay, (long)internal);
        }
    }

    private class tblMainIterator {
        private KDTable _tblMain;
        private int _currentRowIndex = -1;

        public tblMainIterator(KDTable tblMain) {
            this._tblMain = tblMain;
            this._currentRowIndex = this._tblMain.getSelectManager().getActiveRowIndex();
        }

        public void First() {
            this._currentRowIndex = 0;
            OCMaterialAllocEditUI.this.actionFirst.setEnabled(false);
            OCMaterialAllocEditUI.this.actionPre.setEnabled(false);
            OCMaterialAllocEditUI.this.actionNext.setEnabled(true);
            OCMaterialAllocEditUI.this.actionLast.setEnabled(true);
        }

        public void Pre() {
            if (!this.IsFirst()) {
                --this._currentRowIndex;
                OCMaterialAllocEditUI.this.actionFirst.setEnabled(true);
                OCMaterialAllocEditUI.this.actionPre.setEnabled(true);
                OCMaterialAllocEditUI.this.actionNext.setEnabled(true);
                OCMaterialAllocEditUI.this.actionLast.setEnabled(true);
            } else {
                OCMaterialAllocEditUI.this.actionFirst.setEnabled(false);
                OCMaterialAllocEditUI.this.actionPre.setEnabled(false);
                OCMaterialAllocEditUI.this.actionNext.setEnabled(true);
                OCMaterialAllocEditUI.this.actionLast.setEnabled(true);
            }
        }

        public void Next() {
            if (!this.IsLast()) {
                ++this._currentRowIndex;
                OCMaterialAllocEditUI.this.actionFirst.setEnabled(true);
                OCMaterialAllocEditUI.this.actionPre.setEnabled(true);
                OCMaterialAllocEditUI.this.actionNext.setEnabled(true);
                OCMaterialAllocEditUI.this.actionLast.setEnabled(true);
            } else {
                OCMaterialAllocEditUI.this.actionFirst.setEnabled(true);
                OCMaterialAllocEditUI.this.actionPre.setEnabled(true);
                OCMaterialAllocEditUI.this.actionNext.setEnabled(false);
                OCMaterialAllocEditUI.this.actionLast.setEnabled(false);
            }
        }

        public void Last() {
            this._currentRowIndex = this._tblMain.getRowCount() - 1;
            OCMaterialAllocEditUI.this.actionFirst.setEnabled(true);
            OCMaterialAllocEditUI.this.actionPre.setEnabled(true);
            OCMaterialAllocEditUI.this.actionNext.setEnabled(false);
            OCMaterialAllocEditUI.this.actionLast.setEnabled(false);
        }

        public boolean IsFirst() {
            return this._currentRowIndex == 0;
        }

        public boolean IsLast() {
            return this._tblMain.getRowCount() == this._currentRowIndex + 1;
        }

        public IRow CurrentRow() {
            return this._tblMain.getRow(this._currentRowIndex);
        }
    }

    private final class allocProgressHintListener
    implements ProgressHintListener {
        private allocProgressHintListener() {
        }

        public void doFunction(Map param) throws Exception {
            AllocStdInfo allocStd = (AllocStdInfo)param.get("allocStd");
            boolean isOnlyRangeChange = false;
            if (param.get("isOnlyRangeChange").equals(String.valueOf(true))) {
                isOnlyRangeChange = true;
            }
            OCMaterialAllocEditUI.this.doManuAlloc(allocStd, isOnlyRangeChange);
        }
    }
}

