/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.alloc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.common.AllocSourceBillEnum;
import com.kingdee.eas.ncm.common.AllocStatusEnum;
import com.kingdee.eas.ncm.common.progress.client.ProgressHintListener;
import com.kingdee.eas.ncm.common.progress.client.ProgressHintUI;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.ncm.order.fact.alloc.client.AbstractOCMaterialAllocListUI;
import com.kingdee.eas.ncm.order.fact.alloc.client.OCMaterialAllocEditUI;
import com.kingdee.eas.ncm.order.fact.alloc.client.OCMaterialAllocLogReportUI;
import com.kingdee.eas.ncm.order.fact.bill.OrderCCFeeBillFactory;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class OCMaterialAllocListUI
extends AbstractOCMaterialAllocListUI {
    private static final long serialVersionUID = 962164166980166749L;
    private static final Logger logger = CoreUIObject.getLogger(OCMaterialAllocListUI.class);
    private static final String QtyCol = "entry.baseQty";
    private static final String PriceCol = "entry.unitActualCost";
    private static final String AmtCol = "entry.actualCost";
    private CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
    private String companyId = this.company.getId().toString();
    private PeriodInfo period = null;
    private String periodId = null;
    private CommonQueryDialog dialog = null;
    protected FilterInfo _currFilterInfo = null;
    protected boolean bFilter_all = false;
    protected int isOnlyUnAlloced = -1;
    Set storageOrgUnitIds = null;

    public OCMaterialAllocListUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        OrderCMUtils.checkStart(this.companyId);
        this.period = OrderCMUtils.getCurrentPeriod(this.companyId);
        this.periodId = this.period.getId().toString();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                OCMaterialAllocListUI.this.tblMain_afterDataFill(e);
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionLocate.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionStartWorkFlow.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionView.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.menuEdit.setVisible(false);
        this.actionManuAlloc.setVisible(false);
        this.actionWizAlloc.setVisible(false);
        this.initFormatTable();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.ncm.order.fact.alloc.client.OCMaterialAllocEditUI";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MaterialReqBillFactory.getRemoteInstance();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnAutoAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.btnManuAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_flowexample"));
        this.btnViewAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.btnViewLog.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuItemAutoAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.menuItemManuAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_flowexample"));
        this.menuItemViewAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.menuItemViewLog.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.actionViewAlloc_actionPerformed(null);
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.actionViewAlloc_actionPerformed(null);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        return filter;
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        try {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("year", (Object)String.valueOf(this.period.getPeriodYear())));
            filter.getFilterItems().add(new FilterItemInfo("period", (Object)String.valueOf(this.period.getPeriodNumber())));
            filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)String.valueOf(4)));
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.company.getId().toString()));
            Set ccoTypeSet = this.getCostCenterType();
            filter.getFilterItems().add(new FilterItemInfo("costCenterOrgUnit.costCenterType", (Object)ccoTypeSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("transactionType.isManuCostCalculate", (Object)String.valueOf(true)));
            filter.getFilterItems().add(new FilterItemInfo("sourceBillType.billTypeGroup", (Object)new Integer(67), CompareType.EQUALS));
            for (FilterItemInfo item : ev.getFilter().getFilterItems()) {
                if (!item.getPropertyName().equals("isAllocated")) continue;
                int isAllocated = item.getInt("compareValue");
                int idx = ev.getFilter().getFilterItems().indexOf((IObjectValue)item);
                FilterItemInfo newItem = null;
                if (isAllocated == 1) {
                    newItem = new FilterItemInfo("baseStatus", (Object)String.valueOf(4));
                    this.isOnlyUnAlloced = 0;
                } else if (isAllocated == 0) {
                    newItem = new FilterItemInfo("baseStatus", (Object)String.valueOf(4));
                    this.isOnlyUnAlloced = 1;
                }
                ev.getFilter().getFilterItems().set(idx, newItem);
                break;
            }
            try {
                ev.getFilter().mergeFilter(filter, "and");
                this._currFilterInfo = (FilterInfo)ev.getFilter().clone();
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        if (viewInfo == null) {
            viewInfo = new EntityViewInfo();
        }
        String filter = this.getDefaultFilterForQuery().toString();
        this.bFilter_all = viewInfo.getFilter().toString().startsWith(filter);
        IQueryExecutor qe = super.getQueryExecutor(queryPK, viewInfo);
        return qe;
    }

    public void tblMain_afterDataFill(KDTDataRequestEvent e) {
        int firstRowIndex = e.getFirstRow();
        int lastRowIndex = e.getLastRow();
        int unitQtyPrecision = 0;
        int baseUnitQtyPrecision = 0;
        int assistUnitQtyPrecision = 0;
        int pricePrecision = 0;
        int amountPrecision = 0;
        IRow row = null;
        Object temp = null;
        for (int i = firstRowIndex; i <= lastRowIndex; ++i) {
            unitQtyPrecision = 0;
            baseUnitQtyPrecision = 0;
            assistUnitQtyPrecision = 0;
            pricePrecision = 0;
            amountPrecision = 0;
            row = this.tblMain.getRow(i);
            temp = row.getCell("unit.qtyPrecision").getValue();
            if (temp != null && temp instanceof Integer) {
                unitQtyPrecision = (Integer)temp;
            }
            if ((temp = row.getCell("baseUnit.qtyPrecision").getValue()) != null && temp instanceof Integer) {
                baseUnitQtyPrecision = (Integer)temp;
            }
            if ((temp = row.getCell("assistUnit.qtyPrecision").getValue()) != null && temp instanceof Integer) {
                assistUnitQtyPrecision = (Integer)temp;
            }
            if ((temp = row.getCell("material.pricePrecision").getValue()) != null && temp instanceof Integer) {
                pricePrecision = (Integer)temp;
            }
            if ((temp = row.getCell("baseCurrency.precision").getValue()) != null && temp instanceof Integer) {
                amountPrecision = (Integer)temp;
            }
            NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell("entry.qty"), (int)unitQtyPrecision, (boolean)true);
            NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell(QtyCol), (int)baseUnitQtyPrecision, (boolean)true);
            NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell("entry.assistQty"), (int)assistUnitQtyPrecision, (boolean)true);
            NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell(PriceCol), (int)pricePrecision, (boolean)true);
            NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell(AmtCol), (int)amountPrecision, (boolean)true);
        }
    }

    protected Set getCostCenterType() {
        HashSet<Integer> ccoTypeSet = new HashSet<Integer>();
        ccoTypeSet.add(new Integer(0));
        return ccoTypeSet;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog == null) {
            this.dialog = super.initCommonQueryDialog();
        }
        CommonQueryProcessor cmcq = this.getCustomerCommonQueryProcessor();
        this.dialog.setProcessor((IProcessor)cmcq);
        return this.dialog;
    }

    private Set getStorageOrgUnitIds() throws EASBizException, BOSException {
        if (this.storageOrgUnitIds == null) {
            this.storageOrgUnitIds = BDCMUtils.getStorageOrgUnitIdsOfCompany(null, (String)this.companyId);
        }
        return this.storageOrgUnitIds;
    }

    protected CommonQueryProcessor getCustomerCommonQueryProcessor() {
        return new CommonQueryProcessor(){

            public void process() throws Exception {
                Object editor = this.get("CURRENT_EDITOR");
                String fieldProperty = (String)this.get("CURRENT_FIELD_PROP");
                if (editor instanceof KDComboBox) {
                    KDComboBox combox = (KDComboBox)editor;
                    if ("baseStatus".equals(fieldProperty)) {
                        BillBaseStatusEnum[] type = new BillBaseStatusEnum[]{BillBaseStatusEnum.AUDITED};
                        DefaultComboBoxModel<BillBaseStatusEnum> model = new DefaultComboBoxModel<BillBaseStatusEnum>(type);
                        combox.setModel(model);
                        return;
                    }
                    if ("allocState".equals(fieldProperty)) {
                        AllocStatusEnum[] status = new AllocStatusEnum[]{AllocStatusEnum.ALLOCED, AllocStatusEnum.UNALLOCED};
                        DefaultComboBoxModel<AllocStatusEnum> model = new DefaultComboBoxModel<AllocStatusEnum>(status);
                        combox.setModel(model);
                        return;
                    }
                } else if (editor instanceof KDBizPromptBox) {
                    KDBizPromptBox prmt = (KDBizPromptBox)editor;
                    EntityViewInfo view = prmt.getEntityViewInfo() == null ? new EntityViewInfo() : prmt.getEntityViewInfo();
                    FilterInfo filter = null;
                    if ("costCenterOrgUnit.number".equals(fieldProperty) || "costCenterOrgUnit.name".equals(fieldProperty)) {
                        BDCMClientUtils.filterDirectCostCenterF7((KDBizPromptBox)prmt, (String)OCMaterialAllocListUI.this.companyId);
                    } else if ("material.number".equals(fieldProperty) || "material.name".equals(fieldProperty)) {
                        filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)OCMaterialAllocListUI.this.companyId));
                        filter.getFilterItems().add(new FilterItemInfo("FIInfo.status", (Object)new Integer(1)));
                        try {
                            NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)prmt, (FilterInfo)filter);
                        }
                        catch (BOSException e1) {
                            OCMaterialAllocListUI.this.handUIException(e1);
                        }
                    } else if ("transactionType.name".equals(fieldProperty)) {
                        NCMClientUtils.setFilterForTransactionType((KDBizPromptBox)prmt, (String)"104");
                    } else if (!"costItem.number".equals(fieldProperty) && !"costItem.name".equals(fieldProperty)) {
                        if ("warehouse.name".equals(fieldProperty)) {
                            BDCMClientUtils.filterStorageFromCompanyF7((KDBizPromptBox)prmt, (String)"whState", (Object)"1", (String)OCMaterialAllocListUI.this.companyId, (String)"storageOrg.id");
                        } else if ("operation.number".equals(fieldProperty) || "operation.name".equals(fieldProperty)) {
                            filter = new FilterInfo();
                            Set storageOrgUnitIds = OCMaterialAllocListUI.this.getStorageOrgUnitIds();
                            if (storageOrgUnitIds.size() > 0) {
                                filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitIds, CompareType.INCLUDE));
                            }
                            HashSet<Integer> set = new HashSet<Integer>();
                            set.add(new Integer(40));
                            set.add(new Integer(10));
                            set.add(new Integer(50));
                            filter.getFilterItems().add(new FilterItemInfo("status", set, CompareType.NOTINCLUDE));
                            view.setFilter(filter);
                            prmt.setEntityViewInfo(view);
                            prmt.getQueryAgent().resetRuntimeEntityView();
                        }
                    }
                }
            }
        };
    }

    private void setMergeColumn() {
        this.tblMain.checkParsed();
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn("number").setGroup(true);
        this.tblMain.getColumn("number").setMergeable(true);
        this.tblMain.getColumn("baseStatus").setGroup(true);
        this.tblMain.getColumn("baseStatus").setMergeable(true);
        this.tblMain.getColumn("transactionType.name").setGroup(true);
        this.tblMain.getColumn("transactionType.name").setMergeable(true);
        this.tblMain.getColumn("bizDate").setGroup(true);
        this.tblMain.getColumn("bizDate").setMergeable(true);
        this.tblMain.getColumn("costCenterOrgUnit.number").setGroup(true);
        this.tblMain.getColumn("costCenterOrgUnit.number").setMergeable(true);
        this.tblMain.getColumn("costCenterOrgUnit.name").setGroup(true);
        this.tblMain.getColumn("costCenterOrgUnit.name").setMergeable(true);
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
    }

    public void initFormatTable() throws Exception {
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat("yyyy-MM-dd HH:mm:ss");
        this.setMergeColumn();
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    @Override
    public void actionAutoAlloc_actionPerformed(ActionEvent e) throws Exception {
        super.actionAutoAlloc_actionPerformed(e);
        String taskClazzName = "com.kingdee.eas.ncm.order.fact.alloc.app.task.OCMaterialAllocTask";
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (this.bFilter_all) {
            param.put("bMaterialAllocFilter_all", "true");
        }
        param.put("task.support.interrupt", Boolean.TRUE);
        param.put("task.show.time", Boolean.TRUE);
        param.put("task.support.option", Boolean.TRUE);
        param.put("materialAllocFilterInfo", this._currFilterInfo);
        param.put("companyId", this.companyId);
        param.put("periodId", this.periodId);
        param.put("task.listener", new ProgressHintListener(){

            public void beforeTaskExecute(Map param) throws Exception {
                OCMaterialAllocListUI.this.requestMutex(OCMaterialAllocListUI.this.companyId);
            }

            public void afterTaskExecute(Map param, List userObjects) throws Exception {
                OCMaterialAllocListUI.this.releaseMutex(OCMaterialAllocListUI.this.companyId);
            }
        });
        ProgressHintUI hintUI = ProgressHintUI.showProgressHintUI((Component)((Object)this), (String)taskClazzName, param);
        List userObjects = hintUI.getUserObjects();
        if (userObjects.size() > 0 && userObjects.get(0) instanceof String) {
            final boolean success = "materialAlloc_success".equals((String)userObjects.get(0));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!success) {
                        OCMaterialAllocListUI.this.btnViewLog.doClick();
                    }
                }
            });
        }
    }

    @Override
    public void actionManuAlloc_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void requestMutex(String comID) throws Exception {
        try {
            this.setOprtState("CLOSING");
            this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=" + comID);
        }
        catch (Throwable t) {
            this.handUIException(t);
            this.abort();
        }
    }

    protected void releaseMutex(String comID) throws Exception {
        this.setOprtState("RELEASEALL");
        try {
            this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=" + comID);
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
    }

    @Override
    public void actionWizAlloc_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionViewAlloc_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewAlloc_actionPerformed(e);
        String oprationName = AllocSourceBillEnum.MaterialReqBill.getName() + "Alloc_View";
        NCMUtils.addEASLogForAlloc(null, (String)"actionViewAlloc_actionPerformed", (String)(this.company.getNumber() + ' ' + this.company.getName()), (String)oprationName, (String)this.company.getId().toString(), (boolean)true);
        this.showAllocEditUI("VIEW");
    }

    @Override
    public void actionViewLog_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewLog_actionPerformed(e);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("companyId", this.company.getId().toString());
        param.put("periodId", this.period.getId().toString());
        param.put("companyName", this.company.getName().toString());
        param.put("periodNumber", String.valueOf(this.period.getNumber()));
        param.put("feeType", "matFee");
        this.setLogInfo("actionViewLog", "MatAlloc_Error");
        OCMaterialAllocLogReportUI.showAllocReportUI((CoreUIObject)this, param);
    }

    private void showAllocEditUI(String operType) throws Exception {
        this.checkSelected();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("companyId", this.company.getId().toString());
        param.put("companyName", this.company.getName().toString());
        this.setPeriodForDaily(param, operType);
        param.put("filterInfo", (String)this._currFilterInfo);
        param.put("bFilter_all", String.valueOf(this.bFilter_all));
        if (this.isOnlyUnAlloced != -1) {
            if (this.isOnlyUnAlloced == 1) {
                param.put("isOnlyUnAlloced", String.valueOf(true));
            } else {
                param.put("isOnlyUnAlloced", String.valueOf(false));
            }
        }
        OCMaterialAllocEditUI.showAllocEditUI((CoreUIObject)this, param, operType, this.tblMain);
    }

    protected void setPeriodForDaily(Map param, String operType) throws BOSException {
        param.put("periodId", this.period.getId().toString());
        param.put("periodNumber", String.valueOf(this.period.getNumber()));
    }

    public void onGetRowSet(IRowSet rowSet) {
        if (rowSet == null || rowSet.size() == 0) {
            this.actionAutoAlloc.setEnabled(false);
            this.actionViewAlloc.setEnabled(false);
            this.actionViewLog.setEnabled(false);
            this.actionManuAlloc.setEnabled(false);
            this.actionWizAlloc.setEnabled(false);
            this.actionPrint.setEnabled(false);
            this.actionPrintPreview.setEnabled(false);
        } else {
            this.actionAutoAlloc.setEnabled(true);
            this.actionViewAlloc.setEnabled(true);
            this.actionViewLog.setEnabled(true);
            this.actionManuAlloc.setEnabled(true);
            this.actionWizAlloc.setEnabled(true);
            this.actionPrint.setEnabled(true);
            this.actionPrintPreview.setEnabled(true);
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.setLogInfo("actionRefresh", "MatAlloc_View");
    }

    private void setLogInfo(String methodName, String logItemName) {
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        OrderCCFeeBillFactory.getRemoteInstance().logPrint(this.getBizInterface().getType(), "OC_MaterialAlloc_Print", null);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        OrderCCFeeBillFactory.getRemoteInstance().logPrint(this.getBizInterface().getType(), "OC_MaterialAlloc_Print", null);
    }
}

