/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.alloc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ncm.order.fact.alloc.OCAllocFacadeFactory;
import com.kingdee.eas.ncm.order.fact.alloc.client.AbstractOCMaterialAllocLogReportUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public class OCMaterialAllocLogReportUI
extends AbstractOCMaterialAllocLogReportUI {
    private static final long serialVersionUID = 2731972626601692972L;
    private static final Logger logger = CoreUIObject.getLogger(OCMaterialAllocLogReportUI.class);
    private Map _parentParam = null;
    private String _companyId = null;
    private String _periodId = null;
    private String _companyName = null;
    private String _periodNumber = null;
    private String _feeType = null;
    private IRowSet _logData = null;

    public static void showAllocReportUI(CoreUIObject ui, Map param) throws Exception {
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("feeType"));
        Assert.that((boolean)param.containsKey("companyName"));
        Assert.that((boolean)param.containsKey("periodNumber"));
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"param", (Object)param);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(OCMaterialAllocLogReportUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this._parentParam = (Map)this.getUIContext().get("param");
        this._companyId = (String)this._parentParam.get("companyId");
        this._periodId = (String)this._parentParam.get("periodId");
        this._feeType = (String)this._parentParam.get("feeType");
        this._companyName = (String)this._parentParam.get("companyName");
        this._periodNumber = (String)this._parentParam.get("periodNumber");
        this._logData = this._parentParam.containsKey("logData") ? (IRowSet)this._parentParam.get("logData") : OCAllocFacadeFactory.getRemoteInstance().getLogData(this._companyId, this._periodId, this._feeType);
        if ("matFee".equals(this._feeType)) {
            this.setUITitle("\u6750\u6599\u8d39\u7528\u5206\u914d-\u9519\u8bef\u62a5\u544a");
        }
        this.kDTable.checkParsed();
        this.loadFields();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.fillReportData();
    }

    private void fillReportData() {
        try {
            this.txtCompany.setText(this._companyName);
            this.txtPeriod.setText(this._periodNumber);
            boolean isHandle = false;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            this._logData.first();
            while (this._logData.getRow() > 0 && !this._logData.isAfterLast()) {
                if (!isHandle) {
                    this.txtLogTime.setText(sdf.format(this._logData.getTime("FLogTime")));
                    isHandle = true;
                }
                IRow row = this.kDTable.addRow();
                row.getCell("errorInfo").setValue((Object)this._logData.getString("FErrorInfo"));
                row.getCell("possibleReason").setValue((Object)this._logData.getString("FPossibleReason"));
                row.getCell("adviceHandle").setValue((Object)this._logData.getString("FAdviceHandle"));
                this._logData.next();
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kDTable);
        this.kDTable.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kDTable);
        this.kDTable.getPrintManager().printPreview();
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
    }
}

